/*
 * Copyright (C) 2007 Carlos Garnacho <carlos@imendio.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA 02110-1301 USA
 */

#ifndef __GTY_TIMELINE_H__
#define __GTY_TIMELINE_H__

#include <glib-object.h>
#include <gtk/gtkenums.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GTY_TYPE_TIMELINE         (gty_timeline_get_type ())
#define GTY_TIMELINE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTY_TYPE_TIMELINE, GtyTimeline))
#define GTY_TIMELINE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTY_TYPE_TIMELINE, GtyTimelineClass))
#define GTY_IS_TIMELINE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTY_TYPE_TIMELINE))
#define GTY_IS_TIMELINE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTY_TYPE_TIMELINE))
#define GTY_TIMELINE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTY_TYPE_TIMELINE, GtyTimelineClass))

typedef struct GtyTimeline      GtyTimeline;
typedef struct GtyTimelineClass GtyTimelineClass;

typedef enum {
  GTY_TIMELINE_DIRECTION_FORWARD,
  GTY_TIMELINE_DIRECTION_BACKWARD
} GtyTimelineDirection;

typedef enum {
  GTY_TIMELINE_PROGRESS_LINEAR,
  GTY_TIMELINE_PROGRESS_SINUSOIDAL,
  GTY_TIMELINE_PROGRESS_EXPONENTIAL,
  GTY_TIMELINE_PROGRESS_EASE_IN_EASE_OUT
} GtyTimelineProgressType;

struct GtyTimeline
{
  GObject parent_instance;
};

struct GtyTimelineClass
{
  GObjectClass parent_class;

  void (* started)           (GtyTimeline *timeline);
  void (* finished)          (GtyTimeline *timeline);
  void (* paused)            (GtyTimeline *timeline);

  void (* frame)             (GtyTimeline *timeline,
			      gdouble     progress);

  void (* __gty_reserved1) (void);
  void (* __gty_reserved2) (void);
  void (* __gty_reserved3) (void);
  void (* __gty_reserved4) (void);
};


GType                 gty_timeline_get_type            (void) G_GNUC_CONST;

GtyTimeline           *gty_timeline_new                (guint                     duration);
GtyTimeline           *gty_timeline_new_for_screen     (guint                     duration,
                                                        GdkScreen                *screen);

void                  gty_timeline_start               (GtyTimeline              *timeline);
void                  gty_timeline_pause               (GtyTimeline              *timeline);
void                  gty_timeline_rewind              (GtyTimeline              *timeline);

gboolean              gty_timeline_is_running          (GtyTimeline              *timeline);

guint                 gty_timeline_get_fps             (GtyTimeline              *timeline);
void                  gty_timeline_set_fps             (GtyTimeline              *timeline,
                                                        guint                     fps);

gboolean              gty_timeline_get_loop            (GtyTimeline              *timeline);
void                  gty_timeline_set_loop            (GtyTimeline              *timeline,
                                                        gboolean                  loop);

guint                 gty_timeline_get_duration        (GtyTimeline              *timeline);
void                  gty_timeline_set_duration        (GtyTimeline              *timeline,
                                                        guint                     duration);

GdkScreen            *gty_timeline_get_screen          (GtyTimeline              *timeline);
void                  gty_timeline_set_screen          (GtyTimeline              *timeline,
                                                        GdkScreen                *screen);

GtyTimelineDirection  gty_timeline_get_direction       (GtyTimeline              *timeline);
void                  gty_timeline_set_direction       (GtyTimeline              *timeline,
                                                        GtyTimelineDirection      direction);

gdouble               gty_timeline_get_progress        (GtyTimeline              *timeline);

gdouble               gty_timeline_calculate_progress  (gdouble                   linear_progress,
                                                        GtyTimelineProgressType   progress_type);

G_END_DECLS

#endif /* __GTY_TIMELINE_H__ */
