/* vim: set expandtab ts=8 sw=4: */

/*  $Id$
 *
 *  Copyright © 2005 Nick Schermer <nickschermer@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CLIPMAN_H
#define CLIPMAN_H

/* Dialog settings */
#define BORDER			8

/* History settings: default, min and max */
#define DEFHISTORY		10
#define MAXHISTORY		100
#define MINHISTORY		5

/* Character settings: default, min and max */
#define DEFCHARS		30
#define MAXCHARS		200
#define MINCHARS		10

/* Default options */
#define DEFEXITSAVE		FALSE
#define DEFIGNORESELECT		FALSE
#define DEFPREVENTEMPTY		TRUE
#define DEFBEHAVIOUR		1

#define DEFITEMNUMBERS		FALSE
#define DEFSEPMENU		TRUE
#define DEFCOLOREDITEMS		FALSE

#define DEFPRICOLOR		"#000099"
#define DEFDEFCOLOR		"#990000"
#define DEFNUMCOLOR		"#999999"

/* milisecond to check the clipman(s) */
#define TIMER_INTERVAL		500

typedef enum
{
	FROM_PRIMARY,
	FROM_DEFAULT,
}
ClipboardType;

typedef enum
{
	RESTORING,
	STRICTLY,
}
ClipboardBehaviour;

typedef struct
{
	XfcePanelPlugin 	*plugin;
	guint			block:1;

	GtkWidget		*menu;
	GtkWidget		*icon;
	GtkWidget		*button;
	GtkTooltips		*tooltip;
	
	GPtrArray		*clips;
	
	gint			timeId;
	gboolean		killTimeout;
	
	guint			ExitSave:1;
	guint			IgnoreSelect:1;
	guint			PreventEmpty:1;
	
	ClipboardBehaviour	Behaviour;
	
	guint			ItemNumbers:1;
	guint			SeparateMenu:1;
	guint			ColoredItems:1;
	
	gint			HistoryItems;
	gint			MenuCharacters;
	
	gchar			*DefColor;
	gchar			*PriColor;
	gchar			*NumColor;
}
ClipmanPlugin;

typedef struct
{
	ClipmanPlugin	*clipman;
	
	GtkWidget	*GW_ExitSave;
	GtkWidget	*GW_IgnoreSelection;
	GtkWidget	*GW_PreventEmpty;
	
	GtkWidget	*GW_Behaviour;
	
	GtkWidget	*GW_ItemNumbers;
	GtkWidget	*GW_SeparateMenu;
	GtkWidget	*GW_ColoredItems;
	
	GtkWidget	*GW_HistorySize;
	GtkWidget	*GW_ItemChars;
}
ClipmanOptions;

typedef struct
{
	gchar		*text;
	gchar		*title;		/* I've added the title to save
					 * some time when opening the menu */
	ClipboardType	fromtype;
}
ClipmanClip;

typedef struct
{
	ClipmanPlugin	*clipman;
	ClipmanClip	*clip;
	
	GtkWidget	*text;
}
ClipmanAction;

void
clipman_check_array_len (ClipmanPlugin *clipman);

void
clipman_regenerate_titles (ClipmanPlugin *clipman);

void
clipman_save (XfcePanelPlugin *plugin, ClipmanPlugin *clipman);

void
clipman_free_clip (ClipmanClip *clip);

gchar *
clipman_create_title (gchar *txt, gint chars);

void
clipman_replace_text (gchar *o_string, gchar *n_string);

GtkClipboard *primaryClip, *defaultClip;

#endif /* CLIPMAN_H */
