/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from generate-enums-with-same-base-name.json
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py

#pragma once

#if ENABLE(WEB_REPLAY)
#include "FormData1.h"
#include "FormData2.h"
#include "InternalNamespaceHeaderIncludeDummy.h"
#include <platform/ExternalNamespaceHeaderIncludeDummy.h>
#include <replay/PlatformEvent.h>



namespace Test {
class FormCombo;
} // namespace Test

namespace JSC {
template<> struct TEST_EXPORT_MACRO InputTraits<Test::FormCombo> {
    static InputQueue queue() { return InputQueue::ScriptMemoizedData; }
    static const String& type();

    static void encode(JSC::EncodedValue&, const Test::FormCombo&);
    static bool decode(JSC::EncodedValue&, std::unique_ptr<Test::FormCombo>&);
};
template<> struct TEST_EXPORT_MACRO EncodingTraits<Test::FormData1::Type> {
    typedef Test::FormData1::Type DecodedType;

    static EncodedValue encodeValue(const Test::FormData1::Type& value);
    static bool decodeValue(EncodedValue&, Test::FormData1::Type& value);
};

template<> struct TEST_EXPORT_MACRO EncodingTraits<Test::FormData2::Type> {
    typedef Test::FormData2::Type DecodedType;

    static EncodedValue encodeValue(const Test::FormData2::Type& value);
    static bool decodeValue(EncodedValue&, Test::FormData2::Type& value);
};
} // namespace JSC

namespace Test {
class FormCombo : public NondeterministicInput<FormCombo> {
public:
    TEST_EXPORT_MACRO FormCombo(PlatformEvent1::Type eventType1, PlatformEvent2::Type eventType2, FormData1::Type formType1, FormData2::Type formType2);
    virtual ~FormCombo();

    PlatformEvent1::Type eventType1() const { return m_eventType1; }
    PlatformEvent2::Type eventType2() const { return m_eventType2; }
    FormData1::Type formType1() const { return m_formType1; }
    FormData2::Type formType2() const { return m_formType2; }
private:
    PlatformEvent1::Type m_eventType1;
    PlatformEvent2::Type m_eventType2;
    FormData1::Type m_formType1;
    FormData2::Type m_formType2;
};
} // namespace Test

SPECIALIZE_TYPE_TRAITS_BEGIN(Test::FormCombo)
    static bool isType(const NondeterministicInputBase& input) { return input.type() == InputTraits<Test::FormCombo>::type(); }
SPECIALIZE_TYPE_TRAITS_END()

#define TEST_REPLAY_INPUT_NAMES_FOR_EACH(macro) \
    macro(FormCombo) \
    \
// end of TEST_REPLAY_INPUT_NAMES_FOR_EACH

#endif // ENABLE(WEB_REPLAY)
