function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._state++;
            this._browser.injectScript(makeAuthorizer('b-mail-domik-username11', 'b-mail-domik-password11', this._login, this._password));
        } else {
            setTimeout(this._browser.finish.bind(this._browser), 8000);
        }
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Unity.MessagingIndicator.showIndicator', log[2].func, 'Unity.MessagingIndicator.showIndicator');
        var i;
        var found = false;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'YandexMail/YandexMail.user.js'
};
