function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._state++;
            this._browser.injectScript(makeAuthorizer('quick_email', 'quick_pass', this._login, this._password));
        } else {
            this._browser.finish();
        }
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Unity.MessagingIndicator.showIndicator', log[1].func, 'Unity.MessagingIndicator.showIndicator');
    },

    scriptName: 'Vkcom/Vkcom.user.js'
};
