function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        setTimeout(function () {
            this._browser.finish();
        }.bind(this), 5000);
    },

    validateCallLog: function (log) {
        assertEquals('Launchpad', log[0].args[0].name, 'Launchpad');
        var i;
        var actionsCount = 0, launcherAction = false;
        for (i = 0; i < log.length; i++) {
            if (log[i].func === 'Unity.Launcher.addAction' && log[i].args[0] === 'webapps-applications') {
                launcherAction = true;
            }
            if (log[i].func === 'Unity.addAction') {
                actionsCount++;
            }
        }
        assertTrue('Unity.addAction', actionsCount && launcherAction);
    },

    scriptName: 'Launchpad/Launchpad.user.js'
};
