function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open('http://www.facebook.com/');
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('email', 'pass', this._login, this._password));
        } else if (this._state <= 2) {
            this._browser.open(this._url);
        } else {
            setTimeout(this._browser.finish.bind(this._browser), 20000);
        }
        this._state++;
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[1].func, 'Unity.init');
        assertEquals('The Sims Social', log[1].args[0].name, 'The Sims Social');
        assertEquals('URL: ' + this._url, log[1].args[0].homepage, this._url);
    },

    scriptName: 'FacebookApps/FacebookApps.user.js'
};
