/**
 * @file geis_xcb_backend.h
 * @brief internal GEIS XCB back end class
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_XCB_BACKEND_H_
#define GEIS_XCB_BACKEND_H_

#include "geis_backend.h"

/**
 * Constructs a new GEIS XCB back end.
 *
 * @param[in] geis The API instance the back end will run in.
 * @param[in] track_devices Indicates devices should be tracked.
 * @param[in] track_classes Indicates classes should be tracked.
 *
 * The uTouch stack in Ubuntu Maverick used XCB to communicate with a gesture
 * recognition engine built into the X server.
 */
GeisBackend geis_xcb_backend_new(Geis        geis,
                                 GeisBoolean track_devices,
                                 GeisBoolean track_classes);

#endif /* GEIS_XCB_BACKEND_H_ */
