/* update-notifier.h
 * Copyright (C) 2004 Michiel Sikkes <michiel@eyesopened.nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __UPGRADE_NOTIFIER_H__
#define __UPGRADE_NOTIFIER_H__

#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include "eggtrayicon.h"

#define CLIPBOARD_NAME 	"UPGRADE_NOTIFIER_SELECTION"
#define GCONF_KEY_DEFAULT_ACTION "/apps/update-notifier/default_action"
#define GCONF_KEY_NO_UPDATE_NOTIFICATIONS "/apps/update-notifier/no_show_notifications"

#define HOOKS_DIR "/var/lib/update-notifier/user.d/"
#define REBOOT_FILE "/var/run/reboot-required"

void invoke_with_gksu(gchar *cmd, gchar *descr);


typedef struct _TrayApplet TrayApplet;
struct _TrayApplet 
{
   EggTrayIcon *tray_icon;
   GtkWidget *icon;
   GtkWidget *eventbox;
   GtkTooltips *tooltip;
   GtkWidget *menu;

   void *user_data;
};

typedef struct _UpgradeNotifier UpgradeNotifier;
struct _UpgradeNotifier
{
   TrayApplet *update;
   TrayApplet *reboot;
   TrayApplet *hook;

   GConfClient *gconf;

   guint update_finished_timer; 

   
   // some states for the file montioring (these field
   // are the state for the current "time-slice")
   gboolean dpkg_was_run;
   gboolean apt_get_runing;

   // these field are "global" (time-wise)
   gboolean reboot_pending;
   gboolean hook_pending;
   time_t last_apt_action;

};

#endif /* __UPGRADE_NOTIFIER_H__ */
