/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

using DBus;
using Config;

namespace Unity.FilesPlace {

  public static int main (string[] args)
    {
      GLib.Intl.textdomain (Config.PACKAGE);
      GLib.Intl.bindtextdomain (Config.PACKAGE, Config.LOCALEDIR);
      GLib.Intl.bind_textdomain_codeset (Config.PACKAGE, "UTF-8");
      GLib.Intl.setlocale(GLib.LocaleCategory.ALL, "");
    
      DesktopAppInfo.set_desktop_env ("GNOME");
    
      var daemon = new Daemon ();

      /* Export the place daemon on the session bus */
      try {
        var conn = DBus.Bus.get (DBus.BusType.SESSION);
        dynamic DBus.Object bus = conn.get_object ("org.freedesktop.DBus",
                                                   "/org/freedesktop/DBus",
                                                   "org.freedesktop.DBus");

        uint request_name_result = bus.request_name ("com.canonical.Unity.FilesPlace", (uint) 0);
        if (request_name_result == DBus.RequestNameReply.PRIMARY_OWNER)
          {
            debug ("Running files place daemon.");
            new MainLoop (null, false).run();
          }
        else
          {
            print (_("Another Files Place daemon appears to be running.\nBailing out."));
            return 1;
          }
      } catch (DBus.Error error) {
        print (_("Error connecting to session bus: %s.\nBailing out."), error.message);
        return 2;
      }

      return 0;
    }
} /* namespace */
