/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 *
 */

/*
 * FIXME: this code is based on musicstore-scope preview handling code; it needs to be kept in sync and eventually moved to a library !!!
 */
namespace Unity.ShoppingLens
{
  public class U1MSPreviewFactory
  {
    public string formatted_price { get; internal set; }

    public static bool is_u1ms_details (Json.Parser parser)
    {
      var root_obj = parser.get_root ().get_object ();
      return root_obj.has_member ("source") && root_obj.get_string_member ("source") == "Ubuntu One Music Store" && root_obj.has_member ("tracks");
    }

    public Unity.MusicPreview? create_preview (Json.Parser parser)
    {
      var root_obj = parser.get_root ().get_object ();

      var title = root_obj.get_string_member ("title");
      var artwork_path = root_obj.get_string_member ("image");
      File cover_file = File.new_for_uri (artwork_path); //artwork path is a remote uri
      var cover = new FileIcon (cover_file);

      var artist = root_obj.get_string_member ("artist");

      var preview = new Unity.MusicPreview (title, artist, cover);

      if (root_obj.has_member ("formatted_price"))
        formatted_price = root_obj.get_string_member ("formatted_price");
      else
        formatted_price = "";

      if (root_obj.has_member ("tracks"))
      {
        var tracks_node = root_obj.get_array_member ("tracks");
        int i = 1;
        foreach (var track_node in tracks_node.get_elements ())
        {
          var track_obj = track_node.get_object ();
          TrackMetadata tm = new TrackMetadata ();
          tm.uri = track_obj.get_string_member ("preview");
          tm.track_no = i++; //FIXME: u1ms search doesn't provide track numbers *yet*
          tm.title = track_obj.get_string_member ("title");
          tm.length = (int)track_obj.get_member ("duration").get_int ();
          preview.add_track (tm);
        }
      }
      else // details for single track
      {
        TrackMetadata tm = new TrackMetadata ();
        tm.uri = root_obj.get_string_member ("preview");
        tm.title = root_obj.get_string_member ("title");
        tm.length = (int)root_obj.get_member ("duration").get_int ();
        preview.add_track (tm);
      }
      return preview;
    }

    public Unity.PreviewAction? add_download_action (Unity.MusicPreview preview)
    {
      GLib.Icon? icon = new GLib.FileIcon (File.new_for_path (Config.DATADIR + "/icons/unity-icon-theme/places/svg/service-u1.svg"));
      var download_action = new Unity.PreviewAction ("download_album", _("Download"), icon);
      if (formatted_price != null)
        download_action.extra_text = formatted_price;
      preview.add_action (download_action);
      return download_action;
    }
  }

}
