/* test-markup-cleaner.c generated by valac 0.16.1, the Vala compiler
 * generated from test-markup-cleaner.vala, do not modify */

/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecMain ParamSpecMain;

struct _Main {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainPrivate * priv;
};

struct _MainClass {
	GTypeClass parent_class;
	void (*finalize) (Main *self);
};

struct _ParamSpecMain {
	GParamSpec parent_instance;
};


static gpointer main_parent_class = NULL;

gpointer main_ref (gpointer instance);
void main_unref (gpointer instance);
GParamSpec* param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main (GValue* value, gpointer v_object);
void value_take_main (GValue* value, gpointer v_object);
gpointer value_get_main (const GValue* value);
GType main_get_type (void) G_GNUC_CONST;
enum  {
	MAIN_DUMMY_PROPERTY
};
gint main_main (gchar** args, int args_length1);
void main_test_no_markup (void);
static void _main_test_no_markup_gtest_data_func (gpointer self);
void main_test_br_tag_support (void);
static void _main_test_br_tag_support_gtest_data_func (gpointer self);
void main_test_b_tag_support (void);
static void _main_test_b_tag_support_gtest_data_func (gpointer self);
void main_test_i_tag_support (void);
static void _main_test_i_tag_support_gtest_data_func (gpointer self);
void main_test_u_tag_support (void);
static void _main_test_u_tag_support_gtest_data_func (gpointer self);
void main_test_tt_tag_support (void);
static void _main_test_tt_tag_support_gtest_data_func (gpointer self);
void main_test_s_tag_support (void);
static void _main_test_s_tag_support_gtest_data_func (gpointer self);
void main_test_strike_tag_support (void);
static void _main_test_strike_tag_support_gtest_data_func (gpointer self);
void main_test_big_tag_support (void);
static void _main_test_big_tag_support_gtest_data_func (gpointer self);
void main_test_small_tag_support (void);
static void _main_test_small_tag_support_gtest_data_func (gpointer self);
void main_test_sub_tag_support (void);
static void _main_test_sub_tag_support_gtest_data_func (gpointer self);
void main_test_sup_tag_support (void);
static void _main_test_sup_tag_support_gtest_data_func (gpointer self);
void main_test_unsupported_tags (void);
static void _main_test_unsupported_tags_gtest_data_func (gpointer self);
void main_test_nested_tags (void);
static void _main_test_nested_tags_gtest_data_func (gpointer self);
void main_test_amp_entity (void);
static void _main_test_amp_entity_gtest_data_func (gpointer self);
void main_test_nbsp_entity (void);
static void _main_test_nbsp_entity_gtest_data_func (gpointer self);
void main_test_basic_entities_are_preserved (void);
static void _main_test_basic_entities_are_preserved_gtest_data_func (gpointer self);
void main_test_unsupported_entities_are_raw (void);
static void _main_test_unsupported_entities_are_raw_gtest_data_func (gpointer self);
void main_test_num_entities_are_preserved (void);
static void _main_test_num_entities_are_preserved_gtest_data_func (gpointer self);
gchar* unity_shopping_lens_markup_cleaner_html_to_pango_markup (const gchar* html_text);
Main* main_new (void);
Main* main_construct (GType object_type);
static void main_finalize (Main* obj);


static void _main_test_no_markup_gtest_data_func (gpointer self) {
	main_test_no_markup ();
}


static void _main_test_br_tag_support_gtest_data_func (gpointer self) {
	main_test_br_tag_support ();
}


static void _main_test_b_tag_support_gtest_data_func (gpointer self) {
	main_test_b_tag_support ();
}


static void _main_test_i_tag_support_gtest_data_func (gpointer self) {
	main_test_i_tag_support ();
}


static void _main_test_u_tag_support_gtest_data_func (gpointer self) {
	main_test_u_tag_support ();
}


static void _main_test_tt_tag_support_gtest_data_func (gpointer self) {
	main_test_tt_tag_support ();
}


static void _main_test_s_tag_support_gtest_data_func (gpointer self) {
	main_test_s_tag_support ();
}


static void _main_test_strike_tag_support_gtest_data_func (gpointer self) {
	main_test_strike_tag_support ();
}


static void _main_test_big_tag_support_gtest_data_func (gpointer self) {
	main_test_big_tag_support ();
}


static void _main_test_small_tag_support_gtest_data_func (gpointer self) {
	main_test_small_tag_support ();
}


static void _main_test_sub_tag_support_gtest_data_func (gpointer self) {
	main_test_sub_tag_support ();
}


static void _main_test_sup_tag_support_gtest_data_func (gpointer self) {
	main_test_sup_tag_support ();
}


static void _main_test_unsupported_tags_gtest_data_func (gpointer self) {
	main_test_unsupported_tags ();
}


static void _main_test_nested_tags_gtest_data_func (gpointer self) {
	main_test_nested_tags ();
}


static void _main_test_amp_entity_gtest_data_func (gpointer self) {
	main_test_amp_entity ();
}


static void _main_test_nbsp_entity_gtest_data_func (gpointer self) {
	main_test_nbsp_entity ();
}


static void _main_test_basic_entities_are_preserved_gtest_data_func (gpointer self) {
	main_test_basic_entities_are_preserved ();
}


static void _main_test_unsupported_entities_are_raw_gtest_data_func (gpointer self) {
	main_test_unsupported_entities_are_raw ();
}


static void _main_test_num_entities_are_preserved_gtest_data_func (gpointer self) {
	main_test_num_entities_are_preserved ();
}


gint main_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	g_test_add_data_func ("/Unit/NoMarkup", NULL, _main_test_no_markup_gtest_data_func);
	g_test_add_data_func ("/Unit/BrTagSupport", NULL, _main_test_br_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/BTagSupport", NULL, _main_test_b_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/ITagSupport", NULL, _main_test_i_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/UTagSupport", NULL, _main_test_u_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/TtTagSupport", NULL, _main_test_tt_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/STagSupport", NULL, _main_test_s_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/StrikeTagSupport", NULL, _main_test_strike_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/BigTagSupport", NULL, _main_test_big_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/SmallTagSupport", NULL, _main_test_small_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/SubTagSupport", NULL, _main_test_sub_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/SupTagSupport", NULL, _main_test_sup_tag_support_gtest_data_func);
	g_test_add_data_func ("/Unit/UnsupportedTags", NULL, _main_test_unsupported_tags_gtest_data_func);
	g_test_add_data_func ("/Unit/NestedTags", NULL, _main_test_nested_tags_gtest_data_func);
	g_test_add_data_func ("/Unit/AmpEntitySupport", NULL, _main_test_amp_entity_gtest_data_func);
	g_test_add_data_func ("/Unit/NbspEntitySupport", NULL, _main_test_nbsp_entity_gtest_data_func);
	g_test_add_data_func ("/Unit/EntitiesArePreserved", NULL, _main_test_basic_entities_are_preserved_gtest_data_func);
	g_test_add_data_func ("/Unit/UnsupportedEntitiesAreRaw", NULL, _main_test_unsupported_entities_are_raw_gtest_data_func);
	g_test_add_data_func ("/Unit/NumericEntitiesArePreserved", NULL, _main_test_num_entities_are_preserved_gtest_data_func);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return main_main (argv, argc);
}


void main_test_no_markup (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("This is a\ntest");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "This is a\ntest") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_br_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("This is<br/> a<br />test<br>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "This is\n a\ntest\n") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_b_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<B>T</b>his <b>is</b> a <B>test</B>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<b>T</b>his <b>is</b> a <b>test</b>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_i_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<I>T</i>his <i>is</i> a <I>test</I>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<i>T</i>his <i>is</i> a <i>test</i>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_u_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<U>T</u>his <u>is</u> a <U>test</U>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<u>T</u>his <u>is</u> a <u>test</u>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_tt_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<TT>T</TT>his <tt>is</tt> a <tT>test</Tt>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<tt>T</tt>his <tt>is</tt> a <tt>test</tt>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_s_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<S>T</s>his <s>is</s> a <S>test</S>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<s>T</s>his <s>is</s> a <s>test</s>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_strike_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<STRIKE>T</STRIKE>his <strike>is</strike> a <STRike>test</Strike>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<s>T</s>his <s>is</s> a <s>test</s>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_small_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<SMALL>T</SMALL>his <small>is</small> a <SMall>test</SmaLL>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<small>T</small>his <small>is</small> a <small>test</small>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_big_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<BIG>T></BIG>his <big>is</big> a <bIG>test</BiG>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<big>T></big>his <big>is</big> a <big>test</big>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_sub_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<SUB>T</SUB>his <sub>is</sub> a <suB>test</SuB>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<sub>T</sub>his <sub>is</sub> a <sub>test</sub>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_sup_tag_support (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<SUP>T</SUP>his <sup>is</sup> a <suP>test</SuP>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<sup>T</sup>his <sup>is</sup> a <sup>test</sup>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_unsupported_tags (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<foo>This</bar> is a <a href=\"http://foo.com\">test</a>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "This is a test") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_nested_tags (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("<a href=\"wooo\"><small>Click me!</small></a>");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "<small>Click me!</small>") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_amp_entity (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("Foo & Bar");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "Foo &amp; Bar") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_nbsp_entity (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("Foo&nbsp;Bar");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "Foo Bar") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_basic_entities_are_preserved (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("Foo &amp; bar &lt; &GT; &Quot; &apos;");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "Foo &amp; bar &lt; &gt; &quot; &apos;") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_unsupported_entities_are_raw (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("Foo &frac14; bar &not;");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "Foo &amp;frac14 bar &amp;not") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


void main_test_num_entities_are_preserved (void) {
	gchar* _tmp0_;
	gchar* input;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	_tmp0_ = g_strdup ("Foo&#160;bar &#8364;");
	input = _tmp0_;
	_tmp1_ = unity_shopping_lens_markup_cleaner_html_to_pango_markup (input);
	_result_ = _tmp1_;
	g_assert (g_strcmp0 (_result_, "Foo&#160;bar &#8364;") == 0);
	_g_free0 (_result_);
	_g_free0 (input);
}


Main* main_construct (GType object_type) {
	Main* self = NULL;
	self = (Main*) g_type_create_instance (object_type);
	return self;
}


Main* main_new (void) {
	return main_construct (TYPE_MAIN);
}


static void value_main_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_unref (value->data[0].v_pointer);
	}
}


static void value_main_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Main* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Main** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMain* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN), NULL);
	return value->data[0].v_pointer;
}


void value_set_main (GValue* value, gpointer v_object) {
	Main* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_unref (old);
	}
}


void value_take_main (GValue* value, gpointer v_object) {
	Main* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_unref (old);
	}
}


static void main_class_init (MainClass * klass) {
	main_parent_class = g_type_class_peek_parent (klass);
	MAIN_CLASS (klass)->finalize = main_finalize;
}


static void main_instance_init (Main * self) {
	self->ref_count = 1;
}


static void main_finalize (Main* obj) {
	Main * self;
	self = MAIN (obj);
}


GType main_get_type (void) {
	static volatile gsize main_type_id__volatile = 0;
	if (g_once_init_enter (&main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_init, value_main_free_value, value_main_copy_value, value_main_peek_pointer, "p", value_main_collect_value, "p", value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Main), 0, (GInstanceInitFunc) main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_type_id;
		main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Main", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_type_id__volatile, main_type_id);
	}
	return main_type_id__volatile;
}


gpointer main_ref (gpointer instance) {
	Main* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_unref (gpointer instance) {
	Main* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



