/* daemon.c generated by valac 0.14.0, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *             Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity-package-search.h>
#include <zeitgeist.h>
#include <unity-ratings-db.h>
#include <unity.h>
#include <gee.h>
#include <gio/gio.h>
#include <gnome-menus/gmenu-tree.h>
#include <glib/gi18n-lib.h>
#include <dee.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>


#define UNITY_APPLICATIONS_LENS_TYPE_DAEMON (unity_applications_lens_daemon_get_type ())
#define UNITY_APPLICATIONS_LENS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemon))
#define UNITY_APPLICATIONS_LENS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemonClass))
#define UNITY_APPLICATIONS_LENS_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_LENS_TYPE_DAEMON))
#define UNITY_APPLICATIONS_LENS_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_LENS_TYPE_DAEMON))
#define UNITY_APPLICATIONS_LENS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemonClass))

typedef struct _UnityApplicationsLensDaemon UnityApplicationsLensDaemon;
typedef struct _UnityApplicationsLensDaemonClass UnityApplicationsLensDaemonClass;
typedef struct _UnityApplicationsLensDaemonPrivate UnityApplicationsLensDaemonPrivate;

#define UNITY_APPLICATIONS_LENS_TYPE_RUNNER (unity_applications_lens_runner_get_type ())
#define UNITY_APPLICATIONS_LENS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_LENS_TYPE_RUNNER, UnityApplicationsLensRunner))
#define UNITY_APPLICATIONS_LENS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_LENS_TYPE_RUNNER, UnityApplicationsLensRunnerClass))
#define UNITY_APPLICATIONS_LENS_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_LENS_TYPE_RUNNER))
#define UNITY_APPLICATIONS_LENS_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_LENS_TYPE_RUNNER))
#define UNITY_APPLICATIONS_LENS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_LENS_TYPE_RUNNER, UnityApplicationsLensRunnerClass))

typedef struct _UnityApplicationsLensRunner UnityApplicationsLensRunner;
typedef struct _UnityApplicationsLensRunnerClass UnityApplicationsLensRunnerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unity_package_searcher_free0(var) ((var == NULL) ? NULL : (var = (unity_package_searcher_free (var), NULL)))
#define _unity_ratings_database_free0(var) ((var == NULL) ? NULL : (var = (unity_ratings_database_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gmenu_tree_unref0(var) ((var == NULL) ? NULL : (var = (gmenu_tree_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_APPLICATIONS_LENS_TYPE_CATEGORY (unity_applications_lens_category_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _unity_package_search_result_free0(var) ((var == NULL) ? NULL : (var = (unity_package_search_result_free (var), NULL)))
typedef struct _UnityApplicationsLensDaemonUpdateScopeSearchData UnityApplicationsLensDaemonUpdateScopeSearchData;
typedef struct _UnityApplicationsLensDaemonUpdateGlobalSearchData UnityApplicationsLensDaemonUpdateGlobalSearchData;

struct _UnityApplicationsLensDaemon {
	GObject parent_instance;
	UnityApplicationsLensDaemonPrivate * priv;
	UnityPackageSearcher* appsearcher;
};

struct _UnityApplicationsLensDaemonClass {
	GObjectClass parent_class;
};

struct _UnityApplicationsLensDaemonPrivate {
	ZeitgeistLog* log;
	ZeitgeistIndex* zg_index;
	UnityPackageSearcher* pkgsearcher;
	UnityRatingsDatabase* ratings;
	UnityLens* lens;
	UnityScope* scope;
	UnityApplicationsLensRunner* runner;
	GHashTable* type_queries;
	GeeList* image_extensions;
	GHashTable* file_icon_cache;
	UnityLensSearch* previous_search;
	UnityLensSearch* previous_global_search;
	GPtrArray* zg_templates;
	guint app_menu_changed_reindex_timeout;
	GMenuTree* app_menu;
	GRegex* uri_regex;
};

typedef enum  {
	UNITY_APPLICATIONS_LENS_CATEGORY_MOST_USED,
	UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED,
	UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE,
	UNITY_APPLICATIONS_LENS_CATEGORY_EMPTY_SEARCH,
	UNITY_APPLICATIONS_LENS_CATEGORY_EMPTY_SECTION
} UnityApplicationsLensCategory;

struct _UnityApplicationsLensDaemonUpdateScopeSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	UnityLensSearch* search;
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	DeeSharedModel* _tmp2_;
	DeeSharedModel* _tmp3_;
	DeeSharedModel* _tmp4_;
	DeeSharedModel* model;
	UnityLensSearch* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	UnityScope* _tmp8_;
	UnityFilter* _tmp9_;
	UnityRadioOptionFilter* filter;
	UnityRadioOptionFilter* _tmp10_;
	UnityFilterOption* _tmp11_;
	UnityFilterOption* option;
	const gchar* _tmp12_;
	UnityFilterOption* _tmp13_;
	UnityFilterOption* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* type_id;
	UnityLensSearch* _tmp19_;
	gchar* _tmp20_;
	gchar* pkg_search_string;
	UnityLensSearch* _tmp21_;
	gboolean _tmp22_;
	gboolean has_search;
	GTimer* _tmp23_;
	GTimer* timer;
	UnityLensSearch* _tmp24_;
	gchar* _tmp25_;
	gchar* zg_search_string;
	ZeitgeistIndex* _tmp26_;
	ZeitgeistTimeRange* _tmp27_;
	ZeitgeistTimeRange* _tmp28_;
	GPtrArray* _tmp29_;
	GPtrArray* _tmp30_;
	ZeitgeistResultSet* _tmp31_;
	ZeitgeistResultSet* _tmp32_;
	ZeitgeistResultSet* results;
	DeeSharedModel* _tmp33_;
	DeeSharedModel* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	gdouble _tmp37_;
	GError* e;
	UnityLensSearch* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	DeeSharedModel* _tmp43_;
	GeeHashSet* _tmp44_;
	GeeSet* installed_uris;
	GeeHashSet* _tmp45_;
	GeeSet* available_uris;
	UnityPackageSort _tmp46_;
	UnityPackageSearcher* _tmp47_;
	UnityPackageSort _tmp48_;
	UnityPackageSearchResult* _tmp49_;
	UnityPackageSearchResult* appresults;
	UnityPackageSearchResult* _tmp50_;
	GeeSet* _tmp51_;
	GeeSet* _tmp52_;
	DeeSharedModel* _tmp53_;
	UnityPackageSearchResult* _tmp54_;
	gint _tmp55_;
	gdouble _tmp56_;
	DeeSharedModel* _tmp57_;
	gboolean _tmp58_;
	UnityPackageSearcher* _tmp59_;
	gboolean _tmp60_;
	UnityPackageSearcher* _tmp61_;
	UnityPackageSearchResult* _tmp62_;
	UnityPackageSearchResult* pkgresults;
	UnityPackageSearchResult* _tmp63_;
	GeeSet* _tmp64_;
	GeeSet* _tmp65_;
	DeeSharedModel* _tmp66_;
	UnityPackageSearchResult* _tmp67_;
	gint _tmp68_;
	gdouble _tmp69_;
	UnityPackageSearcher* _tmp70_;
	gchar* _tmp71_;
	gchar* filter_query;
	UnityPackageSearcher* _tmp72_;
	const gchar* _tmp73_;
	UnityPackageSearchResult* _tmp74_;
	UnityPackageSearchResult* random_pkgresults;
	UnityPackageSearchResult* _tmp75_;
	GeeSet* _tmp76_;
	GeeSet* _tmp77_;
	DeeSharedModel* _tmp78_;
	UnityPackageSearchResult* _tmp79_;
	gint _tmp80_;
	gdouble _tmp81_;
	UnityLensSearch* _tmp82_;
	UnityLensSearch* _tmp83_;
	GError * _inner_error_;
};

struct _UnityApplicationsLensDaemonUpdateGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsLensDaemon* self;
	UnityLensSearch* search;
	UnityScope* _tmp0_;
	DeeSharedModel* _tmp1_;
	DeeSharedModel* _tmp2_;
	DeeSharedModel* _tmp3_;
	DeeSharedModel* model;
	DeeSharedModel* _tmp4_;
	UnityLensSearch* _tmp5_;
	gboolean _tmp6_;
	UnityScope* _tmp7_;
	UnityLensSearch* _tmp8_;
	gchar* _tmp9_;
	gchar* search_string;
	GeeHashSet* _tmp10_;
	GeeSet* installed_uris;
	GeeHashSet* _tmp11_;
	GeeSet* available_uris;
	GTimer* _tmp12_;
	GTimer* timer;
	UnityPackageSearcher* _tmp13_;
	const gchar* _tmp14_;
	UnityPackageSearchResult* _tmp15_;
	UnityPackageSearchResult* appresults;
	UnityPackageSearchResult* _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	DeeSharedModel* _tmp19_;
	GTimer* _tmp20_;
	UnityPackageSearchResult* _tmp21_;
	gint _tmp22_;
	GTimer* _tmp23_;
	gdouble _tmp24_;
	const gchar* _tmp25_;
	UnityLensSearch* _tmp26_;
	UnityLensSearch* _tmp27_;
};


static gpointer unity_applications_lens_daemon_parent_class = NULL;

#define CONFIG_DATADIR "/usr/local/share"
#define UNITY_APPLICATIONS_LENS_ICON_PATH CONFIG_DATADIR "/icons/unity-icon-theme/places/svg/"
GType unity_applications_lens_daemon_get_type (void) G_GNUC_CONST;
GType unity_applications_lens_runner_get_type (void) G_GNUC_CONST;
#define UNITY_APPLICATIONS_LENS_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_APPLICATIONS_LENS_TYPE_DAEMON, UnityApplicationsLensDaemonPrivate))
enum  {
	UNITY_APPLICATIONS_LENS_DAEMON_DUMMY_PROPERTY
};
static void unity_applications_lens_daemon_populate_type_queries (UnityApplicationsLensDaemon* self);
static void _g_free0_ (gpointer var);
static void unity_applications_lens_daemon_populate_categories (UnityApplicationsLensDaemon* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void unity_applications_lens_daemon_populate_filters (UnityApplicationsLensDaemon* self);
static gboolean unity_applications_lens_daemon_build_app_menu_index (UnityApplicationsLensDaemon* self);
static void ___lambda4_ (UnityApplicationsLensDaemon* self, GMenuTree* menu);
static gboolean unity_applications_lens_daemon_build_app_menu_index_and_result_models (UnityApplicationsLensDaemon* self);
static gboolean _unity_applications_lens_daemon_build_app_menu_index_and_result_models_gsource_func (gpointer self);
static void ____lambda4__gmenu_tree_changed_func (GMenuTree* tree, gpointer self);
static void unity_applications_lens_daemon_populate_zg_templates (UnityApplicationsLensDaemon* self);
static gchar* unity_applications_lens_daemon_prepare_zg_search_string (UnityApplicationsLensDaemon* self, UnityLensSearch* search, const gchar* type_id);
static void unity_applications_lens_daemon_update_scope_search_data_free (gpointer _data);
static void unity_applications_lens_daemon_update_scope_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_scope_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static gboolean unity_applications_lens_daemon_update_scope_search_co (UnityApplicationsLensDaemonUpdateScopeSearchData* _data_);
static gchar* unity_applications_lens_daemon_prepare_pkg_search_string (UnityApplicationsLensDaemon* self, UnityLensSearch* search, const gchar* type_id);
gboolean unity_applications_lens_utils_search_is_invalid (UnityLensSearch* search);
static void unity_applications_lens_daemon_update_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_applications_lens_daemon_append_events_with_category (UnityApplicationsLensDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint category_id);
GType unity_applications_lens_category_get_type (void) G_GNUC_CONST;
static void unity_applications_lens_daemon_add_pkg_search_result (UnityApplicationsLensDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsLensCategory category, guint max_add);
static gboolean __lambda5_ (UnityApplicationsLensDaemon* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void unity_applications_lens_daemon_update_global_search_data_free (gpointer _data);
static void unity_applications_lens_daemon_update_global_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_lens_daemon_update_global_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_);
static gboolean unity_applications_lens_daemon_update_global_search_co (UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_);
static gboolean __lambda6_ (UnityApplicationsLensDaemon* self);
static gboolean ___lambda6__gsource_func (gpointer self);
GIcon* unity_applications_lens_daemon_find_pkg_icon (UnityApplicationsLensDaemon* self, UnityPackageInfo* pkginfo);
static void unity_applications_lens_daemon_on_appinfo_changed (UnityApplicationsLensDaemon* self, const gchar* id, GAppInfo* appinfo);
const gchar* unity_applications_lens_category_to_string (UnityApplicationsLensCategory self);
UnityActivationResponse* unity_applications_lens_daemon_activate (UnityApplicationsLensDaemon* self, const gchar* uri);
gchar* unity_applications_lens_utils_subst_tilde (const gchar* s);
void unity_applications_lens_runner_add_history (UnityApplicationsLensRunner* self, const gchar* last_command);
gchar* unity_applications_lens_utils_get_desktop_id_for_actor (const gchar* actor);
UnityApplicationsLensDaemon* unity_applications_lens_daemon_new (void);
UnityApplicationsLensDaemon* unity_applications_lens_daemon_construct (GType object_type);
static GObject * unity_applications_lens_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_applications_lens_daemon___lambda7_ (UnityApplicationsLensDaemon* self, GObject* obj, GParamSpec* pspec);
gboolean unity_applications_lens_utils_search_has_really_changed (UnityLensSearch* old_search, UnityLensSearch* new_search);
static void __unity_applications_lens_daemon___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_applications_lens_daemon___lambda8_ (UnityApplicationsLensDaemon* self);
static void __unity_applications_lens_daemon___lambda8__unity_scope_filters_changed (UnityScope* _sender, gpointer self);
static void _unity_applications_lens_daemon___lambda9_ (UnityApplicationsLensDaemon* self, GObject* obj, GParamSpec* pspec);
static void __unity_applications_lens_daemon___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static UnityActivationResponse* _unity_applications_lens_daemon_activate_unity_scope_activate_uri (UnityScope* _sender, const gchar* uri, gpointer self);
static void _unity_applications_lens_daemon_on_appinfo_changed_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const gchar* id, GAppInfo* new_appinfo, gpointer self);
UnityApplicationsLensRunner* unity_applications_lens_runner_new (UnityApplicationsLensDaemon* daemon);
UnityApplicationsLensRunner* unity_applications_lens_runner_construct (GType object_type, UnityApplicationsLensDaemon* daemon);
static void unity_applications_lens_daemon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void unity_applications_lens_daemon_populate_type_queries (UnityApplicationsLensDaemon* self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GHashTable* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GHashTable* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GHashTable* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->type_queries);
	self->priv->type_queries = _tmp2_;
	_tmp3_ = self->priv->type_queries;
	_tmp4_ = g_strdup ("all");
	_tmp5_ = g_strdup ("NOT category:XYZ");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->priv->type_queries;
	_tmp7_ = g_strdup ("accessories");
	_tmp8_ = g_strdup ("(category:Utility AND NOT category:Accessibility)");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->type_queries;
	_tmp10_ = g_strdup ("education");
	_tmp11_ = g_strdup ("(category:Education AND NOT category:Science)");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->type_queries;
	_tmp13_ = g_strdup ("game");
	_tmp14_ = g_strdup ("category:Game");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = self->priv->type_queries;
	_tmp16_ = g_strdup ("graphics");
	_tmp17_ = g_strdup ("category:Graphics");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = self->priv->type_queries;
	_tmp19_ = g_strdup ("internet");
	_tmp20_ = g_strdup ("category:Network");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = self->priv->type_queries;
	_tmp22_ = g_strdup ("fonts");
	_tmp23_ = g_strdup ("category:Fonts");
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = self->priv->type_queries;
	_tmp25_ = g_strdup ("office");
	_tmp26_ = g_strdup ("category:Office");
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = self->priv->type_queries;
	_tmp28_ = g_strdup ("media");
	_tmp29_ = g_strdup ("category:AudioVideo");
	g_hash_table_insert (_tmp27_, _tmp28_, _tmp29_);
	_tmp30_ = self->priv->type_queries;
	_tmp31_ = g_strdup ("customization");
	_tmp32_ = g_strdup ("category:Settings");
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
	_tmp33_ = self->priv->type_queries;
	_tmp34_ = g_strdup ("accessibility");
	_tmp35_ = g_strdup ("(category:Accessibility AND NOT category:Settings)");
	g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = self->priv->type_queries;
	_tmp37_ = g_strdup ("developer");
	_tmp38_ = g_strdup ("category:Development");
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = self->priv->type_queries;
	_tmp40_ = g_strdup ("science-and-engineering");
	_tmp41_ = g_strdup ("(category:Science OR category:Engineering)");
	g_hash_table_insert (_tmp39_, _tmp40_, _tmp41_);
	_tmp42_ = self->priv->type_queries;
	_tmp43_ = g_strdup ("system");
	_tmp44_ = g_strdup ("(category:System OR category:Security)");
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp44_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void unity_applications_lens_daemon_populate_categories (UnityApplicationsLensDaemon* self) {
	GList* categories;
	GFile* _tmp0_ = NULL;
	GFile* icon_dir;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFileIcon* _tmp4_;
	GFileIcon* _tmp5_;
	UnityCategory* _tmp6_;
	UnityCategory* _tmp7_;
	UnityCategory* cat;
	UnityCategory* _tmp8_;
	UnityCategory* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_;
	GFileIcon* _tmp13_;
	GFileIcon* _tmp14_;
	UnityCategory* _tmp15_;
	UnityCategory* _tmp16_;
	UnityCategory* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	GFile* _tmp20_;
	GFileIcon* _tmp21_;
	GFileIcon* _tmp22_;
	UnityCategory* _tmp23_;
	UnityCategory* _tmp24_;
	UnityCategory* _tmp25_;
	UnityLens* _tmp26_;
	g_return_if_fail (self != NULL);
	categories = NULL;
	_tmp0_ = g_file_new_for_path (UNITY_APPLICATIONS_LENS_ICON_PATH);
	icon_dir = _tmp0_;
	_tmp1_ = _ ("Most Frequently Used");
	_tmp2_ = g_file_get_child (icon_dir, "group-mostused.svg");
	_tmp3_ = _tmp2_;
	_tmp4_ = (GFileIcon*) g_file_icon_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = unity_category_new (_tmp1_, (GIcon*) _tmp5_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	cat = _tmp7_;
	_tmp8_ = cat;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	categories = g_list_append (categories, _tmp9_);
	_tmp10_ = _ ("Installed");
	_tmp11_ = g_file_get_child (icon_dir, "group-installed.svg");
	_tmp12_ = _tmp11_;
	_tmp13_ = (GFileIcon*) g_file_icon_new (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = unity_category_new (_tmp10_, (GIcon*) _tmp14_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	_tmp16_ = cat;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	categories = g_list_append (categories, _tmp17_);
	_tmp18_ = _ ("Apps Available for Download");
	_tmp19_ = g_file_get_child (icon_dir, "group-downloads.svg");
	_tmp20_ = _tmp19_;
	_tmp21_ = (GFileIcon*) g_file_icon_new (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = unity_category_new (_tmp18_, (GIcon*) _tmp22_, UNITY_CATEGORY_RENDERER_VERTICAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	_tmp24_ = cat;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	categories = g_list_append (categories, _tmp25_);
	_tmp26_ = self->priv->lens;
	unity_lens_set_categories (_tmp26_, categories);
	_g_object_unref0 (cat);
	_g_object_unref0 (icon_dir);
	__g_list_free__g_object_unref0_0 (categories);
}


static void unity_applications_lens_daemon_populate_filters (UnityApplicationsLensDaemon* self) {
	GList* filters;
	UnityLens* _tmp45_;
	g_return_if_fail (self != NULL);
	filters = NULL;
	{
		const gchar* _tmp0_ = NULL;
		UnityRadioOptionFilter* _tmp1_;
		UnityRadioOptionFilter* filter;
		const gchar* _tmp2_ = NULL;
		UnityFilterOption* _tmp3_ = NULL;
		UnityFilterOption* _tmp4_;
		const gchar* _tmp5_ = NULL;
		UnityFilterOption* _tmp6_ = NULL;
		UnityFilterOption* _tmp7_;
		const gchar* _tmp8_ = NULL;
		UnityFilterOption* _tmp9_ = NULL;
		UnityFilterOption* _tmp10_;
		const gchar* _tmp11_ = NULL;
		UnityFilterOption* _tmp12_ = NULL;
		UnityFilterOption* _tmp13_;
		const gchar* _tmp14_ = NULL;
		UnityFilterOption* _tmp15_ = NULL;
		UnityFilterOption* _tmp16_;
		const gchar* _tmp17_ = NULL;
		UnityFilterOption* _tmp18_ = NULL;
		UnityFilterOption* _tmp19_;
		const gchar* _tmp20_ = NULL;
		UnityFilterOption* _tmp21_ = NULL;
		UnityFilterOption* _tmp22_;
		const gchar* _tmp23_ = NULL;
		UnityFilterOption* _tmp24_ = NULL;
		UnityFilterOption* _tmp25_;
		const gchar* _tmp26_ = NULL;
		UnityFilterOption* _tmp27_ = NULL;
		UnityFilterOption* _tmp28_;
		const gchar* _tmp29_ = NULL;
		UnityFilterOption* _tmp30_ = NULL;
		UnityFilterOption* _tmp31_;
		const gchar* _tmp32_ = NULL;
		UnityFilterOption* _tmp33_ = NULL;
		UnityFilterOption* _tmp34_;
		const gchar* _tmp35_ = NULL;
		UnityFilterOption* _tmp36_ = NULL;
		UnityFilterOption* _tmp37_;
		const gchar* _tmp38_ = NULL;
		UnityFilterOption* _tmp39_ = NULL;
		UnityFilterOption* _tmp40_;
		UnityFilter* _tmp41_;
		_tmp0_ = _ ("Type");
		_tmp1_ = unity_radio_option_filter_new ("type", _tmp0_, NULL, FALSE);
		filter = _tmp1_;
		unity_options_filter_set_sort_type ((UnityOptionsFilter*) filter, UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME);
		_tmp2_ = _ ("Accessories");
		_tmp3_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "accessories", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = _ ("Education");
		_tmp6_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "education", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_tmp8_ = _ ("Games");
		_tmp9_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "game", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = _ ("Graphics");
		_tmp12_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "graphics", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_tmp14_ = _ ("Internet");
		_tmp15_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "internet", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		_tmp17_ = _ ("Fonts");
		_tmp18_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "fonts", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_tmp20_ = _ ("Office");
		_tmp21_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "office", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_tmp23_ = _ ("Media");
		_tmp24_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "media", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp25_);
		_tmp26_ = _ ("Customization");
		_tmp27_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "customization", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp28_);
		_tmp29_ = _ ("Accessibility");
		_tmp30_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "accessibility", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp31_);
		_tmp32_ = _ ("Developer");
		_tmp33_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "developer", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp34_);
		_tmp35_ = _ ("Science & Engineering");
		_tmp36_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "science-and-engineering", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp37_);
		_tmp38_ = _ ("System");
		_tmp39_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "system", _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		_g_object_unref0 (_tmp40_);
		_tmp41_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp41_);
		_g_object_unref0 (filter);
	}
	{
		const gchar* _tmp42_ = NULL;
		UnityRatingsFilter* _tmp43_;
		UnityRatingsFilter* filter;
		UnityFilter* _tmp44_;
		_tmp42_ = _ ("Rating");
		_tmp43_ = unity_ratings_filter_new ("rating", _tmp42_, NULL, FALSE);
		filter = _tmp43_;
		_tmp44_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp44_);
		_g_object_unref0 (filter);
	}
	_tmp45_ = self->priv->lens;
	unity_lens_set_filters (_tmp45_, filters);
	__g_list_free__g_object_unref0_0 (filters);
}


static gpointer _gmenu_tree_ref0 (gpointer self) {
	return self ? gmenu_tree_ref (self) : NULL;
}


static gboolean _unity_applications_lens_daemon_build_app_menu_index_and_result_models_gsource_func (gpointer self) {
	gboolean result;
	result = unity_applications_lens_daemon_build_app_menu_index_and_result_models (self);
	return result;
}


static void ___lambda4_ (UnityApplicationsLensDaemon* self, GMenuTree* menu) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->priv->app_menu_changed_reindex_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->app_menu_changed_reindex_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _unity_applications_lens_daemon_build_app_menu_index_and_result_models_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->app_menu_changed_reindex_timeout = _tmp2_;
}


static void ____lambda4__gmenu_tree_changed_func (GMenuTree* tree, gpointer self) {
	___lambda4_ (self, tree);
}


static gboolean unity_applications_lens_daemon_build_app_menu_index (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	GMenuTree* _tmp0_;
	GMenuTree* _tmp4_;
	UnityPackageSearcher* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->app_menu;
	if (_tmp0_ == NULL) {
		GMenuTree* _tmp1_ = NULL;
		GMenuTree* _tmp2_;
		GMenuTree* _tmp3_;
		g_debug ("daemon.vala:256: Building initial application menu");
		_tmp1_ = gmenu_tree_lookup ("unity-lens-applications.menu", GMENU_TREE_FLAGS_INCLUDE_NODISPLAY);
		_tmp2_ = _gmenu_tree_ref0 (_tmp1_);
		_gmenu_tree_unref0 (self->priv->app_menu);
		self->priv->app_menu = _tmp2_;
		_tmp3_ = self->priv->app_menu;
		gmenu_tree_add_monitor (_tmp3_, ____lambda4__gmenu_tree_changed_func, self);
	}
	g_debug ("daemon.vala:277: Indexing application menu");
	_tmp4_ = self->priv->app_menu;
	_tmp5_ = unity_package_searcher_new_for_menu (_tmp4_);
	_unity_package_searcher_free0 (self->appsearcher);
	self->appsearcher = _tmp5_;
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean unity_applications_lens_daemon_build_app_menu_index_and_result_models (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	unity_applications_lens_daemon_build_app_menu_index (self);
	g_debug ("daemon.vala:292: Updating result models");
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = NULL;
	_g_object_unref0 (self->priv->previous_global_search);
	self->priv->previous_global_search = NULL;
	_tmp0_ = self->priv->scope;
	g_object_notify ((GObject*) _tmp0_, "active-search");
	_tmp1_ = self->priv->scope;
	g_object_notify ((GObject*) _tmp1_, "active-global-search");
	result = FALSE;
	return result;
}


static void unity_applications_lens_daemon_populate_zg_templates (UnityApplicationsLensDaemon* self) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistEvent* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* _tmp5_;
	ZeitgeistEvent* ev;
	GPtrArray* _tmp6_;
	GObject* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_sized_new ((guint) 1);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	self->priv->zg_templates = _tmp0_;
	_tmp1_ = zeitgeist_subject_new_full ("application://*", "", "", "", "", "", "");
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_tmp3_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp2_, NULL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	ev = _tmp5_;
	_tmp6_ = self->priv->zg_templates;
	_tmp7_ = g_object_ref (G_IS_OBJECT (ev) ? ((GObject*) ev) : NULL);
	g_ptr_array_add (_tmp6_, _tmp7_);
	_g_object_unref0 (ev);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* unity_applications_lens_daemon_prepare_zg_search_string (UnityApplicationsLensDaemon* self, UnityLensSearch* search, const gchar* type_id) {
	gchar* result = NULL;
	gchar* s = NULL;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_;
	const gchar* _tmp15_;
	const gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	_tmp0_ = search;
	if (_tmp0_ != NULL) {
		UnityLensSearch* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = search;
		_tmp2_ = unity_lens_search_get_search_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (s);
		s = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (s);
		s = _tmp5_;
	}
	_tmp6_ = s;
	_tmp7_ = string_strip (_tmp6_);
	_g_free0 (s);
	s = _tmp7_;
	_tmp9_ = s;
	_tmp10_ = g_str_has_suffix (_tmp9_, "*");
	if (!_tmp10_) {
		const gchar* _tmp11_;
		_tmp11_ = s;
		_tmp8_ = g_strcmp0 (_tmp11_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = s;
		_tmp14_ = g_strconcat (_tmp13_, "*", NULL);
		_g_free0 (s);
		s = _tmp14_;
	}
	_tmp15_ = s;
	if (g_strcmp0 (_tmp15_, "") != 0) {
		const gchar* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp16_ = s;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strconcat ("app:(", _tmp17_, ")", NULL);
		_g_free0 (s);
		s = _tmp18_;
	} else {
		GHashTable* _tmp19_;
		const gchar* _tmp20_;
		gconstpointer _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp19_ = self->priv->type_queries;
		_tmp20_ = type_id;
		_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
		_tmp22_ = g_strdup ((const gchar*) _tmp21_);
		result = _tmp22_;
		_g_free0 (s);
		return result;
	}
	_tmp23_ = type_id;
	if (g_strcmp0 (_tmp23_, "all") == 0) {
		result = s;
		return result;
	} else {
		const gchar* _tmp24_;
		GHashTable* _tmp25_;
		const gchar* _tmp26_;
		gconstpointer _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp24_ = s;
		_tmp25_ = self->priv->type_queries;
		_tmp26_ = type_id;
		_tmp27_ = g_hash_table_lookup (_tmp25_, _tmp26_);
		_tmp28_ = string_to_string ((const gchar*) _tmp27_);
		_tmp29_ = g_strconcat (" AND ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp24_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		result = _tmp32_;
		_g_free0 (s);
		return result;
	}
	_g_free0 (s);
}


static void unity_applications_lens_daemon_update_scope_search_data_free (gpointer _data) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonUpdateScopeSearchData, _data_);
}


static void unity_applications_lens_daemon_update_scope_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonUpdateScopeSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_update_scope_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_update_scope_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	unity_applications_lens_daemon_update_scope_search_co (_data_);
}


static void unity_applications_lens_daemon_update_scope_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void unity_applications_lens_daemon_update_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateScopeSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_applications_lens_daemon_update_scope_search_co (_data_);
}


static gboolean __lambda5_ (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	UnityScope* _tmp0_;
	_tmp0_ = self->priv->scope;
	g_object_thaw_notify ((GObject*) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
	return result;
}


static gboolean unity_applications_lens_daemon_update_scope_search_co (UnityApplicationsLensDaemonUpdateScopeSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->scope;
	g_object_freeze_notify ((GObject*) _data_->_tmp0_);
	_data_->_tmp1_ = _data_->self->priv->scope;
	_data_->_tmp2_ = unity_scope_get_results_model (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->model = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->search;
	_data_->_tmp6_ = unity_lens_search_get_search_string (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_debug ("daemon.vala:349: Searching for: %s", _data_->_tmp7_);
	_data_->_tmp8_ = _data_->self->priv->scope;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = unity_scope_get_filter (_data_->_tmp8_, "type");
	_data_->filter = UNITY_IS_RADIO_OPTION_FILTER (_data_->_tmp9_) ? ((UnityRadioOptionFilter*) _data_->_tmp9_) : NULL;
	_data_->_tmp10_ = _data_->filter;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = unity_radio_option_filter_get_active_option (_data_->_tmp10_);
	_data_->option = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->option;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp12_ = "all";
	} else {
		_data_->_tmp14_ = _data_->option;
		_data_->_tmp15_ = unity_filter_option_get_id (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp12_ = _data_->_tmp16_;
	}
	_data_->_tmp17_ = _data_->_tmp12_;
	_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
	_data_->type_id = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->search;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = unity_applications_lens_daemon_prepare_pkg_search_string (_data_->self, _data_->_tmp19_, _data_->type_id);
	_data_->pkg_search_string = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->search;
	_data_->_tmp22_ = FALSE;
	_data_->_tmp22_ = unity_applications_lens_utils_search_is_invalid (_data_->_tmp21_);
	_data_->has_search = !_data_->_tmp22_;
	_data_->_tmp23_ = g_timer_new ();
	_data_->timer = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->search;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = unity_applications_lens_daemon_prepare_zg_search_string (_data_->self, _data_->_tmp24_, _data_->type_id);
	_data_->zg_search_string = _data_->_tmp25_;
	{
		g_debug ("daemon.vala:369: SEARCH_STRING: %s", _data_->zg_search_string);
		_data_->_tmp26_ = _data_->self->priv->zg_index;
		_data_->_tmp27_ = zeitgeist_time_range_new_anytime ();
		_data_->_tmp28_ = g_object_ref_sink (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->self->priv->zg_templates;
		_data_->_tmp30_ = _g_ptr_array_ref0 (_data_->_tmp29_);
		_data_->_state_ = 1;
		zeitgeist_index_search (_data_->_tmp26_, _data_->zg_search_string, _data_->_tmp28_, _data_->_tmp30_, (guint32) ZEITGEIST_STORAGE_STATE_ANY, (guint32) 20, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, unity_applications_lens_daemon_update_scope_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = zeitgeist_index_search_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_g_object_unref0 (_data_->_tmp28_);
		_data_->results = _data_->_tmp32_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_data_->_tmp33_ = _data_->model;
		dee_model_clear ((DeeModel*) _data_->_tmp33_);
		_data_->_tmp34_ = _data_->model;
		unity_applications_lens_daemon_append_events_with_category (_data_->self, _data_->results, (DeeModel*) _data_->_tmp34_, (guint) UNITY_APPLICATIONS_LENS_CATEGORY_MOST_USED);
		g_timer_stop (_data_->timer);
		_data_->_tmp35_ = 0U;
		_data_->_tmp35_ = zeitgeist_result_set_size (_data_->results);
		_data_->_tmp36_ = 0U;
		_data_->_tmp36_ = zeitgeist_result_set_estimated_matches (_data_->results);
		_data_->_tmp37_ = 0.0;
		_data_->_tmp37_ = g_timer_elapsed (_data_->timer, NULL);
		g_debug ("daemon.vala:382: Entry search found %u/%u Most Used apps in %fms for q" \
"uery '%s'", _data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_ * 1000, _data_->zg_search_string);
		_g_object_unref0 (_data_->results);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp38_ = _data_->search;
		_data_->_tmp39_ = unity_lens_search_get_search_string (_data_->_tmp38_);
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp41_ = _data_->e;
		_data_->_tmp42_ = _data_->_tmp41_->message;
		g_warning ("daemon.vala:387: Error performing search '%s': %s", _data_->_tmp40_, _data_->_tmp42_);
		_data_->_tmp43_ = _data_->model;
		dee_model_clear ((DeeModel*) _data_->_tmp43_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->zg_search_string);
		_g_timer_destroy0 (_data_->timer);
		_g_free0 (_data_->pkg_search_string);
		_g_free0 (_data_->type_id);
		_g_object_unref0 (_data_->option);
		_g_object_unref0 (_data_->filter);
		_g_object_unref0 (_data_->model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_timer_start (_data_->timer);
	_data_->_tmp44_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->installed_uris = (GeeSet*) _data_->_tmp44_;
	_data_->_tmp45_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->available_uris = (GeeSet*) _data_->_tmp45_;
	if (_data_->has_search) {
		_data_->_tmp46_ = UNITY_PACKAGE_SORT_BY_RELEVANCY;
	} else {
		_data_->_tmp46_ = UNITY_PACKAGE_SORT_BY_NAME;
	}
	_data_->_tmp47_ = _data_->self->appsearcher;
	_data_->_tmp48_ = _data_->_tmp46_;
	_data_->_tmp49_ = NULL;
	_data_->_tmp49_ = unity_package_searcher_search (_data_->_tmp47_, _data_->pkg_search_string, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_PREFIX, _data_->_tmp48_);
	_data_->appresults = _data_->_tmp49_;
	_data_->_tmp50_ = _data_->appresults;
	_data_->_tmp51_ = _data_->installed_uris;
	_data_->_tmp52_ = _data_->available_uris;
	_data_->_tmp53_ = _data_->model;
	unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, (DeeModel*) _data_->_tmp53_, UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED, (guint) 0);
	g_timer_stop (_data_->timer);
	_data_->_tmp54_ = _data_->appresults;
	_data_->_tmp55_ = _data_->_tmp54_->num_hits;
	_data_->_tmp56_ = 0.0;
	_data_->_tmp56_ = g_timer_elapsed (_data_->timer, NULL);
	g_debug ("daemon.vala:404: Entry search listed %i Installed apps in %fms for que" \
"ry: %s", _data_->_tmp55_, _data_->_tmp56_ * 1000, _data_->pkg_search_string);
	_data_->_tmp57_ = _data_->model;
	dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (_data_->_tmp57_) ? ((DeeSharedModel*) _data_->_tmp57_) : NULL);
	if (_data_->has_search) {
		_data_->_tmp59_ = _data_->self->priv->pkgsearcher;
		_data_->_tmp58_ = _data_->_tmp59_ != NULL;
	} else {
		_data_->_tmp58_ = FALSE;
	}
	_data_->_tmp60_ = _data_->_tmp58_;
	if (_data_->_tmp60_) {
		g_timer_start (_data_->timer);
		_data_->_tmp61_ = _data_->self->priv->pkgsearcher;
		_data_->_tmp62_ = NULL;
		_data_->_tmp62_ = unity_package_searcher_search (_data_->_tmp61_, _data_->pkg_search_string, (guint) 50, UNITY_PACKAGE_SEARCHTYPE_PREFIX, UNITY_PACKAGE_SORT_BY_RELEVANCY);
		_data_->pkgresults = _data_->_tmp62_;
		_data_->_tmp63_ = _data_->pkgresults;
		_data_->_tmp64_ = _data_->installed_uris;
		_data_->_tmp65_ = _data_->available_uris;
		_data_->_tmp66_ = _data_->model;
		unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_, (DeeModel*) _data_->_tmp66_, UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE, (guint) 0);
		g_timer_stop (_data_->timer);
		_data_->_tmp67_ = _data_->pkgresults;
		_data_->_tmp68_ = _data_->_tmp67_->num_hits;
		_data_->_tmp69_ = 0.0;
		_data_->_tmp69_ = g_timer_elapsed (_data_->timer, NULL);
		g_debug ("daemon.vala:423: Entry search listed %i Available apps in %fms for que" \
"ry: %s", _data_->_tmp68_, _data_->_tmp69_ * 1000, _data_->pkg_search_string);
		_unity_package_search_result_free0 (_data_->pkgresults);
	} else {
		_data_->_tmp70_ = _data_->self->priv->pkgsearcher;
		if (_data_->_tmp70_ != NULL) {
			g_timer_start (_data_->timer);
			_data_->_tmp71_ = NULL;
			_data_->_tmp71_ = unity_applications_lens_daemon_prepare_pkg_search_string (_data_->self, NULL, _data_->type_id);
			_data_->filter_query = _data_->_tmp71_;
			_data_->_tmp72_ = _data_->self->priv->pkgsearcher;
			_data_->_tmp73_ = _data_->filter_query;
			_data_->_tmp74_ = NULL;
			_data_->_tmp74_ = unity_package_searcher_get_random_apps (_data_->_tmp72_, _data_->_tmp73_, (guint) 12);
			_data_->random_pkgresults = _data_->_tmp74_;
			_data_->_tmp75_ = _data_->random_pkgresults;
			_data_->_tmp76_ = _data_->installed_uris;
			_data_->_tmp77_ = _data_->available_uris;
			_data_->_tmp78_ = _data_->model;
			unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp75_, _data_->_tmp76_, _data_->_tmp77_, (DeeModel*) _data_->_tmp78_, UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE, (guint) 6);
			g_timer_stop (_data_->timer);
			_data_->_tmp79_ = _data_->random_pkgresults;
			_data_->_tmp80_ = _data_->_tmp79_->num_hits;
			_data_->_tmp81_ = 0.0;
			_data_->_tmp81_ = g_timer_elapsed (_data_->timer, NULL);
			g_debug ("daemon.vala:434: Entry search listed %i random Available apps in %fms", _data_->_tmp80_, _data_->_tmp81_ * 1000);
			_unity_package_search_result_free0 (_data_->random_pkgresults);
			_g_free0 (_data_->filter_query);
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (_data_->self), g_object_unref);
	_data_->_tmp82_ = _data_->search;
	if (_data_->_tmp82_ != NULL) {
		_data_->_tmp83_ = _data_->search;
		g_signal_emit_by_name (_data_->_tmp83_, "finished");
	}
	_unity_package_search_result_free0 (_data_->appresults);
	_g_object_unref0 (_data_->available_uris);
	_g_object_unref0 (_data_->installed_uris);
	_g_free0 (_data_->zg_search_string);
	_g_timer_destroy0 (_data_->timer);
	_g_free0 (_data_->pkg_search_string);
	_g_free0 (_data_->type_id);
	_g_object_unref0 (_data_->option);
	_g_object_unref0 (_data_->filter);
	_g_object_unref0 (_data_->model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_applications_lens_daemon_update_global_search_data_free (gpointer _data) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityApplicationsLensDaemonUpdateGlobalSearchData, _data_);
}


static void unity_applications_lens_daemon_update_global_search (UnityApplicationsLensDaemon* self, UnityLensSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	UnityApplicationsLensDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	_data_ = g_slice_new0 (UnityApplicationsLensDaemonUpdateGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_lens_daemon_update_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_lens_daemon_update_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	unity_applications_lens_daemon_update_global_search_co (_data_);
}


static void unity_applications_lens_daemon_update_global_search_finish (UnityApplicationsLensDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean __lambda6_ (UnityApplicationsLensDaemon* self) {
	gboolean result = FALSE;
	UnityScope* _tmp0_;
	_tmp0_ = self->priv->scope;
	g_object_thaw_notify ((GObject*) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
	return result;
}


static gboolean unity_applications_lens_daemon_update_global_search_co (UnityApplicationsLensDaemonUpdateGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->scope;
	_data_->_tmp1_ = unity_scope_get_global_results_model (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->model = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->model;
	dee_model_clear ((DeeModel*) _data_->_tmp4_);
	_data_->_tmp5_ = _data_->search;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = unity_applications_lens_utils_search_is_invalid (_data_->_tmp5_);
	if (_data_->_tmp6_) {
		_g_object_unref0 (_data_->model);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->scope;
	g_object_freeze_notify ((GObject*) _data_->_tmp7_);
	_data_->_tmp8_ = _data_->search;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = unity_applications_lens_daemon_prepare_pkg_search_string (_data_->self, _data_->_tmp8_, "all");
	_data_->search_string = _data_->_tmp9_;
	_data_->_tmp10_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->installed_uris = (GeeSet*) _data_->_tmp10_;
	_data_->_tmp11_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->available_uris = (GeeSet*) _data_->_tmp11_;
	_data_->_tmp12_ = g_timer_new ();
	_data_->timer = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->appsearcher;
	_data_->_tmp14_ = _data_->search_string;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = unity_package_searcher_search (_data_->_tmp13_, _data_->_tmp14_, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_PREFIX, UNITY_PACKAGE_SORT_BY_RELEVANCY);
	_data_->appresults = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->appresults;
	_data_->_tmp17_ = _data_->installed_uris;
	_data_->_tmp18_ = _data_->available_uris;
	_data_->_tmp19_ = _data_->model;
	unity_applications_lens_daemon_add_pkg_search_result (_data_->self, _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, (DeeModel*) _data_->_tmp19_, UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED, (guint) 0);
	_data_->_tmp20_ = _data_->timer;
	g_timer_stop (_data_->_tmp20_);
	_data_->_tmp21_ = _data_->appresults;
	_data_->_tmp22_ = _data_->_tmp21_->num_hits;
	_data_->_tmp23_ = _data_->timer;
	_data_->_tmp24_ = 0.0;
	_data_->_tmp24_ = g_timer_elapsed (_data_->_tmp23_, NULL);
	_data_->_tmp25_ = _data_->search_string;
	g_debug ("daemon.vala:478: Global search listed %i Installed apps in %fms for qu" \
"ery: %s", _data_->_tmp22_, _data_->_tmp24_ * 1000, _data_->_tmp25_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (_data_->self), g_object_unref);
	_data_->_tmp26_ = _data_->search;
	if (_data_->_tmp26_ != NULL) {
		_data_->_tmp27_ = _data_->search;
		g_signal_emit_by_name (_data_->_tmp27_, "finished");
	}
	_unity_package_search_result_free0 (_data_->appresults);
	_g_timer_destroy0 (_data_->timer);
	_g_object_unref0 (_data_->available_uris);
	_g_object_unref0 (_data_->installed_uris);
	_g_free0 (_data_->search_string);
	_g_object_unref0 (_data_->model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = delimiters;
	_tmp3_ = new_delimiter;
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
	result = _result_;
	return result;
}


static gchar* unity_applications_lens_daemon_prepare_pkg_search_string (UnityApplicationsLensDaemon* self, UnityLensSearch* search, const gchar* type_id) {
	gchar* result = NULL;
	UnityLensSearch* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	_tmp0_ = search;
	_tmp1_ = unity_applications_lens_utils_search_is_invalid (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = type_id;
		if (g_strcmp0 (_tmp2_, "all") == 0) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("type:Application");
			result = _tmp3_;
			return result;
		} else {
			GHashTable* _tmp4_;
			const gchar* _tmp5_;
			gconstpointer _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp4_ = self->priv->type_queries;
			_tmp5_ = type_id;
			_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
			_tmp7_ = string_to_string ((const gchar*) _tmp6_);
			_tmp8_ = g_strconcat ("type:Application AND ", _tmp7_, NULL);
			result = _tmp8_;
			return result;
		}
	} else {
		UnityLensSearch* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* s;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		_tmp9_ = search;
		_tmp10_ = unity_lens_search_get_search_string (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		s = _tmp12_;
		_tmp13_ = s;
		_tmp14_ = string_strip (_tmp13_);
		_g_free0 (s);
		s = _tmp14_;
		_tmp15_ = s;
		_tmp16_ = string_delimit (_tmp15_, "-", ' ');
		_g_free0 (s);
		s = _tmp16_;
		_tmp17_ = type_id;
		if (g_strcmp0 (_tmp17_, "all") == 0) {
			const gchar* _tmp18_;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp18_ = s;
			_tmp19_ = string_to_string (_tmp18_);
			_tmp20_ = g_strconcat ("type:Application AND ", _tmp19_, NULL);
			result = _tmp20_;
			_g_free0 (s);
			return result;
		} else {
			GHashTable* _tmp21_;
			const gchar* _tmp22_;
			gconstpointer _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp21_ = self->priv->type_queries;
			_tmp22_ = type_id;
			_tmp23_ = g_hash_table_lookup (_tmp21_, _tmp22_);
			_tmp24_ = string_to_string ((const gchar*) _tmp23_);
			_tmp25_ = s;
			_tmp26_ = string_to_string (_tmp25_);
			_tmp27_ = g_strconcat ("type:Application AND ", _tmp24_, " AND ", _tmp26_, NULL);
			result = _tmp27_;
			_g_free0 (s);
			return result;
		}
		_g_free0 (s);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GIcon* unity_applications_lens_daemon_find_pkg_icon (UnityApplicationsLensDaemon* self, UnityPackageInfo* pkginfo) {
	GIcon* result = NULL;
	UnityPackageInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* desktop_id;
	UnityAppInfoManager* _tmp3_ = NULL;
	UnityAppInfoManager* _tmp4_;
	const gchar* _tmp5_;
	GAppInfo* _tmp6_ = NULL;
	GAppInfo* _tmp7_;
	gboolean _tmp8_;
	gboolean installed;
	gboolean _tmp9_;
	UnityPackageInfo* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GThemedIcon* _tmp78_;
	GThemedIcon* icon;
	GHashTable* _tmp79_;
	UnityPackageInfo* _tmp80_;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	GThemedIcon* _tmp83_;
	GIcon* _tmp84_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkginfo != NULL, NULL);
	_tmp0_ = pkginfo;
	_tmp1_ = _tmp0_->desktop_file;
	_tmp2_ = g_path_get_basename (_tmp1_);
	desktop_id = _tmp2_;
	_tmp3_ = unity_app_info_manager_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = desktop_id;
	_tmp6_ = unity_app_info_manager_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	installed = _tmp8_;
	_tmp9_ = installed;
	if (_tmp9_) {
		UnityPackageInfo* _tmp10_;
		const gchar* _tmp11_;
		GThemedIcon* _tmp12_;
		_tmp10_ = pkginfo;
		_tmp11_ = _tmp10_->icon;
		_tmp12_ = (GThemedIcon*) g_themed_icon_new (_tmp11_);
		result = (GIcon*) _tmp12_;
		_g_free0 (desktop_id);
		return result;
	}
	_tmp13_ = pkginfo;
	_tmp14_ = _tmp13_->icon;
	_tmp15_ = g_str_has_prefix (_tmp14_, "/");
	if (_tmp15_) {
		UnityPackageInfo* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_;
		GFileIcon* _tmp20_;
		GIcon* _tmp21_;
		_tmp16_ = pkginfo;
		_tmp17_ = _tmp16_->icon;
		_tmp18_ = g_file_new_for_path (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = (GFileIcon*) g_file_icon_new (_tmp19_);
		_tmp21_ = (GIcon*) _tmp20_;
		_g_object_unref0 (_tmp19_);
		result = _tmp21_;
		_g_free0 (desktop_id);
		return result;
	} else {
		GHashTable* _tmp22_;
		UnityPackageInfo* _tmp23_;
		const gchar* _tmp24_;
		gconstpointer _tmp25_ = NULL;
		GIcon* _tmp26_;
		GIcon* icon;
		GIcon* _tmp27_;
		gchar* path = NULL;
		UnityPackageInfo* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp22_ = self->priv->file_icon_cache;
		_tmp23_ = pkginfo;
		_tmp24_ = _tmp23_->icon;
		_tmp25_ = g_hash_table_lookup (_tmp22_, _tmp24_);
		_tmp26_ = _g_object_ref0 ((GIcon*) _tmp25_);
		icon = _tmp26_;
		_tmp27_ = icon;
		if (_tmp27_ != NULL) {
			result = icon;
			_g_free0 (desktop_id);
			return result;
		}
		_tmp28_ = pkginfo;
		_tmp29_ = _tmp28_->icon;
		_tmp30_ = string_contains (_tmp29_, ".");
		if (_tmp30_) {
			const gchar* _tmp31_ = NULL;
			UnityPackageInfo* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_;
			gboolean _tmp37_ = FALSE;
			_tmp31_ = string_to_string (CONFIG_DATADIR);
			_tmp32_ = pkginfo;
			_tmp33_ = _tmp32_->icon;
			_tmp34_ = string_to_string (_tmp33_);
			_tmp35_ = g_strconcat (_tmp31_, "/app-install/icons/", _tmp34_, NULL);
			_g_free0 (path);
			path = _tmp35_;
			_tmp36_ = path;
			_tmp37_ = g_file_test (_tmp36_, G_FILE_TEST_EXISTS);
			if (_tmp37_) {
				const gchar* _tmp38_;
				GFile* _tmp39_ = NULL;
				GFile* _tmp40_;
				GFileIcon* _tmp41_;
				GHashTable* _tmp42_;
				UnityPackageInfo* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				GIcon* _tmp46_;
				GIcon* _tmp47_;
				_tmp38_ = path;
				_tmp39_ = g_file_new_for_path (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = (GFileIcon*) g_file_icon_new (_tmp40_);
				_g_object_unref0 (icon);
				icon = (GIcon*) _tmp41_;
				_g_object_unref0 (_tmp40_);
				_tmp42_ = self->priv->file_icon_cache;
				_tmp43_ = pkginfo;
				_tmp44_ = _tmp43_->icon;
				_tmp45_ = g_strdup (_tmp44_);
				_tmp46_ = icon;
				_tmp47_ = _g_object_ref0 (_tmp46_);
				g_hash_table_insert (_tmp42_, _tmp45_, _tmp47_);
				result = icon;
				_g_free0 (path);
				_g_free0 (desktop_id);
				return result;
			}
		}
		{
			GeeList* _tmp48_;
			GeeList* _tmp49_;
			GeeList* _ext_list;
			GeeList* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			gint _ext_size;
			gint _ext_index;
			_tmp48_ = self->priv->image_extensions;
			_tmp49_ = _g_object_ref0 (_tmp48_);
			_ext_list = _tmp49_;
			_tmp50_ = _ext_list;
			_tmp51_ = gee_collection_get_size ((GeeCollection*) _tmp50_);
			_tmp52_ = _tmp51_;
			_ext_size = _tmp52_;
			_ext_index = -1;
			while (TRUE) {
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				GeeList* _tmp56_;
				gint _tmp57_;
				gpointer _tmp58_ = NULL;
				gchar* ext;
				const gchar* _tmp59_ = NULL;
				UnityPackageInfo* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				const gchar* _tmp66_;
				gboolean _tmp67_ = FALSE;
				_tmp53_ = _ext_index;
				_ext_index = _tmp53_ + 1;
				_tmp54_ = _ext_index;
				_tmp55_ = _ext_size;
				if (!(_tmp54_ < _tmp55_)) {
					break;
				}
				_tmp56_ = _ext_list;
				_tmp57_ = _ext_index;
				_tmp58_ = gee_list_get (_tmp56_, _tmp57_);
				ext = (gchar*) _tmp58_;
				_tmp59_ = string_to_string (CONFIG_DATADIR);
				_tmp60_ = pkginfo;
				_tmp61_ = _tmp60_->icon;
				_tmp62_ = string_to_string (_tmp61_);
				_tmp63_ = ext;
				_tmp64_ = string_to_string (_tmp63_);
				_tmp65_ = g_strconcat (_tmp59_, "/app-install/icons/", _tmp62_, ".", _tmp64_, NULL);
				_g_free0 (path);
				path = _tmp65_;
				_tmp66_ = path;
				_tmp67_ = g_file_test (_tmp66_, G_FILE_TEST_EXISTS);
				if (_tmp67_) {
					const gchar* _tmp68_;
					GFile* _tmp69_ = NULL;
					GFile* _tmp70_;
					GFileIcon* _tmp71_;
					GHashTable* _tmp72_;
					UnityPackageInfo* _tmp73_;
					const gchar* _tmp74_;
					gchar* _tmp75_;
					GIcon* _tmp76_;
					GIcon* _tmp77_;
					_tmp68_ = path;
					_tmp69_ = g_file_new_for_path (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = (GFileIcon*) g_file_icon_new (_tmp70_);
					_g_object_unref0 (icon);
					icon = (GIcon*) _tmp71_;
					_g_object_unref0 (_tmp70_);
					_tmp72_ = self->priv->file_icon_cache;
					_tmp73_ = pkginfo;
					_tmp74_ = _tmp73_->icon;
					_tmp75_ = g_strdup (_tmp74_);
					_tmp76_ = icon;
					_tmp77_ = _g_object_ref0 (_tmp76_);
					g_hash_table_insert (_tmp72_, _tmp75_, _tmp77_);
					result = icon;
					_g_free0 (ext);
					_g_object_unref0 (_ext_list);
					_g_free0 (path);
					_g_free0 (desktop_id);
					return result;
				}
				_g_free0 (ext);
			}
			_g_object_unref0 (_ext_list);
		}
		_g_free0 (path);
		_g_object_unref0 (icon);
	}
	_tmp78_ = (GThemedIcon*) g_themed_icon_new ("applications-other");
	icon = _tmp78_;
	_tmp79_ = self->priv->file_icon_cache;
	_tmp80_ = pkginfo;
	_tmp81_ = _tmp80_->icon;
	_tmp82_ = g_strdup (_tmp81_);
	_tmp83_ = icon;
	_tmp84_ = _g_object_ref0 ((GIcon*) _tmp83_);
	g_hash_table_insert (_tmp79_, _tmp82_, _tmp84_);
	result = (GIcon*) icon;
	_g_free0 (desktop_id);
	return result;
}


static void unity_applications_lens_daemon_on_appinfo_changed (UnityApplicationsLensDaemon* self, const gchar* id, GAppInfo* appinfo) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = id;
	g_debug ("daemon.vala:606: Application changed: %s", _tmp0_);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void unity_applications_lens_daemon_add_pkg_search_result (UnityApplicationsLensDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsLensCategory category, guint max_add) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* appmanager;
	UnityScope* _tmp1_;
	UnityFilter* _tmp2_ = NULL;
	UnityRatingsFilter* ratings_filter;
	guint n_added;
	UnityPackageSearchResult* _tmp3_;
	GSList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (installed_uris != NULL);
	g_return_if_fail (available_uris != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = unity_app_info_manager_get_instance ();
	appmanager = _tmp0_;
	_tmp1_ = self->priv->scope;
	_tmp2_ = unity_scope_get_filter (_tmp1_, "rating");
	ratings_filter = UNITY_IS_RATINGS_FILTER (_tmp2_) ? ((UnityRatingsFilter*) _tmp2_) : NULL;
	n_added = (guint) 0;
	_tmp3_ = results;
	_tmp4_ = _tmp3_->results;
	{
		GSList* pkginfo_collection = NULL;
		GSList* pkginfo_it = NULL;
		pkginfo_collection = _tmp4_;
		for (pkginfo_it = pkginfo_collection; pkginfo_it != NULL; pkginfo_it = pkginfo_it->next) {
			UnityPackageInfo* pkginfo = NULL;
			pkginfo = (UnityPackageInfo*) pkginfo_it->data;
			{
				UnityPackageInfo* _tmp5_;
				const gchar* _tmp6_;
				UnityPackageInfo* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* desktop_id;
				gchar* full_path = NULL;
				const gchar* _tmp10_;
				gint _tmp11_ = 0;
				gint colon_pos;
				gint _tmp12_;
				UnityAppInfoManager* _tmp19_;
				const gchar* _tmp20_;
				GAppInfo* _tmp21_ = NULL;
				GAppInfo* app;
				UnityAppInfoManager* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				const gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* uri;
				gboolean _tmp28_ = FALSE;
				GeeSet* _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp35_;
				gchar* display_name = NULL;
				gchar* comment = NULL;
				UnityApplicationsLensCategory _tmp36_;
				gboolean _tmp55_ = FALSE;
				GAppInfo* _tmp56_;
				gboolean _tmp59_;
				UnityApplicationsLensCategory _tmp60_;
				UnityPackageInfo* _tmp87_;
				GIcon* _tmp88_ = NULL;
				GIcon* icon;
				const gchar* _tmp89_ = NULL;
				const gchar* _tmp90_;
				const gchar* _tmp92_ = NULL;
				const gchar* _tmp93_;
				gchar* _tmp95_ = NULL;
				const gchar* _tmp96_;
				DeeModel* _tmp100_;
				const gchar* _tmp101_;
				GIcon* _tmp102_;
				gchar* _tmp103_ = NULL;
				gchar* _tmp104_;
				UnityApplicationsLensCategory _tmp105_;
				const gchar* _tmp106_;
				const gchar* _tmp107_;
				const gchar* _tmp108_;
				guint _tmp109_;
				gboolean _tmp110_ = FALSE;
				guint _tmp111_;
				gboolean _tmp114_;
				_tmp5_ = pkginfo;
				_tmp6_ = _tmp5_->desktop_file;
				if (_tmp6_ == NULL) {
					continue;
				}
				_tmp7_ = pkginfo;
				_tmp8_ = _tmp7_->desktop_file;
				_tmp9_ = g_path_get_basename (_tmp8_);
				desktop_id = _tmp9_;
				_tmp10_ = desktop_id;
				_tmp11_ = string_index_of (_tmp10_, ":", 0);
				colon_pos = _tmp11_;
				_tmp12_ = colon_pos;
				if (_tmp12_ > 0) {
					const gchar* _tmp13_;
					gint _tmp14_;
					const gchar* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					gchar* _tmp18_ = NULL;
					_tmp13_ = desktop_id;
					_tmp14_ = colon_pos;
					_tmp15_ = desktop_id;
					_tmp16_ = strlen (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = string_slice (_tmp13_, (glong) (_tmp14_ + 1), (glong) _tmp17_);
					_g_free0 (desktop_id);
					desktop_id = _tmp18_;
				}
				_tmp19_ = appmanager;
				_tmp20_ = desktop_id;
				_tmp21_ = unity_app_info_manager_lookup (_tmp19_, _tmp20_);
				app = _tmp21_;
				_tmp22_ = appmanager;
				_tmp23_ = desktop_id;
				_tmp24_ = unity_app_info_manager_get_path (_tmp22_, _tmp23_);
				_g_free0 (full_path);
				full_path = _tmp24_;
				_tmp25_ = desktop_id;
				_tmp26_ = string_to_string (_tmp25_);
				_tmp27_ = g_strconcat ("application://", _tmp26_, NULL);
				uri = _tmp27_;
				_tmp29_ = installed_uris;
				_tmp30_ = uri;
				_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp29_, _tmp30_);
				if (_tmp31_) {
					_tmp28_ = TRUE;
				} else {
					GeeSet* _tmp32_;
					const gchar* _tmp33_;
					gboolean _tmp34_ = FALSE;
					_tmp32_ = available_uris;
					_tmp33_ = uri;
					_tmp34_ = gee_collection_contains ((GeeCollection*) _tmp32_, _tmp33_);
					_tmp28_ = _tmp34_;
				}
				_tmp35_ = _tmp28_;
				if (_tmp35_) {
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (full_path);
					_g_free0 (desktop_id);
					continue;
				}
				_tmp36_ = category;
				switch (_tmp36_) {
					case UNITY_APPLICATIONS_LENS_CATEGORY_INSTALLED:
					{
						GeeSet* _tmp37_;
						const gchar* _tmp38_;
						GAppInfo* _tmp39_;
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_;
						GAppInfo* _tmp42_;
						const gchar* _tmp43_ = NULL;
						gchar* _tmp44_;
						_tmp37_ = installed_uris;
						_tmp38_ = uri;
						gee_collection_add ((GeeCollection*) _tmp37_, _tmp38_);
						_tmp39_ = app;
						_tmp40_ = g_app_info_get_display_name (_tmp39_);
						_tmp41_ = g_strdup (_tmp40_);
						_g_free0 (display_name);
						display_name = _tmp41_;
						_tmp42_ = app;
						_tmp43_ = g_app_info_get_description (_tmp42_);
						_tmp44_ = g_strdup (_tmp43_);
						_g_free0 (comment);
						comment = _tmp44_;
						break;
					}
					case UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE:
					{
						GeeSet* _tmp45_;
						const gchar* _tmp46_;
						UnityPackageInfo* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						_tmp45_ = available_uris;
						_tmp46_ = uri;
						gee_collection_add ((GeeCollection*) _tmp45_, _tmp46_);
						_tmp47_ = pkginfo;
						_tmp48_ = _tmp47_->application_name;
						_tmp49_ = g_strdup (_tmp48_);
						_g_free0 (display_name);
						display_name = _tmp49_;
						_tmp50_ = g_strdup ("");
						_g_free0 (comment);
						comment = _tmp50_;
						break;
					}
					default:
					{
						UnityApplicationsLensCategory _tmp51_;
						GEnumValue* _tmp52_;
						gchar* _tmp53_ = NULL;
						gchar* _tmp54_;
						_tmp51_ = category;
						_tmp52_ = g_enum_get_value (g_type_class_ref (UNITY_APPLICATIONS_LENS_TYPE_CATEGORY), _tmp51_);
						_tmp53_ = g_strconcat ("Illegal category for package search ", (_tmp52_ != NULL) ? _tmp52_->value_name : NULL, NULL);
						_tmp54_ = _tmp53_;
						g_warning ("daemon.vala:662: %s", _tmp54_);
						_g_free0 (_tmp54_);
						continue;
					}
				}
				_tmp56_ = app;
				if (_tmp56_ != NULL) {
					GAppInfo* _tmp57_;
					gboolean _tmp58_ = FALSE;
					_tmp57_ = app;
					_tmp58_ = g_app_info_should_show (_tmp57_);
					_tmp55_ = !_tmp58_;
				} else {
					_tmp55_ = FALSE;
				}
				_tmp59_ = _tmp55_;
				if (_tmp59_) {
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (full_path);
					_g_free0 (desktop_id);
					continue;
				}
				_tmp60_ = category;
				if (_tmp60_ == UNITY_APPLICATIONS_LENS_CATEGORY_AVAILABLE) {
					GAppInfo* _tmp61_;
					gboolean _tmp62_ = FALSE;
					UnityRatingsDatabase* _tmp63_;
					gboolean _tmp67_;
					UnityPackageInfo* _tmp78_;
					const gchar* _tmp79_;
					const gchar* _tmp80_ = NULL;
					UnityPackageInfo* _tmp81_;
					const gchar* _tmp82_;
					const gchar* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					GeeSet* _tmp85_;
					const gchar* _tmp86_;
					_tmp61_ = app;
					if (_tmp61_ != NULL) {
						_g_free0 (comment);
						_g_free0 (display_name);
						_g_free0 (uri);
						_g_object_unref0 (app);
						_g_free0 (full_path);
						_g_free0 (desktop_id);
						continue;
					}
					_tmp63_ = self->priv->ratings;
					if (_tmp63_ != NULL) {
						UnityRatingsFilter* _tmp64_;
						gfloat _tmp65_;
						gfloat _tmp66_;
						_tmp64_ = ratings_filter;
						_tmp65_ = unity_ratings_filter_get_rating (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp62_ = ((gdouble) _tmp66_) > 0.00001;
					} else {
						_tmp62_ = FALSE;
					}
					_tmp67_ = _tmp62_;
					if (_tmp67_) {
						UnityRatingsResult _result_ = {0};
						UnityRatingsDatabase* _tmp68_;
						UnityPackageInfo* _tmp69_;
						const gchar* _tmp70_;
						UnityRatingsResult _tmp71_ = {0};
						gboolean _tmp72_ = FALSE;
						_tmp68_ = self->priv->ratings;
						_tmp69_ = pkginfo;
						_tmp70_ = _tmp69_->package_name;
						_tmp72_ = unity_ratings_database_query (_tmp68_, _tmp70_, &_tmp71_);
						_result_ = _tmp71_;
						if (_tmp72_) {
							UnityRatingsResult _tmp73_;
							gint32 _tmp74_;
							UnityRatingsFilter* _tmp75_;
							gfloat _tmp76_;
							gfloat _tmp77_;
							_tmp73_ = _result_;
							_tmp74_ = _tmp73_.average_rating;
							_tmp75_ = ratings_filter;
							_tmp76_ = unity_ratings_filter_get_rating (_tmp75_);
							_tmp77_ = _tmp76_;
							if (((gdouble) _tmp74_) < ((_tmp77_ * 5) - 0.2)) {
								_g_free0 (comment);
								_g_free0 (display_name);
								_g_free0 (uri);
								_g_object_unref0 (app);
								_g_free0 (full_path);
								_g_free0 (desktop_id);
								continue;
							}
						} else {
							_g_free0 (comment);
							_g_free0 (display_name);
							_g_free0 (uri);
							_g_object_unref0 (app);
							_g_free0 (full_path);
							_g_free0 (desktop_id);
							continue;
						}
					}
					_tmp78_ = pkginfo;
					_tmp79_ = _tmp78_->package_name;
					_tmp80_ = string_to_string (_tmp79_);
					_tmp81_ = pkginfo;
					_tmp82_ = _tmp81_->application_name;
					_tmp83_ = string_to_string (_tmp82_);
					_tmp84_ = g_strconcat ("unity-install://", _tmp80_, "/", _tmp83_, NULL);
					_g_free0 (uri);
					uri = _tmp84_;
					_tmp85_ = available_uris;
					_tmp86_ = uri;
					gee_collection_add ((GeeCollection*) _tmp85_, _tmp86_);
				}
				_tmp87_ = pkginfo;
				_tmp88_ = unity_applications_lens_daemon_find_pkg_icon (self, _tmp87_);
				icon = _tmp88_;
				_tmp90_ = display_name;
				if (_tmp90_ != NULL) {
					const gchar* _tmp91_;
					_tmp91_ = display_name;
					_tmp89_ = _tmp91_;
				} else {
					_tmp89_ = "";
				}
				_tmp93_ = comment;
				if (_tmp93_ != NULL) {
					const gchar* _tmp94_;
					_tmp94_ = comment;
					_tmp92_ = _tmp94_;
				} else {
					_tmp92_ = "";
				}
				_tmp96_ = full_path;
				if (_tmp96_ != NULL) {
					const gchar* _tmp97_;
					gchar* _tmp98_;
					_tmp97_ = full_path;
					_tmp98_ = g_strconcat ("file://", _tmp97_, NULL);
					_g_free0 (_tmp95_);
					_tmp95_ = _tmp98_;
				} else {
					gchar* _tmp99_;
					_tmp99_ = g_strdup ("");
					_g_free0 (_tmp95_);
					_tmp95_ = _tmp99_;
				}
				_tmp100_ = model;
				_tmp101_ = uri;
				_tmp102_ = icon;
				_tmp103_ = g_icon_to_string (_tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = category;
				_tmp106_ = _tmp89_;
				_tmp107_ = _tmp92_;
				_tmp108_ = _tmp95_;
				dee_model_append (_tmp100_, _tmp101_, _tmp104_, _tmp105_, "application/x-desktop", _tmp106_, _tmp107_, _tmp108_, NULL);
				_g_free0 (_tmp104_);
				_tmp109_ = n_added;
				n_added = _tmp109_ + 1;
				_tmp111_ = max_add;
				if (_tmp111_ > ((guint) 0)) {
					guint _tmp112_;
					guint _tmp113_;
					_tmp112_ = n_added;
					_tmp113_ = max_add;
					_tmp110_ = _tmp112_ >= _tmp113_;
				} else {
					_tmp110_ = FALSE;
				}
				_tmp114_ = _tmp110_;
				if (_tmp114_) {
					_g_free0 (_tmp95_);
					_g_object_unref0 (icon);
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (full_path);
					_g_free0 (desktop_id);
					_g_object_unref0 (ratings_filter);
					_g_object_unref0 (appmanager);
					return;
				}
				_g_free0 (_tmp95_);
				_g_object_unref0 (icon);
				_g_free0 (comment);
				_g_free0 (display_name);
				_g_free0 (uri);
				_g_object_unref0 (app);
				_g_free0 (full_path);
				_g_free0 (desktop_id);
			}
		}
	}
	_g_object_unref0 (ratings_filter);
	_g_object_unref0 (appmanager);
}


/**
     * Override of the default activation handler. The apps lens daemon
     * can handle activation of installable apps using the Software Center
     */
static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


UnityActivationResponse* unity_applications_lens_daemon_activate (UnityApplicationsLensDaemon* self, const gchar* uri) {
	UnityActivationResponse* result = NULL;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar* exec_or_dir;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp52_ = FALSE;
	const gchar* _tmp53_;
	gboolean _tmp56_;
	UnityActivationResponse* _tmp73_;
	UnityActivationResponse* _tmp74_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	exec_or_dir = NULL;
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "unity-install://");
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		const gchar* pkg;
		const gchar* _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp2_ = uri;
		_tmp3_ = string_offset (_tmp2_, (glong) 16);
		pkg = _tmp3_;
		_tmp4_ = pkg;
		g_debug ("daemon.vala:728: Installing: %s", _tmp4_);
		_tmp5_ = g_new0 (gchar*, 2 + 1);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args = _tmp5_;
		args_length1 = 2;
		_args_size_ = args_length1;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = g_strdup ("software-center");
		_g_free0 (_tmp6_[0]);
		_tmp6_[0] = _tmp7_;
		_tmp8_ = _tmp6_[0];
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = pkg;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp9_[1]);
		_tmp9_[1] = _tmp11_;
		_tmp12_ = _tmp9_[1];
	} else {
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = uri;
		_tmp14_ = g_str_has_prefix (_tmp13_, "unity-runner://");
		if (_tmp14_) {
			gchar* orig = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			GRegex* _tmp19_;
			gboolean _tmp23_;
			UnityApplicationsLensRunner* _tmp47_;
			const gchar* _tmp48_;
			_tmp15_ = uri;
			_tmp16_ = string_offset (_tmp15_, (glong) 15);
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (orig);
			orig = _tmp17_;
			_tmp19_ = self->priv->uri_regex;
			if (_tmp19_ != NULL) {
				GRegex* _tmp20_;
				const gchar* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp20_ = self->priv->uri_regex;
				_tmp21_ = orig;
				_tmp22_ = g_regex_match (_tmp20_, _tmp21_, 0, NULL);
				_tmp18_ = _tmp22_;
			} else {
				_tmp18_ = FALSE;
			}
			_tmp23_ = _tmp18_;
			if (_tmp23_) {
				UnityActivationResponse* _tmp28_;
				UnityActivationResponse* _tmp29_;
				{
					const gchar* _tmp24_;
					_tmp24_ = orig;
					g_app_info_launch_default_for_uri (_tmp24_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp25_;
					UnityActivationResponse* _tmp26_;
					UnityActivationResponse* _tmp27_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp25_ = orig;
					g_warning ("daemon.vala:741: Failed to launch URI %s", _tmp25_);
					_tmp26_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
					_tmp27_ = g_object_ref_sink (_tmp26_);
					result = _tmp27_;
					_g_error_free0 (_error_);
					_g_free0 (orig);
					_g_free0 (exec_or_dir);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_free0 (orig);
					_g_free0 (exec_or_dir);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp28_ = unity_activation_response_new (UNITY_HANDLED_TYPE_HIDE_DASH, "");
				_tmp29_ = g_object_ref_sink (_tmp28_);
				result = _tmp29_;
				_g_free0 (orig);
				_g_free0 (exec_or_dir);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				const gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				const gchar* _tmp32_;
				gchar** _tmp33_;
				gchar** _tmp34_ = NULL;
				_tmp30_ = orig;
				_tmp31_ = unity_applications_lens_utils_subst_tilde (_tmp30_);
				_g_free0 (exec_or_dir);
				exec_or_dir = _tmp31_;
				_tmp32_ = exec_or_dir;
				_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, " ", 0);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp34_;
				args_length1 = _vala_array_length (_tmp33_);
				_args_size_ = args_length1;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp35_;
						_tmp35_ = TRUE;
						while (TRUE) {
							gboolean _tmp36_;
							gint _tmp38_;
							gchar** _tmp39_;
							gint _tmp39__length1;
							gchar** _tmp40_;
							gint _tmp40__length1;
							gint _tmp41_;
							gchar** _tmp42_;
							gint _tmp42__length1;
							gint _tmp43_;
							const gchar* _tmp44_;
							gchar* _tmp45_ = NULL;
							gchar* _tmp46_;
							_tmp36_ = _tmp35_;
							if (!_tmp36_) {
								gint _tmp37_;
								_tmp37_ = i;
								i = _tmp37_ + 1;
							}
							_tmp35_ = FALSE;
							_tmp38_ = i;
							_tmp39_ = args;
							_tmp39__length1 = args_length1;
							if (!(_tmp38_ < _tmp39__length1)) {
								break;
							}
							_tmp40_ = args;
							_tmp40__length1 = args_length1;
							_tmp41_ = i;
							_tmp42_ = args;
							_tmp42__length1 = args_length1;
							_tmp43_ = i;
							_tmp44_ = _tmp42_[_tmp43_];
							_tmp45_ = unity_applications_lens_utils_subst_tilde (_tmp44_);
							_g_free0 (_tmp40_[_tmp41_]);
							_tmp40_[_tmp41_] = _tmp45_;
							_tmp46_ = _tmp40_[_tmp41_];
						}
					}
				}
			}
			_tmp47_ = self->priv->runner;
			_tmp48_ = orig;
			unity_applications_lens_runner_add_history (_tmp47_, _tmp48_);
			_g_free0 (orig);
		} else {
			const gchar* _tmp49_;
			UnityActivationResponse* _tmp50_;
			UnityActivationResponse* _tmp51_;
			_tmp49_ = uri;
			g_debug ("daemon.vala:756: Declined activation of URI '%s': Expected URI scheme " \
"unity-install:// or unity-runner://", _tmp49_);
			_tmp50_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
			_tmp51_ = g_object_ref_sink (_tmp50_);
			result = _tmp51_;
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
	_tmp53_ = exec_or_dir;
	if (_tmp53_ != NULL) {
		const gchar* _tmp54_;
		gboolean _tmp55_ = FALSE;
		_tmp54_ = exec_or_dir;
		_tmp55_ = g_file_test (_tmp54_, G_FILE_TEST_IS_DIR);
		_tmp52_ = _tmp55_;
	} else {
		_tmp52_ = FALSE;
	}
	_tmp56_ = _tmp52_;
	if (_tmp56_) {
		{
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp57_ = exec_or_dir;
			_tmp58_ = g_strconcat ("file://", _tmp57_, NULL);
			_tmp59_ = _tmp58_;
			g_app_info_launch_default_for_uri (_tmp59_, NULL, &_inner_error_);
			_g_free0 (_tmp59_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp60_;
			GError* _tmp61_;
			const gchar* _tmp62_;
			UnityActivationResponse* _tmp63_;
			UnityActivationResponse* _tmp64_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp60_ = exec_or_dir;
			_tmp61_ = err;
			_tmp62_ = _tmp61_->message;
			g_warning ("daemon.vala:765: Failed to open current folder '%s' in file manager: %" \
"s", _tmp60_, _tmp62_);
			_tmp63_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
			_tmp64_ = g_object_ref_sink (_tmp63_);
			result = _tmp64_;
			_g_error_free0 (err);
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		{
			const gchar* _tmp65_ = NULL;
			const gchar* home_dir;
			const gchar* _tmp66_;
			gchar** _tmp67_;
			gint _tmp67__length1;
			_tmp65_ = g_get_home_dir ();
			home_dir = _tmp65_;
			_tmp66_ = home_dir;
			_tmp67_ = args;
			_tmp67__length1 = args_length1;
			g_spawn_async (_tmp66_, _tmp67_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch3_g_spawn_error;
				}
				_g_free0 (exec_or_dir);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		goto __finally3;
		__catch3_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp68_;
			GError* _tmp69_;
			const gchar* _tmp70_;
			UnityActivationResponse* _tmp71_;
			UnityActivationResponse* _tmp72_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp68_ = uri;
			_tmp69_ = e;
			_tmp70_ = _tmp69_->message;
			g_warning ("daemon.vala:776: Failed to spawn software-center or direct URI activat" \
"ion '%s': %s", _tmp68_, _tmp70_);
			_tmp71_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
			_tmp72_ = g_object_ref_sink (_tmp71_);
			result = _tmp72_;
			_g_error_free0 (e);
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (exec_or_dir);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp73_ = unity_activation_response_new (UNITY_HANDLED_TYPE_HIDE_DASH, "");
	_tmp74_ = g_object_ref_sink (_tmp73_);
	result = _tmp74_;
	_g_free0 (exec_or_dir);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void unity_applications_lens_daemon_append_events_with_category (UnityApplicationsLensDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint category_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	g_return_if_fail (results != NULL);
	{
		ZeitgeistResultSet* _tmp0_;
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev = NULL;
		_tmp0_ = events;
		_tmp1_ = _vala_zeitgeist_result_set_iterator (_tmp0_);
		_ev_it = _tmp1_;
		while (TRUE) {
			ZeitgeistResultSet* _tmp2_;
			ZeitgeistEvent* _tmp3_ = NULL;
			ZeitgeistEvent* _tmp4_;
			gchar* app_uri = NULL;
			ZeitgeistEvent* _tmp5_;
			gint _tmp6_ = 0;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* desktop_id;
			gchar* full_path = NULL;
			UnityAppInfoManager* _tmp13_ = NULL;
			UnityAppInfoManager* appmanager;
			UnityAppInfoManager* _tmp14_;
			const gchar* _tmp15_;
			GAppInfo* _tmp16_ = NULL;
			GAppInfo* app;
			GAppInfo* _tmp17_;
			GAppInfo* _tmp18_;
			gboolean _tmp19_ = FALSE;
			UnityAppInfoManager* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			const gchar* _tmp24_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* full_uri;
			DeeModel* _tmp31_;
			const gchar* _tmp32_;
			GAppInfo* _tmp33_;
			GIcon* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			guint _tmp37_;
			GAppInfo* _tmp38_;
			const gchar* _tmp39_ = NULL;
			GAppInfo* _tmp40_;
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_;
			_tmp2_ = _ev_it;
			_tmp3_ = _vala_zeitgeist_result_set_next_value (_tmp2_);
			ev = _tmp3_;
			_tmp4_ = ev;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = ev;
			_tmp6_ = zeitgeist_event_num_subjects (_tmp5_);
			if (_tmp6_ > 0) {
				ZeitgeistEvent* _tmp7_;
				ZeitgeistSubject* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp7_ = ev;
				_tmp8_ = zeitgeist_event_get_subject (_tmp7_, 0);
				_tmp9_ = zeitgeist_subject_get_uri (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (app_uri);
				app_uri = _tmp10_;
			} else {
				g_warning ("daemon.vala:799: Unexpected event without subject");
				_g_free0 (app_uri);
				continue;
			}
			_tmp11_ = app_uri;
			_tmp12_ = unity_applications_lens_utils_get_desktop_id_for_actor (_tmp11_);
			desktop_id = _tmp12_;
			_tmp13_ = unity_app_info_manager_get_instance ();
			appmanager = _tmp13_;
			_tmp14_ = appmanager;
			_tmp15_ = desktop_id;
			_tmp16_ = unity_app_info_manager_lookup (_tmp14_, _tmp15_);
			app = _tmp16_;
			_tmp17_ = app;
			if (_tmp17_ == NULL) {
				_g_object_unref0 (app);
				_g_object_unref0 (appmanager);
				_g_free0 (full_path);
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				continue;
			}
			_tmp18_ = app;
			_tmp19_ = g_app_info_should_show (_tmp18_);
			if (!_tmp19_) {
				_g_object_unref0 (app);
				_g_object_unref0 (appmanager);
				_g_free0 (full_path);
				_g_free0 (desktop_id);
				_g_free0 (app_uri);
				continue;
			}
			_tmp20_ = appmanager;
			_tmp21_ = desktop_id;
			_tmp22_ = unity_app_info_manager_get_path (_tmp20_, _tmp21_);
			_g_free0 (full_path);
			full_path = _tmp22_;
			_tmp24_ = full_path;
			if (_tmp24_ != NULL) {
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = full_path;
				_tmp26_ = g_strconcat ("file://", _tmp25_, NULL);
				_g_free0 (_tmp23_);
				_tmp23_ = _tmp26_;
			} else {
				const gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp27_ = app_uri;
				_tmp28_ = g_strdup (_tmp27_);
				_g_free0 (_tmp23_);
				_tmp23_ = _tmp28_;
			}
			_tmp29_ = _tmp23_;
			_tmp30_ = g_strdup (_tmp29_);
			full_uri = _tmp30_;
			_tmp31_ = results;
			_tmp32_ = app_uri;
			_tmp33_ = app;
			_tmp34_ = g_app_info_get_icon (_tmp33_);
			_tmp35_ = g_icon_to_string (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = category_id;
			_tmp38_ = app;
			_tmp39_ = g_app_info_get_display_name (_tmp38_);
			_tmp40_ = app;
			_tmp41_ = g_app_info_get_description (_tmp40_);
			_tmp42_ = full_uri;
			dee_model_append (_tmp31_, _tmp32_, _tmp36_, _tmp37_, "application/x-desktop", _tmp39_, _tmp41_, _tmp42_, NULL);
			_g_free0 (_tmp36_);
			_g_free0 (full_uri);
			_g_free0 (_tmp23_);
			_g_object_unref0 (app);
			_g_object_unref0 (appmanager);
			_g_free0 (full_path);
			_g_free0 (desktop_id);
			_g_free0 (app_uri);
		}
		_g_object_unref0 (_ev_it);
	}
}


UnityApplicationsLensDaemon* unity_applications_lens_daemon_construct (GType object_type) {
	UnityApplicationsLensDaemon * self = NULL;
	self = (UnityApplicationsLensDaemon*) g_object_new (object_type, NULL);
	return self;
}


UnityApplicationsLensDaemon* unity_applications_lens_daemon_new (void) {
	return unity_applications_lens_daemon_construct (UNITY_APPLICATIONS_LENS_TYPE_DAEMON);
}


static void _unity_applications_lens_daemon___lambda7_ (UnityApplicationsLensDaemon* self, GObject* obj, GParamSpec* pspec) {
	UnityScope* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	UnityLensSearch* _tmp3_;
	UnityLensSearch* search;
	UnityLensSearch* _tmp4_;
	UnityLensSearch* _tmp5_;
	gboolean _tmp6_ = FALSE;
	UnityLensSearch* _tmp7_;
	UnityLensSearch* _tmp8_;
	UnityLensSearch* _tmp9_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->scope;
	_tmp1_ = unity_scope_get_active_search (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	search = _tmp3_;
	_tmp4_ = self->priv->previous_search;
	_tmp5_ = search;
	_tmp6_ = unity_applications_lens_utils_search_has_really_changed (_tmp4_, _tmp5_);
	if (!_tmp6_) {
		_g_object_unref0 (search);
		return;
	}
	_tmp7_ = search;
	unity_applications_lens_daemon_update_scope_search (self, _tmp7_, NULL, NULL);
	_tmp8_ = search;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp9_;
	_g_object_unref0 (search);
}


static void __unity_applications_lens_daemon___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_unity_applications_lens_daemon___lambda7_ (self, _sender, pspec);
}


static void _unity_applications_lens_daemon___lambda8_ (UnityApplicationsLensDaemon* self) {
	UnityScope* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	UnityLensSearch* _tmp3_;
	UnityLensSearch* search;
	gboolean _tmp4_ = FALSE;
	UnityLensSearch* _tmp5_;
	gboolean _tmp9_;
	UnityLensSearch* _tmp10_;
	UnityLensSearch* _tmp11_;
	UnityLensSearch* _tmp12_;
	_tmp0_ = self->priv->scope;
	_tmp1_ = unity_scope_get_active_search (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	search = _tmp3_;
	_tmp5_ = search;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		UnityLensSearch* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = search;
		_tmp7_ = unity_lens_search_get_search_string (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == NULL;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		_g_object_unref0 (search);
		return;
	}
	_tmp10_ = search;
	unity_applications_lens_daemon_update_scope_search (self, _tmp10_, NULL, NULL);
	_tmp11_ = search;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp12_;
	_g_object_unref0 (search);
}


static void __unity_applications_lens_daemon___lambda8__unity_scope_filters_changed (UnityScope* _sender, gpointer self) {
	_unity_applications_lens_daemon___lambda8_ (self);
}


static void _unity_applications_lens_daemon___lambda9_ (UnityApplicationsLensDaemon* self, GObject* obj, GParamSpec* pspec) {
	UnityScope* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	UnityLensSearch* _tmp3_;
	UnityLensSearch* search;
	UnityLensSearch* _tmp4_;
	UnityLensSearch* _tmp5_;
	gboolean _tmp6_ = FALSE;
	UnityLensSearch* _tmp7_;
	UnityLensSearch* _tmp8_;
	UnityLensSearch* _tmp9_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->scope;
	_tmp1_ = unity_scope_get_active_global_search (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	search = _tmp3_;
	_tmp4_ = self->priv->previous_global_search;
	_tmp5_ = search;
	_tmp6_ = unity_applications_lens_utils_search_has_really_changed (_tmp4_, _tmp5_);
	if (!_tmp6_) {
		_g_object_unref0 (search);
		return;
	}
	_tmp7_ = search;
	unity_applications_lens_daemon_update_global_search (self, _tmp7_, NULL, NULL);
	_tmp8_ = search;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->previous_global_search);
	self->priv->previous_global_search = _tmp9_;
	_g_object_unref0 (search);
}


static void __unity_applications_lens_daemon___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_unity_applications_lens_daemon___lambda9_ (self, _sender, pspec);
}


static UnityActivationResponse* _unity_applications_lens_daemon_activate_unity_scope_activate_uri (UnityScope* _sender, const gchar* uri, gpointer self) {
	UnityActivationResponse* result;
	result = unity_applications_lens_daemon_activate (self, uri);
	return result;
}


static void _unity_applications_lens_daemon_on_appinfo_changed_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const gchar* id, GAppInfo* new_appinfo, gpointer self) {
	unity_applications_lens_daemon_on_appinfo_changed (self, id, new_appinfo);
}


static GObject * unity_applications_lens_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityApplicationsLensDaemon * self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistIndex* _tmp1_;
	UnityPackageSearcher* _tmp2_;
	UnityPackageSearcher* _tmp3_;
	GeeArrayList* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	GeeList* _tmp15_;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GHashTable* _tmp18_;
	UnityScope* _tmp19_;
	UnityScope* _tmp20_;
	UnityScope* _tmp21_;
	UnityScope* _tmp22_;
	UnityScope* _tmp23_;
	UnityAppInfoManager* _tmp24_ = NULL;
	UnityAppInfoManager* _tmp25_;
	UnityApplicationsLensRunner* _tmp26_;
	UnityLens* _tmp29_;
	UnityLens* _tmp30_;
	const gchar* _tmp31_ = NULL;
	UnityLens* _tmp32_;
	UnityLens* _tmp33_;
	UnityLens* _tmp34_;
	UnityScope* _tmp35_;
	UnityLens* _tmp36_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_applications_lens_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_APPLICATIONS_LENS_DAEMON (obj);
	unity_applications_lens_daemon_populate_type_queries (self);
	unity_applications_lens_daemon_populate_zg_templates (self);
	_tmp0_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->log);
	self->priv->log = _tmp0_;
	_tmp1_ = zeitgeist_index_new ();
	_g_object_unref0 (self->priv->zg_index);
	self->priv->zg_index = _tmp1_;
	_tmp2_ = unity_package_searcher_new ();
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	self->priv->pkgsearcher = _tmp2_;
	_tmp3_ = self->priv->pkgsearcher;
	if (_tmp3_ == NULL) {
		g_critical ("daemon.vala:80: Failed to load Software Center index. 'Apps Available " \
"for Download' will not be listed");
	}
	{
		UnityRatingsDatabase* _tmp4_;
		UnityRatingsDatabase* _tmp5_;
		_tmp4_ = unity_ratings_database_new (&_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_unity_ratings_database_free0 (self->priv->ratings);
		self->priv->ratings = _tmp5_;
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("daemon.vala:86: %s", _tmp7_);
		_unity_ratings_database_free0 (self->priv->ratings);
		self->priv->ratings = NULL;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->image_extensions);
	self->priv->image_extensions = (GeeList*) _tmp8_;
	_tmp9_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp9_, "png");
	_tmp10_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp10_, "xpm");
	_tmp11_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp11_, "svg");
	_tmp12_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp12_, "tiff");
	_tmp13_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp13_, "ico");
	_tmp14_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp14_, "tif");
	_tmp15_ = self->priv->image_extensions;
	gee_collection_add ((GeeCollection*) _tmp15_, "jpg");
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = NULL;
	_g_object_unref0 (self->priv->previous_global_search);
	self->priv->previous_global_search = NULL;
	unity_applications_lens_daemon_build_app_menu_index (self);
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	self->priv->file_icon_cache = _tmp18_;
	_tmp19_ = unity_scope_new ("/com/canonical/unity/scope/applications");
	_g_object_unref0 (self->priv->scope);
	self->priv->scope = _tmp19_;
	_tmp20_ = self->priv->scope;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::active-search", (GCallback) __unity_applications_lens_daemon___lambda7__g_object_notify, self, 0);
	_tmp21_ = self->priv->scope;
	g_signal_connect_object (_tmp21_, "filters-changed", (GCallback) __unity_applications_lens_daemon___lambda8__unity_scope_filters_changed, self, 0);
	_tmp22_ = self->priv->scope;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::active-global-search", (GCallback) __unity_applications_lens_daemon___lambda9__g_object_notify, self, 0);
	_tmp23_ = self->priv->scope;
	g_signal_connect_object (_tmp23_, "activate-uri", (GCallback) _unity_applications_lens_daemon_activate_unity_scope_activate_uri, self, 0);
	_tmp24_ = unity_app_info_manager_get_instance ();
	_tmp25_ = _tmp24_;
	g_signal_connect_object (_tmp25_, "changed", (GCallback) _unity_applications_lens_daemon_on_appinfo_changed_unity_app_info_manager_changed, self, 0);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = unity_applications_lens_runner_new (self);
	_g_object_unref0 (self->priv->runner);
	self->priv->runner = _tmp26_;
	{
		GRegex* _tmp27_;
		GRegex* _tmp28_;
		_tmp27_ = g_regex_new ("^[a-z]+:.+$", 0, 0, &_inner_error_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (self->priv->uri_regex);
		self->priv->uri_regex = _tmp28_;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_regex_unref0 (self->priv->uri_regex);
		self->priv->uri_regex = NULL;
		g_critical ("daemon.vala:161: Failed to compile URI regex. URL launching will be di" \
"sabled");
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp29_ = unity_lens_new ("/com/canonical/unity/lens/applications", "applications");
	_g_object_unref0 (self->priv->lens);
	self->priv->lens = _tmp29_;
	_tmp30_ = self->priv->lens;
	_tmp31_ = _ ("Search Applications");
	unity_lens_set_search_hint (_tmp30_, _tmp31_);
	_tmp32_ = self->priv->lens;
	unity_lens_set_visible (_tmp32_, TRUE);
	_tmp33_ = self->priv->lens;
	unity_lens_set_search_in_global (_tmp33_, TRUE);
	unity_applications_lens_daemon_populate_categories (self);
	unity_applications_lens_daemon_populate_filters (self);
	_tmp34_ = self->priv->lens;
	_tmp35_ = self->priv->scope;
	unity_lens_add_local_scope (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->lens;
	unity_lens_export (_tmp36_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void unity_applications_lens_daemon_class_init (UnityApplicationsLensDaemonClass * klass) {
	unity_applications_lens_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityApplicationsLensDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_applications_lens_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_applications_lens_daemon_finalize;
}


static void unity_applications_lens_daemon_instance_init (UnityApplicationsLensDaemon * self) {
	self->priv = UNITY_APPLICATIONS_LENS_DAEMON_GET_PRIVATE (self);
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	self->priv->app_menu = NULL;
}


static void unity_applications_lens_daemon_finalize (GObject* obj) {
	UnityApplicationsLensDaemon * self;
	self = UNITY_APPLICATIONS_LENS_DAEMON (obj);
	_g_object_unref0 (self->priv->log);
	_g_object_unref0 (self->priv->zg_index);
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	_unity_package_searcher_free0 (self->appsearcher);
	_unity_ratings_database_free0 (self->priv->ratings);
	_g_object_unref0 (self->priv->lens);
	_g_object_unref0 (self->priv->scope);
	_g_object_unref0 (self->priv->runner);
	_g_hash_table_unref0 (self->priv->type_queries);
	_g_object_unref0 (self->priv->image_extensions);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	_g_object_unref0 (self->priv->previous_search);
	_g_object_unref0 (self->priv->previous_global_search);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	_gmenu_tree_unref0 (self->priv->app_menu);
	_g_regex_unref0 (self->priv->uri_regex);
	G_OBJECT_CLASS (unity_applications_lens_daemon_parent_class)->finalize (obj);
}


GType unity_applications_lens_daemon_get_type (void) {
	static volatile gsize unity_applications_lens_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_applications_lens_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityApplicationsLensDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_applications_lens_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityApplicationsLensDaemon), 0, (GInstanceInitFunc) unity_applications_lens_daemon_instance_init, NULL };
		GType unity_applications_lens_daemon_type_id;
		unity_applications_lens_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityApplicationsLensDaemon", &g_define_type_info, 0);
		g_once_init_leave (&unity_applications_lens_daemon_type_id__volatile, unity_applications_lens_daemon_type_id);
	}
	return unity_applications_lens_daemon_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



