/* main-window.c generated by valac 0.20.1, the Vala compiler
 * generated from main-window.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <string.h>
#include <stdlib.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <glib/gstdio.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;

#define TYPE_LIST_STACK (list_stack_get_type ())
#define LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STACK, ListStack))
#define LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STACK, ListStackClass))
#define IS_LIST_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STACK))
#define IS_LIST_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STACK))
#define LIST_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STACK, ListStackClass))

typedef struct _ListStack ListStack;
typedef struct _ListStackClass ListStackClass;

#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__monitor_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__monitor_unref0_ (var), NULL)))
typedef struct _MonitorPrivate MonitorPrivate;
#define _monitor_unref0(var) ((var == NULL) ? NULL : (var = (monitor_unref (var), NULL)))

#define GREETER_LIST_TYPE_SCROLL_TARGET (greeter_list_scroll_target_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FLAT_BUTTON (flat_button_get_type ())
#define FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAT_BUTTON, FlatButton))
#define FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLAT_BUTTON, FlatButtonClass))
#define IS_FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAT_BUTTON))
#define IS_FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLAT_BUTTON))
#define FLAT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLAT_BUTTON, FlatButtonClass))

typedef struct _FlatButton FlatButton;
typedef struct _FlatButtonClass FlatButtonClass;

#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
	UserList* user_list;
	MenuBar* menubar;
	ListStack* stack;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _MainWindowPrivate {
	GList* monitors;
	Background* background;
	GtkBox* login_box;
	GtkBox* hbox;
	GtkButton* back_button;
};

struct _Monitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _MonitorClass {
	GTypeClass parent_class;
	void (*finalize) (Monitor *self);
};

typedef enum  {
	GREETER_LIST_SCROLL_TARGET_START,
	GREETER_LIST_SCROLL_TARGET_END,
	GREETER_LIST_SCROLL_TARGET_UP,
	GREETER_LIST_SCROLL_TARGET_DOWN
} GreeterListScrollTarget;

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};


static gpointer main_window_parent_class = NULL;
extern UnityGreeter* unity_greeter_singleton;

GType main_window_get_type (void) G_GNUC_CONST;
GType fadable_box_get_type (void) G_GNUC_CONST;
GType greeter_list_get_type (void) G_GNUC_CONST;
GType user_list_get_type (void) G_GNUC_CONST;
GType menu_bar_get_type (void) G_GNUC_CONST;
GType list_stack_get_type (void) G_GNUC_CONST;
gpointer monitor_ref (gpointer instance);
void monitor_unref (gpointer instance);
GParamSpec* param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_monitor (GValue* value, gpointer v_object);
void value_take_monitor (GValue* value, gpointer v_object);
gpointer value_get_monitor (const GValue* value);
GType monitor_get_type (void) G_GNUC_CONST;
GType background_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY
};
static void _monitor_unref0_ (gpointer var);
static void _g_list_free__monitor_unref0_ (GList* self);
#define MAIN_WINDOW_MENUBAR_HEIGHT 32
void main_window_push_list (MainWindow* self, GreeterList* widget);
void list_stack_push (ListStack* self, GreeterList* pushed);
guint list_stack_get_num_children (ListStack* self);
void main_window_pop_list (MainWindow* self);
void list_stack_pop (ListStack* self);
static void main_window_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
gint get_grid_offset (gint size);
#define grid_size 40
static void main_window_monitors_changed_cb (MainWindow* self, GdkScreen* screen);
static gboolean main_window_monitor_is_unique_position (MainWindow* self, GdkScreen* screen, gint n);
Monitor* monitor_new (gint x, gint y, gint width, gint height);
Monitor* monitor_construct (GType object_type, gint x, gint y, gint width, gint height);
void background_set_monitors (Background* self, GList* monitors);
static void main_window_move_to_monitor (MainWindow* self, Monitor* monitor);
static gboolean main_window_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
void background_set_active_monitor (Background* self, Monitor* monitor);
static void main_window_add_user_list (MainWindow* self);
UserList* user_list_new (Background* bg, MenuBar* mb);
UserList* user_list_construct (GType object_type, Background* bg, MenuBar* mb);
void unity_greeter_add_style_class (GtkWidget* widget);
static gboolean main_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
GreeterList* list_stack_top (ListStack* self);
void greeter_list_cancel_authentication (GreeterList* self);
GType greeter_list_scroll_target_get_type (void) G_GNUC_CONST;
void greeter_list_scroll (GreeterList* self, GreeterListScrollTarget target);
void main_window_set_keyboard_state (MainWindow* self);
void menu_bar_set_keyboard_state (MenuBar* self);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static GObject * main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
gchar* ug_settings_get_string (const gchar* key);
#define UG_SETTINGS_KEY_BACKGROUND_COLOR "background-color"
Background* background_new (cairo_surface_t* target_surface);
Background* background_construct (GType object_type, cairo_surface_t* target_surface);
gboolean ug_settings_get_boolean (const gchar* key);
#define UG_SETTINGS_KEY_DRAW_GRID "draw-grid"
void background_set_draw_grid (Background* self, gboolean value);
#define UG_SETTINGS_KEY_BACKGROUND "background"
void background_set_default_background (Background* self, const gchar* value);
void background_set_logo (Background* self, const gchar* version_logo, const gchar* background_logo);
#define UG_SETTINGS_KEY_LOGO "logo"
#define UG_SETTINGS_KEY_BACKGROUND_LOGO "background-logo"
MenuBar* menu_bar_new (Background* bg, GtkAccelGroup* ag);
MenuBar* menu_bar_construct (GType object_type, Background* bg, GtkAccelGroup* ag);
FlatButton* flat_button_new (void);
FlatButton* flat_button_construct (GType object_type);
GType flat_button_get_type (void) G_GNUC_CONST;
#define GREETER_LIST_BORDER 4
static void _main_window_pop_list_gtk_button_clicked (GtkButton* _sender, gpointer self);
ListStack* list_stack_new (void);
ListStack* list_stack_construct (GType object_type);
gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
static void _main_window_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self);
static void main_window_finalize (GObject* obj);


static void _monitor_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (monitor_unref (var), NULL));
}


static void _g_list_free__monitor_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _monitor_unref0_, NULL);
	g_list_free (self);
}


void main_window_push_list (MainWindow* self, GreeterList* widget) {
	ListStack* _tmp0_;
	GreeterList* _tmp1_;
	ListStack* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->stack;
	_tmp1_ = widget;
	list_stack_push (_tmp0_, _tmp1_);
	_tmp2_ = self->stack;
	_tmp3_ = list_stack_get_num_children (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > ((guint) 1)) {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->back_button;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	}
}


void main_window_pop_list (MainWindow* self) {
	ListStack* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ListStack* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->stack;
	_tmp1_ = list_stack_get_num_children (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= ((guint) 2)) {
		GtkButton* _tmp3_;
		_tmp3_ = self->priv->back_button;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
	_tmp4_ = self->stack;
	list_stack_pop (_tmp4_);
}


static void main_window_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	MainWindow * self;
	GtkAllocation _tmp0_;
	GtkBox* _tmp1_;
	self = (MainWindow*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (main_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow), &_tmp0_);
	_tmp1_ = self->priv->hbox;
	if (_tmp1_ != NULL) {
		GtkBox* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GtkBox* _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GtkBox* _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		GtkBox* _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp2_ = self->priv->hbox;
		_tmp3_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp4_ = get_grid_offset (_tmp3_);
		gtk_widget_set_margin_left ((GtkWidget*) _tmp2_, _tmp4_ + grid_size);
		_tmp5_ = self->priv->hbox;
		_tmp6_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp7_ = get_grid_offset (_tmp6_);
		gtk_widget_set_margin_right ((GtkWidget*) _tmp5_, _tmp7_);
		_tmp8_ = self->priv->hbox;
		_tmp9_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp10_ = get_grid_offset (_tmp9_);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp8_, _tmp10_);
		_tmp11_ = self->priv->hbox;
		_tmp12_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp13_ = get_grid_offset (_tmp12_);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, _tmp13_);
	}
}


static void main_window_monitors_changed_cb (MainWindow* self, GdkScreen* screen) {
	GdkScreen* _tmp0_;
	gint _tmp1_ = 0;
	GdkScreen* _tmp2_;
	gint _tmp3_ = 0;
	Background* _tmp34_;
	GList* _tmp35_;
	GdkScreen* _tmp36_;
	gint _tmp37_ = 0;
	GdkScreen* _tmp38_;
	gint _tmp39_ = 0;
	GList* _tmp40_;
	gconstpointer _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_width (_tmp0_);
	_tmp2_ = screen;
	_tmp3_ = gdk_screen_get_height (_tmp2_);
	g_debug ("main-window.vala:181: Screen is %dx%d pixels", _tmp1_, _tmp3_);
	__g_list_free__monitor_unref0_0 (self->priv->monitors);
	self->priv->monitors = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GdkScreen* _tmp8_;
				gint _tmp9_ = 0;
				GdkRectangle geometry = {0};
				GdkScreen* _tmp10_;
				gint _tmp11_;
				GdkRectangle _tmp12_ = {0};
				gint _tmp13_;
				GdkRectangle _tmp14_;
				gint _tmp15_;
				GdkRectangle _tmp16_;
				gint _tmp17_;
				GdkRectangle _tmp18_;
				gint _tmp19_;
				GdkRectangle _tmp20_;
				gint _tmp21_;
				GdkScreen* _tmp22_;
				gint _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = screen;
				_tmp9_ = gdk_screen_get_n_monitors (_tmp8_);
				if (!(_tmp7_ < _tmp9_)) {
					break;
				}
				_tmp10_ = screen;
				_tmp11_ = i;
				gdk_screen_get_monitor_geometry (_tmp10_, _tmp11_, &_tmp12_);
				geometry = _tmp12_;
				_tmp13_ = i;
				_tmp14_ = geometry;
				_tmp15_ = _tmp14_.width;
				_tmp16_ = geometry;
				_tmp17_ = _tmp16_.height;
				_tmp18_ = geometry;
				_tmp19_ = _tmp18_.x;
				_tmp20_ = geometry;
				_tmp21_ = _tmp20_.y;
				g_debug ("main-window.vala:187: Monitor %d is %dx%d pixels at %d,%d", _tmp13_, _tmp15_, _tmp17_, _tmp19_, _tmp21_);
				_tmp22_ = screen;
				_tmp23_ = i;
				_tmp24_ = main_window_monitor_is_unique_position (self, _tmp22_, _tmp23_);
				if (_tmp24_) {
					GdkRectangle _tmp25_;
					gint _tmp26_;
					GdkRectangle _tmp27_;
					gint _tmp28_;
					GdkRectangle _tmp29_;
					gint _tmp30_;
					GdkRectangle _tmp31_;
					gint _tmp32_;
					Monitor* _tmp33_;
					_tmp25_ = geometry;
					_tmp26_ = _tmp25_.x;
					_tmp27_ = geometry;
					_tmp28_ = _tmp27_.y;
					_tmp29_ = geometry;
					_tmp30_ = _tmp29_.width;
					_tmp31_ = geometry;
					_tmp32_ = _tmp31_.height;
					_tmp33_ = monitor_new (_tmp26_, _tmp28_, _tmp30_, _tmp32_);
					self->priv->monitors = g_list_append (self->priv->monitors, _tmp33_);
				}
			}
		}
	}
	_tmp34_ = self->priv->background;
	_tmp35_ = self->priv->monitors;
	background_set_monitors (_tmp34_, _tmp35_);
	_tmp36_ = screen;
	_tmp37_ = gdk_screen_get_width (_tmp36_);
	_tmp38_ = screen;
	_tmp39_ = gdk_screen_get_height (_tmp38_);
	gtk_window_resize ((GtkWindow*) self, _tmp37_, _tmp39_);
	gtk_window_move ((GtkWindow*) self, 0, 0);
	_tmp40_ = self->priv->monitors;
	_tmp41_ = g_list_nth_data (_tmp40_, (guint) 0);
	main_window_move_to_monitor (self, (Monitor*) _tmp41_);
}


static gboolean main_window_monitor_is_unique_position (MainWindow* self, GdkScreen* screen, gint n) {
	gboolean result = FALSE;
	GdkRectangle g0 = {0};
	GdkScreen* _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (screen != NULL, FALSE);
	_tmp0_ = screen;
	_tmp1_ = n;
	gdk_screen_get_monitor_geometry (_tmp0_, _tmp1_, &_tmp2_);
	g0 = _tmp2_;
	{
		gint _tmp3_;
		gint i;
		_tmp3_ = n;
		i = _tmp3_ + 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GdkScreen* _tmp8_;
				gint _tmp9_ = 0;
				GdkRectangle g1 = {0};
				GdkScreen* _tmp10_;
				gint _tmp11_;
				GdkRectangle _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				GdkRectangle _tmp14_;
				gint _tmp15_;
				GdkRectangle _tmp16_;
				gint _tmp17_;
				gboolean _tmp22_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = screen;
				_tmp9_ = gdk_screen_get_n_monitors (_tmp8_);
				if (!(_tmp7_ < _tmp9_)) {
					break;
				}
				_tmp10_ = screen;
				_tmp11_ = i;
				gdk_screen_get_monitor_geometry (_tmp10_, _tmp11_, &_tmp12_);
				g1 = _tmp12_;
				_tmp14_ = g0;
				_tmp15_ = _tmp14_.x;
				_tmp16_ = g1;
				_tmp17_ = _tmp16_.x;
				if (_tmp15_ == _tmp17_) {
					GdkRectangle _tmp18_;
					gint _tmp19_;
					GdkRectangle _tmp20_;
					gint _tmp21_;
					_tmp18_ = g0;
					_tmp19_ = _tmp18_.y;
					_tmp20_ = g1;
					_tmp21_ = _tmp20_.y;
					_tmp13_ = _tmp19_ == _tmp21_;
				} else {
					_tmp13_ = FALSE;
				}
				_tmp22_ = _tmp13_;
				if (_tmp22_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gpointer _monitor_ref0 (gpointer self) {
	return self ? monitor_ref (self) : NULL;
}


static gboolean main_window_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MainWindow * self;
	gboolean result = FALSE;
	GdkEventMotion _tmp0_;
	gdouble _tmp1_;
	gint x;
	GdkEventMotion _tmp2_;
	gdouble _tmp3_;
	gint y;
	GdkEventMotion _tmp4_;
	GdkWindow* _tmp5_;
	GdkWindow* _tmp6_ = NULL;
	GList* _tmp22_;
	self = (MainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.x;
	x = (gint) (_tmp1_ + 0.5);
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.y;
	y = (gint) (_tmp3_ + 0.5);
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.window;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
	if (_tmp5_ != _tmp6_) {
		gint w_x = 0;
		gint w_y = 0;
		GdkWindow* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GdkEventMotion _tmp14_;
		GdkWindow* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_get_origin (_tmp7_, &_tmp8_, &_tmp9_);
		w_x = _tmp8_;
		w_y = _tmp9_;
		_tmp10_ = x;
		_tmp11_ = w_x;
		x = _tmp10_ - _tmp11_;
		_tmp12_ = y;
		_tmp13_ = w_y;
		y = _tmp12_ - _tmp13_;
		_tmp14_ = *event;
		_tmp15_ = _tmp14_.window;
		gdk_window_get_origin (_tmp15_, &_tmp16_, &_tmp17_);
		w_x = _tmp16_;
		w_y = _tmp17_;
		_tmp18_ = x;
		_tmp19_ = w_x;
		x = _tmp18_ + _tmp19_;
		_tmp20_ = y;
		_tmp21_ = w_y;
		y = _tmp20_ + _tmp21_;
	}
	_tmp22_ = self->priv->monitors;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp22_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Monitor* _tmp23_;
			Monitor* m = NULL;
			_tmp23_ = _monitor_ref0 ((Monitor*) m_it->data);
			m = _tmp23_;
			{
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gint _tmp27_;
				Monitor* _tmp28_;
				gint _tmp29_;
				gboolean _tmp35_;
				gboolean _tmp39_;
				gboolean _tmp45_;
				_tmp27_ = x;
				_tmp28_ = m;
				_tmp29_ = _tmp28_->x;
				if (_tmp27_ >= _tmp29_) {
					gint _tmp30_;
					Monitor* _tmp31_;
					gint _tmp32_;
					Monitor* _tmp33_;
					gint _tmp34_;
					_tmp30_ = x;
					_tmp31_ = m;
					_tmp32_ = _tmp31_->x;
					_tmp33_ = m;
					_tmp34_ = _tmp33_->width;
					_tmp26_ = _tmp30_ <= (_tmp32_ + _tmp34_);
				} else {
					_tmp26_ = FALSE;
				}
				_tmp35_ = _tmp26_;
				if (_tmp35_) {
					gint _tmp36_;
					Monitor* _tmp37_;
					gint _tmp38_;
					_tmp36_ = y;
					_tmp37_ = m;
					_tmp38_ = _tmp37_->y;
					_tmp25_ = _tmp36_ >= _tmp38_;
				} else {
					_tmp25_ = FALSE;
				}
				_tmp39_ = _tmp25_;
				if (_tmp39_) {
					gint _tmp40_;
					Monitor* _tmp41_;
					gint _tmp42_;
					Monitor* _tmp43_;
					gint _tmp44_;
					_tmp40_ = y;
					_tmp41_ = m;
					_tmp42_ = _tmp41_->y;
					_tmp43_ = m;
					_tmp44_ = _tmp43_->height;
					_tmp24_ = _tmp40_ <= (_tmp42_ + _tmp44_);
				} else {
					_tmp24_ = FALSE;
				}
				_tmp45_ = _tmp24_;
				if (_tmp45_) {
					Monitor* _tmp46_;
					_tmp46_ = m;
					main_window_move_to_monitor (self, _tmp46_);
					_monitor_unref0 (m);
					break;
				}
				_monitor_unref0 (m);
			}
		}
	}
	result = FALSE;
	return result;
}


static void main_window_move_to_monitor (MainWindow* self, Monitor* monitor) {
	GtkBox* _tmp0_;
	Monitor* _tmp1_;
	gint _tmp2_;
	Monitor* _tmp3_;
	gint _tmp4_;
	Background* _tmp5_;
	Monitor* _tmp6_;
	Background* _tmp7_;
	GtkBox* _tmp8_;
	Monitor* _tmp9_;
	gint _tmp10_;
	Monitor* _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = self->priv->login_box;
	_tmp1_ = monitor;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = monitor;
	_tmp4_ = _tmp3_->height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, _tmp2_, _tmp4_);
	_tmp5_ = self->priv->background;
	_tmp6_ = monitor;
	background_set_active_monitor (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->background;
	_tmp8_ = self->priv->login_box;
	_tmp9_ = monitor;
	_tmp10_ = _tmp9_->x;
	_tmp11_ = monitor;
	_tmp12_ = _tmp11_->y;
	gtk_fixed_move ((GtkFixed*) _tmp7_, (GtkWidget*) _tmp8_, _tmp10_, _tmp12_);
}


static void main_window_add_user_list (MainWindow* self) {
	GreeterList* greeter_list = NULL;
	Background* _tmp0_;
	MenuBar* _tmp1_;
	UserList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background;
	_tmp1_ = self->menubar;
	_tmp2_ = user_list_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (greeter_list);
	greeter_list = (GreeterList*) _tmp2_;
	gtk_widget_show ((GtkWidget*) greeter_list);
	unity_greeter_add_style_class ((GtkWidget*) greeter_list);
	main_window_push_list (self, greeter_list);
	_g_object_unref0 (greeter_list);
}


static gboolean main_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MainWindow * self;
	gboolean result = FALSE;
	ListStack* _tmp0_;
	GreeterList* _tmp1_ = NULL;
	GreeterList* top;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	self = (MainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->stack;
	_tmp1_ = list_stack_top (_tmp0_);
	top = _tmp1_;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	switch (_tmp3_) {
		case GDK_KEY_Escape:
		{
			GreeterList* _tmp4_;
			_tmp4_ = top;
			greeter_list_cancel_authentication (_tmp4_);
			break;
		}
		case GDK_KEY_Page_Up:
		case GDK_KEY_KP_Page_Up:
		{
			GreeterList* _tmp5_;
			_tmp5_ = top;
			greeter_list_scroll (_tmp5_, GREETER_LIST_SCROLL_TARGET_START);
			break;
		}
		case GDK_KEY_Page_Down:
		case GDK_KEY_KP_Page_Down:
		{
			GreeterList* _tmp6_;
			_tmp6_ = top;
			greeter_list_scroll (_tmp6_, GREETER_LIST_SCROLL_TARGET_END);
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_KP_Up:
		{
			GreeterList* _tmp7_;
			_tmp7_ = top;
			greeter_list_scroll (_tmp7_, GREETER_LIST_SCROLL_TARGET_UP);
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_KP_Down:
		{
			GreeterList* _tmp8_;
			_tmp8_ = top;
			greeter_list_scroll (_tmp8_, GREETER_LIST_SCROLL_TARGET_DOWN);
			break;
		}
		case GDK_KEY_F10:
		{
			MenuBar* _tmp9_;
			_tmp9_ = self->menubar;
			gtk_menu_shell_select_first ((GtkMenuShell*) _tmp9_, FALSE);
			break;
		}
		default:
		{
			GdkEventKey _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = *event;
			_tmp11_ = GTK_WIDGET_CLASS (main_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_WINDOW, GtkWindow), &_tmp10_);
			result = _tmp11_;
			_g_object_unref0 (top);
			return result;
		}
	}
	result = TRUE;
	_g_object_unref0 (top);
	return result;
}


void main_window_set_keyboard_state (MainWindow* self) {
	MenuBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->menubar;
	menu_bar_set_keyboard_state (_tmp0_);
}


MainWindow* main_window_construct (GType object_type) {
	MainWindow * self = NULL;
	self = (MainWindow*) g_object_new (object_type, NULL);
	return self;
}


MainWindow* main_window_new (void) {
	return main_window_construct (TYPE_MAIN_WINDOW);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _main_window_pop_list_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_pop_list (self);
}


static void _main_window_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self) {
	main_window_monitors_changed_cb (self, _sender);
}


static GObject * main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MainWindow * self;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	GtkAccelGroup* _tmp2_;
	GtkAccelGroup* accel_group;
	GtkAccelGroup* _tmp3_;
	GdkRGBA bg_color = {0};
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GdkRGBA _tmp6_;
	AtkObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GdkWindow* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_;
	cairo_surface_t* _tmp12_ = NULL;
	Background* _tmp13_;
	Background* _tmp14_;
	gboolean _tmp15_ = FALSE;
	Background* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	Background* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	Background* _tmp24_;
	Background* _tmp25_;
	Background* _tmp26_;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	Background* _tmp29_;
	GtkBox* _tmp30_;
	GtkEventBox* _tmp31_;
	GtkEventBox* menubox;
	GtkAlignment* _tmp32_;
	GtkAlignment* menualign;
	gchar* _tmp33_ = NULL;
	gchar* shadow_path;
	gchar* _tmp34_;
	gchar* shadow_style;
	const gchar* _tmp35_;
	gboolean _tmp36_ = FALSE;
	GtkEventBox* _tmp51_;
	GtkEventBox* _tmp52_;
	GtkAlignment* _tmp53_;
	GtkEventBox* _tmp54_;
	GtkAlignment* _tmp55_;
	GtkBox* _tmp56_;
	GtkEventBox* _tmp57_;
	GtkAlignment* _tmp58_;
	GtkEventBox* _tmp59_;
	Background* _tmp60_;
	GtkAccelGroup* _tmp61_;
	MenuBar* _tmp62_;
	MenuBar* _tmp63_;
	GtkAlignment* _tmp64_;
	MenuBar* _tmp65_;
	MenuBar* _tmp66_;
	GtkBox* _tmp67_;
	GtkBox* _tmp68_;
	GtkBox* _tmp69_;
	GtkBox* _tmp70_;
	GtkBox* _tmp71_;
	GtkAlignment* _tmp72_;
	GtkAlignment* align;
	GtkAlignment* _tmp73_;
	GtkAlignment* _tmp74_;
	GtkAlignment* _tmp75_;
	GtkBox* _tmp76_;
	GtkAlignment* _tmp77_;
	FlatButton* _tmp78_;
	GtkButton* _tmp79_;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_;
	GtkImage* _tmp82_;
	GtkImage* _tmp83_;
	GtkImage* image;
	GtkImage* _tmp84_;
	GtkButton* _tmp85_;
	GtkButton* _tmp86_;
	GtkImage* _tmp87_;
	GtkButton* _tmp88_;
	GtkAlignment* _tmp89_;
	GtkButton* _tmp90_;
	GtkAlignment* _tmp91_;
	GtkAlignment* _tmp92_;
	GtkBox* _tmp93_;
	GtkAlignment* _tmp94_;
	ListStack* _tmp95_;
	ListStack* _tmp96_;
	GtkAlignment* _tmp97_;
	ListStack* _tmp98_;
	UnityGreeter* _tmp99_;
	gboolean _tmp100_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_POINTER_MOTION_MASK);
	_tmp2_ = gtk_accel_group_new ();
	accel_group = _tmp2_;
	_tmp3_ = accel_group;
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp3_);
	memset (&bg_color, 0, sizeof (GdkRGBA));
	_tmp4_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_COLOR);
	_tmp5_ = _tmp4_;
	gdk_rgba_parse (&bg_color, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = bg_color;
	gtk_widget_override_background_color ((GtkWidget*) self, GTK_STATE_FLAG_NORMAL, &_tmp6_);
	_tmp7_ = gtk_widget_get_accessible ((GtkWidget*) self);
	_tmp8_ = _ ("Login Screen");
	atk_object_set_name (_tmp7_, _tmp8_);
	gtk_window_set_has_resize_grip ((GtkWindow*) self, FALSE);
	unity_greeter_add_style_class ((GtkWidget*) self);
	gtk_widget_realize ((GtkWidget*) self);
	_tmp9_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp10_ = gdk_cairo_create (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = cairo_get_target (_tmp11_);
	_tmp13_ = background_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp13_;
	_cairo_destroy0 (_tmp11_);
	_tmp14_ = self->priv->background;
	_tmp15_ = ug_settings_get_boolean (UG_SETTINGS_KEY_DRAW_GRID);
	background_set_draw_grid (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->background;
	_tmp17_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND);
	_tmp18_ = _tmp17_;
	background_set_default_background (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = self->priv->background;
	_tmp20_ = ug_settings_get_string (UG_SETTINGS_KEY_LOGO);
	_tmp21_ = _tmp20_;
	_tmp22_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_LOGO);
	_tmp23_ = _tmp22_;
	background_set_logo (_tmp19_, _tmp21_, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp24_ = self->priv->background;
	gtk_widget_show ((GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->background;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->background;
	unity_greeter_add_style_class ((GtkWidget*) _tmp26_);
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->login_box);
	self->priv->login_box = _tmp27_;
	_tmp28_ = self->priv->login_box;
	gtk_widget_show ((GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->background;
	_tmp30_ = self->priv->login_box;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp31_);
	menubox = _tmp31_;
	_tmp32_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 0.0f);
	g_object_ref_sink (_tmp32_);
	menualign = _tmp32_;
	_tmp33_ = g_build_filename (PKGDATADIR, "shadow.png", NULL, NULL);
	shadow_path = _tmp33_;
	_tmp34_ = g_strdup ("");
	shadow_style = _tmp34_;
	_tmp35_ = shadow_path;
	_tmp36_ = g_file_test (_tmp35_, G_FILE_TEST_EXISTS);
	if (_tmp36_) {
		const gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		_tmp37_ = shadow_path;
		_tmp38_ = g_strdup_printf ("background-image: url('%s');\n" \
"                            background-repeat: repeat;", _tmp37_);
		_g_free0 (shadow_style);
		shadow_style = _tmp38_;
	}
	{
		GtkCssProvider* _tmp39_;
		GtkCssProvider* style;
		GtkCssProvider* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		GtkEventBox* _tmp44_;
		GtkStyleContext* _tmp45_ = NULL;
		GtkStyleContext* _tmp46_;
		GtkStyleContext* context;
		GtkStyleContext* _tmp47_;
		GtkCssProvider* _tmp48_;
		_tmp39_ = gtk_css_provider_new ();
		style = _tmp39_;
		_tmp40_ = style;
		_tmp41_ = shadow_style;
		_tmp42_ = g_strdup_printf ("* {background-color: transparent;\n" \
"                                      %s\n" \
"                                     }", _tmp41_);
		_tmp43_ = _tmp42_;
		gtk_css_provider_load_from_data (_tmp40_, _tmp43_, (gssize) (-1), &_inner_error_);
		_g_free0 (_tmp43_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (style);
			goto __catch11_g_error;
		}
		_tmp44_ = menubox;
		_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _tmp44_);
		_tmp46_ = _g_object_ref0 (_tmp45_);
		context = _tmp46_;
		_tmp47_ = context;
		_tmp48_ = style;
		gtk_style_context_add_provider (_tmp47_, (GtkStyleProvider*) _tmp48_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (context);
		_g_object_unref0 (style);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp49_;
		const gchar* _tmp50_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		g_debug ("main-window.vala:87: Internal error loading menubox style: %s", _tmp50_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_free0 (shadow_style);
		_g_free0 (shadow_path);
		_g_object_unref0 (menualign);
		_g_object_unref0 (menubox);
		_g_object_unref0 (accel_group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp51_ = menubox;
	gtk_widget_set_size_request ((GtkWidget*) _tmp51_, -1, MAIN_WINDOW_MENUBAR_HEIGHT);
	_tmp52_ = menubox;
	gtk_widget_show ((GtkWidget*) _tmp52_);
	_tmp53_ = menualign;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = menubox;
	_tmp55_ = menualign;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = self->priv->login_box;
	_tmp57_ = menubox;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = menualign;
	unity_greeter_add_style_class ((GtkWidget*) _tmp58_);
	_tmp59_ = menubox;
	unity_greeter_add_style_class ((GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->background;
	_tmp61_ = accel_group;
	_tmp62_ = menu_bar_new (_tmp60_, _tmp61_);
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (self->menubar);
	self->menubar = _tmp62_;
	_tmp63_ = self->menubar;
	gtk_widget_show ((GtkWidget*) _tmp63_);
	_tmp64_ = menualign;
	_tmp65_ = self->menubar;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = self->menubar;
	unity_greeter_add_style_class ((GtkWidget*) _tmp66_);
	_tmp67_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->hbox);
	self->priv->hbox = _tmp67_;
	_tmp68_ = self->priv->hbox;
	g_object_set ((GtkWidget*) _tmp68_, "expand", TRUE, NULL);
	_tmp69_ = self->priv->hbox;
	gtk_widget_show ((GtkWidget*) _tmp69_);
	_tmp70_ = self->priv->login_box;
	_tmp71_ = self->priv->hbox;
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp72_);
	align = _tmp72_;
	_tmp73_ = align;
	gtk_widget_set_size_request ((GtkWidget*) _tmp73_, grid_size, -1);
	_tmp74_ = align;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp74_, MAIN_WINDOW_MENUBAR_HEIGHT);
	_tmp75_ = align;
	gtk_widget_show ((GtkWidget*) _tmp75_);
	_tmp76_ = self->priv->hbox;
	_tmp77_ = align;
	gtk_container_add ((GtkContainer*) _tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = flat_button_new ();
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (self->priv->back_button);
	self->priv->back_button = (GtkButton*) _tmp78_;
	_tmp79_ = self->priv->back_button;
	gtk_button_set_focus_on_click (_tmp79_, FALSE);
	_tmp80_ = g_build_filename (PKGDATADIR, "arrow_left.png", NULL, NULL);
	_tmp81_ = _tmp80_;
	_tmp82_ = (GtkImage*) gtk_image_new_from_file (_tmp81_);
	g_object_ref_sink (_tmp82_);
	_tmp83_ = _tmp82_;
	_g_free0 (_tmp81_);
	image = _tmp83_;
	_tmp84_ = image;
	gtk_widget_show ((GtkWidget*) _tmp84_);
	_tmp85_ = self->priv->back_button;
	gtk_widget_set_size_request ((GtkWidget*) _tmp85_, grid_size - (GREETER_LIST_BORDER * 2), grid_size - (GREETER_LIST_BORDER * 2));
	_tmp86_ = self->priv->back_button;
	_tmp87_ = image;
	gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = self->priv->back_button;
	g_signal_connect_object (_tmp88_, "clicked", (GCallback) _main_window_pop_list_gtk_button_clicked, self, 0);
	_tmp89_ = align;
	_tmp90_ = self->priv->back_button;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.0f, 1.0f);
	g_object_ref_sink (_tmp91_);
	_g_object_unref0 (align);
	align = _tmp91_;
	_tmp92_ = align;
	gtk_widget_show ((GtkWidget*) _tmp92_);
	_tmp93_ = self->priv->hbox;
	_tmp94_ = align;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = list_stack_new ();
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp95_;
	_tmp96_ = self->stack;
	gtk_widget_show ((GtkWidget*) _tmp96_);
	_tmp97_ = align;
	_tmp98_ = self->stack;
	gtk_container_add ((GtkContainer*) _tmp97_, (GtkWidget*) _tmp98_);
	main_window_add_user_list (self);
	_tmp99_ = unity_greeter_singleton;
	_tmp100_ = _tmp99_->test_mode;
	if (_tmp100_) {
		Monitor* _tmp101_;
		Monitor* _tmp102_;
		Background* _tmp103_;
		GList* _tmp104_;
		GList* _tmp105_;
		gconstpointer _tmp106_ = NULL;
		__g_list_free__monitor_unref0_0 (self->priv->monitors);
		self->priv->monitors = NULL;
		_tmp101_ = monitor_new (0, 0, 800, 600);
		self->priv->monitors = g_list_append (self->priv->monitors, _tmp101_);
		_tmp102_ = monitor_new (800, 120, 640, 480);
		self->priv->monitors = g_list_append (self->priv->monitors, _tmp102_);
		_tmp103_ = self->priv->background;
		_tmp104_ = self->priv->monitors;
		background_set_monitors (_tmp103_, _tmp104_);
		_tmp105_ = self->priv->monitors;
		_tmp106_ = g_list_nth_data (_tmp105_, (guint) 0);
		main_window_move_to_monitor (self, (Monitor*) _tmp106_);
		gtk_window_resize ((GtkWindow*) self, 800 + 640, 600);
	} else {
		GdkScreen* _tmp107_ = NULL;
		GdkScreen* _tmp108_;
		GdkScreen* screen;
		GdkScreen* _tmp109_;
		GdkScreen* _tmp110_;
		_tmp107_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp108_ = _g_object_ref0 (_tmp107_);
		screen = _tmp108_;
		_tmp109_ = screen;
		g_signal_connect_object (_tmp109_, "monitors-changed", (GCallback) _main_window_monitors_changed_cb_gdk_screen_monitors_changed, self, 0);
		_tmp110_ = screen;
		main_window_monitors_changed_cb (self, _tmp110_);
		_g_object_unref0 (screen);
	}
	_g_object_unref0 (image);
	_g_object_unref0 (align);
	_g_free0 (shadow_style);
	_g_free0 (shadow_path);
	_g_object_unref0 (menualign);
	_g_object_unref0 (menubox);
	_g_object_unref0 (accel_group);
	return obj;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	GTK_WIDGET_CLASS (klass)->size_allocate = main_window_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = main_window_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = main_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->constructor = main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_object_unref0 (self->user_list);
	_g_object_unref0 (self->menubar);
	__g_list_free__monitor_unref0_0 (self->priv->monitors);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->login_box);
	_g_object_unref0 (self->priv->hbox);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->stack);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}



