/* menubar.c generated by valac 0.16.1, the Vala compiler
 * generated from menubar.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libindicator/indicator.h"
#include "libindicator/indicator-desktop-shortcuts.h"
#include "libindicator/indicator-image-helper.h"
#include "libindicator/indicator-object.h"
#include "libindicator/indicator-service.h"
#include "libindicator/indicator-service-manager.h"
#include <atk/atk.h>
#include <stdlib.h>
#include <string.h>
#include <lightdm.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gtk/gtkx.h>
#include <sys/utsname.h>


#define TYPE_INDICATOR_MENU_ITEM (indicator_menu_item_get_type ())
#define INDICATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItem))
#define INDICATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItemClass))
#define IS_INDICATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR_MENU_ITEM))
#define IS_INDICATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR_MENU_ITEM))
#define INDICATOR_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItemClass))

typedef struct _IndicatorMenuItem IndicatorMenuItem;
typedef struct _IndicatorMenuItemClass IndicatorMenuItemClass;
typedef struct _IndicatorMenuItemPrivate IndicatorMenuItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;
typedef struct _MenuBarPrivate MenuBarPrivate;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _IndicatorMenuItem {
	GtkMenuItem parent_instance;
	IndicatorMenuItemPrivate * priv;
	IndicatorObjectEntry* entry;
};

struct _IndicatorMenuItemClass {
	GtkMenuItemClass parent_class;
};

struct _IndicatorMenuItemPrivate {
	GtkBox* hbox;
};

struct _MenuBar {
	GtkMenuBar parent_instance;
	MenuBarPrivate * priv;
};

struct _MenuBarClass {
	GtkMenuBarClass parent_class;
};

struct _MenuBarPrivate {
	Background* _background;
	gboolean _high_contrast;
	GtkWindow* _keyboard_window;
	GtkAccelGroup* _accel_group;
	gchar* default_theme_name;
	GList* indicator_objects;
	GtkMenuItem* keyboard_item;
	GtkCheckMenuItem* high_contrast_item;
	GtkLabel* keyboard_label;
	GPid keyboard_pid;
	GtkCheckMenuItem* onscreen_keyboard_item;
};

typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE,
	BACKGROUND_DRAW_FLAGS_GRID
} BackgroundDrawFlags;

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	gboolean test_mode;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};


static gpointer indicator_menu_item_parent_class = NULL;
static gpointer menu_bar_parent_class = NULL;
extern UnityGreeter* unity_greeter_singleton;

GType indicator_menu_item_get_type (void) G_GNUC_CONST;
#define INDICATOR_MENU_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItemPrivate))
enum  {
	INDICATOR_MENU_ITEM_DUMMY_PROPERTY
};
IndicatorMenuItem* indicator_menu_item_new (IndicatorObjectEntry* entry);
IndicatorMenuItem* indicator_menu_item_construct (GType object_type, IndicatorObjectEntry* entry);
void indicator_menu_item_visibility_changed_cb (IndicatorMenuItem* self, GtkWidget* widget);
static void _indicator_menu_item_visibility_changed_cb_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _indicator_menu_item_visibility_changed_cb_gtk_widget_hide (GtkWidget* _sender, gpointer self);
gboolean indicator_menu_item_has_visible_child (IndicatorMenuItem* self);
static void indicator_menu_item_finalize (GObject* obj);
GType menu_bar_get_type (void) G_GNUC_CONST;
GType background_get_type (void) G_GNUC_CONST;
#define MENU_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MENU_BAR, MenuBarPrivate))
enum  {
	MENU_BAR_DUMMY_PROPERTY,
	MENU_BAR_BACKGROUND,
	MENU_BAR_HIGH_CONTRAST,
	MENU_BAR_KEYBOARD_WINDOW,
	MENU_BAR_ACCEL_GROUP
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define MENU_BAR_HEIGHT 24
MenuBar* menu_bar_new (Background* bg, GtkAccelGroup* ag);
MenuBar* menu_bar_construct (GType object_type, Background* bg, GtkAccelGroup* ag);
void menu_bar_set_layouts (MenuBar* self, GList* layouts);
static GtkRadioMenuItem* menu_bar_recreate_menu (MenuBar* self, GList* layouts_in);
static void menu_bar_layout_toggled_cb (MenuBar* self, GtkCheckMenuItem* item);
static gboolean menu_bar_real_draw (GtkWidget* base, cairo_t* c);
Background* menu_bar_get_background (MenuBar* self);
GType background_draw_flags_get_type (void) G_GNUC_CONST;
void background_draw_full (Background* self, cairo_t* c, BackgroundDrawFlags flags);
void menu_bar_set_keyboard_state (MenuBar* self);
gboolean ug_settings_get_boolean (const gchar* key);
#define UG_SETTINGS_KEY_ONSCREEN_KEYBOARD "onscreen-keyboard"
void menu_bar_cleanup (MenuBar* self);
static void menu_bar_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
static void menu_bar_greeter_set_env (MenuBar* self, const gchar* key, const gchar* val);
static GtkWidget* menu_bar_make_a11y_indicator (MenuBar* self);
static void menu_bar_keyboard_toggled_cb (MenuBar* self, GtkCheckMenuItem* item);
static void _menu_bar_keyboard_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void menu_bar_high_contrast_toggled_cb (MenuBar* self, GtkCheckMenuItem* item);
static void _menu_bar_high_contrast_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
GtkAccelGroup* menu_bar_get_accel_group (MenuBar* self);
#define UG_SETTINGS_KEY_HIGH_CONTRAST "high-contrast"
static void menu_bar_screen_reader_toggled_cb (MenuBar* self, GtkCheckMenuItem* item);
static void _menu_bar_screen_reader_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
#define UG_SETTINGS_KEY_SCREEN_READER "screen-reader"
LightDMLayout* unity_greeter_get_layout_by_name (const gchar* name);
gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
static gint menu_bar_cmp_layout (LightDMLayout* a, LightDMLayout* b);
static GtkWidget* menu_bar_make_keyboard_indicator (MenuBar* self);
static void menu_bar_setup_indicators (MenuBar* self);
static void menu_bar_indicator_added_cb (MenuBar* self, IndicatorObject* object, IndicatorObjectEntry* entry);
static void _menu_bar_indicator_added_cb_indicator_object_entry_added (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self);
static void menu_bar_indicator_removed_cb (MenuBar* self, IndicatorObject* object, IndicatorObjectEntry* entry);
static void _menu_bar_indicator_removed_cb_indicator_object_entry_removed (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self);
gboolean ug_settings_set_boolean (const gchar* key, gboolean value);
GtkWindow* menu_bar_get_keyboard_window (MenuBar* self);
static void menu_bar_set_keyboard_window (MenuBar* self, GtkWindow* value);
static gint _menu_bar_cmp_layout_gcompare_func (gconstpointer a, gconstpointer b);
static void _menu_bar_layout_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void menu_bar_set_high_contrast (MenuBar* self, gboolean value);
gboolean menu_bar_get_high_contrast (MenuBar* self);
static guint menu_bar_get_indicator_index (MenuBar* self, IndicatorObject* object);
static IndicatorObject* menu_bar_get_indicator_object_from_entry (MenuBar* self, IndicatorObjectEntry* entry);
static void menu_bar_set_background (MenuBar* self, Background* value);
static void menu_bar_set_accel_group (MenuBar* self, GtkAccelGroup* value);
static GObject * menu_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _menu_bar_cleanup_unity_greeter_starting_session (UnityGreeter* _sender, gpointer self);
static void menu_bar_finalize (GObject* obj);
static void _vala_menu_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_menu_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _indicator_menu_item_visibility_changed_cb_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	indicator_menu_item_visibility_changed_cb (self, _sender);
}


static void _indicator_menu_item_visibility_changed_cb_gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	indicator_menu_item_visibility_changed_cb (self, _sender);
}


IndicatorMenuItem* indicator_menu_item_construct (GType object_type, IndicatorObjectEntry* entry) {
	IndicatorMenuItem * self = NULL;
	IndicatorObjectEntry* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	IndicatorObjectEntry* _tmp5_;
	GtkLabel* _tmp6_;
	IndicatorObjectEntry* _tmp14_;
	GtkImage* _tmp15_;
	IndicatorObjectEntry* _tmp23_;
	const gchar* _tmp24_;
	IndicatorObjectEntry* _tmp28_;
	GtkMenu* _tmp29_;
	gboolean _tmp32_ = FALSE;
	g_return_val_if_fail (entry != NULL, NULL);
	self = (IndicatorMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = entry;
	self->entry = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->hbox);
	self->priv->hbox = _tmp2_;
	_tmp3_ = self->priv->hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->hbox;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = entry;
	_tmp6_ = _tmp5_->label;
	if (_tmp6_ != NULL) {
		IndicatorObjectEntry* _tmp7_;
		GtkLabel* _tmp8_;
		IndicatorObjectEntry* _tmp9_;
		GtkLabel* _tmp10_;
		GtkBox* _tmp11_;
		IndicatorObjectEntry* _tmp12_;
		GtkLabel* _tmp13_;
		_tmp7_ = entry;
		_tmp8_ = _tmp7_->label;
		g_signal_connect_object ((GtkWidget*) _tmp8_, "show", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_show, self, 0);
		_tmp9_ = entry;
		_tmp10_ = _tmp9_->label;
		g_signal_connect_object ((GtkWidget*) _tmp10_, "hide", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_hide, self, 0);
		_tmp11_ = self->priv->hbox;
		_tmp12_ = entry;
		_tmp13_ = _tmp12_->label;
		gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	}
	_tmp14_ = entry;
	_tmp15_ = _tmp14_->image;
	if (_tmp15_ != NULL) {
		IndicatorObjectEntry* _tmp16_;
		GtkImage* _tmp17_;
		IndicatorObjectEntry* _tmp18_;
		GtkImage* _tmp19_;
		GtkBox* _tmp20_;
		IndicatorObjectEntry* _tmp21_;
		GtkImage* _tmp22_;
		_tmp16_ = entry;
		_tmp17_ = _tmp16_->image;
		g_signal_connect_object ((GtkWidget*) _tmp17_, "show", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_show, self, 0);
		_tmp18_ = entry;
		_tmp19_ = _tmp18_->image;
		g_signal_connect_object ((GtkWidget*) _tmp19_, "hide", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_hide, self, 0);
		_tmp20_ = self->priv->hbox;
		_tmp21_ = entry;
		_tmp22_ = _tmp21_->image;
		gtk_box_pack_start (_tmp20_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	}
	_tmp23_ = entry;
	_tmp24_ = _tmp23_->accessible_desc;
	if (_tmp24_ != NULL) {
		AtkObject* _tmp25_ = NULL;
		IndicatorObjectEntry* _tmp26_;
		const gchar* _tmp27_;
		_tmp25_ = gtk_widget_get_accessible ((GtkWidget*) self);
		_tmp26_ = entry;
		_tmp27_ = _tmp26_->accessible_desc;
		atk_object_set_name (_tmp25_, _tmp27_);
	}
	_tmp28_ = entry;
	_tmp29_ = _tmp28_->menu;
	if (_tmp29_ != NULL) {
		IndicatorObjectEntry* _tmp30_;
		GtkMenu* _tmp31_;
		_tmp30_ = entry;
		_tmp31_ = _tmp30_->menu;
		gtk_menu_item_set_submenu ((GtkMenuItem*) self, GTK_IS_WIDGET (_tmp31_) ? ((GtkWidget*) _tmp31_) : NULL);
	}
	_tmp32_ = indicator_menu_item_has_visible_child (self);
	if (_tmp32_) {
		gtk_widget_show ((GtkWidget*) self);
	}
	return self;
}


IndicatorMenuItem* indicator_menu_item_new (IndicatorObjectEntry* entry) {
	return indicator_menu_item_construct (TYPE_INDICATOR_MENU_ITEM, entry);
}


gboolean indicator_menu_item_has_visible_child (IndicatorMenuItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	IndicatorObjectEntry* _tmp2_;
	GtkImage* _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->entry;
	_tmp3_ = _tmp2_->image;
	if (_tmp3_ != NULL) {
		IndicatorObjectEntry* _tmp4_;
		GtkImage* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->entry;
		_tmp5_ = _tmp4_->image;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		IndicatorObjectEntry* _tmp9_;
		GtkLabel* _tmp10_;
		gboolean _tmp14_;
		_tmp9_ = self->entry;
		_tmp10_ = _tmp9_->label;
		if (_tmp10_ != NULL) {
			IndicatorObjectEntry* _tmp11_;
			GtkLabel* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = self->entry;
			_tmp12_ = _tmp11_->label;
			_tmp13_ = gtk_widget_get_visible ((GtkWidget*) _tmp12_);
			_tmp8_ = _tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp14_ = _tmp8_;
		_tmp0_ = _tmp14_;
	}
	_tmp15_ = _tmp0_;
	result = _tmp15_;
	return result;
}


void indicator_menu_item_visibility_changed_cb (IndicatorMenuItem* self, GtkWidget* widget) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = indicator_menu_item_has_visible_child (self);
	gtk_widget_set_visible ((GtkWidget*) self, _tmp0_);
}


static void indicator_menu_item_class_init (IndicatorMenuItemClass * klass) {
	indicator_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IndicatorMenuItemPrivate));
	G_OBJECT_CLASS (klass)->finalize = indicator_menu_item_finalize;
}


static void indicator_menu_item_instance_init (IndicatorMenuItem * self) {
	self->priv = INDICATOR_MENU_ITEM_GET_PRIVATE (self);
}


static void indicator_menu_item_finalize (GObject* obj) {
	IndicatorMenuItem * self;
	self = INDICATOR_MENU_ITEM (obj);
	_g_object_unref0 (self->priv->hbox);
	G_OBJECT_CLASS (indicator_menu_item_parent_class)->finalize (obj);
}


GType indicator_menu_item_get_type (void) {
	static volatile gsize indicator_menu_item_type_id__volatile = 0;
	if (g_once_init_enter (&indicator_menu_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IndicatorMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IndicatorMenuItem), 0, (GInstanceInitFunc) indicator_menu_item_instance_init, NULL };
		GType indicator_menu_item_type_id;
		indicator_menu_item_type_id = g_type_register_static (GTK_TYPE_MENU_ITEM, "IndicatorMenuItem", &g_define_type_info, 0);
		g_once_init_leave (&indicator_menu_item_type_id__volatile, indicator_menu_item_type_id);
	}
	return indicator_menu_item_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


MenuBar* menu_bar_construct (GType object_type, Background* bg, GtkAccelGroup* ag) {
	MenuBar * self = NULL;
	Background* _tmp0_;
	GtkAccelGroup* _tmp1_;
	g_return_val_if_fail (bg != NULL, NULL);
	g_return_val_if_fail (ag != NULL, NULL);
	_tmp0_ = bg;
	_tmp1_ = ag;
	self = (MenuBar*) g_object_new (object_type, "background", _tmp0_, "accel-group", _tmp1_, NULL);
	return self;
}


MenuBar* menu_bar_new (Background* bg, GtkAccelGroup* ag) {
	return menu_bar_construct (TYPE_MENU_BAR, bg, ag);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void menu_bar_set_layouts (MenuBar* self, GList* layouts) {
	GList* _tmp0_;
	GList* _tmp3_;
	GtkRadioMenuItem* _tmp4_ = NULL;
	GtkRadioMenuItem* default_item;
	GtkRadioMenuItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = layouts;
	if (_tmp0_ == NULL) {
		LightDMLayout* _tmp1_ = NULL;
		LightDMLayout* _tmp2_;
		_tmp1_ = lightdm_get_layout ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		layouts = g_list_append (layouts, _tmp2_);
	}
	_tmp3_ = layouts;
	_tmp4_ = menu_bar_recreate_menu (self, _tmp3_);
	default_item = _tmp4_;
	_tmp5_ = default_item;
	if (_tmp5_ != NULL) {
		GtkRadioMenuItem* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = default_item;
		_tmp7_ = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			GtkRadioMenuItem* _tmp9_;
			_tmp9_ = default_item;
			menu_bar_layout_toggled_cb (self, (GtkCheckMenuItem*) _tmp9_);
		} else {
			GtkRadioMenuItem* _tmp10_;
			_tmp10_ = default_item;
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp10_, TRUE);
		}
	}
	_g_object_unref0 (default_item);
}


static gboolean menu_bar_real_draw (GtkWidget* base, cairo_t* c) {
	MenuBar * self;
	gboolean result = FALSE;
	Background* _tmp0_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	GList* _tmp13_ = NULL;
	self = (MenuBar*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->_background;
	if (_tmp0_ != NULL) {
		gint x = 0;
		gint y = 0;
		Background* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		cairo_t* _tmp4_;
		cairo_t* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		Background* _tmp8_;
		cairo_t* _tmp9_;
		cairo_t* _tmp10_;
		_tmp1_ = self->priv->_background;
		gtk_widget_translate_coordinates ((GtkWidget*) _tmp1_, (GtkWidget*) self, 0, 0, &_tmp2_, &_tmp3_);
		x = _tmp2_;
		y = _tmp3_;
		_tmp4_ = c;
		cairo_save (_tmp4_);
		_tmp5_ = c;
		_tmp6_ = x;
		_tmp7_ = y;
		cairo_translate (_tmp5_, (gdouble) _tmp6_, (gdouble) _tmp7_);
		_tmp8_ = self->priv->_background;
		_tmp9_ = c;
		background_draw_full (_tmp8_, _tmp9_, BACKGROUND_DRAW_FLAGS_NONE);
		_tmp10_ = c;
		cairo_restore (_tmp10_);
	}
	_tmp11_ = c;
	cairo_set_source_rgb (_tmp11_, 0.1, 0.1, 0.1);
	_tmp12_ = c;
	cairo_paint_with_alpha (_tmp12_, 0.4);
	_tmp13_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp13_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp14_;
				cairo_t* _tmp15_;
				_tmp14_ = child;
				_tmp15_ = c;
				gtk_container_propagate_draw ((GtkContainer*) self, _tmp14_, _tmp15_);
			}
		}
		_g_list_free0 (child_collection);
	}
	result = FALSE;
	return result;
}


void menu_bar_set_keyboard_state (MenuBar* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->onscreen_keyboard_item;
	_tmp1_ = ug_settings_get_boolean (UG_SETTINGS_KEY_ONSCREEN_KEYBOARD);
	gtk_check_menu_item_set_active (_tmp0_, _tmp1_);
}


void menu_bar_cleanup (MenuBar* self) {
	GPid _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->keyboard_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		gint status = 0;
		GPid _tmp2_;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->keyboard_pid;
		kill ((pid_t) _tmp1_, SIGKILL);
		_tmp2_ = self->priv->keyboard_pid;
		waitpid ((pid_t) _tmp2_, &_tmp3_, 0);
		status = _tmp3_;
		self->priv->keyboard_pid = (GPid) 0;
	}
}


static void menu_bar_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	MenuBar * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (MenuBar*) base;
	_vala_min = MENU_BAR_HEIGHT;
	_vala_nat = MENU_BAR_HEIGHT;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void menu_bar_greeter_set_env (MenuBar* self, const gchar* key, const gchar* val) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = key;
	_tmp1_ = val;
	g_setenv (_tmp0_, _tmp1_, TRUE);
	{
		GDBusProxy* _tmp2_;
		GDBusProxy* proxy;
		const GVariantType* _tmp3_;
		GVariantBuilder* _tmp4_;
		GVariantBuilder* builder;
		GVariantBuilder* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GDBusProxy* _tmp8_;
		GVariantBuilder* _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
		GVariant* _tmp13_;
		_tmp2_ = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_NONE, NULL, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", NULL, &_inner_error_);
		proxy = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp3_ = G_VARIANT_TYPE_ARRAY;
		_tmp4_ = g_variant_builder_new (_tmp3_);
		builder = _tmp4_;
		_tmp5_ = builder;
		_tmp6_ = key;
		_tmp7_ = val;
		g_variant_builder_add (_tmp5_, "{ss}", _tmp6_, _tmp7_, NULL);
		_tmp8_ = proxy;
		_tmp9_ = builder;
		_tmp10_ = g_variant_new ("(a{ss})", _tmp9_, NULL);
		_tmp11_ = g_variant_ref_sink (_tmp10_);
		_tmp12_ = g_dbus_proxy_call_sync (_tmp8_, "UpdateActivationEnvironment", _tmp11_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_variant_unref0 (_tmp13_);
		_g_variant_unref0 (_tmp11_);
		if (_inner_error_ != NULL) {
			_g_variant_builder_unref0 (builder);
			_g_object_unref0 (proxy);
			goto __catch7_g_error;
		}
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (proxy);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("menubar.vala:212: Could not get set environment for indicators: %s", _tmp15_);
		_g_error_free0 (e);
		return;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _menu_bar_keyboard_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	menu_bar_keyboard_toggled_cb (self, _sender);
}


static void _menu_bar_high_contrast_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	menu_bar_high_contrast_toggled_cb (self, _sender);
}


static void _menu_bar_screen_reader_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	menu_bar_screen_reader_toggled_cb (self, _sender);
}


static GtkWidget* menu_bar_make_a11y_indicator (MenuBar* self) {
	GtkWidget* result = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* a11y_item;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* hbox;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* image;
	GtkMenu* _tmp9_;
	GtkMenu* _tmp10_;
	GtkWidget* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkCheckMenuItem* _tmp13_;
	GtkCheckMenuItem* _tmp14_;
	GtkCheckMenuItem* _tmp15_;
	GtkCheckMenuItem* _tmp16_;
	GtkMenu* _tmp17_;
	GtkMenu* _tmp18_;
	GtkMenu* submenu;
	GtkCheckMenuItem* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GtkCheckMenuItem* _tmp21_;
	GtkCheckMenuItem* _tmp22_;
	GtkCheckMenuItem* _tmp23_;
	GtkCheckMenuItem* _tmp24_;
	GtkAccelGroup* _tmp25_;
	GtkCheckMenuItem* _tmp26_;
	GtkCheckMenuItem* _tmp27_;
	GtkCheckMenuItem* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_ = NULL;
	GtkCheckMenuItem* _tmp31_;
	GtkCheckMenuItem* _tmp32_;
	GtkCheckMenuItem* item;
	GtkAccelGroup* _tmp33_;
	gboolean _tmp34_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	a11y_item = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	hbox = _tmp3_;
	gtk_widget_show ((GtkWidget*) hbox);
	gtk_container_add ((GtkContainer*) a11y_item, (GtkWidget*) hbox);
	_tmp4_ = g_build_filename (PKGDATADIR, "a11y.svg", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkImage*) gtk_image_new_from_file (_tmp5_);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	image = _tmp8_;
	gtk_widget_show ((GtkWidget*) image);
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) image);
	gtk_widget_show ((GtkWidget*) a11y_item);
	_tmp9_ = (GtkMenu*) gtk_menu_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_tmp11_ = GTK_IS_WIDGET (_tmp10_) ? ((GtkWidget*) _tmp10_) : NULL;
	gtk_menu_item_set_submenu (a11y_item, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = _ ("Onscreen keyboard");
	_tmp13_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp12_);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->onscreen_keyboard_item);
	self->priv->onscreen_keyboard_item = _tmp14_;
	_tmp15_ = self->priv->onscreen_keyboard_item;
	g_signal_connect_object (_tmp15_, "toggled", (GCallback) _menu_bar_keyboard_toggled_cb_gtk_check_menu_item_toggled, self, 0);
	_tmp16_ = self->priv->onscreen_keyboard_item;
	gtk_widget_show ((GtkWidget*) _tmp16_);
	_tmp17_ = gtk_menu_item_get_submenu (a11y_item);
	_tmp18_ = _tmp17_;
	submenu = _tmp18_;
	_tmp19_ = self->priv->onscreen_keyboard_item;
	gtk_menu_shell_append ((GtkMenuShell*) submenu, (GtkWidget*) ((GtkMenuItem*) _tmp19_));
	_tmp20_ = _ ("High Contrast");
	_tmp21_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp20_);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->high_contrast_item);
	self->priv->high_contrast_item = _tmp22_;
	_tmp23_ = self->priv->high_contrast_item;
	g_signal_connect_object (_tmp23_, "toggled", (GCallback) _menu_bar_high_contrast_toggled_cb_gtk_check_menu_item_toggled, self, 0);
	_tmp24_ = self->priv->high_contrast_item;
	_tmp25_ = self->priv->_accel_group;
	gtk_widget_add_accelerator ((GtkWidget*) _tmp24_, "activate", _tmp25_, (guint) GDK_KEY_h, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	_tmp26_ = self->priv->high_contrast_item;
	gtk_widget_show ((GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->high_contrast_item;
	gtk_menu_shell_append ((GtkMenuShell*) submenu, (GtkWidget*) ((GtkMenuItem*) _tmp27_));
	_tmp28_ = self->priv->high_contrast_item;
	_tmp29_ = ug_settings_get_boolean (UG_SETTINGS_KEY_HIGH_CONTRAST);
	gtk_check_menu_item_set_active (_tmp28_, _tmp29_);
	_tmp30_ = _ ("Screen Reader");
	_tmp31_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp30_);
	_tmp32_ = g_object_ref_sink (_tmp31_);
	item = _tmp32_;
	g_signal_connect_object (item, "toggled", (GCallback) _menu_bar_screen_reader_toggled_cb_gtk_check_menu_item_toggled, self, 0);
	_tmp33_ = self->priv->_accel_group;
	gtk_widget_add_accelerator ((GtkWidget*) item, "activate", _tmp33_, (guint) GDK_KEY_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	gtk_widget_show ((GtkWidget*) item);
	gtk_menu_shell_append ((GtkMenuShell*) submenu, (GtkWidget*) ((GtkMenuItem*) item));
	_tmp34_ = ug_settings_get_boolean (UG_SETTINGS_KEY_SCREEN_READER);
	gtk_check_menu_item_set_active (item, _tmp34_);
	result = (GtkWidget*) a11y_item;
	_g_object_unref0 (item);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	return result;
}


static void menu_bar_layout_toggled_cb (MenuBar* self, GtkCheckMenuItem* item) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkCheckMenuItem* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	LightDMLayout* _tmp5_;
	LightDMLayout* layout;
	LightDMLayout* _tmp6_;
	LightDMLayout* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* desc;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gboolean _tmp14_;
	GtkLabel* _tmp47_;
	const gchar* _tmp48_;
	UnityGreeter* _tmp49_;
	gboolean _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = item;
	_tmp4_ = g_object_get_data ((GObject*) _tmp3_, "unity-greeter-layout");
	_tmp5_ = _g_object_ref0 ((LightDMLayout*) _tmp4_);
	layout = _tmp5_;
	_tmp6_ = layout;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (layout);
		return;
	}
	_tmp7_ = layout;
	_tmp8_ = lightdm_layout_get_short_description (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup (_tmp9_);
	desc = _tmp10_;
	_tmp12_ = desc;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = desc;
		_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
	}
	_tmp14_ = _tmp11_;
	if (_tmp14_) {
		LightDMLayout* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gchar** _tmp19_ = NULL;
		gchar** parts;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		LightDMLayout* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp15_ = layout;
		_tmp16_ = lightdm_layout_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "\t", 2);
		parts = _tmp19_;
		parts_length1 = _vala_array_length (_tmp18_);
		_parts_size_ = parts_length1;
		_tmp20_ = parts;
		_tmp20__length1 = parts_length1;
		_tmp21_ = _tmp20_[0];
		_tmp22_ = layout;
		_tmp23_ = lightdm_layout_get_name (_tmp22_);
		_tmp24_ = _tmp23_;
		if (g_strcmp0 (_tmp21_, _tmp24_) == 0) {
			LightDMLayout* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp25_ = layout;
			_tmp26_ = lightdm_layout_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (desc);
			desc = _tmp28_;
		} else {
			gchar** _tmp29_;
			gint _tmp29__length1;
			const gchar* _tmp30_;
			LightDMLayout* _tmp31_ = NULL;
			LightDMLayout* parent_layout;
			gboolean _tmp32_ = FALSE;
			LightDMLayout* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp39_;
			_tmp29_ = parts;
			_tmp29__length1 = parts_length1;
			_tmp30_ = _tmp29_[0];
			_tmp31_ = unity_greeter_get_layout_by_name (_tmp30_);
			parent_layout = _tmp31_;
			_tmp33_ = parent_layout;
			_tmp34_ = lightdm_layout_get_short_description (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ == NULL) {
				_tmp32_ = TRUE;
			} else {
				LightDMLayout* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = parent_layout;
				_tmp37_ = lightdm_layout_get_short_description (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp32_ = g_strcmp0 (_tmp38_, "") == 0;
			}
			_tmp39_ = _tmp32_;
			if (_tmp39_) {
				gchar** _tmp40_;
				gint _tmp40__length1;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				_tmp40_ = parts;
				_tmp40__length1 = parts_length1;
				_tmp41_ = _tmp40_[0];
				_tmp42_ = g_strdup (_tmp41_);
				_g_free0 (desc);
				desc = _tmp42_;
			} else {
				LightDMLayout* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp43_ = parent_layout;
				_tmp44_ = lightdm_layout_get_short_description (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup (_tmp45_);
				_g_free0 (desc);
				desc = _tmp46_;
			}
			_g_object_unref0 (parent_layout);
		}
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp47_ = self->priv->keyboard_label;
	_tmp48_ = desc;
	gtk_label_set_label (_tmp47_, _tmp48_);
	_tmp49_ = unity_greeter_singleton;
	_tmp50_ = _tmp49_->test_mode;
	if (_tmp50_) {
		LightDMLayout* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		_tmp51_ = layout;
		_tmp52_ = lightdm_layout_get_name (_tmp51_);
		_tmp53_ = _tmp52_;
		g_debug ("menubar.vala:277: Setting layout to %s", _tmp53_);
	} else {
		LightDMLayout* _tmp54_;
		_tmp54_ = layout;
		lightdm_set_layout (_tmp54_);
	}
	_g_free0 (desc);
	_g_object_unref0 (layout);
}


static gint menu_bar_cmp_layout (LightDMLayout* a, LightDMLayout* b) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	LightDMLayout* _tmp1_;
	gboolean _tmp3_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		LightDMLayout* _tmp2_;
		_tmp2_ = b;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = 0;
		return result;
	} else {
		LightDMLayout* _tmp4_;
		_tmp4_ = a;
		if (_tmp4_ == NULL) {
			result = 1;
			return result;
		} else {
			LightDMLayout* _tmp5_;
			_tmp5_ = b;
			if (_tmp5_ == NULL) {
				result = -1;
				return result;
			} else {
				GCompareFunc _tmp6_;
				LightDMLayout* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				LightDMLayout* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_ = 0;
				_tmp6_ = g_strcmp0;
				_tmp7_ = a;
				_tmp8_ = lightdm_layout_get_description (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = b;
				_tmp11_ = lightdm_layout_get_description (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp6_ (_tmp9_, _tmp12_);
				result = _tmp13_;
				return result;
			}
		}
	}
}


static GtkWidget* menu_bar_make_keyboard_indicator (MenuBar* self) {
	GtkWidget* result = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* hbox;
	GtkMenuItem* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* image;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkWidget* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->keyboard_item);
	self->priv->keyboard_item = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	hbox = _tmp3_;
	gtk_widget_show ((GtkWidget*) hbox);
	_tmp4_ = self->priv->keyboard_item;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) hbox);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("keyboard", GTK_ICON_SIZE_LARGE_TOOLBAR);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	image = _tmp6_;
	gtk_widget_show ((GtkWidget*) image);
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) image);
	_tmp7_ = (GtkLabel*) gtk_label_new ("");
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->keyboard_label);
	self->priv->keyboard_label = _tmp8_;
	_tmp9_ = self->priv->keyboard_label;
	gtk_label_set_width_chars (_tmp9_, 2);
	_tmp10_ = self->priv->keyboard_label;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->keyboard_label;
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->keyboard_item;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->keyboard_item;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	result = _tmp14_;
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	return result;
}


static void _menu_bar_indicator_added_cb_indicator_object_entry_added (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self) {
	menu_bar_indicator_added_cb (self, _sender, entry);
}


static void _menu_bar_indicator_removed_cb_indicator_object_entry_removed (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self) {
	menu_bar_indicator_removed_cb (self, _sender, entry);
}


static void menu_bar_setup_indicators (MenuBar* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* keyboard_item;
	GtkWidget* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* a11y_item;
	GtkWidget* _tmp6_;
	GList* _tmp7_ = NULL;
	GList* _tmp8_;
	guint _tmp9_ = 0U;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gchar** filenames;
	gint filenames_length1;
	gint _filenames_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	g_return_if_fail (self != NULL);
	menu_bar_greeter_set_env (self, "INDICATOR_GREETER_MODE", "1");
	menu_bar_greeter_set_env (self, "GIO_USE_VFS", "local");
	menu_bar_greeter_set_env (self, "GVFS_DISABLE_FUSE", "1");
	menu_bar_greeter_set_env (self, "RUNNING_UNDER_GDM", "1");
	_tmp0_ = menu_bar_make_keyboard_indicator (self);
	keyboard_item = _tmp0_;
	_tmp1_ = keyboard_item;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_list_length (_tmp3_);
	gtk_menu_shell_insert ((GtkMenuShell*) self, _tmp1_, ((gint) _tmp4_) - 1);
	_g_list_free0 (_tmp3_);
	_tmp5_ = menu_bar_make_a11y_indicator (self);
	a11y_item = _tmp5_;
	_tmp6_ = a11y_item;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_list_length (_tmp8_);
	gtk_menu_shell_insert ((GtkMenuShell*) self, _tmp6_, ((gint) _tmp9_) - 1);
	_g_list_free0 (_tmp8_);
	_tmp10_ = g_getenv ("LANG");
	_tmp11_ = g_getenv ("LANGUAGE");
	g_debug ("menubar.vala:335: LANG=%s LANGUAGE=%s", _tmp10_, _tmp11_);
	_tmp12_ = g_build_filename (INDICATORDIR, "libsession.so", NULL);
	_tmp13_ = g_build_filename (INDICATORDIR, "libdatetime.so", NULL);
	_tmp14_ = g_build_filename (INDICATORDIR, "libpower.so", NULL);
	_tmp15_ = g_build_filename (INDICATORDIR, "libsoundmenu.so", NULL);
	_tmp16_ = g_build_filename (INDICATORDIR, "libapplication.so", NULL);
	_tmp17_ = g_new0 (gchar*, 5 + 1);
	_tmp17_[0] = _tmp12_;
	_tmp17_[1] = _tmp13_;
	_tmp17_[2] = _tmp14_;
	_tmp17_[3] = _tmp15_;
	_tmp17_[4] = _tmp16_;
	filenames = _tmp17_;
	filenames_length1 = 5;
	_filenames_size_ = filenames_length1;
	_tmp18_ = filenames;
	_tmp18__length1 = filenames_length1;
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = _tmp18_;
		filename_collection_length1 = _tmp18__length1;
		for (filename_it = 0; filename_it < _tmp18__length1; filename_it = filename_it + 1) {
			gchar* _tmp19_;
			gchar* filename = NULL;
			_tmp19_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp19_;
			{
				const gchar* _tmp20_;
				IndicatorObject* _tmp21_;
				IndicatorObject* io;
				IndicatorObject* _tmp22_;
				IndicatorObject* _tmp23_;
				IndicatorObject* _tmp24_;
				IndicatorObject* _tmp25_;
				IndicatorObject* _tmp26_;
				IndicatorObject* _tmp27_;
				GList* _tmp28_ = NULL;
				_tmp20_ = filename;
				_tmp21_ = indicator_object_new_from_file (_tmp20_);
				io = _tmp21_;
				_tmp22_ = io;
				if (_tmp22_ == NULL) {
					_g_object_unref0 (io);
					_g_free0 (filename);
					continue;
				}
				_tmp23_ = io;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				self->priv->indicator_objects = g_list_append (self->priv->indicator_objects, _tmp24_);
				_tmp25_ = io;
				g_signal_connect_object (_tmp25_, "entry-added", (GCallback) _menu_bar_indicator_added_cb_indicator_object_entry_added, self, 0);
				_tmp26_ = io;
				g_signal_connect_object (_tmp26_, "entry-removed", (GCallback) _menu_bar_indicator_removed_cb_indicator_object_entry_removed, self, 0);
				_tmp27_ = io;
				_tmp28_ = indicator_object_get_entries (_tmp27_);
				{
					GList* entry_collection = NULL;
					GList* entry_it = NULL;
					entry_collection = _tmp28_;
					for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
						IndicatorObjectEntry* entry = NULL;
						entry = (IndicatorObjectEntry*) entry_it->data;
						{
							IndicatorObject* _tmp29_;
							IndicatorObjectEntry* _tmp30_;
							_tmp29_ = io;
							_tmp30_ = entry;
							menu_bar_indicator_added_cb (self, _tmp29_, _tmp30_);
						}
					}
					_g_list_free0 (entry_collection);
				}
				_g_object_unref0 (io);
				_g_free0 (filename);
			}
		}
	}
	_tmp31_ = g_getenv ("LANG");
	_tmp32_ = g_getenv ("LANGUAGE");
	g_debug ("menubar.vala:353: LANG=%s LANGUAGE=%s", _tmp31_, _tmp32_);
	filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (a11y_item);
	_g_object_unref0 (keyboard_item);
}


static void menu_bar_keyboard_toggled_cb (MenuBar* self, GtkCheckMenuItem* item) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp48_;
	GtkCheckMenuItem* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	ug_settings_set_boolean (UG_SETTINGS_KEY_ONSCREEN_KEYBOARD, _tmp2_);
	_tmp3_ = self->priv->_keyboard_window;
	if (_tmp3_ == NULL) {
		gint id;
		GtkSocket* _tmp19_;
		GtkSocket* _tmp20_;
		GtkSocket* keyboard_socket;
		GtkSocket* _tmp21_;
		GtkWindow* _tmp22_;
		GtkWindow* _tmp23_;
		GtkWindow* _tmp24_;
		GtkWindow* _tmp25_;
		GtkWindow* _tmp26_;
		GtkSocket* _tmp27_;
		GtkSocket* _tmp28_;
		gint _tmp29_;
		GdkScreen* _tmp30_ = NULL;
		GdkScreen* _tmp31_;
		GdkScreen* screen;
		GdkScreen* _tmp32_;
		GdkWindow* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gint monitor;
		GdkRectangle geom = {0};
		GdkScreen* _tmp35_;
		gint _tmp36_;
		GdkRectangle _tmp37_ = {0};
		GtkWindow* _tmp38_;
		GdkRectangle _tmp39_;
		gint _tmp40_;
		GdkRectangle _tmp41_;
		gint _tmp42_;
		GdkRectangle _tmp43_;
		gint _tmp44_;
		GtkWindow* _tmp45_;
		GdkRectangle _tmp46_;
		gint _tmp47_;
		id = 0;
		{
			gchar** argv = NULL;
			gint argv_length1 = 0;
			gint _argv_size_ = 0;
			gint onboard_stdout_fd = 0;
			gchar** _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gchar** _tmp6_;
			gint _tmp6__length1;
			GPid _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_;
			FILE* _tmp10_ = NULL;
			FILE* f;
			gchar* _tmp11_ = NULL;
			gchar* stdout_text;
			gint stdout_text_length1;
			gint _stdout_text_size_;
			FILE* _tmp12_;
			gchar* _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_ = NULL;
			g_shell_parse_argv ("onboard --xid", &_tmp5_, &_tmp4_, &_inner_error_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp4_;
			argv_length1 = _tmp5_;
			_argv_size_ = argv_length1;
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch8_g_error;
			}
			_tmp6_ = argv;
			_tmp6__length1 = argv_length1;
			g_spawn_async_with_pipes (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, NULL, &_tmp8_, NULL, &_inner_error_);
			self->priv->keyboard_pid = _tmp7_;
			onboard_stdout_fd = _tmp8_;
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch8_g_error;
			}
			_tmp9_ = onboard_stdout_fd;
			_tmp10_ = fdopen (_tmp9_, "r");
			f = _tmp10_;
			_tmp11_ = g_new0 (gchar, 1024);
			stdout_text = _tmp11_;
			stdout_text_length1 = 1024;
			_stdout_text_size_ = stdout_text_length1;
			_tmp12_ = f;
			_tmp13_ = stdout_text;
			_tmp13__length1 = stdout_text_length1;
			_tmp14_ = fgets (_tmp13_, _tmp13__length1, _tmp12_);
			if (_tmp14_ != NULL) {
				gchar* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_ = 0;
				_tmp15_ = stdout_text;
				_tmp15__length1 = stdout_text_length1;
				_tmp16_ = atoi ((const gchar*) _tmp15_);
				id = _tmp16_;
			}
			stdout_text = (g_free (stdout_text), NULL);
			_fclose0 (f);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_warning ("menubar.vala:393: Error setting up keyboard: %s", _tmp18_);
			_g_error_free0 (e);
			return;
		}
		__finally8:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = (GtkSocket*) gtk_socket_new ();
		_tmp20_ = g_object_ref_sink (_tmp19_);
		keyboard_socket = _tmp20_;
		_tmp21_ = keyboard_socket;
		gtk_widget_show ((GtkWidget*) _tmp21_);
		_tmp22_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
		_tmp23_ = g_object_ref_sink (_tmp22_);
		menu_bar_set_keyboard_window (self, _tmp23_);
		_g_object_unref0 (_tmp23_);
		_tmp24_ = self->priv->_keyboard_window;
		gtk_window_set_accept_focus (_tmp24_, FALSE);
		_tmp25_ = self->priv->_keyboard_window;
		gtk_window_set_focus_on_map (_tmp25_, FALSE);
		_tmp26_ = self->priv->_keyboard_window;
		_tmp27_ = keyboard_socket;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = keyboard_socket;
		_tmp29_ = id;
		gtk_socket_add_id (_tmp28_, _tmp29_);
		_tmp30_ = gtk_widget_get_screen ((GtkWidget*) self);
		_tmp31_ = _g_object_ref0 (_tmp30_);
		screen = _tmp31_;
		_tmp32_ = screen;
		_tmp33_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp34_ = gdk_screen_get_monitor_at_window (_tmp32_, _tmp33_);
		monitor = _tmp34_;
		_tmp35_ = screen;
		_tmp36_ = monitor;
		gdk_screen_get_monitor_geometry (_tmp35_, _tmp36_, &_tmp37_);
		geom = _tmp37_;
		_tmp38_ = self->priv->_keyboard_window;
		_tmp39_ = geom;
		_tmp40_ = _tmp39_.x;
		_tmp41_ = geom;
		_tmp42_ = _tmp41_.y;
		_tmp43_ = geom;
		_tmp44_ = _tmp43_.height;
		gtk_window_move (_tmp38_, _tmp40_, (_tmp42_ + _tmp44_) - 200);
		_tmp45_ = self->priv->_keyboard_window;
		_tmp46_ = geom;
		_tmp47_ = _tmp46_.width;
		gtk_window_resize (_tmp45_, _tmp47_, 200);
		_g_object_unref0 (screen);
		_g_object_unref0 (keyboard_socket);
	}
	_tmp48_ = self->priv->_keyboard_window;
	_tmp49_ = item;
	_tmp50_ = gtk_check_menu_item_get_active (_tmp49_);
	_tmp51_ = _tmp50_;
	gtk_widget_set_visible ((GtkWidget*) _tmp48_, _tmp51_);
}


static gint _menu_bar_cmp_layout_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = menu_bar_cmp_layout (a, b);
	return result;
}


static void _menu_bar_layout_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	menu_bar_layout_toggled_cb (self, _sender);
}


static GtkRadioMenuItem* menu_bar_recreate_menu (MenuBar* self, GList* layouts_in) {
	GtkRadioMenuItem* result = NULL;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* submenu;
	GtkMenuItem* _tmp2_;
	GtkMenu* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_ = NULL;
	GList* layouts;
	GtkRadioMenuItem* default_item;
	GtkRadioMenuItem* last_item;
	GList* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	submenu = _tmp1_;
	_tmp2_ = self->priv->keyboard_item;
	_tmp3_ = submenu;
	gtk_menu_item_set_submenu (_tmp2_, GTK_IS_WIDGET (_tmp3_) ? ((GtkWidget*) _tmp3_) : NULL);
	_tmp4_ = layouts_in;
	_tmp5_ = g_list_copy (_tmp4_);
	layouts = _tmp5_;
	layouts = g_list_sort (layouts, _menu_bar_cmp_layout_gcompare_func);
	default_item = NULL;
	last_item = NULL;
	_tmp6_ = layouts;
	{
		GList* layout_collection = NULL;
		GList* layout_it = NULL;
		layout_collection = _tmp6_;
		for (layout_it = layout_collection; layout_it != NULL; layout_it = layout_it->next) {
			LightDMLayout* layout = NULL;
			layout = (LightDMLayout*) layout_it->data;
			{
				GSList* _tmp7_ = NULL;
				GtkRadioMenuItem* _tmp8_;
				GSList* _tmp11_;
				LightDMLayout* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				GtkRadioMenuItem* _tmp15_;
				GtkRadioMenuItem* _tmp16_;
				GtkRadioMenuItem* item;
				GtkRadioMenuItem* _tmp17_;
				GtkRadioMenuItem* _tmp18_;
				GtkRadioMenuItem* _tmp19_;
				GList* _tmp20_;
				gconstpointer _tmp21_;
				LightDMLayout* _tmp22_;
				GtkRadioMenuItem* _tmp25_;
				LightDMLayout* _tmp26_;
				LightDMLayout* _tmp27_;
				GtkRadioMenuItem* _tmp28_;
				GtkMenu* _tmp29_;
				GtkRadioMenuItem* _tmp30_;
				_tmp8_ = last_item;
				if (_tmp8_ == NULL) {
					_tmp7_ = NULL;
				} else {
					GtkRadioMenuItem* _tmp9_;
					GSList* _tmp10_ = NULL;
					_tmp9_ = last_item;
					_tmp10_ = gtk_radio_menu_item_get_group (_tmp9_);
					_tmp7_ = _tmp10_;
				}
				_tmp11_ = _tmp7_;
				_tmp12_ = layout;
				_tmp13_ = lightdm_layout_get_description (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new_with_label (_tmp11_, _tmp14_);
				_tmp16_ = g_object_ref_sink (_tmp15_);
				item = _tmp16_;
				_tmp17_ = item;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (last_item);
				last_item = _tmp18_;
				_tmp19_ = item;
				gtk_widget_show ((GtkWidget*) _tmp19_);
				_tmp20_ = layouts_in;
				_tmp21_ = _tmp20_->data;
				_tmp22_ = layout;
				if (((LightDMLayout*) _tmp21_) == _tmp22_) {
					GtkRadioMenuItem* _tmp23_;
					GtkRadioMenuItem* _tmp24_;
					_tmp23_ = item;
					_tmp24_ = _g_object_ref0 (_tmp23_);
					_g_object_unref0 (default_item);
					default_item = _tmp24_;
				}
				_tmp25_ = item;
				_tmp26_ = layout;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				g_object_set_data_full ((GObject*) _tmp25_, "unity-greeter-layout", _tmp27_, g_object_unref);
				_tmp28_ = item;
				g_signal_connect_object ((GtkCheckMenuItem*) _tmp28_, "toggled", (GCallback) _menu_bar_layout_toggled_cb_gtk_check_menu_item_toggled, self, 0);
				_tmp29_ = submenu;
				_tmp30_ = item;
				gtk_menu_shell_append ((GtkMenuShell*) _tmp29_, (GtkWidget*) ((GtkMenuItem*) _tmp30_));
				_g_object_unref0 (item);
			}
		}
	}
	result = default_item;
	_g_object_unref0 (last_item);
	_g_list_free0 (layouts);
	_g_object_unref0 (submenu);
	return result;
}


static void menu_bar_high_contrast_toggled_cb (MenuBar* self, GtkCheckMenuItem* item) {
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_;
	GtkSettings* settings;
	GtkCheckMenuItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkCheckMenuItem* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = gtk_check_menu_item_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkSettings* _tmp5_;
		_tmp5_ = settings;
		g_object_set ((GObject*) _tmp5_, "gtk-theme-name", "HighContrastInverse", NULL);
	} else {
		GtkSettings* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = settings;
		_tmp7_ = self->priv->default_theme_name;
		g_object_set ((GObject*) _tmp6_, "gtk-theme-name", _tmp7_, NULL);
	}
	_tmp8_ = item;
	_tmp9_ = gtk_check_menu_item_get_active (_tmp8_);
	_tmp10_ = _tmp9_;
	menu_bar_set_high_contrast (self, _tmp10_);
	_tmp11_ = self->priv->_high_contrast;
	ug_settings_set_boolean (UG_SETTINGS_KEY_HIGH_CONTRAST, _tmp11_);
	_g_object_unref0 (settings);
}


static void menu_bar_screen_reader_toggled_cb (MenuBar* self, GtkCheckMenuItem* item) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	ug_settings_set_boolean (UG_SETTINGS_KEY_SCREEN_READER, _tmp2_);
	{
		GtkCheckMenuItem* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = item;
		_tmp4_ = gtk_check_menu_item_get_active (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			g_spawn_command_line_async ("orca --replace --no-setup --disable splash-window,main-window", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
		} else {
			g_spawn_command_line_async ("orca --quit", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("menubar.vala:480: Failed to run Orca: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static guint menu_bar_get_indicator_index (MenuBar* self, IndicatorObject* object) {
	guint result = 0U;
	guint index;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (object != NULL, 0U);
	index = (guint) 0;
	_tmp0_ = self->priv->indicator_objects;
	{
		GList* io_collection = NULL;
		GList* io_it = NULL;
		io_collection = _tmp0_;
		for (io_it = io_collection; io_it != NULL; io_it = io_it->next) {
			IndicatorObject* _tmp1_;
			IndicatorObject* io = NULL;
			_tmp1_ = _g_object_ref0 ((IndicatorObject*) io_it->data);
			io = _tmp1_;
			{
				IndicatorObject* _tmp2_;
				IndicatorObject* _tmp3_;
				guint _tmp4_;
				_tmp2_ = io;
				_tmp3_ = object;
				if (_tmp2_ == _tmp3_) {
					result = index;
					_g_object_unref0 (io);
					return result;
				}
				_tmp4_ = index;
				index = _tmp4_ + 1;
				_g_object_unref0 (io);
			}
		}
	}
	result = index;
	return result;
}


static IndicatorObject* menu_bar_get_indicator_object_from_entry (MenuBar* self, IndicatorObjectEntry* entry) {
	IndicatorObject* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry != NULL, NULL);
	_tmp0_ = self->priv->indicator_objects;
	{
		GList* io_collection = NULL;
		GList* io_it = NULL;
		io_collection = _tmp0_;
		for (io_it = io_collection; io_it != NULL; io_it = io_it->next) {
			IndicatorObject* _tmp1_;
			IndicatorObject* io = NULL;
			_tmp1_ = _g_object_ref0 ((IndicatorObject*) io_it->data);
			io = _tmp1_;
			{
				IndicatorObject* _tmp2_;
				GList* _tmp3_ = NULL;
				_tmp2_ = io;
				_tmp3_ = indicator_object_get_entries (_tmp2_);
				{
					GList* e_collection = NULL;
					GList* e_it = NULL;
					e_collection = _tmp3_;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						IndicatorObjectEntry* e = NULL;
						e = (IndicatorObjectEntry*) e_it->data;
						{
							IndicatorObjectEntry* _tmp4_;
							IndicatorObjectEntry* _tmp5_;
							_tmp4_ = e;
							_tmp5_ = entry;
							if (_tmp4_ == _tmp5_) {
								result = io;
								_g_list_free0 (e_collection);
								return result;
							}
						}
					}
					_g_list_free0 (e_collection);
				}
				_g_object_unref0 (io);
			}
		}
	}
	result = NULL;
	return result;
}


static void menu_bar_indicator_added_cb (MenuBar* self, IndicatorObject* object, IndicatorObjectEntry* entry) {
	IndicatorObject* _tmp0_;
	guint _tmp1_ = 0U;
	guint index;
	gint pos;
	GList* _tmp2_ = NULL;
	IndicatorObjectEntry* _tmp14_;
	gint _tmp15_;
	IndicatorObjectEntry* _tmp16_;
	IndicatorMenuItem* _tmp17_;
	IndicatorMenuItem* _tmp18_;
	IndicatorMenuItem* menuitem;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = object;
	_tmp1_ = menu_bar_get_indicator_index (self, _tmp0_);
	index = _tmp1_;
	pos = 0;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp3_;
				GtkWidget* _tmp4_;
				IndicatorMenuItem* _tmp5_;
				IndicatorMenuItem* menuitem;
				IndicatorMenuItem* _tmp6_;
				IndicatorObjectEntry* _tmp7_;
				IndicatorObject* _tmp8_ = NULL;
				IndicatorObject* child_object;
				IndicatorObject* _tmp9_;
				guint _tmp10_ = 0U;
				guint child_index;
				guint _tmp11_;
				guint _tmp12_;
				gint _tmp13_;
				_tmp3_ = child;
				if (!IS_INDICATOR_MENU_ITEM (_tmp3_)) {
					break;
				}
				_tmp4_ = child;
				_tmp5_ = _g_object_ref0 (INDICATOR_MENU_ITEM (_tmp4_));
				menuitem = _tmp5_;
				_tmp6_ = menuitem;
				_tmp7_ = _tmp6_->entry;
				_tmp8_ = menu_bar_get_indicator_object_from_entry (self, _tmp7_);
				child_object = _tmp8_;
				_tmp9_ = child_object;
				_tmp10_ = menu_bar_get_indicator_index (self, _tmp9_);
				child_index = _tmp10_;
				_tmp11_ = child_index;
				_tmp12_ = index;
				if (_tmp11_ > _tmp12_) {
					_g_object_unref0 (child_object);
					_g_object_unref0 (menuitem);
					break;
				}
				_tmp13_ = pos;
				pos = _tmp13_ + 1;
				_g_object_unref0 (child_object);
				_g_object_unref0 (menuitem);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp14_ = entry;
	_tmp15_ = pos;
	g_debug ("menubar.vala:529: Adding indicator object %p at position %d", _tmp14_, _tmp15_);
	_tmp16_ = entry;
	_tmp17_ = indicator_menu_item_new (_tmp16_);
	_tmp18_ = g_object_ref_sink (_tmp17_);
	menuitem = _tmp18_;
	_tmp19_ = pos;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) menuitem, _tmp19_);
	_g_object_unref0 (menuitem);
}


static void menu_bar_indicator_removed_cb (MenuBar* self, IndicatorObject* object, IndicatorObjectEntry* entry) {
	IndicatorObjectEntry* _tmp0_;
	GList* _tmp1_ = NULL;
	IndicatorObjectEntry* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	g_debug ("menubar.vala:537: Removing indicator object %p", _tmp0_);
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				IndicatorMenuItem* _tmp3_;
				IndicatorMenuItem* menuitem;
				IndicatorMenuItem* _tmp4_;
				IndicatorObjectEntry* _tmp5_;
				IndicatorObjectEntry* _tmp6_;
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (INDICATOR_MENU_ITEM (_tmp2_));
				menuitem = _tmp3_;
				_tmp4_ = menuitem;
				_tmp5_ = _tmp4_->entry;
				_tmp6_ = entry;
				if (_tmp5_ == _tmp6_) {
					GtkWidget* _tmp7_;
					_tmp7_ = child;
					gtk_container_remove ((GtkContainer*) self, _tmp7_);
					_g_object_unref0 (menuitem);
					_g_list_free0 (child_collection);
					return;
				}
				_g_object_unref0 (menuitem);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp8_ = entry;
	g_warning ("menubar.vala:549: Indicator object %p not in menubar", _tmp8_);
}


Background* menu_bar_get_background (MenuBar* self) {
	Background* result;
	Background* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background;
	result = _tmp0_;
	return result;
}


static void menu_bar_set_background (MenuBar* self, Background* value) {
	Background* _tmp0_;
	Background* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_background);
	self->priv->_background = _tmp1_;
	g_object_notify ((GObject *) self, "background");
}


gboolean menu_bar_get_high_contrast (MenuBar* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_high_contrast;
	result = _tmp0_;
	return result;
}


static void menu_bar_set_high_contrast (MenuBar* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_high_contrast = _tmp0_;
	g_object_notify ((GObject *) self, "high-contrast");
}


GtkWindow* menu_bar_get_keyboard_window (MenuBar* self) {
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keyboard_window;
	result = _tmp0_;
	return result;
}


static void menu_bar_set_keyboard_window (MenuBar* self, GtkWindow* value) {
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_keyboard_window);
	self->priv->_keyboard_window = _tmp1_;
	g_object_notify ((GObject *) self, "keyboard-window");
}


GtkAccelGroup* menu_bar_get_accel_group (MenuBar* self) {
	GtkAccelGroup* result;
	GtkAccelGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accel_group;
	result = _tmp0_;
	return result;
}


static void menu_bar_set_accel_group (MenuBar* self, GtkAccelGroup* value) {
	GtkAccelGroup* _tmp0_;
	GtkAccelGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_accel_group);
	self->priv->_accel_group = _tmp1_;
	g_object_notify ((GObject *) self, "accel-group");
}


static void _menu_bar_cleanup_unity_greeter_starting_session (UnityGreeter* _sender, gpointer self) {
	menu_bar_cleanup (self);
}


static GObject * menu_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MenuBar * self;
	GtkSettings* _tmp0_ = NULL;
	struct utsname _tmp1_ = {0};
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* label;
	GtkLabel* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenuItem* hostname_item;
	GtkMenuItem* _tmp8_;
	GtkLabel* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkStyle* _tmp17_ = NULL;
	GdkColor* _tmp18_;
	gint _tmp18__length1;
	GdkColor _tmp19_;
	UnityGreeter* _tmp26_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (menu_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MENU_BAR (obj);
	_tmp0_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp0_, "gtk-theme-name", &self->priv->default_theme_name, NULL);
	gtk_menu_bar_set_pack_direction ((GtkMenuBar*) self, GTK_PACK_DIRECTION_RTL);
	uname (&_tmp1_);
	_tmp2_ = _tmp1_.nodename;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	label = _tmp4_;
	_tmp5_ = label;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	hostname_item = _tmp7_;
	_tmp8_ = hostname_item;
	_tmp9_ = label;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = hostname_item;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = hostname_item;
	gtk_menu_item_set_right_justified (_tmp11_, TRUE);
	_tmp12_ = hostname_item;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = hostname_item;
	gtk_menu_shell_append ((GtkMenuShell*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = label;
	gtk_widget_ensure_style ((GtkWidget*) _tmp14_);
	_tmp15_ = label;
	_tmp16_ = label;
	_tmp17_ = gtk_widget_get_style ((GtkWidget*) _tmp16_);
	_tmp18_ = _tmp17_->fg;
	_tmp18__length1 = -1;
	_tmp19_ = _tmp18_[GTK_STATE_NORMAL];
	gtk_widget_modify_fg ((GtkWidget*) _tmp15_, GTK_STATE_INSENSITIVE, &_tmp19_);
	{
		GtkCssProvider* _tmp20_;
		GtkCssProvider* style;
		GtkCssProvider* _tmp21_;
		GtkStyleContext* _tmp22_ = NULL;
		GtkCssProvider* _tmp23_;
		_tmp20_ = gtk_css_provider_new ();
		style = _tmp20_;
		_tmp21_ = style;
		gtk_css_provider_load_from_data (_tmp21_, "* {-GtkWidget-window-dragging: false;}", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (style);
			goto __catch10_g_error;
		}
		_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp23_ = style;
		gtk_style_context_add_provider (_tmp22_, (GtkStyleProvider*) _tmp23_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (style);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_debug ("menubar.vala:165: Internal error loading menubar style: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (hostname_item);
		_g_object_unref0 (label);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	menu_bar_setup_indicators (self);
	_tmp26_ = unity_greeter_singleton;
	g_signal_connect_object (_tmp26_, "starting-session", (GCallback) _menu_bar_cleanup_unity_greeter_starting_session, self, 0);
	_g_object_unref0 (hostname_item);
	_g_object_unref0 (label);
	return obj;
}


static void menu_bar_class_init (MenuBarClass * klass) {
	menu_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MenuBarPrivate));
	GTK_WIDGET_CLASS (klass)->draw = menu_bar_real_draw;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = menu_bar_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_menu_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_menu_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = menu_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = menu_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BAR_BACKGROUND, g_param_spec_object ("background", "background", "background", TYPE_BACKGROUND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BAR_HIGH_CONTRAST, g_param_spec_boolean ("high-contrast", "high-contrast", "high-contrast", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BAR_KEYBOARD_WINDOW, g_param_spec_object ("keyboard-window", "keyboard-window", "keyboard-window", GTK_TYPE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BAR_ACCEL_GROUP, g_param_spec_object ("accel-group", "accel-group", "accel-group", GTK_TYPE_ACCEL_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void menu_bar_instance_init (MenuBar * self) {
	self->priv = MENU_BAR_GET_PRIVATE (self);
	self->priv->_background = NULL;
	self->priv->_high_contrast = FALSE;
	self->priv->_keyboard_window = NULL;
	self->priv->keyboard_label = NULL;
	self->priv->keyboard_pid = (GPid) 0;
}


static void menu_bar_finalize (GObject* obj) {
	MenuBar * self;
	self = MENU_BAR (obj);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->_keyboard_window);
	_g_object_unref0 (self->priv->_accel_group);
	_g_free0 (self->priv->default_theme_name);
	__g_list_free__g_object_unref0_0 (self->priv->indicator_objects);
	_g_object_unref0 (self->priv->keyboard_item);
	_g_object_unref0 (self->priv->high_contrast_item);
	_g_object_unref0 (self->priv->keyboard_label);
	_g_object_unref0 (self->priv->onscreen_keyboard_item);
	G_OBJECT_CLASS (menu_bar_parent_class)->finalize (obj);
}


GType menu_bar_get_type (void) {
	static volatile gsize menu_bar_type_id__volatile = 0;
	if (g_once_init_enter (&menu_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MenuBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) menu_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MenuBar), 0, (GInstanceInitFunc) menu_bar_instance_init, NULL };
		GType menu_bar_type_id;
		menu_bar_type_id = g_type_register_static (GTK_TYPE_MENU_BAR, "MenuBar", &g_define_type_info, 0);
		g_once_init_leave (&menu_bar_type_id__volatile, menu_bar_type_id);
	}
	return menu_bar_type_id__volatile;
}


static void _vala_menu_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MenuBar * self;
	self = MENU_BAR (object);
	switch (property_id) {
		case MENU_BAR_BACKGROUND:
		g_value_set_object (value, menu_bar_get_background (self));
		break;
		case MENU_BAR_HIGH_CONTRAST:
		g_value_set_boolean (value, menu_bar_get_high_contrast (self));
		break;
		case MENU_BAR_KEYBOARD_WINDOW:
		g_value_set_object (value, menu_bar_get_keyboard_window (self));
		break;
		case MENU_BAR_ACCEL_GROUP:
		g_value_set_object (value, menu_bar_get_accel_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_menu_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MenuBar * self;
	self = MENU_BAR (object);
	switch (property_id) {
		case MENU_BAR_BACKGROUND:
		menu_bar_set_background (self, g_value_get_object (value));
		break;
		case MENU_BAR_HIGH_CONTRAST:
		menu_bar_set_high_contrast (self, g_value_get_boolean (value));
		break;
		case MENU_BAR_KEYBOARD_WINDOW:
		menu_bar_set_keyboard_window (self, g_value_get_object (value));
		break;
		case MENU_BAR_ACCEL_GROUP:
		menu_bar_set_accel_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



