/*
 * UbuntuOne Nautilus plugin
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2009-2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib/gi18n.h>
#include <libsyncdaemon/syncdaemon-shares-interface.h>
#include "ubuntuone-nautilus.h"

/* this is the wrong place for this, but it'll have to do for now */
gboolean
ubuntuone_nautilus_check_shares_and_public_files (UbuntuOneNautilus *uon,
						  SyncdaemonFolderInfo *folder_info,
						  GtkWidget *widget)
{
	SyncdaemonInterface *interface;
	gboolean result = TRUE, has_shares = FALSE, has_published = FALSE;
	GString *question = NULL;

	question = g_string_new (_("This folder contains shared folders and/or published files:\n\n"));

	interface = syncdaemon_daemon_get_shares_interface (uon->syncdaemon);
	if (SYNCDAEMON_IS_SHARES_INTERFACE (interface)) {
		GSList *shared_list, *l;

		shared_list = syncdaemon_shares_interface_get_shared (SYNCDAEMON_SHARES_INTERFACE (interface));
		for (l = shared_list; l != NULL; l = l->next) {
			SyncdaemonShareInfo *share_info = SYNCDAEMON_SHARE_INFO (l->data);

			if (g_str_has_prefix (syncdaemon_share_info_get_path (share_info),
					      syncdaemon_folder_info_get_path (folder_info))
			    && syncdaemon_share_info_get_accepted (share_info)) {
				has_shares = TRUE;

				question = g_string_append (question, "\t- ");
				question = g_string_append (question, syncdaemon_share_info_get_path (share_info));
				question = g_string_append (question, _(" (Shared folder)\n"));
			}
		}

		g_slist_free (shared_list);
	}

	/* Now check for published files */
	if (uon->gotpubs) {
		GHashTableIter iter;
		gchar *key, *value;

		g_hash_table_iter_init (&iter, uon->public);
		while (g_hash_table_iter_next (&iter, (gpointer *) &key, (gpointer *) &value)) {
			if (g_str_has_prefix (key, syncdaemon_folder_info_get_path (folder_info))) {
				has_published = TRUE;

				question = g_string_append (question, "\t- ");
				question = g_string_append (question, key);
				question = g_string_append (question, _(" (Published at "));
				question = g_string_append (question, value);
				question = g_string_append (question, ")\n");
			}
		}
	}

	if (has_shares || has_published) {
		GtkWidget *dialog;

		question = g_string_append (question, _("\nThis action will make these files and folders no "
							"longer available to other users. Would you like to "
							"proceed?"));
		dialog = gtk_message_dialog_new (
			GTK_WINDOW (gtk_widget_get_toplevel (widget)),
			0, GTK_MESSAGE_QUESTION,
			GTK_BUTTONS_YES_NO,
			"%s", question->str);
		if (gtk_dialog_run (GTK_DIALOG (dialog)) != GTK_RESPONSE_YES)
			result = FALSE;

		gtk_widget_destroy (dialog);
	}

	/* Free memory */
	g_string_free (question, TRUE);

	return result;
}
