# ubuntuone.oauthdesktop.logger - logging miscellany
#
# Author: Stuart Langridge <stuart.langridge@canonical.com>
#
# Copyright 2009 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Miscellaneous logging functions."""
import os
import logging
import xdg.BaseDirectory

from logging.handlers import RotatingFileHandler

home = xdg.BaseDirectory.xdg_cache_home
LOGFOLDER = os.path.join(home, 'ubuntuone', 'log')
# create log folder if it doesn't exists
if not os.path.exists(LOGFOLDER):
    os.makedirs(LOGFOLDER)

LOGFILENAME = os.path.join(LOGFOLDER, 'oauth-login.log')

# Only log this level and above
LOG_LEVEL = logging.INFO

root_formatter = logging.Formatter(
    fmt="%(asctime)s:%(msecs)s %(name)s %(message)s")
root_handler = RotatingFileHandler(LOGFILENAME, maxBytes=1048576,
                                   backupCount=1)
root_handler.setLevel(LOG_LEVEL)
    
def setupLogging(log_domain):
    """Create basic logger to set filename"""
    logger = logging.getLogger(log_domain)
    logger.propagate = False
    logger.setLevel(LOG_LEVEL)
    logger.addHandler(root_handler)
    return logger
