# -*- coding: utf-8 -*-
# Author: Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Test the windows keyring implementation."""

from json import dumps
from mocker import MockerTestCase
from twisted.internet.defer import inlineCallbacks
from twisted.trial.unittest import TestCase

from ubuntu_sso.keyring.windows import Keyring, USERNAME


class TestWindowsKeyring(MockerTestCase, TestCase):
    """Test the windows keyring implementation."""

    def setUp(self):
        """Setup  tests."""
        super(TestWindowsKeyring, self).setUp()
        self.keyring_lib = self.mocker.mock()
        self.keyring = Keyring(self.keyring_lib)

    @inlineCallbacks
    def test_set_credentials(self):
        """Test setting the credentials."""
        app_name = 'name'
        password = dict(password='password')
        self.keyring_lib.set_password(app_name, USERNAME, dumps(password))
        self.mocker.replay()
        yield self.keyring.set_credentials(app_name, password)

    @inlineCallbacks
    def test_get_credentials(self):
        """Test getting the credentials."""
        app_name = 'name'
        password = dict(password='password')
        self.keyring_lib.get_password(app_name, USERNAME)
        self.mocker.result(dumps(password))
        self.mocker.replay()
        result = yield self.keyring.get_credentials(app_name)
        self.assertEqual(password, result)

    @inlineCallbacks
    def test_get_credentials_not_present(self):
        """Test getting creds that are not present."""
        app_name = 'name'
        self.keyring_lib.get_password(app_name, USERNAME)
        self.mocker.result(None)
        self.mocker.replay()
        result = yield self.keyring.get_credentials(app_name)
        self.assertEqual(None, result)

    @inlineCallbacks
    def test_delete_credentials(self):
        """Test deleting the credentials."""
        app_name = 'name'
        self.keyring_lib.delete_password(app_name, USERNAME)
        self.mocker.replay()
        result = yield self.keyring.delete_credentials(app_name)
        self.assertTrue(result is None)
