/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2018, 2021 NXP
 */

#ifndef __ASM_ARCH_IMX8_REGS_H__
#define __ASM_ARCH_IMX8_REGS_H__

#define ARCH_MXC

#define LPUART_BASE		0x5A060000

#define GPT1_BASE_ADDR		0x5D140000
#define SCU_LPUART_BASE		0x33220000
#define GPIO1_BASE_ADDR		0x5D080000
#define GPIO2_BASE_ADDR		0x5D090000
#define GPIO3_BASE_ADDR		0x5D0A0000
#define GPIO4_BASE_ADDR		0x5D0B0000
#define GPIO5_BASE_ADDR		0x5D0C0000
#define GPIO6_BASE_ADDR		0x5D0D0000
#define GPIO7_BASE_ADDR		0x5D0E0000
#define GPIO8_BASE_ADDR		0x5D0F0000
#define LPI2C1_BASE_ADDR	0x5A800000
#define LPI2C2_BASE_ADDR	0x5A810000
#define LPI2C3_BASE_ADDR	0x5A820000
#define LPI2C4_BASE_ADDR	0x5A830000
#define LPI2C5_BASE_ADDR	0x5A840000

#define FEC_QUIRK_ENET_MAC

#ifdef CONFIG_IMX8QXP
#define LVDS0_PHYCTRL_BASE	0x56221000
#define LVDS1_PHYCTRL_BASE	0x56241000
#define MIPI0_SS_BASE		0x56220000
#define MIPI1_SS_BASE		0x56240000
#endif

#define APBH_DMA_ARB_BASE_ADDR	0x5B810000
#define APBH_DMA_ARB_END_ADDR	0x5B81FFFF
#define MXS_APBH_BASE		APBH_DMA_ARB_BASE_ADDR

#define MXS_GPMI_BASE		(APBH_DMA_ARB_BASE_ADDR + 0x02000)
#define MXS_BCH_BASE		(APBH_DMA_ARB_BASE_ADDR + 0x04000)

#define PASS_OVER_INFO_ADDR	0x0010fe00

#define USB_BASE_ADDR		0x5b0d0000
#define USB_PHY0_BASE_ADDR	0x5b100000

#define CONFIG_SYS_FSL_SEC_ADDR (0x31400000)

#endif /* __ASM_ARCH_IMX8_REGS_H__ */
