/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.standard.tag.common.sql.DataSourceWrapper;

public class DriverTag
extends TagSupport {
    private static final String DRIVER_CLASS_NAME = "javax.servlet.jsp.jstl.sql.driver";
    private static final String JDBC_URL = "javax.servlet.jsp.jstl.sql.jdbcURL";
    private static final String USER_NAME = "javax.servlet.jsp.jstl.sql.userName";
    private static final String PASSWORD = "javax.servlet.jsp.jstl.sql.password";
    private String driverClassName;
    private String jdbcURL;
    private int scope = 1;
    private String userName;
    private String var;

    public void setDriver(String string) {
        this.driverClassName = string;
    }

    public void setJdbcURL(String string) {
        this.jdbcURL = string;
    }

    public void setScope(String string) {
        if ("page".equals(string)) {
            this.scope = 1;
        } else if ("request".equals(string)) {
            this.scope = 2;
        } else if ("session".equals(string)) {
            this.scope = 3;
        } else if ("application".equals(string)) {
            this.scope = 4;
        }
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public int doStartTag() throws JspException {
        DataSourceWrapper dataSourceWrapper = new DataSourceWrapper();
        try {
            dataSourceWrapper.setDriverClassName(this.getDriverClassName());
        }
        catch (Exception exception) {
            throw new JspTagException("Invalid driver class name: " + exception.toString(), (Throwable)exception);
        }
        dataSourceWrapper.setJdbcURL(this.getJdbcURL());
        dataSourceWrapper.setUserName(this.getUserName());
        dataSourceWrapper.setPassword(this.getPassword());
        this.pageContext.setAttribute(this.var, (Object)dataSourceWrapper, this.scope);
        return 0;
    }

    private String getDriverClassName() {
        if (this.driverClassName != null) {
            return this.driverClassName;
        }
        ServletContext servletContext = this.pageContext.getServletContext();
        return servletContext.getInitParameter(DRIVER_CLASS_NAME);
    }

    private String getJdbcURL() {
        if (this.jdbcURL != null) {
            return this.jdbcURL;
        }
        ServletContext servletContext = this.pageContext.getServletContext();
        return servletContext.getInitParameter(JDBC_URL);
    }

    private String getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        ServletContext servletContext = this.pageContext.getServletContext();
        return servletContext.getInitParameter(USER_NAME);
    }

    private String getPassword() {
        ServletContext servletContext = this.pageContext.getServletContext();
        return servletContext.getInitParameter(PASSWORD);
    }
}

