/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Fragment;
import android.os.SystemClock;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Waiter {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final int TIMEOUT = 20000;
    private final int SMALLTIMEOUT = 10000;
    private final Searcher searcher;
    private final Scroller scroller;
    private final Sleeper sleeper;

    public Waiter(ActivityUtils activityUtils, ViewFetcher viewFetcher, Searcher searcher, Scroller scroller, Sleeper sleeper) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.searcher = searcher;
        this.scroller = scroller;
        this.sleeper = sleeper;
    }

    public boolean waitForActivity(String name) {
        return this.waitForActivity(name, 10000);
    }

    public boolean waitForActivity(String name, int timeout) {
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        Activity currentActivity = this.activityUtils.getCurrentActivity(false);
        while (SystemClock.uptimeMillis() < endTime) {
            if (currentActivity != null && currentActivity.getClass().getSimpleName().equals(name)) {
                return true;
            }
            currentActivity = this.activityUtils.getCurrentActivity();
        }
        return false;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, boolean sleep, boolean scroll) {
        HashSet uniqueViews = new HashSet();
        do {
            boolean foundMatchingView;
            if (sleep) {
                this.sleeper.sleep();
            }
            if (foundMatchingView = this.searcher.searchFor(uniqueViews, viewClass, index)) {
                return true;
            }
            if (!scroll || this.scroller.scroll(0)) continue;
            return false;
        } while (scroll);
        return false;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, int timeout, boolean scroll) {
        HashSet uniqueViews = new HashSet();
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundMatchingView = this.searcher.searchFor(uniqueViews, viewClass, index);
            if (foundMatchingView) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public <T extends View> boolean waitForViews(Class<T> viewClass, Class<? extends View> viewClass2) {
        long endTime = SystemClock.uptimeMillis() + 10000L;
        while (SystemClock.uptimeMillis() < endTime) {
            if (this.waitForView(viewClass, 0, false, false)) {
                return true;
            }
            if (this.waitForView(viewClass2, 0, false, false)) {
                return true;
            }
            this.scroller.scroll(0);
            this.sleeper.sleep();
        }
        return false;
    }

    public boolean waitForView(View view) {
        return this.waitForView(view, 20000, true);
    }

    public boolean waitForView(View view, int timeout) {
        return this.waitForView(view, timeout, true);
    }

    public boolean waitForView(View view, int timeout, boolean scroll) {
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundAnyMatchingView = this.searcher.searchFor(view);
            if (foundAnyMatchingView) {
                return true;
            }
            if (!scroll) continue;
            this.scroller.scroll(0);
        }
        return false;
    }

    public View waitForView(int id) {
        ArrayList<Object> views = new ArrayList();
        long endTime = SystemClock.uptimeMillis() + 10000L;
        while (SystemClock.uptimeMillis() <= endTime) {
            this.sleeper.sleep();
            views = this.viewFetcher.getAllViews(false);
            for (View view : views) {
                if (view.getId() != id) continue;
                views = null;
                return view;
            }
        }
        return null;
    }

    public boolean waitForText(String text) {
        return this.waitForText(text, 0, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, scroll, false);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        boolean foundAnyTextView;
        long endTime = SystemClock.uptimeMillis() + timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                return false;
            }
            this.sleeper.sleep();
        } while (!(foundAnyTextView = this.searcher.searchFor(TextView.class, text, expectedMinimumNumberOfMatches, timeout, scroll, onlyVisible)));
        return true;
    }

    public <T extends View> T waitForAndGetView(int index, Class<T> classToFilterBy) {
        int newIndex;
        long endTime = SystemClock.uptimeMillis() + 10000L;
        while (SystemClock.uptimeMillis() <= endTime && !this.waitForView(classToFilterBy, index, true, true)) {
        }
        int numberOfUniqueViews = this.searcher.getNumberOfUniqueViews();
        ArrayList<T> views = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(classToFilterBy));
        if (views.size() < numberOfUniqueViews && (newIndex = index - (numberOfUniqueViews - views.size())) >= 0) {
            index = newIndex;
        }
        View view = null;
        try {
            view = (View)views.get(index);
        }
        catch (IndexOutOfBoundsException exception) {
            Assert.assertTrue((String)(classToFilterBy.getSimpleName() + " with index " + index + " is not available!"), (boolean)false);
        }
        views = null;
        return (T)view;
    }

    public boolean waitForFragment(String tag, int id, int timeout) {
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() <= endTime) {
            if (this.getSupportFragment(tag, id) != null) {
                return true;
            }
            if (this.getFragment(tag, id) == null) continue;
            return true;
        }
        return false;
    }

    private android.support.v4.app.Fragment getSupportFragment(String tag, int id) {
        FragmentActivity fragmentActivity = null;
        try {
            fragmentActivity = (FragmentActivity)this.activityUtils.getCurrentActivity(false);
        }
        catch (ClassCastException ignored) {
            // empty catch block
        }
        if (fragmentActivity != null) {
            try {
                if (tag == null) {
                    return fragmentActivity.getSupportFragmentManager().findFragmentById(id);
                }
                return fragmentActivity.getSupportFragmentManager().findFragmentByTag(tag);
            }
            catch (NoSuchMethodError ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean waitForLogMessage(String logMessage, int timeout) {
        StringBuilder stringBuilder = new StringBuilder();
        long endTime = SystemClock.uptimeMillis() + (long)timeout;
        while (SystemClock.uptimeMillis() <= endTime) {
            if (this.getLog(stringBuilder).lastIndexOf(logMessage) != -1) {
                return true;
            }
            this.sleeper.sleep();
        }
        return false;
    }

    private StringBuilder getLog(StringBuilder stringBuilder) {
        Process p = null;
        BufferedReader reader = null;
        String line = null;
        try {
            p = Runtime.getRuntime().exec("logcat -d");
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stringBuilder.setLength(0);
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.destroy(p, reader);
        return stringBuilder;
    }

    private void destroy(Process p, BufferedReader reader) {
        p.destroy();
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Fragment getFragment(String tag, int id) {
        try {
            if (tag == null) {
                return this.activityUtils.getCurrentActivity().getFragmentManager().findFragmentById(id);
            }
            return this.activityUtils.getCurrentActivity().getFragmentManager().findFragmentByTag(tag);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }
}

