kotex-utf
=========

Introduction
------------

kotex-utf is a macro package for typesetting Hangul, the native 
alphabet of the Korean language. The input Korean text should be 
encoded in UTF-8.  kotex-utf belongs to ko.TeX, a comprehensive 
Korean typesetting system together with packages kotex-oblivoir, 
kotex-plain, kotex-utils, cjk-ko, xetexko, and luaxexko.

Dependencies
------------

kotex-utf depends on the following packages:

* xetexko: Hangul and hanja mapping tables
* cjk-ko: main style, Korean counters and captions

Files
-----

### TeXinputs

    dhucs-nanumfont.sty -> tex/latex/kotex/
    dhucs.sty -> tex/latex/kotex/
    hfontspec.default -> tex/latex/kotex/
    kosections-utf.sty -> tex/latex/kotex/
    kotex.cfg -> tex/latex/kotex/
    kotexutf.sty -> tex/latex/kotex/
    lucenc.dfu -> tex/latex/kotex/
    lucuhcmj.fd -> tex/latex/kotex/
    contrib/dhucs-cmap.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-enumerate.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-enumitem.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-gremph.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-interword.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-paralist.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-sectsty.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-setspace.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-trivcj.sty -> tex/latex/kotex/contrib/
    contrib/dhucs-ucshyper.sty -> tex/latex/kotex/contrib/
    contrib/dhucsfn.sty -> tex/latex/kotex/contrib/
    contrib/kotex-logo.sty -> tex/latex/kotex/contrib/
    contrib/kotex-varioref.sty -> tex/latex/kotex/contrib/

### TeX4ht

    tex4ht/dhucs.4ht -> tex/latex/kotex/tex4ht/
    tex4ht/dhucs.cfg -> tex/latex/kotex/tex4ht/
    tex4ht/kosections-utf.4ht -> tex/latex/kotex/tex4ht/

### Documents

    README (this file) -> doc/latex/kotex-utf/
    doc/kotexdoc.pdf -> doc/latex/kotex-utf/
    doc/kotexdoc.tex -> doc/latex/kotex-utf/
    doc/sample-finemath-setup.tex -> doc/latex/kotex-utf/
    doc/yettext.tex -> doc/latex/kotex-utf/
    doc/yettext.txt -> doc/latex/kotex-utf/
    doc/fig/allowbreak-dhucs.pdf -> doc/latex/kotex-utf/fig/
    doc/fig/fntexp.pdf -> doc/latex/kotex-utf/fig/
    doc/fig/fntnormal.pdf -> doc/latex/kotex-utf/fig/
    doc/fig/histkotex.jpg -> doc/latex/kotex-utf/fig/
    doc/fig/linebreaktest.pdf -> doc/latex/kotex-utf/fig/
    doc/fig/testdhucsallowbreak.pdf -> doc/latex/kotex-utf/fig/

Usage
-----

Call `kotex.sty` (in cjk-ko package) with package options as follows:

    \usepackage[<options>]{kotex}

When kotex-utf is installed and appropriate options are given,
kotex-utf will be used for Hangul typesetting.
Certain package options are inter-related to the TeX engines
that are used for compilation.
For pdfLaTeX and LaTeX, you can use *utf* option:

    \usepackage[utf]{kotex}

This will activate the default behavior of kotex-utf. The option 
*utf* does not need to be specified since it is a default option. 
You can use other common options such as *hangul*, *hanja*, 
and *nojosa*.

Calling kotex.sty in the following way

    \usepackage[cjk]{kotex}

will typeset Hangul using the cjk-ko package. Options *usedotemph* 
and *usecjkt1font* can be specified in addition to the common options. 

For XeLaTeX and LuaLaTeX, you can just load kotex.sty without 
any package options. kotex-utf will call XeTeX-ko or LuaTeX-ko accordingly.

Sample document
---------------

The following document is a sample document utilizing the iftex 
package for coping with multiple engines:

    \documentclass{article}
    \usepackage{amsmath,amssymb}
    \usepackage{hyperref}
    \usepackage[hangul]{kotex}
    \usepackage{kotex-logo}
    \usepackage{iftex}
    \ifPDFTeX
      \usepackage{dhucs-nanumfont}
      \hypersetup{pdftex,unicode,bookmarks}
      \input glyphtounicode
      \pdfgentounicode=1
    \else\ifXeTeX
      \setmainhangulfont[Ligatures=TeX]{HCR Batang LVT}
      \setsanshangulfont[Ligatures=TeX]{HCR Dotum LVT}
    \else\ifLuaTeX
      \hypersetup{unicode,bookmarks}
      \setmainhangulfont[Ligatures=TeX]{HCR Batang LVT}
      \setsanshangulfont[Ligatures=TeX]{HCR Dotum LVT}
    \fi\fi\fi
    \begin{document}
    \title{\koTeX-article 템플릿}
    \author{저자}
    \date{}
    \maketitle
    \section{절 제목}
    \subsection{소절 제목}
    이 문서는 \koTeX\ 문서입니다.
    \end{document}

For more information, please refer to the included documentation (written in Korean).

License
-------

kotex-utf is licensed under the LaTeX Project Public
License (LPPL).

Contacts
--------

Please report any errors or suggestions to the package maintainer,
Kihwang Lee <leekh@ktug.org>.

