\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{coursebook}

% screen: narrow margins for on-screen viewing, plus non-draft hyperref
\newif\if@screen \@screentrue
\newif\if@afour \@afourtrue
\DeclareOption{screen}{\@screentrue}
% two non-screen options:
\DeclareOption{a4}{\@screenfalse \@afourtrue}
\DeclareOption{letter}{\@screenfalse \@afourfalse}

\ProcessOptions\relax

\RequirePackage[dutch,english]{babel}

\LoadClass[twoside]{report}

\RequirePackage{dcolumn}
\newcolumntype{d}[1]{D{.}{.}{#1}}

\RequirePackage{graphicx}
\RequirePackage{color}
\RequirePackage{amsmath}
\usepackage{bm}

\RequirePackage{verbatim}

\RequirePackage{url}
\global\let\path\url

%%% fonts %%%%%%%%%%%%%%

\RequirePackage[utf8]{inputenc}
\RequirePackage{csquotes} % recommended by babel

\RequirePackage[TS1,T1]{fontenc}
\RequirePackage{newpxtext,newpxmath}
\useosf % old-style figures in text, not in math
\linespread{1.05} % Palatino needs a bit more leading than CM
\renewcommand{\sfdefault}{fav} % vera
\renewcommand\ttdefault{lmtt}
\RequirePackage[protrusion=true,expansion=false]{microtype}
\UseMicrotypeSet[protrusion]{basictext}

%%% layout and typography %%%%%%%%%%%%%%

% vertical page layout
\textheight 680pt
\headsep 18pt
\headheight 12pt
\footskip 40pt

% horizontal page layout
\textwidth 5.5in

% reserve 36bp for outdented section numbers
\newdimen\outd@nt
\outd@nt=36bp
\newdimen\xw@dth
\xw@dth=\textwidth
\advance\xw@dth\outd@nt

\if@screen
  \pdfpagewidth=460bp
  \pdfpageheight=770bp
\else \if@afour
  \pdfpagewidth=595bp
  \pdfpageheight=842bp
\else
  \pdfpagewidth=612bp
  \pdfpageheight=792bp
\fi \fi
\paperwidth=\pdfpagewidth
\paperheight=\pdfpageheight

\parindent=0pt
\parskip=6pt

% make \parskip available in e.g. a minipage environment
\newdimen\saveparskip
\saveparskip=\parskip

% raggedbottom:
\def\@textbottom{\vskip \z@ \@plus.01fil}
\let\@texttop\relax

\AtBeginDocument{%
  % vertical centering of page content
  \topmargin=\pdfpageheight
  % subtract stuff
  \advance\topmargin-\headheight
  \advance\topmargin-\headsep
  \advance\topmargin-\textheight
  \advance\topmargin-\footskip
  % divide remainder by 2
  \divide\topmargin by 2
  % subtract 1in offset
  \advance\topmargin -1in
  % horizontal: center, then make room for outdented section numbers
  \oddsidemargin=\paperwidth
  \advance\oddsidemargin-\textwidth
  \divide\oddsidemargin by 2
  \advance\oddsidemargin .5\outd@nt
  \advance \oddsidemargin -1in
  \evensidemargin=\oddsidemargin
}

%%% page headers- and footers %%%%%%%%%%%%%%%%%%%%%

\AtBeginDocument{\global\let\@datesave\@date}
% left header: title; right header: section
\def\booktitle#1{\gdef\@booktitle{#1}}
\def\bookauthor#1{\gdef\@bookauthor{#1}}
\def\ps@headings{%
    \def\@oddfoot{\null\hspace{-\outd@nt}%
      \sffamily{\scriptsize\MakeUppercase{\@datesave}}\hfill\thepage}
    \def\@evenfoot{\null\hspace{-\outd@nt}%
      \sffamily\thepage\hfill\scriptsize\scriptsize\@booktitle}
    \def\@evenhead{%
      \null\hspace{-\outd@nt}\rlap{\rule[-4pt]{\xw@dth}{0.3bp}}%
      \hfill\sffamily\footnotesize\itshape\leftmark }%
    \def\@oddhead{\null\hspace{-\outd@nt}\rlap{\rule[-4pt]{\xw@dth}{0.3bp}}%
      {\sffamily\footnotesize {\itshape\rightmark }}\hfill\null}%
    \let\@mkboth\markboth
  \def\chaptermark##1{\markboth {\MakeUppercase{\thechapter\quad ##1}}%
      {\MakeUppercase{\thechapter\quad ##1}}}%
  \def\sectionmark##1{%
    \markright {\thesection\quad ##1}}}
\pagestyle{headings}

\def\ps@plain{%
    \def\@oddfoot{\null\hspace{-\outd@nt}%
      \sffamily{\scriptsize\MakeUppercase{\@datesave}}\hfill\thepage}
    \def\@evenfoot{\null\hspace{-\outd@nt}%
      \sffamily\thepage\hfill\scriptsize\@booktitle}
    \let\@oddhead\@empty\let\@evenhead\@empty}

%%% title %%%%%%%%%%%%%%

\renewcommand\maketitle{%
  \begin{titlepage}%
    \begin{center}
      \vspace*{120bp}
      \hspace*{-.5\outd@nt}%
        {\sffamily\fontsize{40bp}{40bp}\selectfont \@title \par}%
      \vspace{80bp}
      \hspace*{-.5\outd@nt}%
        {\fontsize{24bp}{24bp}\itshape \@author \par}
    \end{center}
    \vfill\null
  \end{titlepage}%
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

%%% other tweaks to report style %%%%%%%%%%%%%%%%%

\setcounter{secnumdepth}{2}
\setcounter{tocdepth}{1}
\let\tocsave\tableofcontents
\def\tableofcontents{{%
  \parskip=0pt
  \tocsave
  % restore leftmark
  \markboth{\uppercase{\contentsname}}{\uppercase{\contentsname}}
}}

\def\@makechapterhead#1{%
  {\parindent \z@ \raggedright \normalfont\sffamily
    \large \@chapapp\space \thechapter
    \par\nobreak
    \interlinepenalty\@M
    \Huge \sffamily #1\par\nobreak
    \vskip 40\p@
  }}
\def\@makeschapterhead#1{%
  {\parindent \z@ \raggedright
    \normalfont
    \interlinepenalty\@M
    \Huge \sffamily  #1\par\nobreak
    \vskip 40\p@
  }}

% outdented section numbers
\def\@seccntformat#1{\llap{\csname the#1\endcsname \hspace{6pt}\null}}
\def\section{\@startsection{section}{1}{\z@}%
  {12pt}{9pt}%
  {\sffamily\Large\raggedright}}

\def\subsection{\@startsection{subsection}{2}{\z@}%
  {6pt}{1sp}%
  {\sffamily\large\raggedright}}

% run-in subsubsection headers
\def\@runin#1{{\normalsize\bfseries #1.}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
  {6pt}{-0.5em}{\@runin}}

% footnotes

\renewcommand\@makefntext[1]{%
  \arabic{footnote}.\quad #1}

% lists

% less white in and around lists
\leftmargini1.5em
\leftmarginii1.5em
\leftmarginiii1.5em
\leftmarginiv1.5em
\labelsep0pt
\labelwidth\leftmargini
\def\@mkklab#1{#1\hfil\null}
\def\@listi{\leftmargin\leftmargini
  \parsep 0\p@
  \topsep 0\p@
  \itemsep3\p@
}
\let\@listI\@listi

% left-align label within its space.
% this can only be done by redefining enumerate/itemize
\def\enumerate{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{##1\hss}}%
  \fi}
\let\endenumerate =\endlist
\def\itemize{%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \expandafter
    \list
      \csname\@itemitem\endcsname
      {\def\makelabel##1{##1\hss}}%
  \fi}
\let\enditemize =\endlist

% replace item labels
\def\labelitemi{\guillemotright} % \guilsinglright
\def\labelitemii{\textopenbullet}
\def\labelitemiii{--}
\def\labelitemiv{\textperiodcentered}

\renewcommand*\descriptionlabel[1]{%
 \normalfont\bfseries #1\quad}

%%% float tweaks %%%%%%%%%%%%%%%%%%%%%

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \centering
  \sbox\@tempboxa{\sffamily\small\itshape #1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\sffamily\small\itshape #1. #2\par}%
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{3}
\setcounter{dbltopnumber}{2}
\renewcommand{\topfraction}{.9}
\renewcommand{\textfraction}{.1}
\renewcommand{\bottomfraction}{.75}
\renewcommand{\floatpagefraction}{.9}
\renewcommand{\dblfloatpagefraction}{.9}
\renewcommand{\dbltopfraction}{.9}

%%% verbatims %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% We like a smaller verbatim, but not in running text.
% \every@verbatim doesn't apply to the inline verb environment.

\def\sm@ller{%
  \@tempdima=\f@size pt
  \advance\@tempdima-0.1\@tempdima
  \fontsize{\@tempdima}{\f@baselineskip}\selectfont}
\addto@hook\every@verbatim{\sm@ller}%

% less whitespace around verbatims
\def\less@white{\topsep=3pt}
\addto@hook\every@verbatim{\less@white}

\newenvironment{sverbatim}%
  {\bgroup\small\verbatim}%
  {\endverbatim\egroup}

\newenvironment{fverbatim}%
  {\bgroup\footnotesize\verbatim}%
  {\endverbatim\egroup}

\global\let\verbatim@startsave\verbatim@startline
\newenvironment{labeledverbatim}[1]%
  {\def\verbatim@startline{%
      \verbatim@startsave
      \leavevmode\llap{\sffamily #1\hspace{12pt}\null}%
      \global\let\verbatim@startline\verbatim@startsave}%
   \verbatim}%
  {\endverbatim}

%%% hyperref %%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage{hyperref}
\definecolor{dgreen}{rgb}{0,0.6,0}
\if@screen
  \hypersetup{%
    raiselinks=false,%
    colorlinks=true,%
    citecolor=dgreen,%
    bookmarksnumbered=true,%
    bookmarksopen=true,%
    bookmarksopenlevel=1}
\else
  \hypersetup{draft=true}
\fi

%%% utility macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\extrawhite{\vspace{6pt}}

\newcommand\cmd[1]{\texttt{\textbackslash #1}}
\newcommand\benv[1]{\texttt{\cmd{begin}\{#1\}}}
\newcommand\eenv[1]{\texttt{\cmd{end}\{#1\}}}

\global\let\menupath\textit
\global\let\package\texttt

%% discretionary linebreak
\newcommand{\dbr}{\discretionary{}{}{}}

%% shorter command for backslash
\newcommand{\bsl}{\textbackslash}
\newcommand{\command}[1]{\texttt{\bsl #1}}

%% formatting tabulars %%%%%%%%%%%%%%%
\newcommand\topline{\rule{\linewidth}{.3pt}\par\vspace{6pt}}
\newcommand\midline{\par\vspace{-6pt}\rule{\linewidth}{.3pt}\par\vspace{6pt}}
\newcommand\botline{\par\vspace{-6pt}\rule{\linewidth}{.3pt}}

\input logos

%%% typesetting examples %%%%%%%%%%%%%%%%%%%

% some horizontal measurements for examples
\newdimen\exacolwidth
\exacolwidth=.5\textwidth
\advance\exacolwidth-1pc

% prepare for typesetting example source at the left
\newcommand\exa{%
  \vspace{4pt}
  \par\bgroup\raggedright
  \begin{minipage}{\exacolwidth}
  \raggedright\footnotesize}

% prepare for including typeset example
\newcommand\exb{%
  \end{minipage}%
  \kern 2pc\begin{minipage}{\exacolwidth}
  \raggedright}

% finish example
\newcommand\exc{%
  \end{minipage}\par
  \egroup
  \vspace{4pt}
}

% uniform scaling of screenshots
\newcommand{\scalegrap}[2][.5]{\scalebox{#1}{\includegraphics{#2}}}

%%% framed typeset examples
\newdimen\figwd

\newcommand\includedetail[2][1]{%
  \figwd=#1\linewidth
  \advance\figwd-2\fboxrule
  \advance\figwd-2\fboxsep
  \par\fbox{\includegraphics[width=\figwd]{#2}}\par
}

\endinput
