use std::fs;
use std::io::{self, Write};
use std::path::PathBuf;

/// This is printed to the file before the rest of the contents.
const PRELUDE: &str = r#"// This file is autogenerated.
//
// To add bindings, edit windows_sys.lst then use `./x run generate-windows-sys` to
// regenerate the bindings.
//
// ignore-tidy-filelength
"#;

fn main() -> io::Result<()> {
    let mut path: PathBuf =
        std::env::args_os().nth(1).expect("a path to the rust repository is required").into();
    path.push("library/std/src/sys/windows/c/windows_sys.lst");

    // Load the list of APIs
    let buffer = fs::read_to_string(&path)?;
    let names: Vec<&str> = buffer
        .lines()
        .filter_map(|line| {
            let line = line.trim();
            if line.is_empty() || line.starts_with("//") { None } else { Some(line) }
        })
        .collect();

    // Write the bindings to windows-sys.rs
    let bindings = windows_bindgen::standalone_std(&names);
    path.set_extension("rs");
    let mut f = std::fs::File::create(&path)?;
    f.write_all(PRELUDE.as_bytes())?;
    f.write_all(bindings.as_bytes())?;

    Ok(())
}
