/* $Id: ins.h,v 1.5 2004/11/01 04:35:57 nuffer Exp $ */
#ifndef _ins_h
#define _ins_h

#include "basics.h"

namespace re2c
{

const uint nChars = 256;
typedef uchar Char;

const uint CHAR = 0;
const uint GOTO = 1;
const uint FORK = 2;
const uint TERM = 3;
const uint CTXT = 4;

union Ins {

	struct
	{
		byte	tag;
		byte	marked;
		void	*link;
	}

	i;

	struct
	{
		ushort	value;
		ushort	bump;
		void	*link;
	}

	c;
};

inline bool isMarked(Ins *i)
{
	return i->i.marked != 0;
}

inline void mark(Ins *i)
{
	i->i.marked = true;
}

inline void unmark(Ins *i)
{
	i->i.marked = false;
}

} // end namespace re2c

#endif
