/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEntityReference.h"

#include "EntityReference.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEntityReference);

/* Hash table */

static const HashTableValue JSEntityReferenceTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntityReferenceConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSEntityReferenceTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityReferenceTableValues, 0 };
#else
    { 2, 1, JSEntityReferenceTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSEntityReferenceConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSEntityReferenceConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityReferenceConstructorTableValues, 0 };
#else
    { 1, 0, JSEntityReferenceConstructorTableValues, 0 };
#endif

class JSEntityReferenceConstructor : public DOMConstructorObject {
public:
    JSEntityReferenceConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSEntityReferenceConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSEntityReferencePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSEntityReferenceConstructor::s_info = { "EntityReferenceConstructor", 0, &JSEntityReferenceConstructorTable, 0 };

bool JSEntityReferenceConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityReferenceConstructor, DOMObject>(exec, &JSEntityReferenceConstructorTable, this, propertyName, slot);
}

bool JSEntityReferenceConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntityReferenceConstructor, DOMObject>(exec, &JSEntityReferenceConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSEntityReferencePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSEntityReferencePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityReferencePrototypeTableValues, 0 };
#else
    { 1, 0, JSEntityReferencePrototypeTableValues, 0 };
#endif

const ClassInfo JSEntityReferencePrototype::s_info = { "EntityReferencePrototype", 0, &JSEntityReferencePrototypeTable, 0 };

JSObject* JSEntityReferencePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntityReference>(exec, globalObject);
}

const ClassInfo JSEntityReference::s_info = { "EntityReference", &JSNode::s_info, &JSEntityReferenceTable, 0 };

JSEntityReference::JSEntityReference(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<EntityReference> impl)
    : JSNode(structure, globalObject, impl)
{
}

JSObject* JSEntityReference::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSEntityReferencePrototype(JSEntityReferencePrototype::createStructure(JSNodePrototype::self(exec, globalObject)));
}

bool JSEntityReference::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityReference, Base>(exec, &JSEntityReferenceTable, this, propertyName, slot);
}

bool JSEntityReference::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntityReference, Base>(exec, &JSEntityReferenceTable, this, propertyName, descriptor);
}

JSValue jsEntityReferenceConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSEntityReference* domObject = static_cast<JSEntityReference*>(asObject(slotBase));
    return JSEntityReference::getConstructor(exec, domObject->globalObject());
}
JSValue JSEntityReference::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEntityReferenceConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
