/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGTransformList.h"

#include <wtf/GetPtr.h>

#include "JSSVGMatrix.h"
#include "JSSVGTransform.h"
#include "SVGTransform.h"
#include "SVGTransformList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTransformList)

/* Hash table */

static const HashTableValue JSSVGTransformListTableValues[2] =
{
    { "numberOfItems", DontDelete|ReadOnly, (intptr_t)jsSVGTransformListNumberOfItems, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTransformListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGTransformListTableValues, 0 };
#else
    { 2, 1, JSSVGTransformListTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGTransformListPrototypeTableValues[10] =
{
    { "clear", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionClear, (intptr_t)0 },
    { "initialize", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionInitialize, (intptr_t)1 },
    { "getItem", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionGetItem, (intptr_t)1 },
    { "insertItemBefore", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionInsertItemBefore, (intptr_t)2 },
    { "replaceItem", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionReplaceItem, (intptr_t)2 },
    { "removeItem", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionRemoveItem, (intptr_t)1 },
    { "appendItem", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionAppendItem, (intptr_t)1 },
    { "createSVGTransformFromMatrix", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionCreateSVGTransformFromMatrix, (intptr_t)1 },
    { "consolidate", DontDelete|Function, (intptr_t)jsSVGTransformListPrototypeFunctionConsolidate, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTransformListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGTransformListPrototypeTableValues, 0 };
#else
    { 33, 31, JSSVGTransformListPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGTransformListPrototype::s_info = { "SVGTransformListPrototype", 0, &JSSVGTransformListPrototypeTable, 0 };

JSObject* JSSVGTransformListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTransformList>(exec, globalObject);
}

bool JSSVGTransformListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTransformListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGTransformList::s_info = { "SVGTransformList", 0, &JSSVGTransformListTable, 0 };

JSSVGTransformList::JSSVGTransformList(PassRefPtr<Structure> structure, PassRefPtr<SVGTransformList> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGTransformList::~JSSVGTransformList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGTransformList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGTransformListPrototype(JSSVGTransformListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGTransformList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTransformList, Base>(exec, &JSSVGTransformListTable, this, propertyName, slot);
}

JSValuePtr jsSVGTransformListNumberOfItems(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTransformList* imp = static_cast<SVGTransformList*>(static_cast<JSSVGTransformList*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->numberOfItems());
}

JSValuePtr jsSVGTransformListPrototypeFunctionClear(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->clear(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionInitialize(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->initialize(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->getItem(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionInsertItemBefore(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->insertItemBefore(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionReplaceItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->replaceItem(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->removeItem(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionAppendItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    return castedThisObj->appendItem(exec, args);
}

JSValuePtr jsSVGTransformListPrototypeFunctionCreateSVGTransformFromMatrix(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    SVGTransformList* imp = static_cast<SVGTransformList*>(castedThisObj->impl());
    TransformationMatrix matrix = toSVGMatrix(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGTransform>::create(imp->createSVGTransformFromMatrix(matrix)).get(), castedThisObj->context());
    return result;
}

JSValuePtr jsSVGTransformListPrototypeFunctionConsolidate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransformList::s_info))
        return throwError(exec, TypeError);
    JSSVGTransformList* castedThisObj = static_cast<JSSVGTransformList*>(asObject(thisValue));
    SVGTransformList* imp = static_cast<SVGTransformList*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGTransform>::create(imp->consolidate()).get(), castedThisObj->context());
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, SVGTransformList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGTransformList>(exec, object, context);
}
SVGTransformList* toSVGTransformList(JSC::JSValuePtr value)
{
    return value->isObject(&JSSVGTransformList::s_info) ? static_cast<JSSVGTransformList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
