import _sqlite

"""Python interface to the SQLite embedded database engine."""

#-------------------------------------------------------------------------------
# Module Information
#-------------------------------------------------------------------------------

__revision__ = """$Revision: 1.17 $"""[11:-2]

threadsafety = 1
apilevel = "2.0"
paramstyle = "pyformat"

# This is the version string for the current PySQLite version.
version = "0.4.3"

# This is a tuple with the same digits as the vesrion string, but it's
# suitable for comparisons of various versions.
version_info = (0, 4, 3)

#-------------------------------------------------------------------------------
# Data type support
#-------------------------------------------------------------------------------

from main import DBAPITypeObject, Cursor, Connection, PgResultSet

STRING    = DBAPITypeObject(_sqlite.STRING)

# There is no BINARY because SQLite doesn't support binary data (you'd have to
# escape the null characters)

INT       = DBAPITypeObject(_sqlite.INTEGER)

NUMBER    = DBAPITypeObject(_sqlite.INTEGER,
                            _sqlite.FLOAT)

DATE      = DBAPITypeObject(_sqlite.DATE)

TIME      = DBAPITypeObject(_sqlite.TIME)

TIMESTAMP = DBAPITypeObject(_sqlite.TIMESTAMP)

ROWID     = DBAPITypeObject()

#-------------------------------------------------------------------------------
# Exceptions
#-------------------------------------------------------------------------------

from _sqlite import Warning, Error, InterfaceError, \
    DatabaseError, DataError, OperationalError, IntegrityError, InternalError, \
    ProgrammingError, NotSupportedError

#-------------------------------------------------------------------------------
# Global Functions
#-------------------------------------------------------------------------------

def connect(*args, **kwargs):
    return Connection(*args, **kwargs)

__all__ = ['connect','IntegrityError', 'InterfaceError', 'InternalError',
           'NotSupportedError', 'OperationalError',
           'ProgrammingError', 'Warning',
           'Connection', 'Cursor', 'PgResultSet',
           'apilevel', 'paramstyle', 'threadsafety', 'version', 'version_info']
