import sys
import sqlite
from xmlimport import Project, PROJECT_ATTRS

# Encoding of the strings in the SQLite database
ENCODING = "iso-8859-1"

CHUNKSIZE = 1000

def main():
    out_stream = sys.stdout

    # We want to have all fields in table converted to Unicode strings.
    expected = ["unicode"] * len(PROJECT_ATTRS)

    conn = sqlite.connect("db", client_encoding="iso-8859-1")

    cursor = conn.cursor()

    cursor.execute("-- types %s" % ", ".join(expected))

    out_stream.write((u"""<?xml version="1.0" encoding="%s"?>
                    <!DOCTYPE project-listing
                    SYSTEM "http://freshmeat.net/backend/fm-projects-0.1.dtd">
                    <project-listing>\n""" % ENCODING).encode(ENCODING))

    counter = 0

    while 1:
        cursor.execute("select * from project limit %i offset %i" % (CHUNKSIZE, counter))

        # No results?
        if cursor.rowcount == 0:
            break

        # Under Python 2.2, we could use the optional DB-API extension
        # "for item in cursor:", too.
        for item in cursor.fetchall():
            # Create a new project and fill its attributes with the current row
            # from the resultset.
            prj = Project()
            for key in PROJECT_ATTRS:
                prj.__dict__[key] = item[key.encode(ENCODING)]

            out_stream.write(prj.toxml().encode(ENCODING))

    out_stream.write(u"</project-listing>".encode(ENCODING))

    conn.close()

if __name__ == "__main__":
    main()
