#!/usr/bin/python

# Sample SQLite Program

import sqlite

print "Version: " + sqlite.version
print

def query(cursor, kingdom_name):
    
    # Create the SQL statement using a multi-line triple-quoted string.
    SQL = """select k.kingdom_name, v.vernacular_name, tu.unit_name1, tu.unit_name2, tu.unit_name3
             from taxonomic_units as tu,
             kingdoms as k,
             vernaculars as v
             where tu.tsn=v.tsn
             and tu.unit_name3 != ''
             and tu.kingdom_id = k.kingdom_id
             and k.kingdom_name = %s
             limit 10"""

    cursor.execute(SQL, kingdom_name)

    # Print SQL
    print "SQL: ", cursor.sql + "\n"
    print "Results:\n"

    # Print Column Information. Note all column types are TEXT
    print "Column Information:\n"
    for col in cursor.description:
        print "\t %12s - %3s bytes" % (col[0], repr(col[3]))

    print

    # Print records
    print "Data:\n"

    for row in cursor.fetchall():
        print "%10s, %25s, %15s, %15s, %15s" % tuple(row[:])

    print


# Connect to the database
conn = sqlite.connect(db="db", mode=044)

# Obtain a cursor
cursor = conn.cursor()

query(cursor, 'Plantae')
query(cursor, 'Animalia')
query(cursor, 'Fungi')

# Close the database.
conn.close()
