-- DATABASE itis  delimiter

-- TABLE change_comments row size = 263 number of columns = 4
-- unload file name = chang00100.unl
create table change_comments 
(		
    change_track_id integer not null,
	--serial;
    chg_cmt_id integer primary key,
    change_detail varchar(250) not null ,
    update_date date not null 
);

-- TABLE change_operations row size = 12 number of columns = 3
-- unload file name = chang00101.unl number of rows = 0 }
create table change_operations 
(
    change_track_id integer not null,
    chg_op_id integer not null ,
    update_date date not null 
);

-- TABLE chg_operation_lkp row size = 34 number of columns = 3
-- unload file name = chg_o00102.unl number of rows = 0
create table chg_operation_lkp 
(
	--serial;
    chg_op_id integer primary key,
    change_operation varchar(25,5) not null,
    update_date date not null 
);

-- TABLE change_tracks row size = 367 number of columns = 9
-- unload file name = chang00103.unl number of rows = 0 }
create table change_tracks 
(
	--serial;
    change_track_id integer primary key,
    old_tsn integer,
    change_reason varchar(40,18) not null ,
    change_initiator varchar(100,1) not null ,
    change_reviewer varchar(100,1) not null ,
    change_certifier varchar(100,1) not null ,
    change_time_stamp datetime year to minute not null ,
    tsn integer not null ,
    update_date date not null 
);

-- TABLE kingdoms row size = 18 number of columns = 3 index size = 12 }
-- unload file name = kingd00104.unl number of rows = 5 }
create table kingdoms 
(
	--serial;
    kingdom_id integer primary key,
    kingdom_name char(10) not null,
    update_date date not null 
);

-- TABLE taxon_unit_types row size = 29 number of columns = 6
-- unload file name = taxon00105.unl number of rows = 87 }
create table taxon_unit_types 
(
    kingdom_id integer not null,
    rank_id smallint not null ,
    rank_name char(15) not null ,
    dir_parent_rank_id smallint not null ,
    req_parent_rank_id smallint not null ,
    update_date date not null 
);

-- TABLE geographic_div row size = 54 number of columns = 3
-- unload file name = geogr00106.unl number of rows = 82562 }

create table geographic_div 
(
    tsn integer not null,
    geographic_value varchar(45,6) not null ,
    update_date date not null 
);

-- TABLE jurisdiction row size = 59 number of columns = 4
-- unload file name = juris00107.unl number of rows = 42803 }
create table jurisdiction 
(
    tsn integer not null,
    jurisdiction_value varchar(30,6) not null ,
    origin varchar(19,6) not null ,
    update_date date not null 
);

-- TABLE nodc_ids row size = 20 number of columns = 3 index size = 42 }
-- unload file name = nodc_00108.unl number of rows = 209582 }
create table nodc_ids 
(
    nodc_id char(12) not null ,
    update_date date not null ,
    tsn integer not null ,
    primary key (nodc_id,tsn)  constraint u833_145
);

-- TABLE taxon_authors_lkp row size = 111 number of columns = 4
-- unload file name = taxon00109.unl number of rows = 86424 }
create table taxon_authors_lkp 
(
	--serial;
    taxon_author_id integer primary key,
    taxon_author varchar(100,30) not null ,
    update_date date not null ,
    kingdom_id smallint not null 
);

-- TABLE vernaculars row size = 106 number of columns = 5
-- unload file name = verna00110.unl number of rows = 78107
create table vernaculars 
(
    tsn integer not null,
    vernacular_name varchar(80,5) not null ,
    language varchar(15),
    approved_ind char(1),
    update_date date not null 
);

-- TABLE synonym_links row size = 12 number of columns = 3
-- unload file name = synon00111.unl number of rows = 70331 }
create table synonym_links 
(
    tsn integer not null,
    tsn_accepted integer not null ,
    update_date date not null 
);

-- TABLE reference_links row size = 102 number of columns = 8
-- unload file name = refer00112.unl number of rows = 405345 }
create table reference_links 
(
    tsn integer not null,
    doc_id_prefix char(3) not null ,
    documentation_id integer not null ,
    original_desc_ind char(1),
    init_itis_desc_ind char(1),
    change_track_id integer,
    vernacular_name varchar(80,5),
    update_date date not null 
);

-- TABLE experts row size = 368 number of columns = 5 index size = 16 }
-- unload file name = exper00113.unl number of rows = 54 }
create table experts 
(
    expert_id_prefix char(3) not null ,
	--serial;
    expert_id integer primary key,
    expert varchar(100,1) not null ,
    exp_comment varchar(255),
    update_date date not null 
);

-- TABLE other_sources row size = 356 number of columns = 8
-- unload file name = other00114.unl number of rows = 102 }
create table other_sources 
(
    source_id_prefix char(3) not null ,
	--serial;
    source_id integer primary key,
    source_type char(10) not null ,
    source varchar(64,4) not null ,
    version char(10) not null ,
    acquisition_date date not null ,
    source_comment varchar(255),
    update_date date not null 
);

-- TABLE publications row size = 1060 number of columns = 14
-- unload file name = publi00115.unl number of rows = 1208 }
create table publications 
(
    pub_id_prefix char(3) not null ,
	--serial;
    publication_id integer primary key,
    reference_author varchar(100,1) not null ,
    title varchar(255,10),
    publication_name varchar(255,1) not null ,
    listed_pub_date date,
    actual_pub_date date not null ,
    publisher varchar(80,10),
    pub_place varchar(40,10),
    isbn varchar(16),
    issn varchar(16),
    pages varchar(15),
    pub_comment varchar(255),
    update_date date not null 
);

-- TABLE reviews row size = 399 number of columns = 7 index size = 30 }
-- unload file name = revie00116.unl number of rows = 0 }
create table reviews 
(
    tsn integer not null,
    review_start_date date not null ,
    review_end_date date,
    review_reason varchar(25,8) not null ,
    reviewer varchar(100,25) not null ,
    review_comment varchar(255),
    update_date date not null 
);

-- TABLE tu_comments_links row size = 12 number of columns = 3
-- unload file name = tu_co00117.unl number of rows = 48251

create table tu_comments_links 
(
    tsn integer not null,
    comment_id integer not null ,
    update_date date not null 
);

-- TABLE sub_tracking_hist row size = 378 number of columns = 8
-- unload file name = sub_t00118.unl number of rows = 84
create table sub_tracking_hist 
(
    track_id integer not null,
    sub_status varchar(30),
    time_stamp datetime year to second not null ,
    public_view_ind char(1),
    sub_comment varchar(255),
    reviewer_name varchar(30),
    reviewer_email varchar(30),
    reviewer_phone varchar(15)
);

-- TABLE sub_tracking row size = 194 number of columns = 8
-- unload file name = sub_t00119.unl number of rows = 82

create table sub_tracking 
(
	--serial;
    track_id integer primary key,
    person_name varchar(30,5) not null ,
    address1 varchar(30),
    address2 varchar(30),
    phone_number varchar(30),
    email_address varchar(30),
    agency_name varchar(30),
    parent_track_id integer
);

-- TABLE taxonomic_units row size = 292 number of columns = 23
-- unload file name = taxon00120.unl number of rows = 320804
create table taxonomic_units 
(
	--serial;
    tsn integer primary key,
    unit_ind1 char(1),
    unit_name1 char(35) not null,
    unit_ind2 char(1),
    unit_name2 varchar(35),
    unit_ind3 varchar(7),
    unit_name3 varchar(35),
    unit_ind4 varchar(7),
    unit_name4 varchar(35),
    unnamed_taxon_ind char(1),
    usage varchar(12,5) not null,
    unaccept_reason varchar(24,7),
    credibility_rtng varchar(40,17) not null,
    completeness_rtng char(10),
    currency_rating char(7),
    phylo_sort_seq smallint,
    initial_time_stamp datetime not null,
    parent_tsn integer,
    taxon_author_id integer,
    hybrid_author_id integer,
    kingdom_id smallint not null,
    rank_id smallint not null,
    update_date date not null
);

-- TABLE comments row size = 2117 number of columns = 5
-- unload file name = comme00121.unl number of rows = 8463
create table comments 
(
	--serial;
    comment_id integer primary key,
    commentator varchar(100),
    comment_detail char(2000) not null ,
    comment_time_stamp datetime not null ,
    update_date date not null 
);

create unique index change_comments_idx on change_comments (change_track_id,chg_cmt_id);
create unique index chg_operations_idx on change_operations (change_track_id,chg_op_id);
create unique index chg_oper_lkp_idx on chg_operation_lkp (chg_op_id);
create unique index change_tracks_idx on change_tracks (change_track_id);
create unique index kingdoms_idx on kingdoms (kingdom_id);
create unique index taxon_unit_type_idx on taxon_unit_types (kingdom_id,rank_id);
create unique index geographic_div_idx on geographic_div(tsn,geographic_value);
create unique index jurisdiction_idx on jurisdiction (tsn,jurisdiction_value);
create unique index nodc_ids_idx on nodc_ids (tsn);
create unique index txn_authors_lkp_idx on taxon_authors_lkp (taxon_author_id,kingdom_id);
create unique index vernaculars_idx on vernaculars(tsn,vernacular_name);
create        index synonym_links1_idx on synonym_links (tsn);
create        index synonym_links2_idx on synonym_links (tsn_accepted);
create unique index reference_links_idx on reference_links(tsn,doc_id_prefix,documentation_id);
create unique index experts_idx on experts (expert_id_prefix,expert_id);
create unique index other_sources_idx on other_sources(source_id_prefix,source_id);
create unique index publications_idx on publications (pub_id_prefix,publication_id);
create unique index reviews_idx on reviews (tsn, review_start_date);
create unique index tu_comments_lnk_idx on tu_comments_links(tsn,comment_id);
create        index taxon_unit1_idx on taxonomic_units (parent_tsn);
create        index taxon_unit2_idx on taxonomic_units (unit_name1);
create        index taxon_unit3_idx on taxonomic_units (kingdom_id,rank_id);
create        index taxon_unit4_idx on taxonomic_units (taxon_author_id);
create unique index taxonomic_units_idx on taxonomic_units(tsn);
create unique index comments_idx on comments (comment_id);
