# A demonstration custom widget plugin for Qt Designer.
# 
# Copyright (c) 2007 Riverbank Computing Limited.


from PyQt4 import QtGui, QtDesigner

from pydemo import PyDemo


# This class implements the interface expected by Qt Designer to access the
# custom widget.  See the description of the QDesignerCustomWidgetInterface
# class for full details.
class PyDemoPlugin(QtDesigner.QPyDesignerCustomWidgetPlugin):

    # Initialise the instance.
    def __init__(self, parent=None):
        QtDesigner.QPyDesignerCustomWidgetPlugin.__init__(self)

        self._initialized = False

    # Initialise the custom widget for use with the specified formEditor
    # interface.
    def initialize(self, formEditor):
        if self._initialized:
            return

        self._initialized = True

    # Return True if the custom widget has been intialised.
    def isInitialized(self):
        return self._initialized

    # Return a new instance of the custom widget with the given parent.
    def createWidget(self, parent):
        return PyDemo(parent)

    # Return the name of the class that implements the custom widget.
    def name(self):
        return "PyDemo"

    # Return the name of the group to which the custom widget belongs.  A new
    # group will be created if it doesn't already exist.
    def group(self):
        return "PyQt Examples"

    # Return the icon used to represent the custom widget in Designer's widget
    # box.
    def icon(self):
        return QtGui.QIcon(_logo_pixmap)

    # Return a short description of the custom widget used by Designer in a
    # tool tip.
    def toolTip(self):
        return "PyQt demonstration widget"

    # Return a full description of the custom widget used by Designer in
    # "What's This?" help for the widget.
    def whatsThis(self):
        return "PyDemo is a demonstration custom widget written in Python " \
               "using PyQt."

    # Return True if the custom widget acts as a container for other widgets.
    def isContainer(self):
        return False

    # Return an XML fragment that allows the default values of the custom
    # widget's properties to be overridden.
    def domXml(self):
        return '<widget class="PyDemo" name="pyDemo">\n' \
               ' <property name="toolTip" >\n' \
               '  <string>PyQt demonstration widget</string>\n' \
               ' </property>\n' \
               ' <property name="whatsThis" >\n' \
               '  <string>PyDemo is a demonstration custom widget written ' \
               'in Python using PyQt.</string>\n' \
               ' </property>\n' \
               '</widget>\n'

    # Return the name of the module containing the class that implements the
    # custom widget.  It may include a module path.
    def includeFile(self):
        return "pydemo"


# Define the image used for the icon.
_logo_16x16_xpm = [
    "16 16 6 1",
    " 	c None",
    ".	c #FFFFFF",
    "a	c #01E0FC",
    "b	c #D8D508",
    "c	c #01AC01",
    "d	c #0180E8",
    "aaa...bbbb...aaa",
    "aaaa.bbbbbb.aaaa",
    "aaaa.bbbbbb.aaaa",
    "aaaa.bbbbbb.aaaa",
    "aaa...bbbb...aaa",
    "................",
    "cccccccccccccccc",
    "cccccccccccccccc",
    "cccccccccccccccc",
    "cccccccccccccccc",
    "................",
    "dddddddddddddddd",
    "dddddddddddddddd",
    "dddddddddddddddd",
    "dddddddddddddddd",
    "                "]

_logo_pixmap = QtGui.QPixmap(_logo_16x16_xpm)
