
#include <Python.h>
#include <stdio.h>
#include <math.h>
#include "libnumarray.h"

#ifdef MS_WIN32
#pragma warning(once : 4244)
#endif

#define logical_and(arg1, arg2) (arg1 != 0) & (arg2 != 0)
#define logical_or(arg1, arg2)  (arg1 != 0) | (arg2 != 0)
#define logical_xor(arg1, arg2) ((arg1 != 0) ^ (arg2 != 0)) & 1
#define ufmaximum(arg1, arg2) (((temp1=arg1) > (temp2=arg2)) ? temp1 : temp2)
#define ufminimum(arg1, arg2) (((temp1=arg1) < (temp2=arg2)) ? temp1 : temp2)

static PyObject *_Error;

/*********************  minus  *********************/
/*********************  add  *********************/
/*********************  subtract  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/
/*********************  divide  *********************/
/*********************  floor_divide  *********************/
/*********************  floor_divide  *********************/
/*********************  true_divide  *********************/
/*********************  true_divide  *********************/
/*********************  remainder  *********************/
/*********************  remainder  *********************/
/*********************  power  *********************/
/*********************  abs  *********************/
/*********************  sin  *********************/
/*********************  cos  *********************/
/*********************  tan  *********************/
/*********************  arcsin  *********************/
/*********************  arccos  *********************/
/*********************  arctan  *********************/
/*********************  arctan2  *********************/
/*********************  log  *********************/
/*********************  log10  *********************/
/*********************  exp  *********************/
/*********************  sinh  *********************/
/*********************  cosh  *********************/
/*********************  tanh  *********************/
/*********************  arcsinh  *********************/
/*********************  arccosh  *********************/
/*********************  arctanh  *********************/
/*********************  ieeemask  *********************/
/*********************  ieeemask  *********************/
/*********************  sqrt  *********************/
/*********************  equal  *********************/
/*********************  not_equal  *********************/
/*********************  greater  *********************/
/*********************  greater_equal  *********************/
/*********************  less  *********************/
/*********************  less_equal  *********************/
/*********************  logical_and  *********************/
/*********************  logical_or  *********************/
/*********************  logical_xor  *********************/
/*********************  logical_not  *********************/
/*********************  bitwise_and  *********************/
/*********************  bitwise_or  *********************/
/*********************  bitwise_xor  *********************/
/*********************  bitwise_not  *********************/
/*********************  bitwise_not  *********************/
/*********************  rshift  *********************/
/*********************  lshift  *********************/
/*********************  floor  *********************/
/*********************  floor  *********************/
/*********************  ceil  *********************/
/*********************  ceil  *********************/
/*********************  maximum  *********************/
/*********************  minimum  *********************/
/*********************  fabs  *********************/
/*********************  _round  *********************/
/*********************  hypot  *********************/
/*********************  minus  *********************/

static int minus_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CMINUS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(minus_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  add  *********************/

static int add_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CADD(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(add_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int add_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CADD(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(add_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int add_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CADD(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(add_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int add_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CADD(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int add_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CADD(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  subtract  *********************/

static int subtract_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CSUB(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(subtract_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int subtract_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CSUB(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(subtract_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int subtract_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CSUB(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(subtract_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int subtract_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CSUB(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int subtract_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CSUB(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  multiply  *********************/

static int multiply_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CMUL(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(multiply_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int multiply_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CMUL(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(multiply_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int multiply_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CMUL(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(multiply_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int multiply_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CMUL(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int multiply_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CMUL(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  divide  *********************/

static int divide_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CDIV(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(divide_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int divide_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CDIV(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(divide_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int divide_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CDIV(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(divide_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int divide_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CDIV(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int divide_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CDIV(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  true_divide  *********************/

static int true_divide_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CDIV(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(true_divide_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int true_divide_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CDIV(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(true_divide_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int true_divide_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CDIV(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(true_divide_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int true_divide_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CDIV(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            true_divide_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(true_divide_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int true_divide_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CDIV(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            true_divide_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(true_divide_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  remainder  *********************/

static int remainder_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CREM(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(remainder_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int remainder_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CREM(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(remainder_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int remainder_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CREM(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(remainder_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int remainder_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CREM(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int remainder_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CREM(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  power  *********************/

static int power_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CPOW(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(power_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int power_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CPOW(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(power_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int power_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CPOW(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(power_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int power_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CPOW(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int power_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CPOW(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  abs  *********************/

static int abs_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Float32 *tout = (Float32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = NUM_CABS(*tin);
    }
    return 0;
}

UFUNC_DESCR2(abs_Complex32_vector, sizeof(Complex32), sizeof(Float32));
/*********************  sin  *********************/

static int sin_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CSIN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(sin_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  cos  *********************/

static int cos_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CCOS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(cos_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  tan  *********************/

static int tan_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CTAN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(tan_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  arcsin  *********************/

static int arcsin_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CASIN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arcsin_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  arccos  *********************/

static int arccos_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CACOS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arccos_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  arctan  *********************/

static int arctan_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CATAN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arctan_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  arcsinh  *********************/

static int arcsinh_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CASINH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arcsinh_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  arccosh  *********************/

static int arccosh_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CACOSH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arccosh_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  arctanh  *********************/

static int arctanh_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CATANH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arctanh_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  log  *********************/

static int log_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CLOG(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(log_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  log10  *********************/

static int log10_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CLOG10(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(log10_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  exp  *********************/

static int exp_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CEXP(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(exp_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  sinh  *********************/

static int sinh_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CSINH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(sinh_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  cosh  *********************/

static int cosh_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CCOSH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(cosh_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  tanh  *********************/

static int tanh_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CTANH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(tanh_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  sqrt  *********************/

static int sqrt_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CSQRT(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(sqrt_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  equal  *********************/

static int equal_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CEQ(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(equal_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int equal_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CEQ(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(equal_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int equal_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CEQ(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(equal_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));

/*********************  not_equal  *********************/

static int not_equal_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CNE(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(not_equal_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int not_equal_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CNE(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(not_equal_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int not_equal_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CNE(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(not_equal_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));

/*********************  logical_and  *********************/

static int logical_and_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CLAND(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_and_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int logical_and_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CLAND(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_and_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int logical_and_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CLAND(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_and_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));

/*********************  logical_or  *********************/

static int logical_or_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CLOR(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_or_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int logical_or_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CLOR(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_or_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int logical_or_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CLOR(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_or_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));

/*********************  logical_xor  *********************/

static int logical_xor_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CLXOR(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_xor_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int logical_xor_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CLXOR(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_xor_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));


static int logical_xor_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CLXOR(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_xor_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Bool));

/*********************  logical_not  *********************/

static int logical_not_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = NUM_CLNOT(*tin);
    }
    return 0;
}

UFUNC_DESCR2(logical_not_Complex32_vector, sizeof(Complex32), sizeof(Bool));
/*********************  floor  *********************/

static int floor_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CFLOOR(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(floor_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  ceil  *********************/

static int ceil_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CCEIL(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(ceil_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  maximum  *********************/

static int maximum_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CMAX(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(maximum_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int maximum_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CMAX(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(maximum_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int maximum_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CMAX(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(maximum_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int maximum_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            *tout = NUM_CMAX(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int maximum_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            net = NUM_CMAX(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  minimum  *********************/

static int minimum_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CMIN(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(minimum_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int minimum_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CMIN(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(minimum_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int minimum_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CMIN(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(minimum_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int minimum_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            *tout = NUM_CMIN(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int minimum_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            net = NUM_CMIN(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));
/*********************  fabs  *********************/

static int fabs_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CFABS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(fabs_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  _round  *********************/

static int _round_Complex32_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin = (Complex32 *) buffers[0];
    Complex32 *tout = (Complex32 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CROUND(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(_round_Complex32_vector, sizeof(Complex32), sizeof(Complex32));
/*********************  hypot  *********************/

static int hypot_Complex32_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32  *tin1  = (Complex32 *) buffers[0];
    Complex32  *tin2  = (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CHYPOT(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(hypot_Complex32_vector_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int hypot_Complex32_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 *tin1     = (Complex32 *) buffers[0];
    Complex32 tscalar   = *(Complex32 *) buffers[1];
    Complex32 *tout    = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CHYPOT(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(hypot_Complex32_vector_scalar, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int hypot_Complex32_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex32 tscalar = *(Complex32 *) buffers[0];
    Complex32 *tin2   =  (Complex32 *) buffers[1];
    Complex32 *tout  = (Complex32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CHYPOT(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(hypot_Complex32_scalar_vector, sizeof(Complex32), sizeof(Complex32), sizeof(Complex32));


static int hypot_Complex32_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32 *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout = (Complex32 *) ((char *) output + outboffset);
    Complex32 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex32 *) ((char *) tout + outbstrides[dim]);
            NUM_CHYPOT(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            hypot_Complex32_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(hypot_Complex32_accumulate, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static int hypot_Complex32_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex32  *tin   = (Complex32 *) ((char *) input  + inboffset);
    Complex32 *tout  = (Complex32 *) ((char *) output + outboffset);
    Complex32 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex32 *) ((char *) tin + inbstrides[dim]);
            NUM_CHYPOT(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            hypot_Complex32_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(hypot_Complex32_reduce, CHECK_ALIGN, sizeof(Complex32), sizeof(Complex32));

static PyMethodDef _ufuncComplex32Methods[] = {

	{NULL,      NULL}        /* Sentinel */
};

static PyObject *init_funcDict(void) {
    PyObject *dict;
    dict = PyDict_New();
    NA_add_cfunc(dict, "('minus', 'vector', (('Complex32',), ('Complex32',)))", (void *) &minus_Complex32_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &add_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &add_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('add', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &add_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('add', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &add_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('add', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &add_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &subtract_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &subtract_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('subtract', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &subtract_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &subtract_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('subtract', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &subtract_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &multiply_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &multiply_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('multiply', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &multiply_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &multiply_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('multiply', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &multiply_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('divide', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &divide_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('divide', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &divide_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('divide', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &divide_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('divide', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &divide_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('divide', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &divide_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &true_divide_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &true_divide_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('true_divide', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &true_divide_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &true_divide_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('true_divide', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &true_divide_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &remainder_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &remainder_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('remainder', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &remainder_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &remainder_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('remainder', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &remainder_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('power', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &power_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('power', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &power_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('power', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &power_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('power', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &power_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('power', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &power_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('abs', 'vector', (('Complex32',), ('Float32',)))", (void *) &abs_Complex32_vector_descr);
    NA_add_cfunc(dict, "('sin', 'vector', (('Complex32',), ('Complex32',)))", (void *) &sin_Complex32_vector_descr);
    NA_add_cfunc(dict, "('cos', 'vector', (('Complex32',), ('Complex32',)))", (void *) &cos_Complex32_vector_descr);
    NA_add_cfunc(dict, "('tan', 'vector', (('Complex32',), ('Complex32',)))", (void *) &tan_Complex32_vector_descr);
    NA_add_cfunc(dict, "('arcsin', 'vector', (('Complex32',), ('Complex32',)))", (void *) &arcsin_Complex32_vector_descr);
    NA_add_cfunc(dict, "('arccos', 'vector', (('Complex32',), ('Complex32',)))", (void *) &arccos_Complex32_vector_descr);
    NA_add_cfunc(dict, "('arctan', 'vector', (('Complex32',), ('Complex32',)))", (void *) &arctan_Complex32_vector_descr);
    NA_add_cfunc(dict, "('arcsinh', 'vector', (('Complex32',), ('Complex32',)))", (void *) &arcsinh_Complex32_vector_descr);
    NA_add_cfunc(dict, "('arccosh', 'vector', (('Complex32',), ('Complex32',)))", (void *) &arccosh_Complex32_vector_descr);
    NA_add_cfunc(dict, "('arctanh', 'vector', (('Complex32',), ('Complex32',)))", (void *) &arctanh_Complex32_vector_descr);
    NA_add_cfunc(dict, "('log', 'vector', (('Complex32',), ('Complex32',)))", (void *) &log_Complex32_vector_descr);
    NA_add_cfunc(dict, "('log10', 'vector', (('Complex32',), ('Complex32',)))", (void *) &log10_Complex32_vector_descr);
    NA_add_cfunc(dict, "('exp', 'vector', (('Complex32',), ('Complex32',)))", (void *) &exp_Complex32_vector_descr);
    NA_add_cfunc(dict, "('sinh', 'vector', (('Complex32',), ('Complex32',)))", (void *) &sinh_Complex32_vector_descr);
    NA_add_cfunc(dict, "('cosh', 'vector', (('Complex32',), ('Complex32',)))", (void *) &cosh_Complex32_vector_descr);
    NA_add_cfunc(dict, "('tanh', 'vector', (('Complex32',), ('Complex32',)))", (void *) &tanh_Complex32_vector_descr);
    NA_add_cfunc(dict, "('sqrt', 'vector', (('Complex32',), ('Complex32',)))", (void *) &sqrt_Complex32_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &equal_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_scalar', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &equal_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('equal', 'scalar_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &equal_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &not_equal_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_scalar', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &not_equal_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('not_equal', 'scalar_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &not_equal_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_and_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_scalar', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_and_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_and', 'scalar_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_and_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_or_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_scalar', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_or_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_or', 'scalar_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_or_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_xor_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_scalar', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_xor_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_xor', 'scalar_vector', (('Complex32', 'Complex32'), ('Bool',)))", (void *) &logical_xor_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_not', 'vector', (('Complex32',), ('Bool',)))", (void *) &logical_not_Complex32_vector_descr);
    NA_add_cfunc(dict, "('floor', 'vector', (('Complex32',), ('Complex32',)))", (void *) &floor_Complex32_vector_descr);
    NA_add_cfunc(dict, "('ceil', 'vector', (('Complex32',), ('Complex32',)))", (void *) &ceil_Complex32_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &maximum_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &maximum_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('maximum', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &maximum_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &maximum_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('maximum', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &maximum_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &minimum_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &minimum_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('minimum', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &minimum_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &minimum_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('minimum', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &minimum_Complex32_accumulate_descr);
    NA_add_cfunc(dict, "('fabs', 'vector', (('Complex32',), ('Complex32',)))", (void *) &fabs_Complex32_vector_descr);
    NA_add_cfunc(dict, "('_round', 'vector', (('Complex32',), ('Complex32',)))", (void *) &_round_Complex32_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &hypot_Complex32_vector_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_scalar', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &hypot_Complex32_vector_scalar_descr);
    NA_add_cfunc(dict, "('hypot', 'scalar_vector', (('Complex32', 'Complex32'), ('Complex32',)))", (void *) &hypot_Complex32_scalar_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'reduce', (('Complex32',), ('Complex32',)))", (void *) &hypot_Complex32_reduce_descr);
    NA_add_cfunc(dict, "('hypot', 'accumulate', (('Complex32',), ('Complex32',)))", (void *) &hypot_Complex32_accumulate_descr);
    return dict;
}

/* platform independent*/
#ifdef MS_WIN32
__declspec(dllexport)
#endif
void init_ufuncComplex32(void) {
    PyObject *m, *d;
    m = Py_InitModule("_ufuncComplex32", _ufuncComplex32Methods);
    d = PyModule_GetDict(m);
    _Error = PyErr_NewException("_ufuncComplex32.error", NULL, NULL);
    PyDict_SetItemString(d, "error", _Error);
    import_libnumarray();
    PyDict_SetItemString(d, "functionDict", init_funcDict());
}
