
#include <Python.h>
#include <stdio.h>
#include <math.h>
#include "libnumarray.h"

#ifdef MS_WIN32
#pragma warning(once : 4244)
#endif

#define logical_and(arg1, arg2) (arg1 != 0) & (arg2 != 0)
#define logical_or(arg1, arg2)  (arg1 != 0) | (arg2 != 0)
#define logical_xor(arg1, arg2) ((arg1 != 0) ^ (arg2 != 0)) & 1
#define ufmaximum(arg1, arg2) (((temp1=arg1) > (temp2=arg2)) ? temp1 : temp2)
#define ufminimum(arg1, arg2) (((temp1=arg1) < (temp2=arg2)) ? temp1 : temp2)

static PyObject *_Error;

/*********************  minus  *********************/

static int minus_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Int8 *tout = (Int8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = -*tin;
    }
    return 0;
}

UFUNC_DESCR2(minus_Bool_vector, sizeof(Bool), sizeof(Int8));
/*********************  add  *********************/

static int add_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 + *tin2;
    }
    return 0;
}

UFUNC_DESCR3(add_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int add_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Int8 *tout    = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 + tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(add_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int add_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar + *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(add_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));

/*********************  subtract  *********************/

static int subtract_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 - *tin2;
    }
    return 0;
}

UFUNC_DESCR3(subtract_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int subtract_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Int8 *tout    = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 - tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(subtract_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int subtract_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar - *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(subtract_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));

/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/

static int divide_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1 / *tin2);
    }
    return 0;
}

UFUNC_DESCR3(divide_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int divide_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1 / tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(divide_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int divide_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar / *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(divide_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int divide_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : lastval / *tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int divide_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : net / *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  divide  *********************/
/*********************  floor_divide  *********************/

static int floor_divide_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : floor(*tin1 / (double) *tin2));
    }
    return 0;
}

UFUNC_DESCR3(floor_divide_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int floor_divide_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : floor(*tin1 / (double) tscalar));
    }
    return 0;
}

UFUNC_DESCR3vs(floor_divide_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int floor_divide_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : floor(tscalar / (double) *tin2));
    }
    return 0;
}

UFUNC_DESCR3sv(floor_divide_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int floor_divide_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : floor(lastval / (double) *tin));
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            floor_divide_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(floor_divide_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int floor_divide_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : floor(net / (double) *tin));
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            floor_divide_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(floor_divide_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  floor_divide  *********************/
/*********************  true_divide  *********************/

static int true_divide_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1 / (double) *tin2);
    }
    return 0;
}

UFUNC_DESCR3(true_divide_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Float32));


static int true_divide_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Float32 *tout    = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1 / (double) tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(true_divide_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Float32));


static int true_divide_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar / (double) *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(true_divide_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Float32));

/*********************  true_divide  *********************/
/*********************  remainder  *********************/

static int remainder_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1  %  *tin2);
    }
    return 0;
}

UFUNC_DESCR3(remainder_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int remainder_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1  %  tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(remainder_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int remainder_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar  %  *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(remainder_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int remainder_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : lastval  %  *tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int remainder_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : net  %  *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  remainder  *********************/
/*********************  power  *********************/

static int power_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = num_pow(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(power_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int power_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Int8 *tout    = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = num_pow(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(power_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int power_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = num_pow(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(power_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));

/*********************  abs  *********************/

static int abs_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Int8 *tout = (Int8 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = fabs(*tin);
    }
    return 0;
}

UFUNC_DESCR2(abs_Bool_vector, sizeof(Bool), sizeof(Int8));
/*********************  sin  *********************/

static int sin_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sin(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sin_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  cos  *********************/

static int cos_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = cos(*tin);
    }
    return 0;
}

UFUNC_DESCR2(cos_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  tan  *********************/

static int tan_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = tan(*tin);
    }
    return 0;
}

UFUNC_DESCR2(tan_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arcsin  *********************/

static int arcsin_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = asin(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arcsin_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arccos  *********************/

static int arccos_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = acos(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arccos_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arctan  *********************/

static int arctan_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = atan(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arctan_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arctan2  *********************/

static int arctan2_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = atan2(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(arctan2_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Float64));


static int arctan2_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Float64 *tout    = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = atan2(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(arctan2_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Float64));


static int arctan2_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = atan2(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(arctan2_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Float64));

/*********************  log  *********************/

static int log_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_log(*tin);
    }
    return 0;
}

UFUNC_DESCR2(log_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  log10  *********************/

static int log10_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_log10(*tin);
    }
    return 0;
}

UFUNC_DESCR2(log10_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  exp  *********************/

static int exp_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = exp(*tin);
    }
    return 0;
}

UFUNC_DESCR2(exp_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  sinh  *********************/

static int sinh_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sinh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sinh_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  cosh  *********************/

static int cosh_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = cosh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(cosh_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  tanh  *********************/

static int tanh_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = tanh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(tanh_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arcsinh  *********************/

static int arcsinh_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_asinh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arcsinh_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arccosh  *********************/

static int arccosh_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_acosh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arccosh_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  arctanh  *********************/

static int arctanh_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_atanh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arctanh_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  ieeemask  *********************/
/*********************  ieeemask  *********************/
/*********************  sqrt  *********************/

static int sqrt_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sqrt(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sqrt_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  equal  *********************/

static int equal_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 == *tin2;
    }
    return 0;
}

UFUNC_DESCR3(equal_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int equal_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 == tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(equal_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int equal_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar == *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(equal_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int equal_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval == *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            equal_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(equal_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int equal_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net == *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            equal_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(equal_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  not_equal  *********************/

static int not_equal_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 != *tin2;
    }
    return 0;
}

UFUNC_DESCR3(not_equal_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int not_equal_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 != tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(not_equal_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int not_equal_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar != *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(not_equal_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int not_equal_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval != *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            not_equal_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(not_equal_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int not_equal_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net != *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            not_equal_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(not_equal_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  greater  *********************/

static int greater_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 > *tin2;
    }
    return 0;
}

UFUNC_DESCR3(greater_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int greater_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 > tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(greater_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int greater_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar > *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(greater_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int greater_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval > *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            greater_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(greater_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int greater_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net > *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            greater_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(greater_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  greater_equal  *********************/

static int greater_equal_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 >= *tin2;
    }
    return 0;
}

UFUNC_DESCR3(greater_equal_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int greater_equal_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 >= tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(greater_equal_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int greater_equal_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar >= *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(greater_equal_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int greater_equal_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval >= *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            greater_equal_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(greater_equal_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int greater_equal_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net >= *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            greater_equal_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(greater_equal_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  less  *********************/

static int less_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 < *tin2;
    }
    return 0;
}

UFUNC_DESCR3(less_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int less_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 < tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(less_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int less_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar < *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(less_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int less_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval < *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            less_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(less_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int less_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net < *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            less_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(less_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  less_equal  *********************/

static int less_equal_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 <= *tin2;
    }
    return 0;
}

UFUNC_DESCR3(less_equal_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int less_equal_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 <= tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(less_equal_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int less_equal_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar <= *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(less_equal_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int less_equal_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval <= *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            less_equal_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(less_equal_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int less_equal_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net <= *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            less_equal_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(less_equal_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  logical_and  *********************/

static int logical_and_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_and(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_and_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_and_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_and(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_and_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_and_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_and(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_and_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_and_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = logical_and(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            logical_and_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(logical_and_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int logical_and_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = logical_and(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            logical_and_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(logical_and_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  logical_or  *********************/

static int logical_or_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_or(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_or_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_or_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_or(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_or_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_or_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_or(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_or_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_or_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = logical_or(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            logical_or_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(logical_or_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int logical_or_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = logical_or(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            logical_or_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(logical_or_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  logical_xor  *********************/

static int logical_xor_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_xor(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_xor_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_xor_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_xor(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_xor_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_xor_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_xor(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_xor_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int logical_xor_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = logical_xor(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            logical_xor_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(logical_xor_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int logical_xor_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = logical_xor(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            logical_xor_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(logical_xor_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  logical_not  *********************/

static int logical_not_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = !*tin;
    }
    return 0;
}

UFUNC_DESCR2(logical_not_Bool_vector, sizeof(Bool), sizeof(Bool));
/*********************  bitwise_and  *********************/

static int bitwise_and_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 & *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_and_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_and_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 & tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_and_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_and_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar & *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_and_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_and_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval & *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_and_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_and_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int bitwise_and_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net & *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_and_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_and_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  bitwise_or  *********************/

static int bitwise_or_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 | *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_or_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_or_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 | tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_or_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_or_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar | *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_or_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_or_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval | *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_or_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_or_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int bitwise_or_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net | *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_or_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_or_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  bitwise_xor  *********************/

static int bitwise_xor_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 ^ *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_xor_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_xor_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 ^ tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_xor_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_xor_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar ^ *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_xor_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int bitwise_xor_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval ^ *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_xor_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_xor_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int bitwise_xor_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net ^ *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_xor_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_xor_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  bitwise_not  *********************/
/*********************  bitwise_not  *********************/

static int bitwise_not_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = BOOLEAN_BITWISE_NOT(*tin);
    }
    return 0;
}

UFUNC_DESCR2(bitwise_not_Bool_vector, sizeof(Bool), sizeof(Bool));
/*********************  rshift  *********************/

static int rshift_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 >> *tin2;
    }
    return 0;
}

UFUNC_DESCR3(rshift_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int rshift_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 >> tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(rshift_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int rshift_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar >> *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(rshift_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int rshift_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval >> *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            rshift_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(rshift_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int rshift_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net >> *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            rshift_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(rshift_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  lshift  *********************/

static int lshift_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 << *tin2;
    }
    return 0;
}

UFUNC_DESCR3(lshift_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int lshift_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 << tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(lshift_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int lshift_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar << *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(lshift_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Bool));


static int lshift_Bool_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout = (Bool *) ((char *) output + outboffset);
    Bool lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            tout = (Bool *) ((char *) tout + outbstrides[dim]);
            *tout = lastval << *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            lshift_Bool_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(lshift_Bool_accumulate, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));

static int lshift_Bool_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Bool  *tin   = (Bool *) ((char *) input  + inboffset);
    Bool *tout  = (Bool *) ((char *) output + outboffset);
    Bool net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Bool *) ((char *) tin + inbstrides[dim]);
            net = net << *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            lshift_Bool_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(lshift_Bool_reduce, CHECK_ALIGN, sizeof(Bool), sizeof(Bool));
/*********************  floor  *********************/

static int floor_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = (*tin);
    }
    return 0;
}

UFUNC_DESCR2(floor_Bool_vector, sizeof(Bool), sizeof(Bool));
/*********************  floor  *********************/
/*********************  ceil  *********************/

static int ceil_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = (*tin);
    }
    return 0;
}

UFUNC_DESCR2(ceil_Bool_vector, sizeof(Bool), sizeof(Bool));
/*********************  ceil  *********************/
/*********************  maximum  *********************/

static int maximum_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    Bool temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ufmaximum(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(maximum_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int maximum_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Int8 *tout    = (Int8 *) buffers[2];
    Bool temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ufmaximum(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(maximum_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int maximum_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    Bool temp1, temp2;
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ufmaximum(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(maximum_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));

/*********************  minimum  *********************/

static int minimum_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    Bool temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ufminimum(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(minimum_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int minimum_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Int8 *tout    = (Int8 *) buffers[2];
    Bool temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ufminimum(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(minimum_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Int8));


static int minimum_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Int8 *tout  = (Int8 *) buffers[2];
    Bool temp1, temp2;
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ufminimum(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(minimum_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Int8));

/*********************  fabs  *********************/

static int fabs_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = fabs(*tin);
    }
    return 0;
}

UFUNC_DESCR2(fabs_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  _round  *********************/

static int _round_Bool_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin = (Bool *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_round(*tin);
    }
    return 0;
}

UFUNC_DESCR2(_round_Bool_vector, sizeof(Bool), sizeof(Float64));
/*********************  hypot  *********************/

static int hypot_Bool_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool  *tin1  = (Bool *) buffers[0];
    Bool  *tin2  = (Bool *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = hypot(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(hypot_Bool_vector_vector, sizeof(Bool), sizeof(Bool), sizeof(Float64));


static int hypot_Bool_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool *tin1     = (Bool *) buffers[0];
    Bool tscalar   = *(Bool *) buffers[1];
    Float64 *tout    = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = hypot(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(hypot_Bool_vector_scalar, sizeof(Bool), sizeof(Bool), sizeof(Float64));


static int hypot_Bool_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Bool tscalar = *(Bool *) buffers[0];
    Bool *tin2   =  (Bool *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = hypot(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(hypot_Bool_scalar_vector, sizeof(Bool), sizeof(Bool), sizeof(Float64));

/*********************  minus  *********************/
/*********************  add  *********************/
/*********************  subtract  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/
/*********************  true_divide  *********************/
/*********************  remainder  *********************/
/*********************  power  *********************/
/*********************  abs  *********************/
/*********************  sin  *********************/
/*********************  cos  *********************/
/*********************  tan  *********************/
/*********************  arcsin  *********************/
/*********************  arccos  *********************/
/*********************  arctan  *********************/
/*********************  arcsinh  *********************/
/*********************  arccosh  *********************/
/*********************  arctanh  *********************/
/*********************  log  *********************/
/*********************  log10  *********************/
/*********************  exp  *********************/
/*********************  sinh  *********************/
/*********************  cosh  *********************/
/*********************  tanh  *********************/
/*********************  sqrt  *********************/
/*********************  equal  *********************/
/*********************  not_equal  *********************/
/*********************  logical_and  *********************/
/*********************  logical_or  *********************/
/*********************  logical_xor  *********************/
/*********************  logical_not  *********************/
/*********************  floor  *********************/
/*********************  ceil  *********************/
/*********************  maximum  *********************/
/*********************  minimum  *********************/
/*********************  fabs  *********************/
/*********************  _round  *********************/
/*********************  hypot  *********************/

static PyMethodDef _ufuncBoolMethods[] = {

	{NULL,      NULL}        /* Sentinel */
};

static PyObject *init_funcDict(void) {
    PyObject *dict;
    dict = PyDict_New();
    NA_add_cfunc(dict, "('minus', 'vector', (('Bool',), ('Int8',)))", (void *) &minus_Bool_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &add_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_scalar', (('Bool', 'Bool'), ('Int8',)))", (void *) &add_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('add', 'scalar_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &add_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &subtract_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_scalar', (('Bool', 'Bool'), ('Int8',)))", (void *) &subtract_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('subtract', 'scalar_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &subtract_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('divide', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &divide_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('divide', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &divide_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('divide', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &divide_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('divide', 'reduce', (('Bool',), ('Bool',)))", (void *) &divide_Bool_reduce_descr);
    NA_add_cfunc(dict, "('divide', 'accumulate', (('Bool',), ('Bool',)))", (void *) &divide_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('floor_divide', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &floor_divide_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('floor_divide', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &floor_divide_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('floor_divide', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &floor_divide_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('floor_divide', 'reduce', (('Bool',), ('Bool',)))", (void *) &floor_divide_Bool_reduce_descr);
    NA_add_cfunc(dict, "('floor_divide', 'accumulate', (('Bool',), ('Bool',)))", (void *) &floor_divide_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_vector', (('Bool', 'Bool'), ('Float32',)))", (void *) &true_divide_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_scalar', (('Bool', 'Bool'), ('Float32',)))", (void *) &true_divide_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('true_divide', 'scalar_vector', (('Bool', 'Bool'), ('Float32',)))", (void *) &true_divide_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &remainder_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &remainder_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('remainder', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &remainder_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'reduce', (('Bool',), ('Bool',)))", (void *) &remainder_Bool_reduce_descr);
    NA_add_cfunc(dict, "('remainder', 'accumulate', (('Bool',), ('Bool',)))", (void *) &remainder_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('power', 'vector_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &power_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('power', 'vector_scalar', (('Bool', 'Bool'), ('Int8',)))", (void *) &power_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('power', 'scalar_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &power_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('abs', 'vector', (('Bool',), ('Int8',)))", (void *) &abs_Bool_vector_descr);
    NA_add_cfunc(dict, "('sin', 'vector', (('Bool',), ('Float64',)))", (void *) &sin_Bool_vector_descr);
    NA_add_cfunc(dict, "('cos', 'vector', (('Bool',), ('Float64',)))", (void *) &cos_Bool_vector_descr);
    NA_add_cfunc(dict, "('tan', 'vector', (('Bool',), ('Float64',)))", (void *) &tan_Bool_vector_descr);
    NA_add_cfunc(dict, "('arcsin', 'vector', (('Bool',), ('Float64',)))", (void *) &arcsin_Bool_vector_descr);
    NA_add_cfunc(dict, "('arccos', 'vector', (('Bool',), ('Float64',)))", (void *) &arccos_Bool_vector_descr);
    NA_add_cfunc(dict, "('arctan', 'vector', (('Bool',), ('Float64',)))", (void *) &arctan_Bool_vector_descr);
    NA_add_cfunc(dict, "('arctan2', 'vector_vector', (('Bool', 'Bool'), ('Float64',)))", (void *) &arctan2_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('arctan2', 'vector_scalar', (('Bool', 'Bool'), ('Float64',)))", (void *) &arctan2_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('arctan2', 'scalar_vector', (('Bool', 'Bool'), ('Float64',)))", (void *) &arctan2_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('log', 'vector', (('Bool',), ('Float64',)))", (void *) &log_Bool_vector_descr);
    NA_add_cfunc(dict, "('log10', 'vector', (('Bool',), ('Float64',)))", (void *) &log10_Bool_vector_descr);
    NA_add_cfunc(dict, "('exp', 'vector', (('Bool',), ('Float64',)))", (void *) &exp_Bool_vector_descr);
    NA_add_cfunc(dict, "('sinh', 'vector', (('Bool',), ('Float64',)))", (void *) &sinh_Bool_vector_descr);
    NA_add_cfunc(dict, "('cosh', 'vector', (('Bool',), ('Float64',)))", (void *) &cosh_Bool_vector_descr);
    NA_add_cfunc(dict, "('tanh', 'vector', (('Bool',), ('Float64',)))", (void *) &tanh_Bool_vector_descr);
    NA_add_cfunc(dict, "('arcsinh', 'vector', (('Bool',), ('Float64',)))", (void *) &arcsinh_Bool_vector_descr);
    NA_add_cfunc(dict, "('arccosh', 'vector', (('Bool',), ('Float64',)))", (void *) &arccosh_Bool_vector_descr);
    NA_add_cfunc(dict, "('arctanh', 'vector', (('Bool',), ('Float64',)))", (void *) &arctanh_Bool_vector_descr);
    NA_add_cfunc(dict, "('sqrt', 'vector', (('Bool',), ('Float64',)))", (void *) &sqrt_Bool_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &equal_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &equal_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('equal', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &equal_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('equal', 'reduce', (('Bool',), ('Bool',)))", (void *) &equal_Bool_reduce_descr);
    NA_add_cfunc(dict, "('equal', 'accumulate', (('Bool',), ('Bool',)))", (void *) &equal_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &not_equal_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &not_equal_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('not_equal', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &not_equal_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'reduce', (('Bool',), ('Bool',)))", (void *) &not_equal_Bool_reduce_descr);
    NA_add_cfunc(dict, "('not_equal', 'accumulate', (('Bool',), ('Bool',)))", (void *) &not_equal_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('greater', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &greater_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('greater', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &greater_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('greater', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &greater_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('greater', 'reduce', (('Bool',), ('Bool',)))", (void *) &greater_Bool_reduce_descr);
    NA_add_cfunc(dict, "('greater', 'accumulate', (('Bool',), ('Bool',)))", (void *) &greater_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('greater_equal', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &greater_equal_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('greater_equal', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &greater_equal_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('greater_equal', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &greater_equal_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('greater_equal', 'reduce', (('Bool',), ('Bool',)))", (void *) &greater_equal_Bool_reduce_descr);
    NA_add_cfunc(dict, "('greater_equal', 'accumulate', (('Bool',), ('Bool',)))", (void *) &greater_equal_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('less', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &less_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('less', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &less_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('less', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &less_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('less', 'reduce', (('Bool',), ('Bool',)))", (void *) &less_Bool_reduce_descr);
    NA_add_cfunc(dict, "('less', 'accumulate', (('Bool',), ('Bool',)))", (void *) &less_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('less_equal', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &less_equal_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('less_equal', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &less_equal_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('less_equal', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &less_equal_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('less_equal', 'reduce', (('Bool',), ('Bool',)))", (void *) &less_equal_Bool_reduce_descr);
    NA_add_cfunc(dict, "('less_equal', 'accumulate', (('Bool',), ('Bool',)))", (void *) &less_equal_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_and_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_and_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_and', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_and_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'reduce', (('Bool',), ('Bool',)))", (void *) &logical_and_Bool_reduce_descr);
    NA_add_cfunc(dict, "('logical_and', 'accumulate', (('Bool',), ('Bool',)))", (void *) &logical_and_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_or_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_or_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_or', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_or_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'reduce', (('Bool',), ('Bool',)))", (void *) &logical_or_Bool_reduce_descr);
    NA_add_cfunc(dict, "('logical_or', 'accumulate', (('Bool',), ('Bool',)))", (void *) &logical_or_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_xor_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_xor_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_xor', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &logical_xor_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'reduce', (('Bool',), ('Bool',)))", (void *) &logical_xor_Bool_reduce_descr);
    NA_add_cfunc(dict, "('logical_xor', 'accumulate', (('Bool',), ('Bool',)))", (void *) &logical_xor_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('logical_not', 'vector', (('Bool',), ('Bool',)))", (void *) &logical_not_Bool_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_and_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_and_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_and_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'reduce', (('Bool',), ('Bool',)))", (void *) &bitwise_and_Bool_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'accumulate', (('Bool',), ('Bool',)))", (void *) &bitwise_and_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_or_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_or_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_or_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'reduce', (('Bool',), ('Bool',)))", (void *) &bitwise_or_Bool_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'accumulate', (('Bool',), ('Bool',)))", (void *) &bitwise_or_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_xor_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_xor_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &bitwise_xor_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'reduce', (('Bool',), ('Bool',)))", (void *) &bitwise_xor_Bool_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'accumulate', (('Bool',), ('Bool',)))", (void *) &bitwise_xor_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_not', 'vector', (('Bool',), ('Bool',)))", (void *) &bitwise_not_Bool_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &rshift_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &rshift_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('rshift', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &rshift_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'reduce', (('Bool',), ('Bool',)))", (void *) &rshift_Bool_reduce_descr);
    NA_add_cfunc(dict, "('rshift', 'accumulate', (('Bool',), ('Bool',)))", (void *) &rshift_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('lshift', 'vector_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &lshift_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('lshift', 'vector_scalar', (('Bool', 'Bool'), ('Bool',)))", (void *) &lshift_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('lshift', 'scalar_vector', (('Bool', 'Bool'), ('Bool',)))", (void *) &lshift_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('lshift', 'reduce', (('Bool',), ('Bool',)))", (void *) &lshift_Bool_reduce_descr);
    NA_add_cfunc(dict, "('lshift', 'accumulate', (('Bool',), ('Bool',)))", (void *) &lshift_Bool_accumulate_descr);
    NA_add_cfunc(dict, "('floor', 'vector', (('Bool',), ('Bool',)))", (void *) &floor_Bool_vector_descr);
    NA_add_cfunc(dict, "('ceil', 'vector', (('Bool',), ('Bool',)))", (void *) &ceil_Bool_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &maximum_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_scalar', (('Bool', 'Bool'), ('Int8',)))", (void *) &maximum_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('maximum', 'scalar_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &maximum_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &minimum_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_scalar', (('Bool', 'Bool'), ('Int8',)))", (void *) &minimum_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('minimum', 'scalar_vector', (('Bool', 'Bool'), ('Int8',)))", (void *) &minimum_Bool_scalar_vector_descr);
    NA_add_cfunc(dict, "('fabs', 'vector', (('Bool',), ('Float64',)))", (void *) &fabs_Bool_vector_descr);
    NA_add_cfunc(dict, "('_round', 'vector', (('Bool',), ('Float64',)))", (void *) &_round_Bool_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_vector', (('Bool', 'Bool'), ('Float64',)))", (void *) &hypot_Bool_vector_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_scalar', (('Bool', 'Bool'), ('Float64',)))", (void *) &hypot_Bool_vector_scalar_descr);
    NA_add_cfunc(dict, "('hypot', 'scalar_vector', (('Bool', 'Bool'), ('Float64',)))", (void *) &hypot_Bool_scalar_vector_descr);
    return dict;
}

/* platform independent*/
#ifdef MS_WIN32
__declspec(dllexport)
#endif
void init_ufuncBool(void) {
    PyObject *m, *d;
    m = Py_InitModule("_ufuncBool", _ufuncBoolMethods);
    d = PyModule_GetDict(m);
    _Error = PyErr_NewException("_ufuncBool.error", NULL, NULL);
    PyDict_SetItemString(d, "error", _Error);
    import_libnumarray();
    PyDict_SetItemString(d, "functionDict", init_funcDict());
}
