"""
TODO:
    * is using global statements the best solution or should we add an filter-object
    * maybe move initialisation of libxml2 parser to utils
    * maybe merge Buglist.BugInfo and Bug.Bug into one class
"""

"""import urllib
import urlparse
import time
import sys"""
import bughelper_error as Error
import utils
import libxml2

LPURLERROR = Error.LPUrlError

#deactivate error messages from the validation [libxml2.htmlParseDoc]
def noerr(ctx, str):
    pass

libxml2.registerErrorHandler(noerr, None)

# Metaclass to test the type of an object
class TestMeta(type):
    def __str__(cls): return cls.__name__


def sort(x,y,sort):
    if sort.startswith("-"):
        sort = sort.strip("-")
        order = -1
    else:
        order = 1
    if sort == "nr":
        return order * cmp(int(x.bugnumber), int(y.bugnumber))
    if sort == "importance":
        importance = ["Critical","High","Medium","Low","Wishlist","Undecided"]
        return order * cmp(importance.index(getattr(x,sort)), importance.index(getattr(y,sort)))
    if sort == "status":
        status = ["Fix Released","Fix Committed","In Progress",\
            "Triaged", "Confirmed","Won\'t Fix","Invalid","Incomplete", "New"]
        return order * cmp(status.index(getattr(x,sort)), status.index(getattr(y,sort)))


class BugInfo(object):
    # TODO: use same attribute names like Bug.Bug
    # object can be indetified by str(type(x)) == "BugInfo"
    __metaclass__ = TestMeta
    def __init__(self, nr, url, status, importance, summary, package=None):
        self.bugnumber = nr
        self.url = utils.valid_lp_url(url,utils.BUG)
        assert self.url, "Invalid launchpad url %s" %url
        self.status = status
        self.importance = importance
        self.summary = summary
        self.sourcepackage = package
    def __int__(self):
        return int(self.bugnumber)
    def __repr__(self):
        return "<BugInfo %s>" %self.bugnumber
    def __str__(self):
        return "[Bug %s %s: %s/%s]" %(self.bugnumber, self.sourcepackage or "", self.status, self.importance)
    def __hash__(self):
        return int(self.bugnumber)
    def __eq__(self, other):
        return hash(self) == hash(other)

class BugPage(object):
    """
    grab content of a single bug-table    
    """
    def __init__(self, url, connection=None):
        assert connection, "Connection object needed"
        self.__connection = connection
        self.url = utils.valid_lp_url(url,utils.BUGPAGE)
        assert self.url, "Invalid launchpad url %s" %url
        self.following_page = None
        self.__bugs = set()
        self.pageBody = None
        __xmldoc = None
        
    def parse_bugs(self):
        __lp_content = self.__connection.get(self.url)
            
        self.pageBody = __lp_content.text

        __xmldoc = libxml2.htmlParseDoc(self.pageBody, None)
        if __xmldoc.xpathEval('//div/p[contains(.,"There are currently no open bugs.")]'):
            __xmldoc.freeDoc()
            return
        
        # count number of columns
        # Bug-Pages have five columns: icon|nr|summary(url)|importance|status
        # personal Bug-Pages have six columns: icon|nr|summary(url)|package|importance|status
        # TODO: look for more simple XPath-statements
        __col = int(__xmldoc.xpathEval('count(//table[@id="buglisting"]//thead//tr//th[not(@*)])'))
        for __span in __xmldoc.xpathEval('//table[@id="buglisting"]//thead//tr//@colspan'):
            __col += int(__span.content)

        assert __col == 5 or __col == 6, "Parsing of this page (%s) is not \
supported by python-launchpad-bugs" %self.url
        __bug_table_rows = __xmldoc.xpathEval('//table[@id="buglisting"]//tbody//tr')
        for row in __bug_table_rows:
            out = []
            for i in xrange(2,__col+1):
                if i == 3:
                    expr = 'td[' + str(i) + ']//a'
                else:
                    expr = 'td[' + str(i) + ']/text()'
                res = row.xpathEval(expr)
                assert res, "Wrong XPath-Expression in BugPage (%s)" %self.url
                if i == 3:
                    out.append(res[0].prop("href"))
                out.append(res[0].content)
            # package is optional, move package to the end of the list
            if len(out) == 6:
                out.append(out.pop(3))
            else:
                out.append(None)
            self.__bugs.add(BugInfo(out[0], out[1], out[4],out[3],utils.sanitize_html(out[2]), out[5]))

        __next = __xmldoc.xpathEval('//div[@class="lesser"]//a[@rel="next"]//@href')
        if __next:
            self.following_page = utils.sanitize_html(__next[0].content)
        __xmldoc.freeDoc()
        
    def get_bugs(self):
        if not self.pageBody:
            self.parse_bugs()
        return self.__bugs
    bugs = property(fget=get_bugs,doc="get bugs")

class BugList(object):
    """
    returns a SET of BugInfo objects
    searches baseurl and its following pages
    """
    def __init__(self, baseurl, run=False, bugs=set(), connection=None, filter=None):
        assert connection, "Connection object needed"
        self.__connection = connection
        
        self.__filter = filter
        
        self.baseurl = utils.valid_lp_url(baseurl,utils.BUGLIST)
        assert self.baseurl, "Invalid launchpad url %s" %baseurl
        self.__bugs = bugs
        if not run:
            self.add(self.baseurl)
        
    def __iter__(self):
        """ allow direct iteration over instance of BugList """
        for b in self.__bugs:
            yield(b)            
    
    def __iadd__(self, other):
        """ let l be an instance of BugList,
        l += BugList(<LP-URL>) will add bugs to l
        l.add(<LP-URL>) is still possible
        """
        __bugs = self.__bugs.union(other.bugs)
        return BugList(other.baseurl, run=True, bugs=__bugs, connection=self.__connection, filter=self.__filter)
            
    def filter(self,func=set()):
        """
        filters bugs-set by given func and returns a new BugList object
        each func has to return a tuple of sets (<remove>,<add>)
        """
        if type(func) != type(set()):
            func = set(func)
        func = func | self.__filter.functions
        __bugs = self.__bugs.copy()
        for f in set(func):
            __bugs = f(__bugs)
        return BugList(self.baseurl, run=True, bugs=__bugs, connection=self.__connection, filter=self.__filter)
    
    
    def sort(self, optsort):
        """ returns a LIST of bugs sorted by optsort """
        __bugs = list()
        __bugs = [x for x in self.__bugs]
        __bugs.sort(lambda x, y: sort(x,y,optsort))
        return __bugs
    
    def fetch(self, url):
        """
        searches given bugpage for bugs and 'next'-page and returns both values
        
        if calling <url> returns an LPURLERROR, this error will be ignored
        if there are still bugs in the buglist, otherwise raised again
        """
        __bugs = set()
        __follow = None
        try:
            __bp = BugPage(url, connection=self.__connection)
            __bugs = __bp.bugs
            __follow = __bp.following_page
        except LPURLERROR, e:
            if len(self.__bugs) == 0:
                raise LPURLERROR(text = str(e))
        return __bugs, __follow

    def add(self, url, follow=True):
        """ adds bugs to the buglist """
        __follow = True
        __url = url
        __bugs = set()
        while(__url and __follow):
            (__bugs,__url) = self.fetch(__url)
            __follow = follow
            self.__bugs = self.__bugs.union(__bugs)
        
    def get_bugs(self):
        return self.__bugs
    bugs = property(fget=get_bugs,doc="get list of bugs")
    
