import bughelper_error as Error
import buglist_filter

class bl_filter(buglist_filter.Filter):
    def __init__(self, method):
        buglist_filter.Filter.__init__(self, method)
#
# factory 
#

class LaunchpadConnector(object):
    def __init__(self, cls, method="HTML"):
        self.Error = Error
        method = method.lower()
        
        __connections = {
            "htmlBug": {"module": "html_bug", "connection" : ("http_connection","HTTPConnection")},
            "htmlBugList": {"module": "html_buglist", "connection" : ("http_connection","HTTPConnection")},
            "xmlrpcBug" : {"module": "xmlrpc_bug", "connection" : ("http_connection","HTTPConnection")},
            "textBug" : {"module": "text_bug", "connection" : ("http_connection","HTTPConnection")},
            "textBugList" : {"module": "text_buglist", "connection" : ("http_connection","HTTPConnection")}
            }
        
        __module = "".join([method, cls]) 
        
        if not __connections.has_key(__module):
            raise NotImplementedError, 'Connection unknown: %s' %__module
        
        try:
            self.module = __import__(__connections[__module]["module"], globals(), locals(), [], -1)
        except TypeError:
            self.module = __import__(__connections[__module]["module"], globals(), locals(), [])
        self.cls = getattr(self.module, cls)
        try:
            self.__mod_connection = __import__(__connections[__module]["connection"][0], globals(), locals(), [], -1)
        except TypeError:
            self.__mod_connection = __import__(__connections[__module]["connection"][0], globals(), locals(), [])
        self.connection = getattr(self.__mod_connection, __connections[__module]["connection"][1])()
        
    def get_debug(self):
        return getattr(self.module, "DEBUG")
        
    def set_debug(self, value):
        if hasattr(self.module, "DEBUG"):
            self.module.DEBUG = bool(value)
        else:
            raise AttributeError, "'%s' has no attribute 'DEBUG'" %self.module.__class__.__name__
    DEBUG = property(get_debug, set_debug, doc="add additional debug messages to output")
    

class ConnectBug(LaunchpadConnector):
    def __init__(self, method="HTML"):
        LaunchpadConnector.__init__(self, "Bug", method)
        
    def __call__(self, bug=None, url=None):
        return self.cls(bug, url, connection=self.connection)
       
    def get_auth(self):
        return self.connection.get_auth()
        
    def set_auth(self, auth):
        self.connection.set_auth(auth)
    authentication = property(get_auth, set_auth)
    
    @property
    def content_types(self):
        return self.connection.content_types
    
        
    def get_attachment_path(self):
        return self.module.ATTACHMENT_PATH
        
    def set_attachment_path(self, path):
        self.module.ATTACHMENT_PATH = path
    attachment_path = property(get_attachment_path, set_attachment_path, "path for saving attachments")
    
    
    def NewAttachment(self, *args, **kwargs):
        """ returns a Attachment-class """
        return getattr(self.module, "Attachment")(*args, **kwargs)
    
    def NewComment(self, *args, **kwargs):
        """ returns a Comment-object """
        return getattr(self.module, "Comment")(*args, **kwargs)
        
    def New(self, *args, **kwargs):
        """ returns a Bug-object """
        return getattr(self.module, "create_new_bugreport")(connection=self.connection, *args, **kwargs)

class ConnectBugList(LaunchpadConnector):
    def __init__(self, method="HTML"):
        LaunchpadConnector.__init__(self, "BugList", method)
        self.__buglist_filter = bl_filter(method)
        
    def __call__(self, baseurl=None):
        return self.cls(baseurl, connection=self.connection, filter=self.__buglist_filter)
       
    def get_auth(self):
        return self.connection.get_auth()
        
    def set_auth(self, auth):
        self.connection.set_auth(auth)
        
    authentication = property(get_auth, set_auth)
    
    def set_filter(self, **kargs):
        return self.__buglist_filter.set_filter(**kargs)
        
    def reset_filter(self):
        return self.__buglist_filter.reset()

    def get_url_opt(self):
        return self.__buglist_filter.urlopt
        
    urlopt = property(fget=get_url_opt)
    
    def get_modified_url(self, ignore_conflict=False):
        return self.__buglist_filter.get_modiefied_url(ignore_conflict)
    modified_url = property(get_modified_url, doc="returns new url")
