/*
  libreiserfs - a library for manipulating reiserfs partitions
  Copyright (C) 2001-2004 Yury Umanets <torque@ukrpost.net>.
                                                                                                 
  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.
                                                                                                 
  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.
                                                                                                 
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <reiserfs/reiserfs.h>

#if ENABLE_NLS
# include <libintl.h>
# define _(String) dgettext (PACKAGE, String)
#else
# define _(String) (String)
#endif

#ifdef DEBUG
int libreiserfs_assert(int cond, char *cond_text, char *file,
		       int line, char *function)
{
	reiserfs_exception_option_t opt;

	if (cond) return 1;

	opt = libreiserfs_exception_throw(EXCEPTION_BUG,
					  EXCEPTION_IGNORE_CANCEL,
					  _("Assertion (%s) at %s:%d "
					    "in function %s() failed."),
					  cond_text, file, 
					  line, function);
	
	return opt == EXCEPTION_IGNORE;
}
#endif
