# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from pgm_test_case import PgmTestCase
import pgm

class TestCanvas(PgmTestCase):

    def setUp(self):
        self.c = pgm.Canvas()
        PgmTestCase.setUp(self)

    def tearDown(self):
        del self.c
        PgmTestCase.tearDown(self)

    def test_size(self):

        # get
        size = self.c.get_size()
        self.failUnless(isinstance(size, tuple))
        self.assertEqual(len(size), 2)

        w, h = size
        self.failUnless(isinstance(w, float))
        self.failUnless(isinstance(h, float))

        # set
        new_size = (1024, 768)
        self.c.set_size(*new_size)
        self.assertEqual(self.c.get_size(), new_size)

    def test_add_remove(self):

        layer = pgm.DrawableLayer(pgm.DRAWABLE_MIDDLE)
        d1 = pgm.Text("foo")
        d2 = pgm.Text("bar")
        d3 = pgm.Text("koa")

        self.assertEqual(d1.__gstrefcount__, 1)

        #import pdb; pdb.set_trace()
        # add
        err = self.c.add(layer, d1)
        self.assertEqual(err, pgm.ERROR_OK)
        self.assertEqual(d1.__gstrefcount__, 2)

        err = self.c.add(layer, d1)
        self.assertEqual(err, pgm.ERROR_X)
        self.assertEqual(d1.__gstrefcount__, 2)

        # add many
        err = self.c.add(layer, d2, d3)
        self.assertEqual(err, pgm.ERROR_OK)
        self.assertEqual(d2.__gstrefcount__, 2)
        self.assertEqual(d3.__gstrefcount__, 2)

        # remove
        err = self.c.remove(d1)
        self.assertEqual(err, pgm.ERROR_OK)
        self.assertEqual(d1.__gstrefcount__, 1)

        err = self.c.remove(d1)
        self.assertEqual(err, pgm.ERROR_X)

        # remove many
        err = self.c.remove(d2, d3)
        self.assertEqual(err, pgm.ERROR_OK)
        self.assertEqual(d2.__gstrefcount__, 1)
        self.assertEqual(d3.__gstrefcount__, 1)

        err = self.c.remove(d2, d3)
        self.assertEqual(err, pgm.ERROR_X)

        del d1, d2, d3

    def test_order(self):
        layer = pgm.DrawableLayer(pgm.DRAWABLE_MIDDLE)
        d1 = pgm.Text("foo")


        self.c.add(layer, d1)

        # get
        order = self.c.get_order(d1)
        self.failUnless(isinstance(order, tuple))
        self.assertEqual(len(order), 2)

        l, order = order

        self.assertEqual(l, layer)
        self.failUnless(isinstance(order, int))
        # FIXME: test order value

        # set
        self.c.set_order(d1, 0)
        self.assertEqual(self.c.get_order(d1), (layer, 0))

        self.c.remove(d1)
        self.assertEqual(d1.__gstrefcount__, 1)
        del d1

    def test_layer_count(self):

        layer = pgm.DrawableLayer(pgm.DRAWABLE_MIDDLE)
        d1 = pgm.Text("foo")

        self.c.add(layer, d1)

        # get
        layer_count = self.c.get_layer_count(layer)
        self.failUnless(isinstance(layer_count, int))
        self.assertEqual(layer_count, 1)

        self.c.remove(d1)
        layer_count = self.c.get_layer_count(layer)
        self.failUnless(isinstance(layer_count, int))
        self.assertEqual(layer_count, 0)

        self.assertEqual(d1.__gstrefcount__, 1)
        del d1

    def test_regenerate(self):

        err = self.c.regenerate()
        self.assertEqual(err, pgm.ERROR_OK)
