#ifndef INCLUDE_DEBUG_H
#define INCLUDE_DEBUG_H
/* ----------------------------------------------------------------------------
 * debug.h
 * definitions for debugging. This file describes in detail which debug
 * information should be printed to console. The symbol DEBUG must also
 * be defined. It is the master key for all of this options.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

/* module_powersave.c */
#define SLEEPLOCKS    0 /* =1 for printing sleeplock status to console */

/* module_pmac.c */
#define PMUINTR       0 /* =1 for printing PMU interrupts to console */
#define SIMUAMBIENT   0 /* =1 for simulating ambient light sensor */
#define TESTAMBIENT   0 /* =1 for printing some ambient values to console */
#define TRACKPAD      0 /* =1 for debugging dynamic trackpad reconfiguration */

/* module_cdrom.c */
#define CDROM         0 /* =1 mount and status information */
#define CDROMPERF     0 /* =1 for printing CDROM performance data to console */

/* module_peep.c */
#define PEEP_IPC      1 /* =1, all tags sent to clients will be printed */
#define PEEP_CONFIG   1 /* =1, all configure tags will be printed */
#define PEEP_QUERY    1 /* =1, all query tags will be printed */
#define PEEP_SECURE   1 /* =1, all security tags will be printed */
#define PEEP_KEYBOARD 0 /* =1, keyboard events are printed */
#define PEEP_MOUSE    0 /* =1, mouse events are printed */
#define PEEP_TIMER    0 /* =1, timer events are printed */
#define PEEP_NOCYCLIC 1 /* =1, some cyclic tags will be filtered out */

#endif    /* INCLUDE_DEBUG_H */

