/*
 * Copyright 2010 Inalogic® Inc.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License, as
 * published by the  Free Software Foundation; either version 2.1 or 3.0
 * of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jaytaoko@inalogic.com>
 *
 */


#include "NuxCore.h"
#include "Point.h"

namespace nux
{

  Point::Point()
    : x (0), y (0)
  {
  }

  Point::Point (int x_, int y_)
    : x (x_), y (y_)
  {
  }

  Point::~Point()
  {
  }

  Point::Point (const Point &p)
    : x (p.x), y (p.y)
  {
  }

  Point &Point::operator = (const Point &p)
  {
    if (&p == this)
      return *this;

    x = p.x;
    y = p.y;
    return *this;
  }

  bool Point::operator == (const Point &p) const
  {
    if ( (x == p.x) && (y == p.y) )
    {
      return true;
    }

    return false;
  }

  bool Point::operator != (const Point &p) const
  {
    if ( (x == p.x) && (y == p.y) )
    {
      return false;
    }

    return true;
  }

  Point Point::operator + (const Point &p) const
  {
    Point point;

    point.x = x + p.x;
    point.y = y + p.y;
    return point;
  }

  Point Point::operator - (const Point &p) const
  {
    Point point;

    point.x = x - p.x;
    point.y = y - p.y;
    return point;
  }

  Point &Point::operator += (const Point &p)
  {
    x += p.x;
    y += p.y;
    return *this;
  }

  Point &Point::operator -= (const Point &p)
  {
    x -= p.x;
    y -= p.y;
    return *this;
  }
}
