// This file is generated by kconfig_compiler from 802-11-wireless-security.kcfg.
// All changes you do to this file will be lost.

#include "802-11-wireless-security.h"
#include "802-11-wireless-securitysecrets.h"

using namespace Knm;

WirelessSecuritySetting::WirelessSecuritySetting() : Setting(Setting::WirelessSecurity)
                                                     , mSecurityType(WirelessSecuritySetting::EnumSecurityType::None), mKeymgmt(0), mWeptxkeyindex(0), mAuthalg(0), mWepKeyType(None)
{
    m_secretsObject = new WirelessSecuritySecrets(this);
}

WirelessSecuritySetting::WirelessSecuritySetting(WirelessSecuritySetting *setting) : Setting(setting)
{
    m_secretsObject = new WirelessSecuritySecrets(static_cast<WirelessSecuritySecrets*>(setting->getSecretsObject()), this);
    setSecurityType(setting->securityType());
    setKeymgmt(setting->keymgmt());
    setWeptxkeyindex(setting->weptxkeyindex());
    setAuthalg(setting->authalg());
    setProto(setting->proto());
    setPairwise(setting->pairwise());
    setGroup(setting->group());
    setLeapusername(setting->leapusername());
    setWepkey0(setting->wepkey0());
    setWepkey1(setting->wepkey1());
    setWepkey2(setting->wepkey2());
    setWepkey3(setting->wepkey3());
    setWepkeyflags(setting->wepkeyflags());
    setPsk(setting->psk());
    setPskflags(setting->pskflags());
    setLeappassword(setting->leappassword());
    setLeappasswordflags(setting->leappasswordflags());
    setWepKeyType(setting->wepKeyType());
}

WirelessSecuritySetting::~WirelessSecuritySetting()
{
}

QString WirelessSecuritySetting::name() const
{
  return QLatin1String("802-11-wireless-security");
}
bool WirelessSecuritySetting::hasSecrets() const
{
    if (isNull())
        return false;
    switch (mSecurityType)
    {
        case EnumSecurityType::None:
        case EnumSecurityType::DynamicWep:
        case EnumSecurityType::WpaEap:
        case EnumSecurityType::Wpa2Eap:
            return false;
        case EnumSecurityType::StaticWep:
        case EnumSecurityType::Leap:
        case EnumSecurityType::WpaPsk:
        case EnumSecurityType::Wpa2Psk:
        default:
            return true;
    }
}

void WirelessSecuritySetting::reset()
{
    m_initialized = false;
    mSecurityType = EnumSecurityType::None;
    mKeymgmt = EnumKeymgmt::None;
    mWeptxkeyindex = 0;
    mAuthalg = EnumAuthalg::none;
    mProto = QStringList();
    mPairwise = QStringList();
    mGroup = QStringList();
    mLeapusername = QString();
    mWepkey0 = QString();
    mWepkey1 = QString();
    mWepkey2 = QString();
    mWepkey3 = QString();
    mPsk = QString();
    mLeappassword = QString();
    mWeppassphrase = QString();
    mWepKeyType = None;
}

void WirelessSecuritySetting::setSecrets(Setting::secretsTypes types)
{
    switch (mSecurityType)
    {
        case EnumSecurityType::StaticWep:
            setWepkeyflags(types);
            break;
        case EnumSecurityType::WpaPsk:
            setPskflags(types);
            break;
        case EnumSecurityType::Leap:
            setLeappasswordflags(types);
            break;
        default:
            break;
    }
}
