/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 *
 * Copyright (C) 2007 Andris Pavenis <andris.pavenis@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * ***** END OF LICENSE BLOCK ***** */

#include <assert.h>
#include <stdlib.h>
extern "C"
{
    /*
     * Replace some functions present beginning from gecko2.
     * Otherwise component is not loadable with earlier versions.
     *
     * For gecko2 these functions are located in libmozalloc.so.
     *
     */
    void moz_free(void *ptr)
    {
        free(ptr);
    }

    void *moz_malloc(size_t size)
    {
        return malloc(size);
    }

    void *moz_xmalloc(size_t size)
    {
        void *ptr = malloc(size);
        assert(ptr != NULL);
        return ptr;
    }
}
