﻿// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//
// Authors:
//        Antonello Provenzano  <antonello@deveel.com>
//

using System.Collections.ObjectModel;
using System.Reflection;
using System.Text;

namespace System.Linq.Expressions
{
    public sealed class NewExpression : Expression
    {
        #region .ctor
        internal NewExpression(Type type, ConstructorInfo constructor, ReadOnlyCollection<Expression> arguments)
            : base(ExpressionType.New, type)
        {
            this.constructor = constructor;
            this.arguments = arguments;
        }
        #endregion

        #region Fields
        private ReadOnlyCollection<Expression> arguments;
        private ConstructorInfo constructor;
        #endregion

        #region Properties
        public ReadOnlyCollection<Expression> Arguments
        {
            get { return arguments; }
        }

        public ConstructorInfo Constructor
        {
            get { return constructor; }
        }
        #endregion

        #region Internal Methods
        internal override void BuildString(StringBuilder builder)
        {
            Type initType = base.Type;
            if (constructor != null)
                initType = constructor.DeclaringType;

            builder.Append("new " + initType.Name + "(");

            int argc = arguments.Count;
            for (int i = 0; i < argc; i++)
            {
                Expression argExpr = arguments[i];
                argExpr.BuildString(builder);

                if (i < argc - 1)
                    builder.Append(", ");
            }

            builder.Append(")");
        }
        #endregion
    }
}