﻿//
// AuthenticodeDeformatterTest.cs - 
//	NUnit Test Cases for AuthenticodeDeformatter
//
// Author:
//	Sebastien Pouliot (sebastien@ximian.com)
//
// Copyright (C) 2004 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.IO;
using System.Reflection;
using System.Security.Cryptography;

using Mono.Security.Authenticode;
using NUnit.Framework;

namespace MonoTests.Mono.Security.Authenticode {

	[TestFixture]
	public class AuthenticodeDeformatterTest {

		static byte[] helloworld_signed = {
			0x4D, 0x5A, 0x90, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
			0xFF, 0xFF, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x80, 0x00, 0x00, 0x00, 0x0E, 0x1F, 0xBA, 0x0E, 0x00, 0xB4, 0x09, 0xCD, 
			0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x54, 0x68, 0x69, 0x73, 0x20, 0x70, 
			0x72, 0x6F, 0x67, 0x72, 0x61, 0x6D, 0x20, 0x63, 0x61, 0x6E, 0x6E, 0x6F, 
			0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6E, 0x20, 0x69, 0x6E, 0x20, 
			0x44, 0x4F, 0x53, 0x20, 0x6D, 0x6F, 0x64, 0x65, 0x2E, 0x0D, 0x0D, 0x0A, 
			0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x45, 0x00, 0x00, 
			0x4C, 0x01, 0x03, 0x00, 0xF5, 0xE5, 0xFA, 0x3E, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x0E, 0x01, 0x0B, 0x01, 0x06, 0x00, 
			0x00, 0x04, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x1E, 0x23, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 
			0x00, 0x00, 0x40, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 
			0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 
			0x96, 0x96, 0x00, 0x00, 0x03, 0x00, 0x00, 0x04, 0x00, 0x00, 0x10, 0x00, 
			0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0xC4, 0x22, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 
			0x00, 0x40, 0x00, 0x00, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0xA8, 0x11, 0x00, 0x00, 
			0x00, 0x60, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x08, 0x20, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x2E, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00, 
			0x24, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
			0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x2E, 0x72, 0x73, 0x72, 
			0x63, 0x00, 0x00, 0x00, 0x30, 0x03, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 
			0x00, 0x04, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x40, 
			0x2E, 0x72, 0x65, 0x6C, 0x6F, 0x63, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 
			0x00, 0x60, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x40, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
			0x7C, 0x20, 0x00, 0x00, 0x48, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
			0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x13, 0x30, 0x01, 0x00, 0x0B, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x72, 0x01, 0x00, 0x00, 0x70, 0x28, 0x03, 0x00, 
			0x00, 0x0A, 0x2A, 0x00, 0x13, 0x30, 0x01, 0x00, 0x07, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x02, 0x28, 0x04, 0x00, 0x00, 0x0A, 0x2A, 0x00, 
			0x42, 0x53, 0x4A, 0x42, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x0C, 0x00, 0x00, 0x00, 0x76, 0x31, 0x2E, 0x31, 0x2E, 0x34, 0x33, 0x32, 
			0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x6C, 0x00, 0x00, 0x00, 
			0xEC, 0x00, 0x00, 0x00, 0x23, 0x7E, 0x00, 0x00, 0x58, 0x01, 0x00, 0x00, 
			0x9C, 0x00, 0x00, 0x00, 0x23, 0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x73, 
			0x00, 0x00, 0x00, 0x00, 0xF4, 0x01, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
			0x23, 0x55, 0x53, 0x00, 0x0C, 0x02, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
			0x23, 0x47, 0x55, 0x49, 0x44, 0x00, 0x00, 0x00, 0x1C, 0x02, 0x00, 0x00, 
			0x2C, 0x00, 0x00, 0x00, 0x23, 0x42, 0x6C, 0x6F, 0x62, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x47, 0x15, 0x00, 0x00, 
			0x09, 0x00, 0x00, 0x00, 0x00, 0xFA, 0x01, 0x33, 0x00, 0x02, 0x00, 0x00, 
			0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
			0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
			0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 
			0x25, 0x00, 0x1E, 0x00, 0x06, 0x00, 0x5C, 0x00, 0x49, 0x00, 0x06, 0x00, 
			0x70, 0x00, 0x1E, 0x00, 0x06, 0x00, 0x88, 0x00, 0x1E, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 
			0x00, 0x00, 0x10, 0x00, 0x2C, 0x00, 0x33, 0x00, 0x05, 0x00, 0x01, 0x00, 
			0x01, 0x00, 0x50, 0x20, 0x00, 0x00, 0x00, 0x00, 0x91, 0x00, 0x3E, 0x00, 
			0x0A, 0x00, 0x01, 0x00, 0x68, 0x20, 0x00, 0x00, 0x00, 0x00, 0x86, 0x18, 
			0x43, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x83, 0x00, 
			0x11, 0x00, 0x43, 0x00, 0x14, 0x00, 0x19, 0x00, 0x43, 0x00, 0x10, 0x00, 
			0x21, 0x00, 0x90, 0x00, 0x1F, 0x00, 0x09, 0x00, 0x43, 0x00, 0x10, 0x00, 
			0x20, 0x00, 0x13, 0x00, 0x1A, 0x00, 0x2E, 0x00, 0x0B, 0x00, 0x24, 0x00, 
			0x04, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x01, 0x00, 
			0x00, 0x00, 0x88, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 
			0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x4D, 0x6F, 
			0x64, 0x75, 0x6C, 0x65, 0x3E, 0x00, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x31, 
			0x2E, 0x65, 0x78, 0x65, 0x00, 0x6D, 0x73, 0x63, 0x6F, 0x72, 0x6C, 0x69, 
			0x62, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x00, 0x4F, 0x62, 0x6A, 
			0x65, 0x63, 0x74, 0x00, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x31, 0x00, 0x68, 
			0x65, 0x6C, 0x6C, 0x6F, 0x77, 0x6F, 0x72, 0x6C, 0x64, 0x00, 0x4D, 0x61, 
			0x69, 0x6E, 0x00, 0x2E, 0x63, 0x74, 0x6F, 0x72, 0x00, 0x53, 0x79, 0x73, 
			0x74, 0x65, 0x6D, 0x2E, 0x44, 0x69, 0x61, 0x67, 0x6E, 0x6F, 0x73, 0x74, 
			0x69, 0x63, 0x73, 0x00, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x61, 0x62, 
			0x6C, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 
			0x53, 0x54, 0x41, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x41, 0x74, 0x74, 
			0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x61, 0x72, 0x67, 0x73, 0x00, 
			0x43, 0x6F, 0x6E, 0x73, 0x6F, 0x6C, 0x65, 0x00, 0x57, 0x72, 0x69, 0x74, 
			0x65, 0x4C, 0x69, 0x6E, 0x65, 0x00, 0x00, 0x00, 0x00, 0x15, 0x48, 0x00, 
			0x65, 0x00, 0x6C, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x20, 0x00, 0x77, 0x00, 
			0x6F, 0x00, 0x72, 0x00, 0x64, 0x00, 0x00, 0x00, 0xA7, 0x01, 0xAB, 0x9B, 
			0xF7, 0xF7, 0x3F, 0x49, 0xB9, 0x45, 0x97, 0xAF, 0x40, 0x00, 0x5D, 0x9D, 
			0x00, 0x08, 0xB7, 0x7A, 0x5C, 0x56, 0x19, 0x34, 0xE0, 0x89, 0x05, 0x00, 
			0x01, 0x01, 0x1D, 0x0E, 0x03, 0x20, 0x00, 0x01, 0x05, 0x20, 0x02, 0x01, 
			0x02, 0x02, 0x04, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x01, 0x01, 0x0E, 
			0x06, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xEC, 0x22, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x23, 0x00, 0x00, 
			0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x43, 
			0x6F, 0x72, 0x45, 0x78, 0x65, 0x4D, 0x61, 0x69, 0x6E, 0x00, 0x6D, 0x73, 
			0x63, 0x6F, 0x72, 0x65, 0x65, 0x2E, 0x64, 0x6C, 0x6C, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0xFF, 0x25, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x80, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x80, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 
			0x58, 0x40, 0x00, 0x00, 0xD4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0xD4, 0x02, 0x34, 0x00, 0x00, 0x00, 0x56, 0x00, 
			0x53, 0x00, 0x5F, 0x00, 0x56, 0x00, 0x45, 0x00, 0x52, 0x00, 0x53, 0x00, 
			0x49, 0x00, 0x4F, 0x00, 0x4E, 0x00, 0x5F, 0x00, 0x49, 0x00, 0x4E, 0x00, 
			0x46, 0x00, 0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBD, 0x04, 0xEF, 0xFE, 
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x44, 0x00, 0x00, 0x00, 0x01, 0x00, 0x56, 0x00, 0x61, 0x00, 0x72, 0x00, 
			0x46, 0x00, 0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6E, 0x00, 
			0x66, 0x00, 0x6F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x04, 0x00, 
			0x00, 0x00, 0x54, 0x00, 0x72, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x73, 0x00, 
			0x6C, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x04, 0x34, 0x02, 0x00, 0x00, 
			0x01, 0x00, 0x53, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6E, 0x00, 
			0x67, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x49, 0x00, 
			0x6E, 0x00, 0x66, 0x00, 0x6F, 0x00, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 
			0x01, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 
			0x34, 0x00, 0x62, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x02, 0x00, 
			0x01, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x6D, 0x00, 0x6D, 0x00, 0x65, 0x00, 
			0x6E, 0x00, 0x74, 0x00, 0x73, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
			0x24, 0x00, 0x02, 0x00, 0x01, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x6D, 0x00, 
			0x70, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x79, 0x00, 0x4E, 0x00, 0x61, 0x00, 
			0x6D, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
			0x2C, 0x00, 0x02, 0x00, 0x01, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6C, 0x00, 
			0x65, 0x00, 0x44, 0x00, 0x65, 0x00, 0x73, 0x00, 0x63, 0x00, 0x72, 0x00, 
			0x69, 0x00, 0x70, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x30, 0x00, 0x08, 0x00, 
			0x01, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x56, 0x00, 
			0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00, 
			0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x00, 0x00, 0x38, 0x00, 0x0B, 0x00, 
			0x01, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 
			0x6E, 0x00, 0x61, 0x00, 0x6C, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 
			0x65, 0x00, 0x00, 0x00, 0x43, 0x00, 0x6C, 0x00, 0x61, 0x00, 0x73, 0x00, 
			0x73, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x65, 0x00, 0x78, 0x00, 0x65, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x02, 0x00, 0x01, 0x00, 0x4C, 0x00, 
			0x65, 0x00, 0x67, 0x00, 0x61, 0x00, 0x6C, 0x00, 0x43, 0x00, 0x6F, 0x00, 
			0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 
			0x74, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x02, 0x00, 
			0x01, 0x00, 0x4C, 0x00, 0x65, 0x00, 0x67, 0x00, 0x61, 0x00, 0x6C, 0x00, 
			0x54, 0x00, 0x72, 0x00, 0x61, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6D, 0x00, 
			0x61, 0x00, 0x72, 0x00, 0x6B, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x20, 0x00, 0x00, 0x00, 0x40, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x4F, 0x00, 
			0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x69, 0x00, 0x6E, 0x00, 0x61, 0x00, 
			0x6C, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x6E, 0x00, 
			0x61, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x00, 0x00, 0x43, 0x00, 0x6C, 0x00, 
			0x61, 0x00, 0x73, 0x00, 0x73, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x65, 0x00, 
			0x78, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x02, 0x00, 
			0x01, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x64, 0x00, 0x75, 0x00, 
			0x63, 0x00, 0x74, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x34, 0x00, 0x08, 0x00, 
			0x01, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x64, 0x00, 0x75, 0x00, 
			0x63, 0x00, 0x74, 0x00, 0x56, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 
			0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x30, 0x00, 0x2E, 0x00, 
			0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x00, 0x00, 
			0x38, 0x00, 0x08, 0x00, 0x01, 0x00, 0x41, 0x00, 0x73, 0x00, 0x73, 0x00, 
			0x65, 0x00, 0x6D, 0x00, 0x62, 0x00, 0x6C, 0x00, 0x79, 0x00, 0x20, 0x00, 
			0x56, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00, 0x69, 0x00, 0x6F, 0x00, 
			0x6E, 0x00, 0x00, 0x00, 0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00, 
			0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 
			0x20, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0xA8, 0x11, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x30, 0x82, 0x11, 0x97, 
			0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x02, 0xA0, 
			0x82, 0x11, 0x88, 0x30, 0x82, 0x11, 0x84, 0x02, 0x01, 0x01, 0x31, 0x0E, 
			0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x02, 0x05, 
			0x05, 0x00, 0x30, 0x67, 0x06, 0x0A, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 
			0x37, 0x02, 0x01, 0x04, 0xA0, 0x59, 0x30, 0x57, 0x30, 0x33, 0x06, 0x0A, 
			0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x02, 0x01, 0x0F, 0x30, 0x25, 
			0x03, 0x01, 0x00, 0xA0, 0x20, 0xA2, 0x1E, 0x80, 0x1C, 0x00, 0x3C, 0x00, 
			0x3C, 0x00, 0x3C, 0x00, 0x4F, 0x00, 0x62, 0x00, 0x73, 0x00, 0x6F, 0x00, 
			0x6C, 0x00, 0x65, 0x00, 0x74, 0x00, 0x65, 0x00, 0x3E, 0x00, 0x3E, 0x00, 
			0x3E, 0x30, 0x20, 0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
			0x0D, 0x02, 0x05, 0x05, 0x00, 0x04, 0x10, 0x35, 0xA5, 0x21, 0x3B, 0xFC, 
			0xFE, 0xFA, 0x40, 0x97, 0xAA, 0xBB, 0xDE, 0x3B, 0x52, 0x15, 0x6F, 0xA0, 
			0x82, 0x0C, 0xF4, 0x30, 0x82, 0x02, 0xBC, 0x30, 0x82, 0x02, 0x25, 0x02, 
			0x10, 0x4A, 0x19, 0xD2, 0x38, 0x8C, 0x82, 0x59, 0x1C, 0xA5, 0x5D, 0x73, 
			0x5F, 0x15, 0x5D, 0xDC, 0xA3, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x30, 0x81, 0x9E, 0x31, 
			0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x16, 0x56, 0x65, 
			0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 
			0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x17, 0x30, 0x15, 
			0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 
			0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x2C, 0x30, 
			0x2A, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x23, 0x56, 0x65, 0x72, 0x69, 
			0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x20, 0x53, 0x74, 
			0x61, 0x6D, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 
			0x63, 0x65, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x31, 0x34, 0x30, 0x32, 0x06, 
			0x03, 0x55, 0x04, 0x0B, 0x13, 0x2B, 0x4E, 0x4F, 0x20, 0x4C, 0x49, 0x41, 
			0x42, 0x49, 0x4C, 0x49, 0x54, 0x59, 0x20, 0x41, 0x43, 0x43, 0x45, 0x50, 
			0x54, 0x45, 0x44, 0x2C, 0x20, 0x28, 0x63, 0x29, 0x39, 0x37, 0x20, 0x56, 
			0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 
			0x2E, 0x30, 0x1E, 0x17, 0x0D, 0x39, 0x37, 0x30, 0x35, 0x31, 0x32, 0x30, 
			0x30, 0x30, 0x30, 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x30, 0x34, 0x30, 0x31, 
			0x30, 0x37, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5A, 0x30, 0x81, 0x9E, 
			0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x16, 0x56, 
			0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 
			0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x17, 0x30, 
			0x15, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x0E, 0x56, 0x65, 0x72, 0x69, 
			0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x2C, 
			0x30, 0x2A, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x23, 0x56, 0x65, 0x72, 
			0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x20, 0x53, 
			0x74, 0x61, 0x6D, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x53, 0x65, 0x72, 0x76, 
			0x69, 0x63, 0x65, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x31, 0x34, 0x30, 0x32, 
			0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x2B, 0x4E, 0x4F, 0x20, 0x4C, 0x49, 
			0x41, 0x42, 0x49, 0x4C, 0x49, 0x54, 0x59, 0x20, 0x41, 0x43, 0x43, 0x45, 
			0x50, 0x54, 0x45, 0x44, 0x2C, 0x20, 0x28, 0x63, 0x29, 0x39, 0x37, 0x20, 
			0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 
			0x63, 0x2E, 0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8D, 0x00, 
			0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xD3, 0x2E, 0x20, 0xF0, 0x68, 
			0x7C, 0x2C, 0x2D, 0x2E, 0x81, 0x1C, 0xB1, 0x06, 0xB2, 0xA7, 0x0B, 0xB7, 
			0x11, 0x0D, 0x57, 0xDA, 0x53, 0xD8, 0x75, 0xE3, 0xC9, 0x33, 0x2A, 0xB2, 
			0xD4, 0xF6, 0x09, 0x5B, 0x34, 0xF3, 0xE9, 0x90, 0xFE, 0x09, 0x0C, 0xD0, 
			0xDB, 0x1B, 0x5A, 0xB9, 0xCD, 0xE7, 0xF6, 0x88, 0xB1, 0x9D, 0xC0, 0x87, 
			0x25, 0xEB, 0x7D, 0x58, 0x10, 0x73, 0x6A, 0x78, 0xCB, 0x71, 0x15, 0xFD, 
			0xC6, 0x58, 0xF6, 0x29, 0xAB, 0x58, 0x5E, 0x96, 0x04, 0xFD, 0x2D, 0x62, 
			0x11, 0x58, 0x81, 0x1C, 0xCA, 0x71, 0x94, 0xD5, 0x22, 0x58, 0x2F, 0xD5, 
			0xCC, 0x14, 0x05, 0x84, 0x36, 0xBA, 0x94, 0xAA, 0xB4, 0x4D, 0x4A, 0xE9, 
			0xEE, 0x3B, 0x22, 0xAD, 0x56, 0x99, 0x7E, 0x21, 0x9C, 0x6C, 0x86, 0xC0, 
			0x4A, 0x47, 0x97, 0x6A, 0xB4, 0xA6, 0x36, 0xD5, 0xFC, 0x09, 0x2D, 0xD3, 
			0xB4, 0x39, 0x9B, 0x02, 0x03, 0x01, 0x00, 0x01, 0x30, 0x0D, 0x06, 0x09, 
			0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x03, 
			0x81, 0x81, 0x00, 0x61, 0x55, 0x0E, 0x3E, 0x7B, 0xC7, 0x92, 0x12, 0x7E, 
			0x11, 0x10, 0x8E, 0x22, 0xCC, 0xD4, 0xB3, 0x13, 0x2B, 0x5B, 0xE8, 0x44, 
			0xE4, 0x0B, 0x78, 0x9E, 0xA4, 0x7E, 0xF3, 0xA7, 0x07, 0x72, 0x1E, 0xE2, 
			0x59, 0xEF, 0xCC, 0x84, 0xE3, 0x89, 0x94, 0x4C, 0xDB, 0x4E, 0x61, 0xEF, 
			0xB3, 0xA4, 0xFB, 0x46, 0x3D, 0x50, 0x34, 0x0B, 0x9F, 0x70, 0x56, 0xF6, 
			0x8E, 0x2A, 0x7F, 0x17, 0xCE, 0xE5, 0x63, 0xBF, 0x79, 0x69, 0x07, 0x73, 
			0x2E, 0xB0, 0x95, 0x28, 0x8A, 0xF5, 0xED, 0xAA, 0xA9, 0xD2, 0x5D, 0xCD, 
			0x0A, 0xCA, 0x10, 0x09, 0x8F, 0xCE, 0xB3, 0xAF, 0x28, 0x96, 0xC4, 0x79, 
			0x29, 0x84, 0x92, 0xDC, 0xFF, 0xBA, 0x67, 0x42, 0x48, 0xA6, 0x90, 0x10, 
			0xE4, 0xBF, 0x61, 0xF8, 0x9C, 0x53, 0xE5, 0x93, 0xD1, 0x73, 0x3F, 0xF8, 
			0xFD, 0x9D, 0x4F, 0x84, 0xAC, 0x55, 0xD1, 0xFD, 0x11, 0x63, 0x63, 0x30, 
			0x82, 0x03, 0x13, 0x30, 0x82, 0x02, 0x7C, 0xA0, 0x03, 0x02, 0x01, 0x02, 
			0x02, 0x01, 0x01, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
			0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x30, 0x81, 0xC4, 0x31, 0x0B, 0x30, 
			0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x5A, 0x41, 0x31, 0x15, 
			0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x0C, 0x57, 0x65, 0x73, 
			0x74, 0x65, 0x72, 0x6E, 0x20, 0x43, 0x61, 0x70, 0x65, 0x31, 0x12, 0x30, 
			0x10, 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x09, 0x43, 0x61, 0x70, 0x65, 
			0x20, 0x54, 0x6F, 0x77, 0x6E, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 
			0x04, 0x0A, 0x13, 0x14, 0x54, 0x68, 0x61, 0x77, 0x74, 0x65, 0x20, 0x43, 
			0x6F, 0x6E, 0x73, 0x75, 0x6C, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x63, 0x63, 
			0x31, 0x28, 0x30, 0x26, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x1F, 0x43, 
			0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 
			0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x44, 0x69, 
			0x76, 0x69, 0x73, 0x69, 0x6F, 0x6E, 0x31, 0x19, 0x30, 0x17, 0x06, 0x03, 
			0x55, 0x04, 0x03, 0x13, 0x10, 0x54, 0x68, 0x61, 0x77, 0x74, 0x65, 0x20, 
			0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x43, 0x41, 0x31, 0x26, 0x30, 
			0x24, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x01, 
			0x16, 0x17, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 0x63, 0x65, 0x72, 
			0x74, 0x73, 0x40, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 0x2E, 0x63, 0x6F, 
			0x6D, 0x30, 0x1E, 0x17, 0x0D, 0x39, 0x36, 0x30, 0x38, 0x30, 0x31, 0x30, 
			0x30, 0x30, 0x30, 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x32, 0x30, 0x31, 0x32, 
			0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5A, 0x30, 0x81, 0xC4, 
			0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x5A, 
			0x41, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x0C, 
			0x57, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6E, 0x20, 0x43, 0x61, 0x70, 0x65, 
			0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x09, 0x43, 
			0x61, 0x70, 0x65, 0x20, 0x54, 0x6F, 0x77, 0x6E, 0x31, 0x1D, 0x30, 0x1B, 
			0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x14, 0x54, 0x68, 0x61, 0x77, 0x74, 
			0x65, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x75, 0x6C, 0x74, 0x69, 0x6E, 0x67, 
			0x20, 0x63, 0x63, 0x31, 0x28, 0x30, 0x26, 0x06, 0x03, 0x55, 0x04, 0x0B, 
			0x13, 0x1F, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 
			0x69, 0x6F, 0x6E, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 
			0x20, 0x44, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6F, 0x6E, 0x31, 0x19, 0x30, 
			0x17, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x10, 0x54, 0x68, 0x61, 0x77, 
			0x74, 0x65, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x43, 0x41, 
			0x31, 0x26, 0x30, 0x24, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
			0x01, 0x09, 0x01, 0x16, 0x17, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 
			0x63, 0x65, 0x72, 0x74, 0x73, 0x40, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 
			0x2E, 0x63, 0x6F, 0x6D, 0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
			0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 
			0x8D, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xD3, 0xA4, 0x50, 
			0x6E, 0xC8, 0xFF, 0x56, 0x6B, 0xE6, 0xCF, 0x5D, 0xB6, 0xEA, 0x0C, 0x68, 
			0x75, 0x47, 0xA2, 0xAA, 0xC2, 0xDA, 0x84, 0x25, 0xFC, 0xA8, 0xF4, 0x47, 
			0x51, 0xDA, 0x85, 0xB5, 0x20, 0x74, 0x94, 0x86, 0x1E, 0x0F, 0x75, 0xC9, 
			0xE9, 0x08, 0x61, 0xF5, 0x06, 0x6D, 0x30, 0x6E, 0x15, 0x19, 0x02, 0xE9, 
			0x52, 0xC0, 0x62, 0xDB, 0x4D, 0x99, 0x9E, 0xE2, 0x6A, 0x0C, 0x44, 0x38, 
			0xCD, 0xFE, 0xBE, 0xE3, 0x64, 0x09, 0x70, 0xC5, 0xFE, 0xB1, 0x6B, 0x29, 
			0xB6, 0x2F, 0x49, 0xC8, 0x3B, 0xD4, 0x27, 0x04, 0x25, 0x10, 0x97, 0x2F, 
			0xE7, 0x90, 0x6D, 0xC0, 0x28, 0x42, 0x99, 0xD7, 0x4C, 0x43, 0xDE, 0xC3, 
			0xF5, 0x21, 0x6D, 0x54, 0x9F, 0x5D, 0xC3, 0x58, 0xE1, 0xC0, 0xE4, 0xD9, 
			0x5B, 0xB0, 0xB8, 0xDC, 0xB4, 0x7B, 0xDF, 0x36, 0x3A, 0xC2, 0xB5, 0x66, 
			0x22, 0x12, 0xD6, 0x87, 0x0D, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x13, 
			0x30, 0x11, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 
			0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xFF, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
			0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x03, 0x81, 
			0x81, 0x00, 0x07, 0xFA, 0x4C, 0x69, 0x5C, 0xFB, 0x95, 0xCC, 0x46, 0xEE, 
			0x85, 0x83, 0x4D, 0x21, 0x30, 0x8E, 0xCA, 0xD9, 0xA8, 0x6F, 0x49, 0x1A, 
			0xE6, 0xDA, 0x51, 0xE3, 0x60, 0x70, 0x6C, 0x84, 0x61, 0x11, 0xA1, 0x1A, 
			0xC8, 0x48, 0x3E, 0x59, 0x43, 0x7D, 0x4F, 0x95, 0x3D, 0xA1, 0x8B, 0xB7, 
			0x0B, 0x62, 0x98, 0x7A, 0x75, 0x8A, 0xDD, 0x88, 0x4E, 0x4E, 0x9E, 0x40, 
			0xDB, 0xA8, 0xCC, 0x32, 0x74, 0xB9, 0x6F, 0x0D, 0xC6, 0xE3, 0xB3, 0x44, 
			0x0B, 0xD9, 0x8A, 0x6F, 0x9A, 0x29, 0x9B, 0x99, 0x18, 0x28, 0x3B, 0xD1, 
			0xE3, 0x40, 0x28, 0x9A, 0x5A, 0x3C, 0xD5, 0xB5, 0xE7, 0x20, 0x1B, 0x8B, 
			0xCA, 0xA4, 0xAB, 0x8D, 0xE9, 0x51, 0xD9, 0xE2, 0x4C, 0x2C, 0x59, 0xA9, 
			0xDA, 0xB9, 0xB2, 0x75, 0x1B, 0xF6, 0x42, 0xF2, 0xEF, 0xC7, 0xF2, 0x18, 
			0xF9, 0x89, 0xBC, 0xA3, 0xFF, 0x8A, 0x23, 0x2E, 0x70, 0x47, 0x30, 0x82, 
			0x03, 0x13, 0x30, 0x82, 0x02, 0x7C, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 
			0x03, 0x09, 0xCE, 0x15, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
			0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x30, 0x81, 0xC4, 0x31, 0x0B, 
			0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x5A, 0x41, 0x31, 
			0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x0C, 0x57, 0x65, 
			0x73, 0x74, 0x65, 0x72, 0x6E, 0x20, 0x43, 0x61, 0x70, 0x65, 0x31, 0x12, 
			0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x09, 0x43, 0x61, 0x70, 
			0x65, 0x20, 0x54, 0x6F, 0x77, 0x6E, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 
			0x55, 0x04, 0x0A, 0x13, 0x14, 0x54, 0x68, 0x61, 0x77, 0x74, 0x65, 0x20, 
			0x43, 0x6F, 0x6E, 0x73, 0x75, 0x6C, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x63, 
			0x63, 0x31, 0x28, 0x30, 0x26, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x1F, 
			0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 
			0x6E, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x44, 
			0x69, 0x76, 0x69, 0x73, 0x69, 0x6F, 0x6E, 0x31, 0x19, 0x30, 0x17, 0x06, 
			0x03, 0x55, 0x04, 0x03, 0x13, 0x10, 0x54, 0x68, 0x61, 0x77, 0x74, 0x65, 
			0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x43, 0x41, 0x31, 0x26, 
			0x30, 0x24, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 
			0x01, 0x16, 0x17, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 0x63, 0x65, 
			0x72, 0x74, 0x73, 0x40, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 0x2E, 0x63, 
			0x6F, 0x6D, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x33, 0x30, 0x31, 0x31, 0x35, 
			0x30, 0x36, 0x33, 0x35, 0x32, 0x37, 0x5A, 0x17, 0x0D, 0x30, 0x34, 0x30, 
			0x32, 0x30, 0x38, 0x30, 0x39, 0x35, 0x30, 0x35, 0x32, 0x5A, 0x30, 0x81, 
			0x9C, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 
			0x43, 0x41, 0x31, 0x0F, 0x30, 0x0D, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 
			0x06, 0x51, 0x75, 0x65, 0x62, 0x65, 0x63, 0x31, 0x0F, 0x30, 0x0D, 0x06, 
			0x03, 0x55, 0x04, 0x07, 0x13, 0x06, 0x51, 0x75, 0x65, 0x62, 0x65, 0x63, 
			0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x17, 0x4D, 
			0x6F, 0x74, 0x75, 0x73, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6E, 0x6F, 0x6C, 
			0x6F, 0x67, 0x69, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x27, 
			0x30, 0x25, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x1E, 0x53, 0x65, 0x63, 
			0x75, 0x72, 0x65, 0x20, 0x41, 0x70, 0x70, 0x6C, 0x69, 0x63, 0x61, 0x74, 
			0x69, 0x6F, 0x6E, 0x20, 0x44, 0x65, 0x76, 0x65, 0x6C, 0x6F, 0x70, 0x6D, 
			0x65, 0x6E, 0x74, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55, 0x04, 0x03, 
			0x13, 0x17, 0x4D, 0x6F, 0x74, 0x75, 0x73, 0x20, 0x54, 0x65, 0x63, 0x68, 
			0x6E, 0x6F, 0x6C, 0x6F, 0x67, 0x69, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 
			0x2E, 0x30, 0x5C, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
			0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x4B, 0x00, 0x30, 0x48, 0x02, 
			0x41, 0x00, 0xC5, 0x46, 0xCD, 0xDA, 0xE2, 0x72, 0xC5, 0x63, 0x5B, 0xE5, 
			0xAC, 0x2A, 0x3A, 0x61, 0xFA, 0x63, 0x1F, 0xC3, 0xC9, 0x32, 0x82, 0x9D, 
			0xBD, 0x83, 0x56, 0x50, 0x07, 0x66, 0x45, 0xB4, 0x6C, 0xFF, 0x4A, 0x68, 
			0x37, 0xB4, 0x6B, 0xA3, 0x92, 0x1E, 0xA8, 0x35, 0xC7, 0x06, 0xCB, 0xE1, 
			0x39, 0x22, 0xB5, 0x0E, 0xA1, 0x7B, 0x7B, 0x33, 0x16, 0x6F, 0xA7, 0x14, 
			0xE5, 0x51, 0x1A, 0x7D, 0x41, 0xB5, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 
			0x7D, 0x30, 0x7B, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x25, 0x04, 0x18, 
			0x30, 0x16, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x03, 
			0x06, 0x0A, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x02, 0x01, 0x16, 
			0x30, 0x11, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xF8, 0x42, 0x01, 
			0x01, 0x04, 0x04, 0x03, 0x02, 0x04, 0x10, 0x30, 0x1D, 0x06, 0x03, 0x55, 
			0x1D, 0x04, 0x04, 0x16, 0x30, 0x14, 0x30, 0x0E, 0x30, 0x0C, 0x06, 0x0A, 
			0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x02, 0x01, 0x16, 0x03, 0x02, 
			0x07, 0x80, 0x30, 0x18, 0x06, 0x03, 0x55, 0x1D, 0x11, 0x04, 0x11, 0x30, 
			0x0F, 0x82, 0x0D, 0x77, 0x77, 0x77, 0x2E, 0x6D, 0x6F, 0x74, 0x75, 0x73, 
			0x2E, 0x63, 0x6F, 0x6D, 0x30, 0x0C, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x01, 
			0x01, 0xFF, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 
			0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x03, 0x81, 0x81, 
			0x00, 0x6D, 0xD6, 0x83, 0xDA, 0x39, 0xA2, 0xD8, 0x81, 0x12, 0x8D, 0xA5, 
			0x3E, 0xE5, 0xB7, 0xBE, 0x17, 0x42, 0x34, 0x6C, 0x34, 0xF7, 0x92, 0x89, 
			0x28, 0xD0, 0xE7, 0xF2, 0xAA, 0x91, 0xAA, 0x76, 0x40, 0xE2, 0x0B, 0xC3, 
			0x5A, 0x61, 0x3F, 0x00, 0x21, 0x68, 0x8E, 0xB3, 0x20, 0xCD, 0x42, 0x47, 
			0x6B, 0x14, 0xB2, 0x60, 0x36, 0x28, 0xC9, 0xC6, 0x97, 0xB5, 0xC3, 0x9F, 
			0x23, 0xED, 0xF6, 0x9B, 0xC9, 0x80, 0x07, 0x10, 0x0F, 0xA2, 0x54, 0x63, 
			0x5E, 0x13, 0x21, 0xBC, 0xD1, 0xAB, 0xEE, 0x96, 0xB7, 0xF8, 0x4D, 0x39, 
			0x8B, 0xB6, 0xDC, 0x49, 0x60, 0x3B, 0xAB, 0x7B, 0x4A, 0x38, 0x77, 0x7A, 
			0x2F, 0x34, 0x26, 0xF6, 0xE7, 0x6D, 0x9A, 0x27, 0x4E, 0xF6, 0x69, 0x13, 
			0xB2, 0x84, 0xEB, 0x23, 0xC3, 0x7A, 0x8C, 0x6B, 0xA2, 0xF6, 0x04, 0xDD, 
			0x45, 0xF3, 0xC5, 0x76, 0x5C, 0x35, 0xF6, 0x2A, 0x3E, 0x30, 0x82, 0x04, 
			0x02, 0x30, 0x82, 0x03, 0x6B, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 
			0x08, 0x7A, 0x6D, 0x5C, 0x6F, 0x62, 0x93, 0x4F, 0xBA, 0xC4, 0xFD, 0x43, 
			0xE1, 0x14, 0x18, 0x9D, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
			0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x30, 0x81, 0x9E, 0x31, 0x1F, 
			0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x16, 0x56, 0x65, 0x72, 
			0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 
			0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x17, 0x30, 0x15, 0x06, 
			0x03, 0x55, 0x04, 0x0B, 0x13, 0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 
			0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x2C, 0x30, 0x2A, 
			0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x23, 0x56, 0x65, 0x72, 0x69, 0x53, 
			0x69, 0x67, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x20, 0x53, 0x74, 0x61, 
			0x6D, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 
			0x65, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x31, 0x34, 0x30, 0x32, 0x06, 0x03, 
			0x55, 0x04, 0x0B, 0x13, 0x2B, 0x4E, 0x4F, 0x20, 0x4C, 0x49, 0x41, 0x42, 
			0x49, 0x4C, 0x49, 0x54, 0x59, 0x20, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 
			0x45, 0x44, 0x2C, 0x20, 0x28, 0x63, 0x29, 0x39, 0x37, 0x20, 0x56, 0x65, 
			0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 
			0x30, 0x1E, 0x17, 0x0D, 0x30, 0x31, 0x30, 0x32, 0x32, 0x38, 0x30, 0x30, 
			0x30, 0x30, 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x30, 0x34, 0x30, 0x31, 0x30, 
			0x36, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5A, 0x30, 0x81, 0xA0, 0x31, 
			0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0E, 0x56, 0x65, 
			0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 
			0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x56, 
			0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 
			0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3B, 0x30, 
			0x39, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x32, 0x54, 0x65, 0x72, 0x6D, 
			0x73, 0x20, 0x6F, 0x66, 0x20, 0x75, 0x73, 0x65, 0x20, 0x61, 0x74, 0x20, 
			0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 
			0x76, 0x65, 0x72, 0x69, 0x73, 0x69, 0x67, 0x6E, 0x2E, 0x63, 0x6F, 0x6D, 
			0x2F, 0x72, 0x70, 0x61, 0x20, 0x28, 0x63, 0x29, 0x30, 0x31, 0x31, 0x27, 
			0x30, 0x25, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x1E, 0x56, 0x65, 0x72, 
			0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x20, 0x53, 
			0x74, 0x61, 0x6D, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x53, 0x65, 0x72, 0x76, 
			0x69, 0x63, 0x65, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 
			0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 
			0x01, 0x0F, 0x00, 0x30, 0x82, 0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 
			0xC0, 0x7A, 0x61, 0x87, 0xEB, 0xB2, 0xA7, 0x03, 0x63, 0x1B, 0x2B, 0x1A, 
			0x61, 0xDE, 0x80, 0xB7, 0x15, 0x1D, 0xA0, 0x8B, 0x90, 0x3D, 0xBB, 0x27, 
			0x92, 0x84, 0x14, 0x39, 0xEB, 0x85, 0xCE, 0x29, 0x92, 0x06, 0x66, 0x48, 
			0xA4, 0x03, 0x4F, 0x8D, 0xE8, 0x4F, 0xA7, 0xF0, 0xAF, 0x5E, 0xD1, 0x2F, 
			0x19, 0xC7, 0x91, 0xF1, 0xB5, 0x9E, 0x7B, 0x91, 0x21, 0xCE, 0xE9, 0xFF, 
			0xE3, 0x4E, 0xF0, 0xFC, 0xAF, 0x95, 0x58, 0xB8, 0x63, 0x2D, 0xE6, 0x8E, 
			0xF6, 0x29, 0x18, 0xCD, 0x70, 0x8E, 0x50, 0xC3, 0xED, 0x96, 0xBB, 0x40, 
			0xDB, 0xBE, 0x25, 0xE8, 0x42, 0x55, 0xD6, 0xF6, 0x85, 0xF2, 0x06, 0xE7, 
			0x8B, 0x99, 0x1C, 0x31, 0xF3, 0x03, 0x0F, 0xD4, 0x4C, 0x9C, 0x24, 0x2A, 
			0xDC, 0x1B, 0x1B, 0x8F, 0x82, 0xF3, 0xB0, 0xEF, 0xA7, 0x4D, 0xE3, 0x14, 
			0xA7, 0xE0, 0x8F, 0xD6, 0xC7, 0x68, 0xC2, 0x61, 0x58, 0xA9, 0x72, 0xD4, 
			0xF8, 0x30, 0x48, 0x4F, 0xD9, 0x2F, 0x6F, 0x63, 0x20, 0xD9, 0x89, 0xCA, 
			0x82, 0x7B, 0xC2, 0x4B, 0xBC, 0x28, 0xC5, 0x81, 0x68, 0xE7, 0xE6, 0x82, 
			0x40, 0xAC, 0x46, 0x3A, 0xA0, 0xF9, 0x3F, 0x36, 0xCD, 0x4C, 0xBB, 0x54, 
			0x42, 0x5A, 0x7A, 0x65, 0x7B, 0xFE, 0x84, 0xE4, 0xC7, 0x47, 0x54, 0xAC, 
			0xB9, 0x3D, 0xEC, 0x80, 0xC7, 0x1A, 0xF7, 0xC4, 0x33, 0x81, 0x81, 0xC9, 
			0x2A, 0x95, 0xFB, 0x7F, 0x5E, 0x3A, 0x87, 0x90, 0x14, 0xDB, 0xCC, 0x2E, 
			0x75, 0xF2, 0xEF, 0x6B, 0xE6, 0x3D, 0xA9, 0x60, 0xBE, 0x42, 0x01, 0xAA, 
			0x4F, 0xAA, 0x5B, 0xA8, 0x3F, 0x22, 0x31, 0x9F, 0x12, 0x15, 0xF9, 0x73, 
			0xA1, 0x1E, 0x82, 0x8B, 0x04, 0x2B, 0xEA, 0x46, 0x02, 0x4C, 0x6D, 0x8F, 
			0x1F, 0x50, 0x2E, 0x95, 0x4B, 0x2A, 0x78, 0x06, 0x84, 0x74, 0x3D, 0x91, 
			0x8F, 0x2C, 0x47, 0x31, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x81, 0xB8, 
			0x30, 0x81, 0xB5, 0x30, 0x40, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 
			0x07, 0x01, 0x01, 0x04, 0x34, 0x30, 0x32, 0x30, 0x30, 0x06, 0x08, 0x2B, 
			0x06, 0x01, 0x05, 0x05, 0x07, 0x30, 0x01, 0x86, 0x24, 0x68, 0x74, 0x74, 
			0x70, 0x3A, 0x2F, 0x2F, 0x6F, 0x63, 0x73, 0x70, 0x2E, 0x76, 0x65, 0x72, 
			0x69, 0x73, 0x69, 0x67, 0x6E, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x6F, 0x63, 
			0x73, 0x70, 0x2F, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x30, 0x09, 0x06, 
			0x03, 0x55, 0x1D, 0x13, 0x04, 0x02, 0x30, 0x00, 0x30, 0x44, 0x06, 0x03, 
			0x55, 0x1D, 0x20, 0x04, 0x3D, 0x30, 0x3B, 0x30, 0x39, 0x06, 0x0B, 0x60, 
			0x86, 0x48, 0x01, 0x86, 0xF8, 0x45, 0x01, 0x07, 0x01, 0x01, 0x30, 0x2A, 
			0x30, 0x28, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x02, 0x01, 
			0x16, 0x1C, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 
			0x77, 0x2E, 0x76, 0x65, 0x72, 0x69, 0x73, 0x69, 0x67, 0x6E, 0x2E, 0x63, 
			0x6F, 0x6D, 0x2F, 0x72, 0x70, 0x61, 0x30, 0x13, 0x06, 0x03, 0x55, 0x1D, 
			0x25, 0x04, 0x0C, 0x30, 0x0A, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 
			0x07, 0x03, 0x08, 0x30, 0x0B, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x04, 0x04, 
			0x03, 0x02, 0x06, 0xC0, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
			0xF7, 0x0D, 0x01, 0x01, 0x04, 0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x2D, 
			0xF3, 0x4F, 0x63, 0x60, 0x2C, 0x18, 0xDA, 0xF5, 0x24, 0x0F, 0x52, 0xB3, 
			0x0C, 0xEB, 0xB3, 0xBC, 0x67, 0x85, 0xC2, 0x23, 0xED, 0x8F, 0x46, 0x0D, 
			0xCF, 0x1A, 0x4D, 0xBE, 0xF3, 0x7C, 0x7A, 0x20, 0x30, 0x32, 0x18, 0x68, 
			0x8B, 0x92, 0xBB, 0x32, 0x99, 0xF0, 0x93, 0xB8, 0x3B, 0x15, 0x06, 0x27, 
			0x7B, 0x3E, 0x02, 0x06, 0x00, 0xA4, 0x21, 0x92, 0x84, 0x13, 0x0A, 0xC5, 
			0x98, 0xE5, 0x40, 0x57, 0xC5, 0x05, 0x25, 0xE8, 0xAF, 0xAF, 0x11, 0x6A, 
			0xA9, 0xE5, 0x3B, 0xCB, 0xE9, 0x23, 0xF6, 0x94, 0x29, 0x5D, 0x40, 0x55, 
			0xF3, 0xA5, 0x53, 0x9D, 0xC8, 0x36, 0x3A, 0x39, 0x65, 0x08, 0x73, 0x73, 
			0xA4, 0x32, 0xD2, 0xAF, 0xAC, 0xBF, 0xC7, 0x05, 0x3C, 0xFF, 0x45, 0xEC, 
			0xC3, 0xE8, 0xDA, 0x24, 0xD1, 0xCE, 0x63, 0xAE, 0x09, 0xA7, 0xFB, 0xE2, 
			0x1B, 0xE3, 0xFD, 0x41, 0x0A, 0x6A, 0x96, 0x31, 0x82, 0x04, 0x0C, 0x30, 
			0x82, 0x04, 0x08, 0x02, 0x01, 0x01, 0x30, 0x81, 0xCC, 0x30, 0x81, 0xC4, 
			0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x5A, 
			0x41, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x0C, 
			0x57, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6E, 0x20, 0x43, 0x61, 0x70, 0x65, 
			0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x09, 0x43, 
			0x61, 0x70, 0x65, 0x20, 0x54, 0x6F, 0x77, 0x6E, 0x31, 0x1D, 0x30, 0x1B, 
			0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x14, 0x54, 0x68, 0x61, 0x77, 0x74, 
			0x65, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x75, 0x6C, 0x74, 0x69, 0x6E, 0x67, 
			0x20, 0x63, 0x63, 0x31, 0x28, 0x30, 0x26, 0x06, 0x03, 0x55, 0x04, 0x0B, 
			0x13, 0x1F, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 
			0x69, 0x6F, 0x6E, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 
			0x20, 0x44, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6F, 0x6E, 0x31, 0x19, 0x30, 
			0x17, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x10, 0x54, 0x68, 0x61, 0x77, 
			0x74, 0x65, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x43, 0x41, 
			0x31, 0x26, 0x30, 0x24, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
			0x01, 0x09, 0x01, 0x16, 0x17, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 
			0x63, 0x65, 0x72, 0x74, 0x73, 0x40, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 
			0x2E, 0x63, 0x6F, 0x6D, 0x02, 0x03, 0x09, 0xCE, 0x15, 0x30, 0x0C, 0x06, 
			0x08, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x02, 0x05, 0x05, 0x00, 0xA0, 
			0x81, 0x84, 0x30, 0x19, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
			0x01, 0x09, 0x03, 0x31, 0x0C, 0x06, 0x0A, 0x2B, 0x06, 0x01, 0x04, 0x01, 
			0x82, 0x37, 0x02, 0x01, 0x04, 0x30, 0x1C, 0x06, 0x0A, 0x2B, 0x06, 0x01, 
			0x04, 0x01, 0x82, 0x37, 0x02, 0x01, 0x0B, 0x31, 0x0E, 0x30, 0x0C, 0x06, 
			0x0A, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x02, 0x01, 0x16, 0x30, 
			0x1F, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x04, 
			0x31, 0x12, 0x04, 0x10, 0x62, 0x0B, 0x26, 0x7E, 0x35, 0x1A, 0xB1, 0xE5, 
			0x5E, 0xF4, 0x4F, 0x14, 0xD0, 0xC0, 0xD1, 0x90, 0x30, 0x28, 0x06, 0x0A, 
			0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x02, 0x01, 0x0C, 0x31, 0x1A, 
			0x30, 0x18, 0xA1, 0x16, 0x80, 0x14, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 
			0x2F, 0x77, 0x77, 0x77, 0x2E, 0x6D, 0x6F, 0x74, 0x75, 0x73, 0x2E, 0x63, 
			0x6F, 0x6D, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
			0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x40, 0x0D, 0xBA, 0xBB, 0xB0, 0x63, 
			0x33, 0x6A, 0x03, 0x20, 0xA0, 0xD4, 0xC0, 0xBD, 0xDA, 0xAB, 0xE3, 0x73, 
			0xCA, 0x92, 0xB6, 0xE5, 0x75, 0x73, 0x0C, 0xD2, 0x4F, 0xB1, 0x8D, 0x96, 
			0x89, 0xD8, 0x01, 0x8B, 0x9C, 0x1E, 0x9D, 0x5A, 0xF1, 0xEE, 0x05, 0x9A, 
			0x59, 0xB9, 0x5A, 0xC0, 0xEC, 0x1C, 0x2B, 0x17, 0x1B, 0x8B, 0x10, 0xC7, 
			0xC1, 0xF6, 0xE2, 0xF9, 0x3E, 0xCC, 0xC9, 0x3A, 0x19, 0x17, 0x51, 0xA1, 
			0x82, 0x02, 0x4C, 0x30, 0x82, 0x02, 0x48, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x09, 0x06, 0x31, 0x82, 0x02, 0x39, 0x30, 0x82, 
			0x02, 0x35, 0x02, 0x01, 0x01, 0x30, 0x81, 0xB3, 0x30, 0x81, 0x9E, 0x31, 
			0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x16, 0x56, 0x65, 
			0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 
			0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x17, 0x30, 0x15, 
			0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 
			0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x2C, 0x30, 
			0x2A, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x23, 0x56, 0x65, 0x72, 0x69, 
			0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x69, 0x6D, 0x65, 0x20, 0x53, 0x74, 
			0x61, 0x6D, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 
			0x63, 0x65, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x31, 0x34, 0x30, 0x32, 0x06, 
			0x03, 0x55, 0x04, 0x0B, 0x13, 0x2B, 0x4E, 0x4F, 0x20, 0x4C, 0x49, 0x41, 
			0x42, 0x49, 0x4C, 0x49, 0x54, 0x59, 0x20, 0x41, 0x43, 0x43, 0x45, 0x50, 
			0x54, 0x45, 0x44, 0x2C, 0x20, 0x28, 0x63, 0x29, 0x39, 0x37, 0x20, 0x56, 
			0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 
			0x2E, 0x02, 0x10, 0x08, 0x7A, 0x6D, 0x5C, 0x6F, 0x62, 0x93, 0x4F, 0xBA, 
			0xC4, 0xFD, 0x43, 0xE1, 0x14, 0x18, 0x9D, 0x30, 0x0C, 0x06, 0x08, 0x2A, 
			0x86, 0x48, 0x86, 0xF7, 0x0D, 0x02, 0x05, 0x05, 0x00, 0xA0, 0x59, 0x30, 
			0x18, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x03, 
			0x31, 0x0B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 
			0x01, 0x30, 0x1C, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 
			0x09, 0x05, 0x31, 0x0F, 0x17, 0x0D, 0x30, 0x33, 0x31, 0x30, 0x30, 0x37, 
			0x31, 0x35, 0x32, 0x34, 0x33, 0x30, 0x5A, 0x30, 0x1F, 0x06, 0x09, 0x2A, 
			0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x04, 0x31, 0x12, 0x04, 0x10, 
			0x11, 0x7B, 0x03, 0x6B, 0xAB, 0xC2, 0x07, 0x41, 0x02, 0x76, 0x9F, 0x71, 
			0xBE, 0xA3, 0xD1, 0x03, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
			0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82, 0x01, 0x00, 0x58, 
			0xD1, 0xF6, 0x51, 0xF0, 0x1C, 0xDB, 0x38, 0x15, 0x55, 0x6C, 0x09, 0x4A, 
			0xDC, 0x14, 0x7E, 0x02, 0x7A, 0x6D, 0x8C, 0x2E, 0xB1, 0xA0, 0xDB, 0x5A, 
			0x55, 0x4F, 0xFB, 0xD4, 0x4D, 0x73, 0xEB, 0xDF, 0xD5, 0xAC, 0x62, 0x80, 
			0xE9, 0x4C, 0x58, 0x67, 0xD2, 0xAC, 0x6E, 0x5A, 0x71, 0x9E, 0x1F, 0xED, 
			0xB0, 0x08, 0x74, 0xF7, 0xC1, 0x7B, 0xC1, 0x53, 0xD2, 0x7E, 0x41, 0x7C, 
			0xF3, 0x35, 0xBF, 0x83, 0xF8, 0x30, 0xAC, 0x67, 0xC7, 0xA1, 0x34, 0xC4, 
			0xB4, 0xD4, 0xB0, 0x6F, 0x36, 0x5A, 0xC3, 0xA9, 0x3E, 0x76, 0x1B, 0xB2, 
			0x68, 0x99, 0x85, 0x48, 0xA5, 0x84, 0x79, 0xE2, 0x8F, 0x10, 0xE9, 0x06, 
			0x20, 0xC4, 0x7A, 0x7F, 0x8A, 0x0F, 0x0A, 0x95, 0x0F, 0xD9, 0xE9, 0x02, 
			0xA5, 0x6B, 0x58, 0x30, 0x75, 0x15, 0xEF, 0x31, 0xAB, 0x2A, 0x2E, 0xC1, 
			0x1F, 0xB3, 0xCF, 0xD8, 0x2A, 0x60, 0xB3, 0x1E, 0x1F, 0x2E, 0x76, 0xC8, 
			0x7A, 0x6B, 0x2D, 0xD6, 0x3B, 0xC8, 0xE2, 0x78, 0xB7, 0x83, 0x20, 0xA8, 
			0x2C, 0x66, 0xFF, 0x30, 0xE4, 0x37, 0xEB, 0xBB, 0x03, 0x06, 0xAD, 0x31, 
			0xFD, 0x18, 0x9E, 0x97, 0xD1, 0x5E, 0xB4, 0x4A, 0x5D, 0x03, 0xDA, 0x89, 
			0xDB, 0xF1, 0x0B, 0xDA, 0x45, 0x14, 0x82, 0x01, 0xC0, 0x2E, 0x5B, 0x69, 
			0xCF, 0xD4, 0xAB, 0xD4, 0xB2, 0x8E, 0x96, 0xBA, 0x3B, 0x58, 0x04, 0xE7, 
			0x4C, 0xD9, 0x12, 0x91, 0x2B, 0x87, 0xFD, 0x0B, 0x63, 0xF1, 0x55, 0x12, 
			0x3A, 0xCE, 0xF1, 0x78, 0x23, 0x4D, 0x61, 0x51, 0x90, 0x16, 0x12, 0x12, 
			0xAA, 0xFF, 0xBE, 0x82, 0x0E, 0xC9, 0x81, 0x75, 0xBA, 0x20, 0x16, 0x18, 
			0x12, 0xE2, 0xAC, 0x97, 0x88, 0xCB, 0xCA, 0x4C, 0x4E, 0x82, 0x09, 0x31, 
			0xED, 0x42, 0xB3, 0xD8, 0xCF, 0x55, 0x10, 0x2A, 0xA3, 0x12, 0x5A, 0x3C, 
			0x0A, 0xB2, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00
		};

		private string WriteFile () 
		{
			string filename = "helloworld_signed.exe";
			try {
				if (File.Exists (filename)) {
					File.Delete (filename);
				}
				using (FileStream fs = File.OpenWrite (filename)) {
					fs.Write (helloworld_signed, 0, helloworld_signed.Length);
					filename = Path.GetFullPath (fs.Name);
					fs.Close ();
				}
			}
			catch {}
			return filename;
		}

		[Test]
		public void VerifySignedAssembly ()
		{
			string filename = WriteFile ();
			AuthenticodeDeformatter ad = new AuthenticodeDeformatter (filename);
			// note: it's a valid signed PE file - but it doesn't 
			// mean it's root is trusted on the current system
			Assert.IsTrue (((ad.Reason == 0) || (ad.Reason == 6)), "Reason");
			Assert.AreEqual ("35-A5-21-3B-FC-FE-FA-40-97-AA-BB-DE-3B-52-15-6F", BitConverter.ToString (ad.Hash), "Hash");
			Assert.AreEqual (632011370700000000, ad.Timestamp.ToUniversalTime ().Ticks, "Timestamp");
			Assert.AreEqual (4, ad.Certificates.Count, "#Certificates");
			Assert.AreEqual ("C=ZA, S=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA, E=server-certs@thawte.com", ad.SigningCertificate.IssuerName, "IssuerName");
			Assert.AreEqual ("C=CA, S=Quebec, L=Quebec, O=Motus Technologies Inc., OU=Secure Application Development, CN=Motus Technologies Inc.", ad.SigningCertificate.SubjectName, "SubjectName");
		}

		[Test]
		public void VerifyUnsignedAssembly ()
		{
			string filename = Assembly.GetExecutingAssembly ().Location;
			AuthenticodeDeformatter ad = new AuthenticodeDeformatter (filename);
			// no digital signature
			Assert.AreEqual (1, ad.Reason, "Reason");
			Assert.IsNull (ad.Hash, "Hash");
			Assert.AreEqual (DateTime.MinValue, ad.Timestamp, "Timestamp");
			Assert.IsNull (ad.Certificates, "Certificates");
			Assert.IsNull (ad.SigningCertificate, "SigningCertificate");
		}
	}
}
