/* Libvoikko: Finnish spellchecker and hyphenator library
 * Copyright (C) 2006 - 2010 Harri Pitkänen <hatapitk@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *********************************************************************************/
 
/* Macro definitions for helping portability. */

#ifndef VOIKKO_PORTING_H
#define VOIKKO_PORTING_H

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__)
# ifndef WIN32
#  define WIN32
# endif
#endif

#define VOIKKOLINKAGE extern "C"

/* Shared library support */
#ifdef WIN32
  #define VOIKKOEXPORT VOIKKOLINKAGE __declspec(dllexport)
#else
  #ifdef GCC_VISIBILITY
    #define VOIKKOEXPORT VOIKKOLINKAGE __attribute__ ((visibility("default")))
  #else
    #define VOIKKOEXPORT VOIKKOLINKAGE
  #endif
#endif

#endif
