/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FB2CONTENT_H_INCLUDED
#define FB2CONTENT_H_INCLUDED

namespace libebook
{

class FB2Collector;
struct FB2BlockFormat;
class FB2Style;

/** Represents a part of FB2 content.
  *
  * This is used to save note texts and images, collected in the first
  * pass, for use in the second pass.
  *
  * @sa FB2ContentMap
  */
class FB2Content
{
public:
  virtual ~FB2Content() = 0;

  /** Insert the content of this into @c collector.
    */
  virtual void unfold(FB2Collector &collector) const = 0;
};

}

#endif // FB2CONTENT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
