/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef SFX_SIDEBAR_ACCESSIBLE_TITLE_BAR_HXX
#define SFX_SIDEBAR_ACCESSIBLE_TITLE_BAR_HXX

#include <toolkit/awt/vclxaccessiblecomponent.hxx>
#include <com/sun/star/accessibility/XAccessible.hpp>


namespace css = ::com::sun::star;
namespace cssu = ::com::sun::star::uno;

namespace sfx2 { namespace sidebar {

class TitleBar;

class AccessibleTitleBar
    : public VCLXAccessibleComponent
{
public:
    static cssu::Reference<css::accessibility::XAccessible> Create (TitleBar& rTitleBar);

protected:
    virtual void FillAccessibleStateSet (utl::AccessibleStateSetHelper& rStateSet);

private:
    AccessibleTitleBar (VCLXWindow* pWindow);
    virtual ~AccessibleTitleBar (void);
};


} } // end of namespace sfx2::sidebar

#endif
