/*
 * Version: MPL 1.1 / GPLv3+ / LGPLv3+
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 *       Miklos Vajna <vmiklos@frugalware.org>
 * Portions created by the Initial Developer are Copyright (C) 2011 the
 * Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 3 or later (the "GPLv3+"), or
 * the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
 * in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
 * instead of those above.
 */

#include <rtfskipdestination.hxx>

namespace writerfilter {
namespace rtftok {

RTFSkipDestination::RTFSkipDestination(RTFDocumentImpl& rImport)
    : m_rImport(rImport),
    m_bParsed(true),
    m_bReset(true)
{
}

RTFSkipDestination::~RTFSkipDestination()
{
    if (m_rImport.getSkipUnknown() && m_bReset)
    {
        if (!m_bParsed)
        {
            OSL_TRACE("%s: skipping destination", OSL_THIS_FUNC);
            m_rImport.getState().nDestinationState = DESTINATION_SKIP;
        }
        m_rImport.setSkipUnknown(false);
    }
}

void RTFSkipDestination::setParsed(bool bParsed)
{
    m_bParsed = bParsed;
}

void RTFSkipDestination::setReset(bool bReset)
{
    m_bReset = bReset;
}

} // namespace rtftok
} // namespace writerfilter

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
