/*
 * Copyright (C) 2009 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 */

#ifndef _LAUNCHER_CATEGORY_H_
#define _LAUNCHER_CATEGORY_H_

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define LAUNCHER_TYPE_CATEGORY	(launcher_category_get_type ())

typedef struct _LauncherCategory LauncherCategory;

GType          launcher_category_get_type      (void) G_GNUC_CONST;

LauncherCategory * launcher_category_new           (const gchar *name,
                                            const gchar *comment,
                                            const gchar *icon_name);

void           launcher_category_free          (LauncherCategory *category);

const gchar *  launcher_category_get_name      (LauncherCategory *category);

const gchar *  launcher_category_get_comment   (LauncherCategory *category);

const gchar *  launcher_category_get_icon_name (LauncherCategory *category);

void           launcher_category_append_child  (LauncherCategory *category,
                                            gpointer     child);
void           launcher_category_sort_children (LauncherCategory *category,
                                                GCompareFunc      sort_func);


GSList      *  launcher_category_get_children  (LauncherCategory *category);

void           launcher_category_empty_children (LauncherCategory *category);

G_END_DECLS

#endif /* _LAUNCHER_CATEGORY_H_ */
