/***************************************************************************
 *   Copyright (C) 2005 by Joris Guisson                                   *
 *   joris.guisson@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ***************************************************************************/
#ifndef BTDATACHECKERLISTENER_H
#define BTDATACHECKERLISTENER_H

#include <util/constants.h>
#include <ktorrent_export.h>

namespace bt
{

	/**
		@author Joris Guisson <joris.guisson@gmail.com>
	*/
	class KTORRENT_EXPORT DataCheckerListener
	{
	public:
		DataCheckerListener(bool auto_import);
		virtual ~DataCheckerListener();

		/**
		 * Called when a chunk has  been proccessed.
		 * This will be called from the scanning thread.
		 * @param num The number processed
		 * @param total The total number of pieces to process
		*/
		virtual void progress(Uint32 num,Uint32 total) = 0;
	
		/**
		 * Called when a failed or dowloaded chunk is found.
		 * This will be called from the scanning thread.
		 * @param num_failed The number of failed chunks
		 * @param num_found The number of found chunks
		 * @param num_downloaded Number of downloaded chunks
		 * @param num_not_downloaded Number of not downloaded chunks
		 */
		virtual void status(Uint32 num_failed,Uint32 num_found,Uint32 num_downloaded,Uint32 num_not_downloaded) = 0;
		
		/**
		 * Data check has been finished.
		 * This will be called from the application thread.
		 */
		virtual void finished() = 0;
		
		/**
		 * An error occurred during the datacheck.
		 * This will be called from the application thread.
		 * @param err Error message
		 */
		virtual void error(const QString & err) = 0;
		
		/**
		 * Test if we need to stop.
		 */
		bool needToStop() const {return stopped;}
		
		/// Check if the check has been stopped
		bool isStopped() const {return stopped;}
		
		/// Is this an auto_import
		bool isAutoImport() const {return auto_import;}
		
		/**
		 * Stop the data check.
		 */
		void stop() {stopped = true;}
	private:
		bool stopped;
	
	protected:
		bool auto_import;
	};

}

#endif
